/*
 * Decompiled with CFR 0.152.
 */
package com.archimed.dicom;

import com.archimed.dicom.DDict;
import com.archimed.dicom.DDictEntry;
import com.archimed.dicom.DicomException;
import com.archimed.dicom.k;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;

public class DDictBase {
    public static final int tUN = 0;
    public static final int tUNKNOWN = 0;
    public static final int tUL = 1;
    public static final int tUI = 2;
    public static final int tUS = 3;
    public static final int tAE = 4;
    public static final int tAT = 5;
    public static final int tLO = 6;
    public static final int tSH = 7;
    public static final int tOB = 8;
    public static final int tCS = 9;
    public static final int tSQ = 10;
    public static final int tDA = 11;
    public static final int tTM = 12;
    public static final int tST = 13;
    public static final int tPN = 14;
    public static final int tIS = 15;
    public static final int tDS = 16;
    public static final int tAS = 17;
    public static final int tLT = 18;
    public static final int tSL = 19;
    public static final int tFD = 20;
    public static final int tUS_SS = 21;
    public static final int tOW_OB = 22;
    public static final int tSS = 23;
    public static final int tOW = 24;
    public static final int tNONE = 25;
    public static final int tFL = 26;
    public static final int tUT = 27;
    public static final int tDT = 28;
    public static final int tOF = 29;
    private static String[] a = new String[]{"UN", "UL", "UI", "US", "AE", "AT", "LO", "SH", "OB", "CS", "SQ", "DA", "TM", "ST", "PN", "IS", "DS", "AS", "LT", "SL", "FD", "US_SS", "OW_OB", "SS", "OW", "NONE", "FL", "UT", "DT", "OF"};
    public static final int dUNDEFINED = Integer.MAX_VALUE;
    protected static HashMap dctList = new HashMap();
    protected static k geList = new k();

    public static String getTypeName(int n2) {
        if (n2 < 0 || n2 > a.length) {
            throw new IllegalArgumentException("unknown DDict tXX type constant: " + n2);
        }
        return a[n2];
    }

    public static String getTypeCodeName(int n2) {
        DDictEntry dDictEntry = DDict.getEntry(n2);
        if (dDictEntry == null) {
            return DDictBase.getTypeName(0);
        }
        return DDictBase.getTypeName(dDictEntry.getType());
    }

    public static int lookupDDict(int n2, int n3) {
        if ((n2 & 0xFF00) == 20480 && (n2 & 1) != 1) {
            n2 = 20480;
        } else if ((n2 & 0xFF00) == 24576 && (n2 & 1) != 1) {
            n2 = 24576;
        }
        int n4 = (n2 << 16) + n3;
        int n5 = geList.if(n4);
        if (n5 == Integer.MAX_VALUE) {
            return Integer.MAX_VALUE;
        }
        return n5;
    }

    public static int getGroup(int n2) {
        return ((DDictEntry)dctList.get(new Integer(n2))).getGroup();
    }

    public static int getElement(int n2) {
        return ((DDictEntry)dctList.get(new Integer(n2))).getElement();
    }

    public static int getTypeCode(int n2) {
        DDictEntry dDictEntry = DDict.getEntry(n2);
        if (dDictEntry == null) {
            return 0;
        }
        return dDictEntry.getType();
    }

    public static int getTypeCode(int n2, int n3) {
        int n4 = DDictBase.getTypeCode(DDictBase.lookupDDict(n2, n3));
        if (n4 == 0 && (n2 & 1) == 1) {
            if (n3 >= 16 && n3 <= 255) {
                return 6;
            }
            return 0;
        }
        return n4;
    }

    public static String getDescription(int n2) {
        DDictEntry dDictEntry = DDictBase.getEntry(n2);
        if (dDictEntry == null) {
            return "Undefined";
        }
        return dDictEntry.getDescription();
    }

    public static Enumeration ddictEntries() {
        Enumeration enumeration = new Enumeration(){
            private Iterator a = dctList.keySet().iterator();

            public boolean hasMoreElements() {
                return this.a.hasNext();
            }

            public Object nextElement() {
                return dctList.get(this.a.next());
            }
        };
        return enumeration;
    }

    public static DDictEntry getEntry(int n2) {
        return (DDictEntry)dctList.get(new Integer(n2));
    }

    public static int addEntry(DDictEntry dDictEntry) throws DicomException {
        int n2 = (dDictEntry.getGroup() << 16) + dDictEntry.getElement();
        Iterator iterator = dctList.keySet().iterator();
        int n3 = 0;
        while (iterator.hasNext()) {
            int n4 = (Integer)iterator.next();
            if (n4 == Integer.MAX_VALUE || n3 >= n4) continue;
            n3 = n4;
        }
        dctList.put(new Integer(++n3), dDictEntry);
        geList.a(n2, n3);
        DDictBase.a(dDictEntry.getGroup(), dDictEntry.getElement(), n3);
        return n3;
    }

    private static void a(int n2, int n3, int n4) {
        if (!DDict.isPrivateTag(n2, n3)) {
            return;
        }
        for (int i2 = 17; i2 <= 255; ++i2) {
            int n5 = n2 << 16 | i2 << 8 | n3;
            geList.a(n5, n4);
        }
    }

    static int getTypeFixed(int n2) {
        switch (n2) {
            case 3: 
            case 21: 
            case 23: {
                return 2;
            }
            case 1: 
            case 5: 
            case 19: 
            case 26: {
                return 4;
            }
            case 20: {
                return 8;
            }
        }
        return 0;
    }

    static int getTypeCode(String string) throws DicomException {
        if (string.equals("UL")) {
            return 1;
        }
        if (string.equals("UI")) {
            return 2;
        }
        if (string.equals("LO")) {
            return 6;
        }
        if (string.equals("US")) {
            return 3;
        }
        if (string.equals("AE")) {
            return 4;
        }
        if (string.equals("AT")) {
            return 5;
        }
        if (string.equals("SH")) {
            return 7;
        }
        if (string.equals("IS")) {
            return 15;
        }
        if (string.equals("OB")) {
            return 8;
        }
        if (string.equals("DA")) {
            return 11;
        }
        if (string.equals("TM")) {
            return 12;
        }
        if (string.equals("CS")) {
            return 9;
        }
        if (string.equals("SQ")) {
            return 10;
        }
        if (string.equals("LT")) {
            return 18;
        }
        if (string.equals("ST")) {
            return 13;
        }
        if (string.equals("PN")) {
            return 14;
        }
        if (string.equals("DS")) {
            return 16;
        }
        if (string.equals("AS")) {
            return 17;
        }
        if (string.equals("SL")) {
            return 19;
        }
        if (string.equals("FD")) {
            return 20;
        }
        if (string.equals("FL")) {
            return 26;
        }
        if (string.equals("OW")) {
            return 24;
        }
        if (string.equals("SS")) {
            return 23;
        }
        if (string.equals("UN")) {
            return 0;
        }
        if (string.equals("UT")) {
            return 27;
        }
        if (string.equals("DT")) {
            return 28;
        }
        if (string.equals("OF")) {
            return 29;
        }
        throw new DicomException("getTypeCode: unexpected type " + string);
    }

    static final boolean isPrivateTag(int n2, int n3) {
        return (n2 & 1) == 1 && n3 >= 4096 && n3 <= 4351;
    }

    static {
        dctList.put(new Integer(Integer.MAX_VALUE), new DDictEntry(Integer.MAX_VALUE, Integer.MAX_VALUE, 0, "Undefined", "1"));
        DDict.initDDict();
    }
}

