/*
 * Decompiled with CFR 0.152.
 */
package com.archimed.dicom;

import com.archimed.dicom.ATValue;
import com.archimed.dicom.DDict;
import com.archimed.dicom.DicomException;
import com.archimed.dicom.DicomObject;
import com.archimed.dicom.DumpUtils;
import com.archimed.dicom.Jdt;
import com.archimed.dicom.Person;
import com.archimed.dicom.TagValue;
import com.archimed.dicom.charset.DicomCharset;
import com.archimed.dicom.l;
import java.math.BigDecimal;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class DataElement
extends TagValue {
    private static final long else = 0xFFFFFFFFL;
    private static final long char = 0L;
    private static final int try = Integer.MAX_VALUE;
    private static final int int = Integer.MIN_VALUE;
    private static final int case = Integer.MAX_VALUE;
    private static final int byte = Integer.MIN_VALUE;
    private static final int if = Short.MAX_VALUE;
    private static final int a = Short.MIN_VALUE;
    private static final int new = 65535;
    private static final int for = 0;
    private static final DicomCharset[] do = new DicomCharset[]{DicomCharset.DEFAULT};

    public int getGroup() {
        return super.getGroup();
    }

    public int getElement() {
        return super.getElement();
    }

    public int getTag() {
        return DDict.lookupDDict(this.getGroup(), this.getElement());
    }

    public int size() {
        return super.size();
    }

    public Object getValue(int n2) {
        return this.val.elementAt(n2);
    }

    public Object getValue() {
        return this.getValue(0);
    }

    void setValue(Object object, int n2) {
        if (n2 == this.val.size()) {
            this.addValue(object);
        } else {
            this.val.set(n2, object);
        }
    }

    void addValue(Object object) {
        this.val.add(object);
    }

    public int getVR() {
        return this.dcm_type;
    }

    public int getValueLength() {
        return this.dataLen;
    }

    public void clear() {
        this.val.clear();
    }

    public Object removeValue(int n2) {
        return this.val.remove(n2);
    }

    public String getString(int n2) throws DicomException {
        return this.getString(n2, true);
    }

    public String getString(int n2, boolean bl) {
        switch (this.dcm_type) {
            case 6: 
            case 7: 
            case 13: 
            case 14: 
            case 18: 
            case 27: {
                byte[] byArray = (byte[])this.getValue(n2);
                if (bl) {
                    int[] nArray = l.a(byArray, this.dcm_type);
                    return Jdt.getCharsetCoder().decode(byArray, nArray[0], nArray[1], this.dcm.dicomCharsets());
                }
                return Jdt.getCharsetCoder().decode(byArray, 0, byArray.length, this.dcm.dicomCharsets());
            }
            case 4: 
            case 9: 
            case 11: 
            case 12: 
            case 15: 
            case 16: 
            case 17: 
            case 28: {
                byte[] byArray = (byte[])this.getValue(n2);
                if (bl) {
                    int[] nArray = l.a(byArray, this.dcm_type);
                    return Jdt.getCharsetCoder().decode(byArray, nArray[0], nArray[1], do);
                }
                return Jdt.getCharsetCoder().decode(byArray, 0, byArray.length, do);
            }
            case 2: {
                byte[] byArray = (byte[])this.getValue(n2);
                int[] nArray = l.a(byArray, this.dcm_type);
                return Jdt.getCharsetCoder().decode(byArray, nArray[0], nArray[1], do);
            }
            case 1: 
            case 3: 
            case 19: 
            case 20: 
            case 21: 
            case 23: 
            case 26: {
                Object object = this.getValue(n2);
                return object == null ? null : object.toString();
            }
            case 0: 
            case 8: 
            case 22: 
            case 24: {
                byte[] byArray = (byte[])this.getValue(n2);
                String string = "";
                int n3 = byArray.length;
                if (n3 > 12) {
                    n3 = 12;
                }
                for (int i2 = 0; i2 < n3; ++i2) {
                    string = i2 != n3 - 1 ? string + DumpUtils.toHexString(byArray[i2]) + "\\" : string + DumpUtils.toHexString(byArray[i2]);
                }
                if (n3 == 12) {
                    string = string + "...";
                }
                return string;
            }
            case 5: {
                ATValue aTValue = (ATValue)this.getValue(n2);
                int n4 = aTValue.getGroup();
                int n5 = aTValue.getElement();
                String string = "(" + DumpUtils.toHexString(n4, 4) + "," + DumpUtils.toHexString(n5, 4) + ")";
                return string;
            }
            case 29: {
                float[] fArray = (float[])this.getValue(n2);
                String string = "";
                int n6 = fArray.length;
                if (n6 > 2) {
                    n6 = 2;
                }
                for (int i3 = 0; i3 < n6; ++i3) {
                    string = i3 != n6 - 1 ? string + fArray[i3] + ";" : string + fArray[i3];
                }
                if (fArray.length > 2) {
                    string = string + ";...";
                }
                return string;
            }
        }
        return null;
    }

    public void setString(String string, int n2) throws DicomException {
        if (string == null) {
            throw new DicomException("String argument in setString cannot be null. Use \"\" to insert an empty String");
        }
        this.setValue(this.a(string), n2);
    }

    public void addString(String string) throws DicomException {
        if (string == null) {
            throw new DicomException("String argument in addString cannot be null. Use \"\" to insert an empty String");
        }
        this.addValue(this.a(string));
    }

    public void setString(String string, int n2, DicomCharset dicomCharset) throws DicomException {
        if (string == null) {
            throw new DicomException("String argument in setString cannot be null. Use \"\" to insert an empty String");
        }
        this.setValue(this.a(string, new DicomCharset[]{dicomCharset}), n2);
    }

    public void addString(String string, DicomCharset dicomCharset) throws DicomException {
        if (string == null) {
            throw new DicomException("String argument in setString cannot be null. Use \"\" to insert an empty String");
        }
        this.addValue(this.a(string, new DicomCharset[]{dicomCharset}));
    }

    private Object a(String string, DicomCharset[] dicomCharsetArray) throws DicomException {
        switch (this.dcm_type) {
            case 6: 
            case 7: 
            case 13: 
            case 18: 
            case 27: {
                return Jdt.getCharsetCoder().encode(string, dicomCharsetArray);
            }
            case 2: 
            case 4: 
            case 9: 
            case 12: 
            case 28: {
                return Jdt.getCharsetCoder().encode(string);
            }
            case 17: {
                if (string.length() != 0 && string.length() != 4) {
                    throw new DicomException("Type AS has to have 4 bytes fixed.");
                }
                return Jdt.getCharsetCoder().encode(string);
            }
            case 14: {
                return Jdt.getCharsetCoder().encode(string, dicomCharsetArray);
            }
            case 11: {
                return Jdt.getCharsetCoder().encode(string);
            }
            case 16: {
                if (Jdt.isDSAsString()) {
                    return Jdt.getCharsetCoder().encode(string);
                }
                return new Float(string);
            }
            case 26: {
                return new Float(string);
            }
            case 15: {
                return Jdt.getCharsetCoder().encode(string);
            }
            case 23: {
                return new Short(string);
            }
            case 3: 
            case 21: {
                return new Integer(string);
            }
            case 1: 
            case 19: {
                return new Long(string);
            }
            case 20: {
                return new Double(string);
            }
            case 0: 
            case 8: 
            case 22: 
            case 24: {
                return string.getBytes();
            }
        }
        throw new DicomException("unable to represent " + DDict.getTypeName(this.getVR()) + " data element from java.lang.String");
    }

    private Object a(String string) throws DicomException {
        return this.a(string, this.dcm.dicomCharsets());
    }

    public Short getShort(int n2) throws DicomException {
        switch (this.getVR()) {
            case 23: {
                return (Short)this.getValue(n2);
            }
        }
        throw new DicomException("unable to represent " + DDict.getTypeName(this.getVR()) + " data element as java.lang.Short");
    }

    public void setShort(Short s2, int n2) throws DicomException {
        if (s2 == null && this.getVR() != 15) {
            throw new DicomException("Short argument can only be null for data elements of VR IS");
        }
        this.setValue(this.a(s2), n2);
    }

    public void addShort(Short s2) throws DicomException {
        if (s2 == null && this.getVR() != 15) {
            throw new DicomException("Short argument can only be null for data elements of VR IS");
        }
        this.addValue(this.a(s2));
    }

    private Object a(Short s2) throws DicomException {
        switch (this.getVR()) {
            case 1: {
                this.a(s2.longValue(), 0L, 0xFFFFFFFFL, 1);
                return new Long(s2.longValue());
            }
            case 19: {
                return new Long(s2.longValue());
            }
            case 3: {
                this.a(s2.longValue(), 0L, 65535L, 3);
                return new Integer(s2.intValue());
            }
            case 23: {
                return s2;
            }
            case 15: {
                if (s2 == null) {
                    return new byte[0];
                }
                this.a(s2.longValue(), Integer.MIN_VALUE, Integer.MAX_VALUE, 15);
                return Jdt.getCharsetCoder().encode(s2.toString());
            }
        }
        throw new DicomException("unable to represent " + DDict.getTypeName(this.getVR()) + " data element as java.lang.Short");
    }

    public Integer getInteger(int n2) throws DicomException {
        switch (this.getVR()) {
            case 15: {
                byte[] byArray = (byte[])this.getValue(n2);
                int[] nArray = l.a(byArray, this.getVR());
                String string = Jdt.getCharsetCoder().decode(byArray, nArray[0], nArray[1]);
                string = string.startsWith("+") ? string.substring(1) : string;
                return Integer.valueOf(string, 10);
            }
            case 19: {
                return new Integer(((Long)this.getValue(n2)).intValue());
            }
            case 3: {
                return (Integer)this.getValue(n2);
            }
            case 23: {
                return new Integer(((Short)this.getValue(n2)).intValue());
            }
        }
        throw new DicomException("unable to represent " + DDict.getTypeName(this.getVR()) + " data element as java.lang.Integer");
    }

    public void setInteger(Integer n2, int n3) throws DicomException {
        if (n2 == null && this.getVR() != 15) {
            throw new DicomException("Integer argument can only be null for data elements of VR IS");
        }
        this.setValue(this.a(n2), n3);
    }

    public void addInteger(Integer n2) throws DicomException {
        if (n2 == null && this.getVR() != 15) {
            throw new DicomException("Integer argument can only be null for data elements of VR IS");
        }
        this.addValue(this.a(n2));
    }

    private Object a(Integer n2) throws DicomException {
        switch (this.getVR()) {
            case 1: {
                this.a(n2.longValue(), 0L, 0xFFFFFFFFL, 1);
                return new Long(n2.longValue());
            }
            case 19: {
                return new Long(n2.longValue());
            }
            case 3: {
                this.a(n2.longValue(), 0L, 65535L, 3);
                return n2;
            }
            case 23: {
                this.a(n2.longValue(), -32768L, 32767L, 23);
                return new Short(n2.shortValue());
            }
            case 15: {
                if (n2 == null) {
                    return new byte[0];
                }
                this.a(n2.longValue(), Integer.MIN_VALUE, Integer.MAX_VALUE, 15);
                return Jdt.getCharsetCoder().encode(n2.toString());
            }
        }
        throw new DicomException("unable to represent " + DDict.getTypeName(this.getVR()) + " data element as java.lang.Integer");
    }

    public Long getLong(int n2) throws DicomException {
        switch (this.getVR()) {
            case 15: {
                byte[] byArray = (byte[])this.getValue(n2);
                int[] nArray = l.a(byArray, this.getVR());
                String string = Jdt.getCharsetCoder().decode(byArray, nArray[0], nArray[1]);
                return Long.valueOf(string, 10);
            }
            case 1: 
            case 19: {
                return (Long)this.getValue(n2);
            }
            case 3: {
                return new Long(((Integer)this.getValue(n2)).intValue());
            }
            case 23: {
                return new Long(((Short)this.getValue(n2)).intValue());
            }
        }
        throw new DicomException("unable to represent " + DDict.getTypeName(this.getVR()) + " data element as java.lang.Integer");
    }

    public void setLong(Long l2, int n2) throws DicomException {
        if (l2 == null && this.getVR() != 15) {
            throw new DicomException("Long argument can only be null for data elements of VR IS");
        }
        this.setValue(this.a(l2), n2);
    }

    public void addLong(Long l2) throws DicomException {
        if (l2 == null && this.getVR() != 15) {
            throw new DicomException("Long argument can only be null for data elements of VR IS");
        }
        this.addValue(this.a(l2));
    }

    private Object a(Long l2) throws DicomException {
        switch (this.getVR()) {
            case 1: {
                this.a(l2, 0L, 0xFFFFFFFFL, 1);
                return l2;
            }
            case 19: {
                this.a(l2, Integer.MIN_VALUE, Integer.MAX_VALUE, 19);
                return l2;
            }
            case 3: {
                this.a(l2, 0L, 65535L, 3);
                return new Integer((int)l2.longValue());
            }
            case 23: {
                this.a(l2, -32768L, 32767L, 23);
                return new Short((short)l2.longValue());
            }
            case 15: {
                if (l2 == null) {
                    return new byte[0];
                }
                this.a(l2, Integer.MIN_VALUE, Integer.MAX_VALUE, 15);
                return Jdt.getCharsetCoder().encode(l2.toString());
            }
        }
        throw new DicomException("unable to represent " + DDict.getTypeName(this.getVR()) + " data element as java.lang.Integer");
    }

    public Person getPersonName(int n2) throws DicomException {
        switch (this.getVR()) {
            case 14: {
                return new Person(this.getString(n2));
            }
        }
        throw new DicomException("unable to represent " + DDict.getTypeName(this.getVR()) + " data element as a Person Object");
    }

    public void setPersonName(Person person, int n2) throws DicomException {
        this.setValue(this.a(person), n2);
    }

    public void setPersonName(Person person, int n2, DicomCharset dicomCharset, DicomCharset dicomCharset2, DicomCharset dicomCharset3) throws DicomException {
        this.setValue(this.a(person, dicomCharset, dicomCharset2, dicomCharset3), n2);
    }

    public void addPersonName(Person person) throws DicomException {
        this.addValue(this.a(person));
    }

    public void addPersonName(Person person, DicomCharset dicomCharset, DicomCharset dicomCharset2, DicomCharset dicomCharset3) throws DicomException {
        this.addValue(this.a(person, dicomCharset, dicomCharset2, dicomCharset3));
    }

    private Object a(Person person) throws DicomException {
        DicomCharset dicomCharset = this.dcm.dicomCharsets()[0];
        return this.a(person, dicomCharset, dicomCharset, dicomCharset);
    }

    private Object a(Person person, DicomCharset dicomCharset, DicomCharset dicomCharset2, DicomCharset dicomCharset3) throws DicomException {
        switch (this.getVR()) {
            case 14: {
                return person.encode(dicomCharset, dicomCharset2, dicomCharset3);
            }
        }
        throw new DicomException("unable to represent " + DDict.getTypeName(this.getVR()) + " data element as a Person Object");
    }

    public byte[] getBytes(int n2) throws DicomException {
        switch (this.getVR()) {
            case 0: 
            case 2: 
            case 4: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 22: 
            case 24: 
            case 27: 
            case 28: {
                return (byte[])this.getValue(n2);
            }
        }
        throw new DicomException("unable to represent " + DDict.getTypeName(this.getVR()) + " data element as byte array");
    }

    public void setBytes(byte[] byArray, int n2) throws DicomException {
        if (byArray == null) {
            throw new DicomException("byte array argument cannot be null.");
        }
        this.setValue(this.fromBytes(byArray), n2);
    }

    public void addBytes(byte[] byArray) throws DicomException {
        if (byArray == null) {
            throw new DicomException("byte array argument cannot be null.");
        }
        this.addValue(this.fromBytes(byArray));
    }

    public Object fromBytes(byte[] byArray) throws DicomException {
        switch (this.getVR()) {
            case 0: 
            case 2: 
            case 4: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 22: 
            case 24: 
            case 27: 
            case 28: {
                return byArray;
            }
        }
        throw new DicomException("unable to represent " + DDict.getTypeName(this.getVR()) + " data element as byte array");
    }

    public Float getFloat(int n2) throws DicomException {
        switch (this.getVR()) {
            case 26: {
                return (Float)this.getValue(n2);
            }
        }
        throw new DicomException("unable to represent " + DDict.getTypeName(this.getVR()) + " data element as java.lang.Float");
    }

    public void setFloat(Float f2, int n2) throws DicomException {
        if (f2 == null) {
            throw new DicomException("Float argument cannot be null");
        }
        this.setValue(this.fromFloat(f2), n2);
    }

    public void addFloat(Float f2) throws DicomException {
        if (f2 == null) {
            throw new DicomException("Float argument cannot be null");
        }
        this.addValue(this.fromFloat(f2));
    }

    public Object fromFloat(Float f2) throws DicomException {
        switch (this.getVR()) {
            case 26: {
                return f2;
            }
        }
        throw new DicomException("unable to represent " + DDict.getTypeName(this.getVR()) + " data element as java.lang.Float");
    }

    public Double getDouble(int n2) throws DicomException {
        switch (this.getVR()) {
            case 20: {
                return (Double)this.getValue(n2);
            }
        }
        throw new DicomException("unable to represent " + DDict.getTypeName(this.getVR()) + " data element as java.lang.Double");
    }

    public void setDouble(Double d2, int n2) throws DicomException {
        if (d2 == null) {
            throw new DicomException("Double argument cannot be null");
        }
        this.setValue(this.fromDouble(d2), n2);
    }

    public void addDouble(Double d2) throws DicomException {
        if (d2 == null) {
            throw new DicomException("Double argument cannot be null");
        }
        this.addValue(this.fromDouble(d2));
    }

    public Object fromDouble(Double d2) throws DicomException {
        switch (this.getVR()) {
            case 20: {
                return d2;
            }
        }
        throw new DicomException("unable to represent " + DDict.getTypeName(this.getVR()) + " data element as java.lang.Double");
    }

    public float[] getFloats(int n2) throws DicomException {
        switch (this.getVR()) {
            case 29: {
                return (float[])this.getValue(n2);
            }
        }
        throw new DicomException("unable to represent " + DDict.getTypeName(this.getVR()) + " data element as float array");
    }

    public void setFloats(float[] fArray, int n2) throws DicomException {
        if (fArray == null) {
            throw new DicomException("float array argument cannot be null");
        }
        this.setValue(this.fromFloats(fArray), n2);
    }

    public void addFloats(float[] fArray) throws DicomException {
        if (fArray == null) {
            throw new DicomException("float array argument cannot be null");
        }
        this.addValue(this.fromFloats(fArray));
    }

    public Object fromFloats(float[] fArray) throws DicomException {
        switch (this.getVR()) {
            case 29: {
                return fArray;
            }
        }
        throw new DicomException("unable to represent " + DDict.getTypeName(this.getVR()) + " data element as float array");
    }

    public DicomObject getSequenceItem(int n2) throws DicomException {
        switch (this.getVR()) {
            case 10: {
                return (DicomObject)this.getValue(n2);
            }
        }
        throw new DicomException("unable to represent " + DDict.getTypeName(this.getVR()) + " data element as a DicomObject");
    }

    public void setSequenceItem(DicomObject dicomObject, int n2) throws DicomException {
        this.setValue(this.fromDicomObject(dicomObject), n2);
    }

    public void addSequenceItem(DicomObject dicomObject) throws DicomException {
        this.addValue(this.fromDicomObject(dicomObject));
    }

    public Object fromDicomObject(DicomObject dicomObject) throws DicomException {
        switch (this.getVR()) {
            case 10: {
                dicomObject.setParent(this.dcm);
                return dicomObject;
            }
        }
        throw new DicomException("unable to represent " + DDict.getTypeName(this.getVR()) + " data element as DicomObject");
    }

    public ATValue getATValue(int n2) throws DicomException {
        switch (this.getVR()) {
            case 5: {
                return (ATValue)this.getValue(n2);
            }
        }
        throw new DicomException("unable to represent " + DDict.getTypeName(this.getVR()) + " data element as a AttributeTag object");
    }

    public void setATValue(ATValue aTValue, int n2) throws DicomException {
        if (aTValue == null) {
            throw new DicomException("ATValue argument cannot be null");
        }
        this.setValue(this.fromATValue(aTValue), n2);
    }

    public void addATValue(ATValue aTValue) throws DicomException {
        if (aTValue == null) {
            throw new DicomException("ATValue argument cannot be null");
        }
        this.addValue(this.fromATValue(aTValue));
    }

    public Object fromATValue(ATValue aTValue) throws DicomException {
        switch (this.getVR()) {
            case 5: {
                return aTValue;
            }
        }
        throw new DicomException("unable to represent " + DDict.getTypeName(this.getVR()) + " data element as ATValue");
    }

    public BigDecimal getBigDecimal(int n2) throws DicomException {
        switch (this.getVR()) {
            case 16: {
                byte[] byArray = (byte[])this.getValue(n2);
                if (byArray == null || byArray.length == 0) {
                    return null;
                }
                int[] nArray = l.a(byArray, 16);
                return new BigDecimal(Jdt.getCharsetCoder().decode(byArray, nArray[0], nArray[1]));
            }
        }
        throw new DicomException("unable to represent " + DDict.getTypeName(this.getVR()) + " data element as a java.math.BigDecimal object");
    }

    public void setBigDecimal(BigDecimal bigDecimal, int n2) throws DicomException {
        this.setValue(this.a(bigDecimal), n2);
    }

    public void addBigDecimal(BigDecimal bigDecimal) throws DicomException {
        this.addValue(this.a(bigDecimal));
    }

    private Object a(BigDecimal bigDecimal) throws DicomException {
        switch (this.getVR()) {
            case 16: {
                if (bigDecimal == null) {
                    return new byte[0];
                }
                return Jdt.getCharsetCoder().encode(bigDecimal.toString());
            }
        }
        throw new DicomException("unable to represent " + DDict.getTypeName(this.getVR()) + " data element as java.math.BigDecimal object");
    }

    private void a(long l2, long l3, long l4, int n2) throws DicomException {
        if (l2 < l3 || l2 > l4) {
            throw new DicomException("unable to store " + l2 + " as " + DDict.getTypeName(n2) + ": value out of bound (" + l3 + "," + l4 + ")");
        }
    }
}

