/*
 * Decompiled with CFR 0.152.
 */
package com.archimed.dicom;

import com.archimed.dicom.DDict;
import com.archimed.dicom.DataElement;
import com.archimed.dicom.DicomException;
import com.archimed.dicom.DicomObject;
import com.archimed.dicom.Jdt;
import com.archimed.dicom.TagWriteEvent;
import com.archimed.dicom.TagWriteListener;
import com.archimed.dicom.UID;
import com.archimed.dicom.UnknownUIDException;
import com.archimed.dicom.a;
import com.archimed.dicom.c;
import com.archimed.log.JdtLogger;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.Vector;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class DicomWriter {
    public static final int GRPLEN_NONE = 1;
    public static final int GRPLEN_ALL = 2;
    public static final int GRPLEN_KEEP = 3;
    public static final int DCMFILE_NO = 4101;
    public static final int DCMFILE_YES = 4102;
    public static final int DCMFILE_GENERATE = 4103;
    public static final int SEQLEN_UNDEFINED = 8200;
    public static final int SEQLEN_DEFINED = 8201;
    public static final int SEQLEN_KEEPANDUNDEF = 8208;
    public static final int SEQLEN_KEEPANDDEF = 8209;
    protected JdtLogger log = Jdt.getJdtLoggerFactory().getJdtLogger(DicomWriter.class);
    private Map a = new HashMap();

    public void addTagWriteListener(TagWriteListener tagWriteListener, int n2) {
        this.addTagWriteListener(tagWriteListener, DDict.getGroup(n2), DDict.getElement(n2));
    }

    public synchronized void addTagWriteListener(TagWriteListener tagWriteListener, int n2, int n3) {
        Integer n4 = this.a(n2, n3);
        Vector<TagWriteListener> vector = (Vector<TagWriteListener>)this.a.get(n4);
        if (vector == null) {
            vector = new Vector<TagWriteListener>();
            this.a.put(n4, vector);
        }
        vector.add(tagWriteListener);
    }

    public synchronized void addTagWriteListener(TagWriteListener tagWriteListener) {
        Vector<TagWriteListener> vector = (Vector<TagWriteListener>)this.a.get(null);
        if (vector == null) {
            vector = new Vector<TagWriteListener>();
            this.a.put(null, vector);
        }
        vector.add(tagWriteListener);
    }

    public synchronized void removeTagWriteListener(TagWriteListener tagWriteListener, int n2) {
        this.removeTagWriteListener(tagWriteListener, DDict.getGroup(n2), DDict.getElement(n2));
    }

    public synchronized void removeTagWriteListener(TagWriteListener tagWriteListener, int n2, int n3) {
        Vector vector = (Vector)this.a.get(this.a(n2, n3));
        if (vector == null) {
            return;
        }
        vector.remove(tagWriteListener);
    }

    public synchronized void removeTagWriteListener(TagWriteListener tagWriteListener) {
        Vector vector = (Vector)this.a.get(null);
        if (vector == null) {
            return;
        }
        vector.remove(tagWriteListener);
    }

    TagWriteEvent fireBeforeData(DataElement dataElement, OutputStream outputStream, long l2) {
        int n2;
        boolean bl = false;
        TagWriteEvent tagWriteEvent = new TagWriteEvent(dataElement, outputStream, l2);
        Vector vector = (Vector)this.a.get(null);
        if (vector != null && vector.size() > 0) {
            bl = true;
            for (n2 = 0; n2 < vector.size(); ++n2) {
                ((TagWriteListener)vector.get(n2)).beforeHeader(tagWriteEvent);
            }
        }
        if ((vector = (Vector)this.a.get(this.a(dataElement))) != null && vector.size() > 0) {
            bl = true;
            for (n2 = 0; n2 < vector.size(); ++n2) {
                ((TagWriteListener)vector.get(n2)).beforeHeader(tagWriteEvent);
            }
        }
        return bl ? tagWriteEvent : null;
    }

    private Integer a(DataElement dataElement) {
        return this.a(dataElement.getGroup(), dataElement.getElement());
    }

    private Integer a(int n2, int n3) {
        return new Integer(n2 * 65535 + n3);
    }

    public void write(DicomObject dicomObject, OutputStream outputStream, boolean bl) throws DicomException, IOException {
        int n2;
        DicomObject dicomObject2 = dicomObject.getFileMetaInformation();
        if (bl && dicomObject2 == null) {
            dicomObject.changeDICOMFileMetaInformation(8193);
        }
        try {
            n2 = UID.getUIDEntry(dicomObject2.getS(31)).getConstant();
        }
        catch (Exception exception) {
            n2 = 8193;
        }
        this.write(dicomObject, outputStream, bl, n2, Jdt.isWriteDefaultUndefLenSequences(), Jdt.isWriteDefaultGroupLengths());
    }

    public void write(DicomObject dicomObject, OutputStream outputStream, boolean bl, int n2, boolean bl2) throws DicomException, IOException {
        this.write(dicomObject, outputStream, bl, n2, bl2, true);
    }

    public void write(DicomObject dicomObject, OutputStream outputStream, boolean bl, int n2, boolean bl2, boolean bl3) throws DicomException, IOException {
        int n3;
        int n4 = bl2 ? 8200 : 8201;
        int n5 = n3 = bl3 ? 2 : 1;
        if (bl) {
            if (dicomObject.getFileMetaInformation() == null) {
                dicomObject.changeDICOMFileMetaInformation(n2);
            }
            this.writeFile(dicomObject, outputStream, n4, n3);
        } else {
            this.writeDataSet(dicomObject, outputStream, n2, n4, n3);
        }
    }

    public void writeFile(DicomObject dicomObject, OutputStream outputStream, int n2, int n3) throws DicomException, IOException {
        int n4;
        this.if(n2, n3);
        DicomObject dicomObject2 = dicomObject.getFileMetaInformation();
        if (dicomObject2 == null) {
            throw new DicomException("Cannot write DICOM file: no meta information object specified in DicomObject");
        }
        if (dicomObject2.getSize(31) == 0) {
            throw new DicomException("Cannot write DICOM file: transfer syntax missing in file meta information");
        }
        String string = null;
        try {
            string = (String)dicomObject2.get(31);
            n4 = UID.getUIDEntry(string).getConstant();
        }
        catch (UnknownUIDException unknownUIDException) {
            throw new DicomException("Cannot write DICOM file: unknown transfer syntax '" + string + "'");
        }
        long l2 = this.writeHeader(dicomObject, outputStream);
        if (l2 >= 0L) {
            this.writeTags(dicomObject, outputStream, n4, n2, n3, l2);
        }
    }

    public void writeDataSet(DicomObject dicomObject, OutputStream outputStream, int n2, int n3, int n4) throws DicomException, IOException {
        this.if(n3, n4);
        this.writeTags(dicomObject, outputStream, n2, n3, n4, 0L);
    }

    private void if(int n2, int n3) {
        if (n3 < 1 || n3 > 3) {
            throw new IllegalArgumentException("Illegal value for groupOpt");
        }
        if (n2 < 8200 || n2 > 8209) {
            throw new IllegalArgumentException("Illegal value for seqLengthOpt");
        }
    }

    long writeHeader(DicomObject dicomObject, OutputStream outputStream) throws IOException, DicomException {
        this.log.debug("DicomObject.writeHeader.");
        byte[] byArray = dicomObject.getPreamble();
        if (byArray == null) {
            byArray = new byte[128];
        }
        assert (byArray.length == 128);
        outputStream.write(byArray);
        outputStream.write(68);
        outputStream.write(73);
        outputStream.write(67);
        outputStream.write(77);
        return this.writeTags(dicomObject.getFileMetaInformation(), outputStream, 8194, 8201, 2, 0L);
    }

    long writeTags(DicomObject dicomObject, OutputStream outputStream, int n2, int n3, int n4, long l2) throws IOException, DicomException {
        this.log.debug("DicomObject.writeTags.");
        a a2 = new a(outputStream, l2);
        a2.if(n2);
        Enumeration enumeration = dicomObject.enumerateVRs(n2, n3, n4);
        while (enumeration.hasMoreElements()) {
            c c2 = (c)enumeration.nextElement();
            TagWriteEvent tagWriteEvent = this.fireBeforeData(c2, outputStream, a2.a());
            if (tagWriteEvent == null || tagWriteEvent.getDataWriteStatus() == 0) {
                c2.a(a2, n3);
                c2.a(a2, n3, n4);
            } else if (tagWriteEvent.getDataWriteStatus() == 3 && n4 == 2) {
                throw new DicomException("cannot skip tag when writing grouplengths");
            }
            if (tagWriteEvent == null || !tagWriteEvent.isStopWriting()) continue;
            return -1L;
        }
        return a2.a();
    }
}

