/*
 * Decompiled with CFR 0.152.
 */
package com.archimed.dicom.charset;

import com.archimed.dicom.Jdt;
import com.archimed.dicom.charset.DicomCharset;
import com.archimed.dicom.charset.DicomCharsetException;
import com.archimed.log.JdtLogger;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.CharacterCodingException;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CharsetEncoder;
import java.nio.charset.CodingErrorAction;
import java.nio.charset.UnsupportedCharsetException;

public class DicomCharsetCoder {
    public static final byte ESC = 27;
    public static final char LF = '\n';
    public static final char CR = '\r';
    public static final char FF = '\f';
    protected JdtLogger log = Jdt.getJdtLoggerFactory().getJdtLogger(DicomCharsetCoder.class);

    public byte[] encode(String string) throws DicomCharsetException {
        return this.encode(string, DicomCharset.DEFAULT);
    }

    public byte[] encode(String string, DicomCharset dicomCharset) {
        return this.encode(string, new DicomCharset[]{dicomCharset}, false);
    }

    public byte[] encode(String string, DicomCharset[] dicomCharsetArray) {
        return this.encode(string, dicomCharsetArray, false);
    }

    public byte[] encode(String string, DicomCharset dicomCharset, boolean bl) {
        return this.encode(string, new DicomCharset[]{dicomCharset}, bl);
    }

    private byte[] a(ByteBuffer byteBuffer) {
        byte[] byArray = new byte[byteBuffer.position()];
        byteBuffer.rewind();
        byteBuffer.get(byArray);
        return byArray;
    }

    public byte[] encode(String string, DicomCharset[] dicomCharsetArray, boolean bl) {
        CharsetEncoder[] charsetEncoderArray = new CharsetEncoder[dicomCharsetArray.length];
        for (int i2 = 0; i2 < dicomCharsetArray.length; ++i2) {
            charsetEncoderArray[i2] = dicomCharsetArray[i2].getJavaCharset().newEncoder();
        }
        ByteBuffer byteBuffer = ByteBuffer.allocate(string.length() * 6);
        int n2 = 0;
        int n3 = 0;
        boolean bl2 = false;
        block1: for (int i3 = 0; i3 < string.length(); ++i3) {
            char c2 = string.charAt(i3);
            if (DicomCharsetCoder.a(c2)) {
                n2 = 0;
            }
            for (int i4 = 0; i4 < charsetEncoderArray.length; ++i4) {
                bl2 = false;
                if (!charsetEncoderArray[i4].canEncode(c2)) continue;
                if (bl && i3 == 0) {
                    byte[] byArray = this.a(dicomCharsetArray[i4], c2);
                    byteBuffer.put((byte)27);
                    byteBuffer.put(byArray);
                }
                if (dicomCharsetArray.length == 1) {
                    charsetEncoderArray[i4].encode(CharBuffer.wrap(string), byteBuffer, true);
                    break block1;
                }
                n3 = n2;
                n2 = i4;
                this.a(c2, dicomCharsetArray[n2], dicomCharsetArray[n3], charsetEncoderArray[n2], byteBuffer);
                bl2 = true;
                break;
            }
            if (bl2) continue;
            throw new DicomCharsetException("Unable to encode string with specified charsets", null);
        }
        return this.a(byteBuffer);
    }

    private static final boolean a(char c2) {
        return c2 == '\n' || c2 == '\f' || c2 == '\r';
    }

    private byte[] a(DicomCharset dicomCharset, char c2) {
        byte[] byArray;
        ByteBuffer byteBuffer = dicomCharset.getJavaCharset().encode(CharBuffer.wrap(new char[]{c2}));
        byteBuffer.rewind();
        if (byteBuffer.get() > 0) {
            byArray = dicomCharset.getEscapeSequenceG0();
            if (byArray == null) {
                throw new DicomCharsetException("no G0 escape sequence found for " + dicomCharset.getDefinedTerm());
            }
        } else {
            byArray = dicomCharset.getEscapeSequenceG1();
            if (byArray == null) {
                throw new DicomCharsetException("no G1 escape sequence found for " + dicomCharset.getDefinedTerm());
            }
        }
        return byArray;
    }

    private void a(char c2, DicomCharset dicomCharset, DicomCharset dicomCharset2, CharsetEncoder charsetEncoder, ByteBuffer byteBuffer) {
        ByteBuffer byteBuffer2 = null;
        try {
            byteBuffer2 = charsetEncoder.encode(CharBuffer.wrap(new char[]{c2}));
            byteBuffer2.rewind();
        }
        catch (CharacterCodingException characterCodingException) {
            throw new DicomCharsetException("Unable to encode character:" + characterCodingException, characterCodingException);
        }
        if (dicomCharset != dicomCharset2) {
            byte[] byArray;
            if (byteBuffer2.get() > 0) {
                byArray = dicomCharset.getEscapeSequenceG0();
                if (byArray == null) {
                    throw new DicomCharsetException("no G0 escape sequence found for " + dicomCharset.getDefinedTerm());
                }
            } else {
                byArray = dicomCharset.getEscapeSequenceG1();
                if (byArray == null) {
                    throw new DicomCharsetException("no G1 escape sequence found for " + dicomCharset.getDefinedTerm());
                }
            }
            byteBuffer2.rewind();
            byteBuffer.put((byte)27);
            byteBuffer.put(byArray);
        }
        byteBuffer.put(byteBuffer2);
    }

    public String decode(byte[] byArray) throws DicomCharsetException {
        return this.decode(byArray, 0, byArray.length);
    }

    public String decode(byte[] byArray, int n2, int n3) throws DicomCharsetException {
        return this.decode(byArray, n2, n3, new DicomCharset[]{DicomCharset.DEFAULT});
    }

    public String decode(byte[] byArray, DicomCharset[] dicomCharsetArray) throws DicomCharsetException {
        return this.decode(byArray, 0, byArray.length, dicomCharsetArray);
    }

    public String decode(byte[] byArray, int n2, int n3, DicomCharset[] dicomCharsetArray) throws DicomCharsetException {
        ByteBuffer byteBuffer = ByteBuffer.wrap(byArray, n2, n3);
        if (dicomCharsetArray.length == 1) {
            try {
                CharsetDecoder charsetDecoder = dicomCharsetArray[0].getJavaCharset().newDecoder();
                return charsetDecoder.decode(byteBuffer).toString();
            }
            catch (CharacterCodingException characterCodingException) {
                this.log.warn("decoding using specified characterset failed,using fail-over: " + characterCodingException);
                this.log.debug("", characterCodingException);
                return this.a(byArray, n2, n3, characterCodingException);
            }
            catch (UnsupportedCharsetException unsupportedCharsetException) {
                this.log.warn("decoding using specified characterset failed,using fail-over: " + unsupportedCharsetException);
                this.log.debug("", unsupportedCharsetException);
                return this.a(byArray, n2, n3, unsupportedCharsetException);
            }
        }
        StringBuffer stringBuffer = new StringBuffer();
        byte[] byArray2 = new byte[2];
        byte[] byArray3 = new byte[3];
        int n4 = byteBuffer.position();
        Charset charset = dicomCharsetArray[0].getJavaCharset();
        while (byteBuffer.hasRemaining()) {
            byte by = byteBuffer.get();
            if (by != 27) continue;
            ByteBuffer byteBuffer2 = ByteBuffer.wrap(byteBuffer.array(), n4, byteBuffer.position() - n4 - 1);
            try {
                stringBuffer.append(charset.newDecoder().decode(byteBuffer2).toString());
            }
            catch (CharacterCodingException characterCodingException) {
                throw new DicomCharsetException("unable to decode bytes into String", characterCodingException);
            }
            byArray2[0] = byteBuffer.get();
            byArray2[1] = byteBuffer.get();
            DicomCharset dicomCharset = DicomCharset.lookup(byArray2);
            if (dicomCharset == null) {
                byArray3[0] = byArray2[0];
                byArray3[1] = byArray2[1];
                byArray3[2] = byteBuffer.get();
                dicomCharset = DicomCharset.lookup(byArray3);
                if (dicomCharset == null) {
                    throw new DicomCharsetException("unknown escape sequence encountered", null);
                }
            }
            charset = dicomCharset.getJavaCharset();
            n4 = byteBuffer.position();
        }
        if (n4 < byteBuffer.limit()) {
            byteBuffer.position(n4);
            try {
                stringBuffer.append(charset.newDecoder().decode(byteBuffer).toString());
            }
            catch (CharacterCodingException characterCodingException) {
                throw new DicomCharsetException("unable to decode bytes into String", characterCodingException);
            }
        }
        return stringBuffer.toString();
    }

    private String a(byte[] byArray, int n2, int n3, Exception exception) {
        if (Jdt.isThrowCodingException()) {
            throw new DicomCharsetException("unable to decode bytes into String: " + exception, exception);
        }
        if (Jdt.isUsePlatformCharset()) {
            return new String(byArray, n2, n3);
        }
        CharsetDecoder charsetDecoder = DicomCharset.lookup("ISO_IR 100").getJavaCharset().newDecoder();
        charsetDecoder.onMalformedInput(CodingErrorAction.REPLACE);
        try {
            ByteBuffer byteBuffer = ByteBuffer.wrap(byArray, n2, n3);
            byteBuffer.position(n2);
            return charsetDecoder.decode(byteBuffer).toString();
        }
        catch (CharacterCodingException characterCodingException) {
            throw new DicomCharsetException("unable to decode bytes into String with ISO_IR 100 charset: " + characterCodingException, characterCodingException);
        }
    }
}

