/*
 * Decompiled with CFR 0.152.
 */
package com.archimed.dicom.dir;

import java.util.regex.Pattern;

public interface QueryMode {
    public static final QueryMode CASE_SENSITIVE_SUBSTRING = new QueryMode(){

        public boolean match(String string, String string2) {
            if (string == null ^ string2 == null) {
                return false;
            }
            if (string == null) {
                string = "";
            }
            if (string2 == null) {
                string2 = "";
            }
            return string.indexOf(string2) >= 0;
        }
    };
    public static final QueryMode CASE_INSENSITIVE_SUBSTRING = new QueryMode(){

        public boolean match(String string, String string2) {
            if (string == null ^ string2 == null) {
                return false;
            }
            if (string == null) {
                string = "";
            }
            if (string2 == null) {
                string2 = "";
            }
            return string.toLowerCase().indexOf(string2.toLowerCase()) >= 0;
        }
    };
    public static final QueryMode EXACT = new QueryMode(){

        public boolean match(String string, String string2) {
            if (string == null ^ string2 == null) {
                return false;
            }
            if (string == null && string2 == null) {
                return true;
            }
            return string.equals(string2);
        }
    };
    public static final QueryMode CASE_INSENSITIVE = new QueryMode(){

        public boolean match(String string, String string2) {
            if (string == null ^ string2 == null) {
                return false;
            }
            if (string == null && string2 == null) {
                return true;
            }
            return string.equalsIgnoreCase(string2);
        }
    };
    public static final QueryMode REGEX_FULL = new QueryMode(){

        public boolean match(String string, String string2) {
            if (string == null ^ string2 == null) {
                return false;
            }
            if (string == null && string2 == null) {
                return true;
            }
            return string.matches(string2);
        }
    };
    public static final QueryMode REGEX_SUBSTRING = new QueryMode(){

        public boolean match(String string, String string2) {
            if (string == null ^ string2 == null) {
                return false;
            }
            if (string == null && string2 == null) {
                return true;
            }
            return Pattern.compile(string2).matcher(string).find();
        }
    };
    public static final QueryMode EMPTY = new QueryMode(){

        public boolean match(String string, String string2) {
            return string == null || string.length() == 0;
        }
    };
    public static final QueryMode NOT_EMPTY = new QueryMode(){

        public boolean match(String string, String string2) {
            return string != null && string.length() > 0;
        }
    };

    public boolean match(String var1, String var2);
}

