/*
 * Decompiled with CFR 0.152.
 */
package com.archimed.dicom.network;

import com.archimed.dicom.DicomException;
import com.archimed.dicom.network.AbortException;
import com.archimed.dicom.network.Acknowledge;
import com.archimed.dicom.network.Dimse;
import com.archimed.dicom.network.PduException;
import com.archimed.dicom.network.PresentationContext;
import com.archimed.dicom.network.Request;
import com.archimed.dicom.network.ULServiceMessage;
import com.archimed.dicom.network.ag;
import com.archimed.dicom.network.ah;
import com.archimed.dicom.network.ak;
import com.archimed.dicom.network.al;
import com.archimed.dicom.network.am;
import com.archimed.dicom.network.q;
import com.archimed.dicom.network.r;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class AssociationIO {
    private InputStream case;
    private al byte;
    private ak a;
    private OutputStream for;
    private q int;
    private r char;
    private int new = -1;
    private int goto = -1;
    private boolean else = true;
    private boolean if = true;
    private boolean try = true;
    private Acknowledge do;

    public AssociationIO(InputStream inputStream, OutputStream outputStream) {
        this.case = inputStream;
        this.for = outputStream;
        this.byte = new al(inputStream);
        this.a = new ak(this.byte);
        this.int = new q(outputStream);
        this.char = new r(outputStream);
    }

    public ULServiceMessage read() throws IOException, PduException, AbortException, DicomException {
        ah ah2 = this.byte.a();
        if (ah2.getType() == 1) {
            this.goto = ((Request)ah2).getMaxPduSize();
        } else if (ah2.getType() == 2) {
            this.goto = ((Acknowledge)ah2).getMaxPduSize();
            this.do = (Acknowledge)ah2;
        }
        if (ah2.getType() != 4) {
            return (ULServiceMessage)((Object)ah2);
        }
        ULServiceMessage uLServiceMessage = this.a.if((am)ah2);
        if (uLServiceMessage.getMessageType() != 1004) {
            throw new PduException("unexpected pdu received: " + uLServiceMessage);
        }
        Dimse dimse = (Dimse)uLServiceMessage;
        PresentationContext presentationContext = this.do.findPresentationContext(dimse.getPresentationContextId());
        if (presentationContext == null) {
            throw new PduException("received Dimse refers to unknown presentation context ID: " + dimse.getPresentationContextId());
        }
        if (presentationContext.getResult() != 0) {
            throw new PduException("received Dimse refers to presentation context ID with different status than ACCEPTED");
        }
        dimse.setDatasetTransferSyntax(presentationContext.getAcceptedTS().getConstant());
        return dimse;
    }

    public void write(ULServiceMessage uLServiceMessage) throws IOException, PduException, DicomException {
        if (uLServiceMessage.getMessageType() == 1002) {
            this.do = (Acknowledge)uLServiceMessage;
        }
        if (uLServiceMessage.getMessageType() != 1004) {
            this.int.a((ah)((Object)uLServiceMessage));
            return;
        }
        Dimse dimse = (Dimse)uLServiceMessage;
        PresentationContext presentationContext = this.do.findPresentationContext(dimse.getPresentationContextId());
        if (presentationContext == null) {
            throw new PduException("no presentation context found in Acknowledge with pc id: " + dimse.getPresentationContextId());
        }
        if (presentationContext.getResult() != 0) {
            throw new PduException("presentation context specified in Dimse does not have status ACCEPTED");
        }
        int n2 = this.new == -1 ? this.goto : this.new;
        if (n2 == 0) {
            n2 = 16384;
        }
        this.char.a((Dimse)uLServiceMessage, n2, this.else, this.try, presentationContext.getAcceptedTS().getConstant(), this.if);
    }

    public boolean isSeparateDataPDU() {
        return this.try;
    }

    public void setSeparateDataPDU(boolean bl) {
        this.try = bl;
    }

    public boolean isWriteSeqUndefLength() {
        return this.else;
    }

    public void setWriteSeqUndefLength(boolean bl) {
        this.else = bl;
    }

    public int getMaxPduLength() {
        return this.new;
    }

    public void setMaxPduLength(int n2) {
        if (n2 < 0) {
            throw new IllegalArgumentException("length must be > 0");
        }
        this.new = n2;
    }

    public void addProgressListener(ag ag2) {
        this.char.if(ag2);
    }

    public void removeProgressListener(ag ag2) {
        this.char.a(ag2);
    }

    public boolean isWriteGroupLengths() {
        return this.if;
    }

    public void setWriteGroupLengths(boolean bl) {
        this.if = bl;
    }
}

