/*
 * Decompiled with CFR 0.152.
 */
package com.archimed.dicom.network;

import com.archimed.dicom.DicomException;
import com.archimed.dicom.DicomObject;
import com.archimed.dicom.IllegalValueException;
import com.archimed.dicom.UID;
import com.archimed.dicom.UnknownUIDException;
import java.util.Hashtable;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class DimseUtil {
    public static final int N_EVENT_REPORT_REQUEST = 256;
    public static final int N_EVENT_REPORT_RESPONSE = 33024;
    public static final int N_GET_REQUEST = 272;
    public static final int N_GET_RESPONSE = 33040;
    public static final int N_SET_REQUEST = 288;
    public static final int N_SET_RESPONSE = 33056;
    public static final int N_ACTION_REQUEST = 304;
    public static final int N_ACTION_RESPONSE = 33072;
    public static final int N_CREATE_REQUEST = 320;
    public static final int N_CREATE_RESPONSE = 33088;
    public static final int N_DELETE_REQUEST = 336;
    public static final int N_DELETE_RESPONSE = 33104;
    public static final int C_STORE_REQUEST = 1;
    public static final int C_STORE_RESPONSE = 32769;
    public static final int C_GET_REQUEST = 16;
    public static final int C_GET_RESPONSE = 32784;
    public static final int C_FIND_REQUEST = 32;
    public static final int C_FIND_RESPONSE = 32800;
    public static final int C_MOVE_REQUEST = 33;
    public static final int C_MOVE_RESPONSE = 32801;
    public static final int C_ECHO_REQUEST = 48;
    public static final int C_ECHO_RESPONSE = 32816;
    public static final int C_CANCEL_FIND_REQUEST = 4095;
    public static final int MEDIUM_PRIORITY = 0;
    public static final int HIGH_PRIORITY = 1;
    public static final int LOW_PRIORITY = 2;
    private static final Integer if = new Integer(0);
    private static final Integer do = new Integer(257);
    private static Hashtable a = new Hashtable();

    private static final void a(int n2, String string) {
        a.put(new Integer(n2), string);
    }

    public static String getCommandName(int n2) {
        return (String)a.get(new Integer(n2));
    }

    public static int getCommandType(DicomObject dicomObject) throws IllegalValueException {
        Integer n2 = (Integer)dicomObject.get(3);
        if (n2 == null) {
            throw new IllegalValueException("dicomset is not a DIMSE command");
        }
        return n2;
    }

    public static int getMessageID(DicomObject dicomObject) throws IllegalValueException {
        Integer n2 = (Integer)dicomObject.get(4);
        if (n2 == null) {
            throw new IllegalValueException("dicomset does not contain MessageID tag");
        }
        return n2;
    }

    public static int getMessageIDBeingRespondedTo(DicomObject dicomObject) throws IllegalValueException {
        Integer n2 = (Integer)dicomObject.get(5);
        if (n2 == null) {
            throw new IllegalValueException("dicomset does not contain MessageIDBeingRespondedTo tag");
        }
        return n2;
    }

    public static int getPriority(DicomObject dicomObject) throws IllegalValueException {
        Integer n2 = (Integer)dicomObject.get(4);
        if (n2 == null) {
            throw new IllegalValueException("dicomset does not contain Priority tag");
        }
        return n2;
    }

    public static int getAffectedSOPClass(DicomObject dicomObject) throws IllegalValueException, UnknownUIDException {
        String string = (String)dicomObject.get(1);
        return UID.getUIDEntry(string).getConstant();
    }

    public static String getAffectedSOPInstance(DicomObject dicomObject) throws IllegalValueException {
        String string = (String)dicomObject.get(13);
        return string;
    }

    public static int getRequestedSOPClass(DicomObject dicomObject) throws IllegalValueException, UnknownUIDException {
        String string = (String)dicomObject.get(2);
        return UID.getUIDEntry(string).getConstant();
    }

    public static String getRequestedSOPInstance(DicomObject dicomObject) throws IllegalValueException, UnknownUIDException {
        String string = (String)dicomObject.get(14);
        return string;
    }

    public static boolean dataPresent(DicomObject dicomObject) throws IllegalValueException {
        Integer n2 = (Integer)dicomObject.get(8);
        if (n2 == null) {
            throw new IllegalValueException("no DataSetType tag in dicomobject");
        }
        return n2 != 257;
    }

    public static DicomObject createEventReportRequest(Integer n2, Integer n3, String string, boolean bl, Integer n4) throws DicomException, IllegalValueException {
        DicomObject dicomObject = new DicomObject();
        dicomObject.set(3, new Integer(256));
        dicomObject.set(1, UID.getUIDEntry(n3).getValue());
        dicomObject.set(4, n2);
        if (bl) {
            dicomObject.set(8, if);
        } else {
            dicomObject.set(8, do);
        }
        dicomObject.set(13, string);
        dicomObject.set(15, n4);
        return dicomObject;
    }

    public static DicomObject createEventReportResponse(Integer n2, Integer n3, String string, boolean bl, Integer n4, Integer n5) throws DicomException, IllegalValueException {
        DicomObject dicomObject = new DicomObject();
        if (n3 != null) {
            dicomObject.set(1, UID.getUIDEntry(n3).getValue());
        }
        dicomObject.set(3, new Integer(33024));
        dicomObject.set(5, n2);
        if (bl) {
            dicomObject.set(8, if);
        } else {
            dicomObject.set(8, do);
        }
        if (string != null) {
            dicomObject.set(13, string);
        }
        if (n5 != null) {
            dicomObject.set(15, n5);
        }
        dicomObject.set(9, n4);
        return dicomObject;
    }

    public static DicomObject createNGetRequest(Integer n2, Integer n3, String string, int[] nArray) throws DicomException, IllegalValueException {
        DicomObject dicomObject = new DicomObject();
        dicomObject.set(2, UID.getUIDEntry(n3).getValue());
        dicomObject.set(3, new Integer(272));
        dicomObject.set(4, n2);
        dicomObject.set(8, do);
        dicomObject.set(14, string);
        return dicomObject;
    }

    public static DicomObject createNGetResponse(Integer n2, Integer n3, String string, boolean bl, Integer n4) throws DicomException, IllegalValueException {
        DicomObject dicomObject = new DicomObject();
        if (n3 != null) {
            dicomObject.set(1, UID.getUIDEntry(n3).getValue());
        }
        dicomObject.set(3, new Integer(33040));
        dicomObject.set(5, n2);
        if (bl) {
            dicomObject.set(8, if);
        } else {
            dicomObject.set(8, do);
        }
        if (string != null) {
            dicomObject.set(13, string);
        }
        dicomObject.set(9, n4);
        return dicomObject;
    }

    public static DicomObject createSetRequest(Integer n2, Integer n3, String string) throws DicomException, IllegalValueException {
        DicomObject dicomObject = new DicomObject();
        dicomObject.set(2, UID.getUIDEntry(n3).getValue());
        dicomObject.set(3, new Integer(288));
        dicomObject.set(4, n2);
        dicomObject.set(8, if);
        dicomObject.set(14, string);
        return dicomObject;
    }

    public static DicomObject createSetResponse(Integer n2, Integer n3, String string, boolean bl, Integer n4) throws DicomException, IllegalValueException {
        DicomObject dicomObject = new DicomObject();
        if (n3 != null) {
            dicomObject.set(1, UID.getUIDEntry(n3).getValue());
        }
        dicomObject.set(3, new Integer(33056));
        dicomObject.set(5, n2);
        if (bl) {
            dicomObject.set(8, if);
        } else {
            dicomObject.set(8, if);
        }
        if (string != null) {
            dicomObject.set(13, string);
        }
        dicomObject.set(9, n4);
        return dicomObject;
    }

    public static DicomObject createActionRequest(Integer n2, Integer n3, String string, boolean bl, Integer n4) throws DicomException, IllegalValueException {
        DicomObject dicomObject = new DicomObject();
        dicomObject.set(2, UID.getUIDEntry(n3).getValue());
        dicomObject.set(3, new Integer(304));
        dicomObject.set(4, n2);
        if (bl) {
            dicomObject.set(8, if);
        } else {
            dicomObject.set(8, do);
        }
        dicomObject.set(14, string);
        dicomObject.set(18, n4);
        return dicomObject;
    }

    public static DicomObject createActionResponse(Integer n2, Integer n3, String string, boolean bl, Integer n4, Integer n5) throws DicomException, IllegalValueException {
        DicomObject dicomObject = new DicomObject();
        if (n3 != null) {
            dicomObject.set(1, UID.getUIDEntry(n3).getValue());
        }
        dicomObject.set(3, new Integer(33072));
        dicomObject.set(5, n2);
        if (bl) {
            dicomObject.set(8, if);
        } else {
            dicomObject.set(8, do);
        }
        if (string != null) {
            dicomObject.set(13, string);
        }
        if (n5 != null) {
            dicomObject.set(18, n5);
        }
        dicomObject.set(9, n4);
        return dicomObject;
    }

    public static DicomObject createCreateRequest(Integer n2, Integer n3, String string, boolean bl) throws DicomException, IllegalValueException {
        DicomObject dicomObject = new DicomObject();
        dicomObject.set(1, UID.getUIDEntry(n3).getValue());
        dicomObject.set(3, new Integer(320));
        dicomObject.set(4, n2);
        if (bl) {
            dicomObject.set(8, if);
        } else {
            dicomObject.set(8, do);
        }
        if (string != null) {
            dicomObject.set(13, string);
        }
        return dicomObject;
    }

    public static DicomObject createCreateResponse(Integer n2, Integer n3, String string, boolean bl, Integer n4) throws DicomException, IllegalValueException {
        DicomObject dicomObject = new DicomObject();
        if (n3 != null) {
            dicomObject.set(1, UID.getUIDEntry(n3).getValue());
        }
        dicomObject.set(3, new Integer(33088));
        dicomObject.set(5, n2);
        if (bl) {
            dicomObject.set(8, if);
        } else {
            dicomObject.set(8, do);
        }
        if (string != null) {
            dicomObject.set(13, string);
        }
        dicomObject.set(9, n4);
        return dicomObject;
    }

    public static DicomObject createDeleteRequest(Integer n2, Integer n3, String string) throws DicomException, IllegalValueException {
        DicomObject dicomObject = new DicomObject();
        dicomObject.set(2, UID.getUIDEntry(n3).getValue());
        dicomObject.set(3, new Integer(336));
        dicomObject.set(4, n2);
        dicomObject.set(8, do);
        dicomObject.set(14, string);
        return dicomObject;
    }

    public static DicomObject createDeleteResponse(Integer n2, Integer n3, String string, Integer n4) throws DicomException, IllegalValueException {
        DicomObject dicomObject = new DicomObject();
        if (n3 != null) {
            dicomObject.set(1, UID.getUIDEntry(n3).getValue());
        }
        dicomObject.set(3, new Integer(33104));
        dicomObject.set(5, n2);
        dicomObject.set(8, do);
        if (string != null) {
            dicomObject.set(13, string);
        }
        dicomObject.set(9, n4);
        return dicomObject;
    }

    public static DicomObject createEchoRequest(Integer n2, Integer n3) throws DicomException, IllegalValueException {
        DicomObject dicomObject = new DicomObject();
        dicomObject.set(1, UID.getUIDEntry(n3).getValue());
        dicomObject.set(3, new Integer(48));
        dicomObject.set(4, n2);
        dicomObject.set(8, do);
        return dicomObject;
    }

    public static DicomObject createEchoResponse(Integer n2, Integer n3, Integer n4) throws DicomException, IllegalValueException {
        DicomObject dicomObject = new DicomObject();
        if (n3 != null) {
            dicomObject.set(1, UID.getUIDEntry(n3).getValue());
        }
        dicomObject.set(3, new Integer(32816));
        dicomObject.set(5, n2);
        dicomObject.set(8, do);
        dicomObject.set(9, n4);
        return dicomObject;
    }

    public static DicomObject createMoveRequest(Integer n2, Integer n3, Integer n4, String string) throws DicomException, IllegalValueException {
        DicomObject dicomObject = new DicomObject();
        dicomObject.set(1, UID.getUIDEntry(n3).getValue());
        dicomObject.set(3, new Integer(33));
        dicomObject.set(4, n2);
        dicomObject.set(7, n4);
        dicomObject.set(8, if);
        dicomObject.set(6, string);
        return dicomObject;
    }

    public static DicomObject createMoveResponse(Integer n2, Integer n3, boolean bl, Integer n4, Integer n5, Integer n6, Integer n7, Integer n8) throws DicomException, IllegalValueException {
        DicomObject dicomObject = new DicomObject();
        if (n3 != null) {
            dicomObject.set(1, UID.getUIDEntry(n3).getValue());
        }
        dicomObject.set(3, new Integer(32801));
        dicomObject.set(5, n2);
        if (bl) {
            dicomObject.set(8, if);
        } else {
            dicomObject.set(8, do);
        }
        dicomObject.set(9, n4);
        if (n5 != null) {
            dicomObject.set(19, n5);
        }
        if (n6 != null) {
            dicomObject.set(20, n6);
        }
        if (n7 != null) {
            dicomObject.set(21, n7);
        }
        if (n8 != null) {
            dicomObject.set(22, n8);
        }
        return dicomObject;
    }

    public static DicomObject createCGetRequest(Integer n2, Integer n3, Integer n4) throws DicomException, IllegalValueException {
        DicomObject dicomObject = new DicomObject();
        dicomObject.set(1, UID.getUIDEntry(n3).getValue());
        dicomObject.set(3, new Integer(16));
        dicomObject.set(4, n2);
        dicomObject.set(7, n4);
        dicomObject.set(8, if);
        return dicomObject;
    }

    public static DicomObject createCGetResponse(Integer n2, Integer n3, boolean bl, Integer n4, Integer n5, Integer n6, Integer n7, Integer n8) throws DicomException, IllegalValueException {
        DicomObject dicomObject = new DicomObject();
        if (n3 != null) {
            dicomObject.set(1, UID.getUIDEntry(n3).getValue());
        }
        dicomObject.set(3, new Integer(32784));
        dicomObject.set(5, n2);
        if (bl) {
            dicomObject.set(8, if);
        } else {
            dicomObject.set(8, do);
        }
        dicomObject.set(9, n4);
        if (n5 != null) {
            dicomObject.set(19, n5);
        }
        if (n6 != null) {
            dicomObject.set(20, n5);
        }
        if (n7 != null) {
            dicomObject.set(21, n5);
        }
        if (n8 != null) {
            dicomObject.set(22, n5);
        }
        return dicomObject;
    }

    public static DicomObject createStoreRequest(Integer n2, Integer n3, Integer n4, String string, String string2, String string3) throws DicomException, IllegalValueException {
        DicomObject dicomObject = new DicomObject();
        dicomObject.set(1, UID.getUIDEntry(n3).getValue());
        dicomObject.set(3, new Integer(1));
        dicomObject.set(4, n2);
        dicomObject.set(7, n4);
        dicomObject.set(8, if);
        dicomObject.set(13, string);
        if (string2 != null) {
            dicomObject.set(23, string2);
        }
        if (string3 != null) {
            dicomObject.set(24, new Integer(string3));
        }
        return dicomObject;
    }

    public static DicomObject createStoreResponse(Integer n2, Integer n3, String string, Integer n4) throws DicomException, IllegalValueException {
        DicomObject dicomObject = new DicomObject();
        if (n3 != null) {
            dicomObject.set(1, UID.getUIDEntry(n3).getValue());
        }
        dicomObject.set(3, new Integer(32769));
        dicomObject.set(5, n2);
        dicomObject.set(8, do);
        dicomObject.set(9, n4);
        if (string != null) {
            dicomObject.set(13, string);
        }
        return dicomObject;
    }

    public static DicomObject createFindRequest(Integer n2, Integer n3, Integer n4) throws DicomException, IllegalValueException {
        DicomObject dicomObject = new DicomObject();
        dicomObject.set(1, UID.getUIDEntry(n3).getValue());
        dicomObject.set(3, new Integer(32));
        dicomObject.set(4, n2);
        dicomObject.set(8, if);
        dicomObject.set(7, n4);
        return dicomObject;
    }

    public static DicomObject createFindResponse(Integer n2, Integer n3, boolean bl, Integer n4) throws DicomException, IllegalValueException {
        DicomObject dicomObject = new DicomObject();
        if (n3 != null) {
            dicomObject.set(1, UID.getUIDEntry(n3).getValue());
        }
        dicomObject.set(3, new Integer(32800));
        dicomObject.set(5, n2);
        if (bl) {
            dicomObject.set(8, if);
        } else {
            dicomObject.set(8, do);
        }
        dicomObject.set(9, n4);
        return dicomObject;
    }

    public static DicomObject createCancelRequest(Integer n2) throws DicomException, IllegalValueException {
        DicomObject dicomObject = new DicomObject();
        dicomObject.set(3, new Integer(4095));
        dicomObject.set(5, n2);
        dicomObject.set(8, do);
        return dicomObject;
    }

    static {
        DimseUtil.a(256, "N-EVENT-REPORT-REQUEST");
        DimseUtil.a(33024, "N-EVENT-REPORT-RESPONSE");
        DimseUtil.a(272, "N-GET-REQUEST");
        DimseUtil.a(33040, "N-GET-RESPONSE");
        DimseUtil.a(288, "N-SET-REQUEST");
        DimseUtil.a(33056, "N-SET-RESPONSE");
        DimseUtil.a(304, "N-ACTION-REQUEST");
        DimseUtil.a(33072, "N-ACTION-RESPONSE");
        DimseUtil.a(320, "N-CREATE-REQUEST");
        DimseUtil.a(33088, "N-CREATE-RESPONSE");
        DimseUtil.a(336, "N-DELETE-REQUEST");
        DimseUtil.a(33104, "N-DELETE-RESPONSE");
        DimseUtil.a(1, "C-STORE-REQUEST");
        DimseUtil.a(32769, "C-STORE-RESPONSE");
        DimseUtil.a(16, "C-GET-REQUEST");
        DimseUtil.a(32784, "C-GET-RESPONSE");
        DimseUtil.a(32, "C-FIND-REQUEST");
        DimseUtil.a(32800, "C-FIND-RESPONSE");
        DimseUtil.a(33, "C-MOVE-REQUEST");
        DimseUtil.a(32801, "C-MOVE-RESPONSE");
        DimseUtil.a(48, "C-ECHO-REQUEST");
        DimseUtil.a(32816, "C-ECHO-RESPONSE");
        DimseUtil.a(4095, "C-CANCEL-FIND-REQUEST");
    }
}

