/*
 * Decompiled with CFR 0.152.
 */
package com.archimed.dicom.scu;

import com.archimed.dicom.DicomException;
import com.archimed.dicom.DicomObject;
import com.archimed.dicom.Jdt;
import com.archimed.dicom.SOPClassUID;
import com.archimed.dicom.network.Abort;
import com.archimed.dicom.network.AssociationIO;
import com.archimed.dicom.network.Command;
import com.archimed.dicom.network.Dimse;
import com.archimed.dicom.network.PduException;
import com.archimed.dicom.network.ReleaseRequest;
import com.archimed.dicom.network.ULServiceMessage;
import com.archimed.dicom.network.p;
import com.archimed.dicom.scu.SCUException;
import com.archimed.dicom.scu.SCUFactory;
import com.archimed.log.JdtLogger;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class CFindSCU {
    protected JdtLogger log = Jdt.getJdtLoggerFactory().getJdtLogger(CFindSCU.class);
    private AssociationIO do;
    private SOPClassUID for;
    private int int;
    private Command if = null;
    private boolean a = false;

    public CFindSCU(AssociationIO associationIO, int n2, SOPClassUID sOPClassUID) {
        this.do = associationIO;
        this.int = n2;
        this.for = sOPClassUID;
    }

    public AssociationIO getAssociationIO() {
        return this.do;
    }

    public Collection cfind(DicomObject dicomObject, int n2, ResponseHandler responseHandler) throws SCUException, DicomException, IOException {
        ULServiceMessage uLServiceMessage;
        int n3 = SCUFactory.getMessageID();
        Command command2 = Command.createCFindReq(n3, this.for.getConstant(), n2);
        Dimse dimse = new Dimse(this.int, command2, dicomObject);
        this.do.write(dimse);
        this.if = command2;
        ArrayList arrayList = new ArrayList();
        block4: while (true) {
            uLServiceMessage = this.do.read();
            switch (uLServiceMessage.getMessageType()) {
                case 1004: {
                    boolean bl;
                    if (!(bl = this.a(arrayList, (Dimse)uLServiceMessage, responseHandler))) continue block4;
                    return arrayList;
                }
                case 1007: {
                    this.log.error("abort received when expecting dimse: " + uLServiceMessage);
                    throw new SCUException("abort received when expecting dimse: " + uLServiceMessage);
                }
            }
            break;
        }
        this.log.error("unexpected pdu received when expecting dimse: " + uLServiceMessage);
        throw new SCUException("unexpected pdu received when expecting dimse: " + uLServiceMessage);
    }

    public void ccancelfind() throws SCUException, DicomException, IOException {
        if (this.if == null) {
            this.log.error("error sending C-CANCEL-FIND: unable to cancel before C-FIND request has been sent");
            new SCUException("error sending C-CANCEL-FIND: unable to cancel before C-FIND request has been sent");
        }
        Command command2 = Command.createCCancel(this.if);
        Dimse dimse = new Dimse(this.int, command2, null);
        this.do.write(dimse);
        this.a = true;
    }

    private boolean a(List list, Dimse dimse, ResponseHandler responseHandler) throws IOException, DicomException, SCUException {
        Command command2 = dimse.getCommand();
        if (command2.getCommandType() != 32800) {
            this.log.error("unexpected response command received: " + command2.getCommandName() + ", aborting");
            this.do.write(new Abort(Abort.DICOM_UL_SERVICE_USER, Abort.REASON_NOT_SPECIFIED));
            throw new SCUException("unexpected response command received: " + command2.getCommandName() + ", aborting");
        }
        p p2 = p.do(command2.getStatus());
        if (p2.try()) {
            responseHandler.success(dimse);
            this.log.debug("received success C-FIND response");
            return true;
        }
        if (p2.a()) {
            responseHandler.pending(dimse);
            if (!this.a) {
                this.log.debug("received pending C-FIND response, adding response dataset to collection");
                list.add(dimse.getDataSet());
            } else {
                this.log.debug("received pending C-FIND response when already canceled, omitting response dataset from collection");
            }
            return false;
        }
        if (p2.do()) {
            responseHandler.failed(dimse);
            return true;
        }
        if (p2.new()) {
            responseHandler.canceled(dimse);
            if (this.a) {
                return true;
            }
            this.log.error("unexpected status of canceled in C-FIND response");
            return true;
        }
        if (p2.if()) {
            this.log.error("unknown status code returned for C-FIND: " + p2 + ",aborting");
            this.do.write(new Abort(Abort.DICOM_UL_SERVICE_USER, Abort.REASON_NOT_SPECIFIED));
            return true;
        }
        this.log.error("internal error: code should not reach this point");
        throw new SCUException("internal error: code should not reach this point");
    }

    public void close() throws DicomException, IOException, PduException, SCUException {
        this.do.write(new ReleaseRequest());
        ULServiceMessage uLServiceMessage = this.do.read();
        if (uLServiceMessage.getMessageType() != 1006) {
            throw new SCUException("unexpected release response message: " + uLServiceMessage.getMessageType());
        }
    }

    public static interface ResponseHandler {
        public void pending(Dimse var1);

        public void success(Dimse var1);

        public void failed(Dimse var1);

        public void canceled(Dimse var1);
    }
}

