/*
 * Decompiled with CFR 0.152.
 */
package com.archimed.dicom.scu;

import com.archimed.dicom.DicomException;
import com.archimed.dicom.DicomObject;
import com.archimed.dicom.IllegalValueException;
import com.archimed.dicom.Jdt;
import com.archimed.dicom.SOPClassUID;
import com.archimed.dicom.network.Acknowledge;
import com.archimed.dicom.network.AssociationIO;
import com.archimed.dicom.network.Request;
import com.archimed.dicom.network.ResponsePolicy;
import com.archimed.dicom.network.ULServiceMessage;
import com.archimed.dicom.scu.CFindSCU;
import com.archimed.dicom.scu.MultiCFindSCU;
import com.archimed.dicom.scu.SCUException;
import com.archimed.dicom.scu.SCUFactory;
import com.archimed.dicom.scu.a.n;
import com.archimed.log.JdtLogger;
import java.io.IOException;
import java.net.Socket;
import java.util.Collection;

public class CFindSCUFactory
extends SCUFactory {
    protected static JdtLogger log = Jdt.getJdtLoggerFactory().getJdtLogger(CFindSCUFactory.class);

    public static Collection executeCFind(String string, int n2, String string2, String string3, SOPClassUID sOPClassUID, DicomObject dicomObject, CFindSCU.ResponseHandler responseHandler) throws SCUException, IOException {
        CFindSCU cFindSCU = CFindSCUFactory.createCFindSCU(string, n2, string3, string2, sOPClassUID);
        try {
            Collection collection = cFindSCU.cfind(dicomObject, 0, responseHandler);
            CFindSCUFactory.release(cFindSCU.getAssociationIO());
            return collection;
        }
        catch (DicomException dicomException) {
            log.error("DicomException while executing C-FIND: " + dicomException, dicomException);
            throw new SCUException("DicomException while executing C-FIND: + ex", dicomException);
        }
    }

    public static CFindSCU createCFindSCU(String string, int n2, String string2, String string3, SOPClassUID sOPClassUID) throws SCUException, IOException {
        Socket socket = new Socket(string, n2);
        return CFindSCUFactory.createCFindSCU(socket, string2, string3, sOPClassUID);
    }

    public static CFindSCU createCFindSCU(Socket socket, String string, String string2, SOPClassUID sOPClassUID) throws SCUException, IOException {
        AssociationIO associationIO = new AssociationIO(socket.getInputStream(), socket.getOutputStream());
        Request request = new Request();
        request.setCalledTitle(string2);
        request.setCallingTitle(string);
        try {
            request.addPresentationContext(1, sOPClassUID.getConstant(), new int[]{8193});
        }
        catch (IllegalValueException illegalValueException) {
            log.error("IllegalValueException while adding presentation context: " + illegalValueException, illegalValueException);
            throw new SCUException("IllegalValueException while adding presentation context: " + illegalValueException, illegalValueException);
        }
        request.setMaxPduSize(32768);
        try {
            associationIO.write(request);
        }
        catch (DicomException dicomException) {
            log.error("DicomException while writing Association Request: " + dicomException, dicomException);
            throw new SCUException("DicomException while writing Association Request: " + dicomException, dicomException);
        }
        ULServiceMessage uLServiceMessage = null;
        try {
            uLServiceMessage = associationIO.read();
        }
        catch (DicomException dicomException) {
            log.error("DicomException while reading Association Response: " + dicomException, dicomException);
            throw new SCUException("DicomException while writing Association Response: " + dicomException, dicomException);
        }
        switch (uLServiceMessage.getMessageType()) {
            case 1002: {
                int n2;
                Acknowledge acknowledge = (Acknowledge)uLServiceMessage;
                try {
                    n2 = ResponsePolicy.getResultForAbstractSyntax(request, acknowledge, sOPClassUID.getConstant());
                }
                catch (IllegalValueException illegalValueException) {
                    log.error("IllegalValueException while calling getResultForAbstractSyntax: " + illegalValueException, illegalValueException);
                    throw new SCUException("IllegalValueException while calling getResultForAbstractSyntax: " + illegalValueException);
                }
                if (n2 == 0) {
                    return new CFindSCU(associationIO, 1, sOPClassUID);
                }
                throw new SCUException("association acknwowledge received but presentation context not accepted");
            }
            case 1003: {
                log.error("association reject received: " + uLServiceMessage);
                throw new SCUException("association reject received: " + uLServiceMessage);
            }
            case 1007: {
                log.error("abort received: " + uLServiceMessage);
                throw new SCUException("abort received: " + uLServiceMessage);
            }
        }
        log.error("unexpected pdu received: " + uLServiceMessage);
        throw new SCUException("unexpected pdu received: " + uLServiceMessage);
    }

    public static MultiCFindSCU createMultiCFindSCU(String string, int n2, String string2, String string3) {
        return new n(string, n2, string2, string3);
    }

    public static MultiCFindSCU createMultiCFindSCU(String string, int n2, String string2, String string3, SOPClassUID sOPClassUID) {
        return new n(string, n2, string2, string3, sOPClassUID);
    }
}

