/*
 * Decompiled with CFR 0.152.
 */
package com.archimed.dicom.xml;

import com.archimed.dicom.DDict;
import com.archimed.dicom.DataElement;
import com.archimed.dicom.DicomException;
import com.archimed.dicom.DicomObject;
import com.archimed.dicom.DumpUtils;
import com.archimed.dicom.xml.Dicom2XmlException;
import java.io.OutputStream;
import java.util.Enumeration;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.DOMImplementation;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Text;

public class Dicom2FlatXmlConverter {
    public void write(DicomObject dicomObject, OutputStream outputStream) throws Dicom2XmlException, DicomException {
        DicomObject dicomObject2 = dicomObject.getFileMetaInformation();
        if (dicomObject2 == null) {
            throw new Dicom2XmlException("No file meta information");
        }
        this.write(dicomObject, outputStream, true);
    }

    public void write(DicomObject dicomObject, OutputStream outputStream, boolean bl) throws Dicom2XmlException, DicomException {
        Element element;
        DocumentBuilder documentBuilder;
        try {
            documentBuilder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
        }
        catch (ParserConfigurationException parserConfigurationException) {
            throw new Dicom2XmlException("ParserConfigurationException: " + parserConfigurationException, parserConfigurationException);
        }
        DOMImplementation dOMImplementation = documentBuilder.getDOMImplementation();
        Document document = dOMImplementation.createDocument("http://www.trispark.com/jdt/dicom2flatxml", "dicomfile", null);
        document.getDocumentElement().setAttribute("xmlns:xsi", "http://www.w3.org/2001/XMLSchema-instance");
        document.getDocumentElement().setAttribute("xsi:schemaLocation", "http://www.trispark.com/jdt/dicom2flatxml dicom2flatxml.xsd");
        DicomObject dicomObject2 = dicomObject.getFileMetaInformation();
        if (dicomObject2 != null && bl) {
            element = document.createElement("filemeta");
            document.getDocumentElement().appendChild(element);
            this.a(dicomObject2, document, element, "", "");
        }
        element = document.createElement("dataset");
        document.getDocumentElement().appendChild(element);
        this.a(dicomObject, document, element, "", "");
        TransformerFactory transformerFactory = TransformerFactory.newInstance();
        Transformer transformer = null;
        try {
            transformer = transformerFactory.newTransformer();
        }
        catch (TransformerConfigurationException transformerConfigurationException) {
            throw new Dicom2XmlException("TransformerConfigurationException: " + transformerConfigurationException, transformerConfigurationException);
        }
        DOMSource dOMSource = new DOMSource(document);
        StreamResult streamResult = new StreamResult(outputStream);
        try {
            transformer.transform(dOMSource, streamResult);
        }
        catch (TransformerException transformerException) {
            throw new Dicom2XmlException("TransformerException: " + transformerException, transformerException);
        }
    }

    private void a(DicomObject dicomObject, Document document, Element element, String string, String string2) throws DicomException {
        Enumeration enumeration = dicomObject.enumerateVRs(false);
        String string3 = "";
        String string4 = null;
        Element element2 = null;
        while (enumeration.hasMoreElements()) {
            DataElement dataElement = (DataElement)enumeration.nextElement();
            string3 = !string.equals("") ? string + "." + DumpUtils.toHexString(dataElement.getGroup(), 4) : DumpUtils.toHexString(dataElement.getGroup(), 4);
            if (string4 == null || !string4.equals(string3)) {
                element2 = document.createElement("dicom-group");
                element2.setAttribute("group", string3);
                if (!string2.equals("")) {
                    element2.setAttribute("card", string2);
                }
                element.appendChild(element2);
            }
            this.a(dataElement, document, element2, string, string2);
            string4 = string3;
        }
    }

    private void a(DataElement dataElement, Document document, Element element, String string, String string2) throws DicomException {
        String string3 = DumpUtils.toHexString(dataElement.getElement(), 4);
        Element element2 = document.createElement("dicom-element");
        element2.setAttribute("element", string3);
        element2.setAttribute("vr", DDict.getTypeName(dataElement.getVR()));
        element2.setAttribute("name", DDict.getDescription(dataElement.getTag()));
        element2.setAttribute("vm", dataElement.size() + "");
        element.appendChild(element2);
        if (dataElement.getVR() != 10) {
            this.a(dataElement, document, element2);
        } else {
            StringBuffer stringBuffer = new StringBuffer();
            if (!string.equals("")) {
                stringBuffer.append(string);
                stringBuffer.append(".");
            }
            stringBuffer.append(DumpUtils.toHexString(dataElement.getGroup(), 4));
            stringBuffer.append(".");
            stringBuffer.append(DumpUtils.toHexString(dataElement.getElement(), 4));
            String string4 = stringBuffer.toString();
            for (int i2 = 0; i2 < dataElement.size(); ++i2) {
                int n2 = i2 + 1;
                DicomObject dicomObject = dataElement.getSequenceItem(i2);
                this.a(dicomObject, document, (Element)element.getParentNode(), string4, n2 + "");
            }
        }
    }

    private void a(DataElement dataElement, Document document, Element element) throws DicomException {
        for (int i2 = 0; i2 < dataElement.size(); ++i2) {
            int n2 = i2 + 1;
            Element element2 = document.createElement("dicom-element-value");
            element2.setAttribute("card", "" + n2);
            Text text = document.createTextNode(dataElement.getString(i2));
            element2.appendChild(text);
            element.appendChild(element2);
        }
    }
}

