/*
 * Decompiled with CFR 0.152.
 */
package com.ge.med.StdAnno;

import com.ge.med.StdAnno.ApDicomAccessor;
import com.ge.med.StdAnno.ApGroup;
import com.ge.med.StdAnno.ApSeg;
import com.ge.med.StdAnno.ApTextDrawer;
import java.io.Serializable;
import java.text.DecimalFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.Hashtable;
import java.util.Vector;

public abstract class ApStyle {
    public static final int en_US = 0;
    public static final int es_MX = 1;
    public static final int fr = 2;
    public static final int it = 3;
    public static final int de = 4;
    public static final int pt_BR = 5;
    public static final int nb_NO = 6;
    public static final int zh = 7;
    public static final int kr = 8;
    public static final int ja = 9;
    public static final int ru_RU = 10;
    public static final int da_DK = 11;
    public static final int nl_NL = 12;
    public static final int fi_FI = 13;
    public static final int sv_SE = 14;
    public static final int NBLANGS = 15;
    protected int priority;
    private Date date;
    private Calendar cal;
    private int lang;
    private SimpleDateFormat dateFormatter;
    protected int nbGroups;
    private int currentGroup;
    protected String[] groupName = null;
    protected boolean[] groupOn = null;
    protected Vector<ApGroup> groups = new Vector();
    protected Hashtable<String, ApGroup> groupHash = new Hashtable();
    protected DecimalFormat df = new DecimalFormat();
    protected String[] dicomElements = null;
    protected Hashtable<String, Object> assigners = new Hashtable();
    protected LineVector[] quads;
    protected ApDicomAccessor valueAccessor;
    protected ApTextDrawer textDrawer;
    public static boolean traceOn = true;

    public ApStyle() {
        this.date = new Date();
        this.cal = Calendar.getInstance();
        this.dateFormatter = new SimpleDateFormat();
        this.quads = new LineVector[9];
        for (int i2 = 0; i2 < this.quads.length; ++i2) {
            this.quads[i2] = new LineVector();
        }
        this.priority = 0;
        this.lang = 0;
    }

    public void setCurrentPriority(int n2) {
        this.priority = n2;
    }

    public int getLang() {
        return this.lang;
    }

    public void setlang(int n2) {
        this.lang = n2;
        switch (n2) {
            case 0: {
                this.setRTVar("lang", "en_US");
                break;
            }
            case 1: {
                this.setRTVar("lang", "es_MX");
                break;
            }
            case 2: {
                this.setRTVar("lang", "fr");
                break;
            }
            case 3: {
                this.setRTVar("lang", "it");
                break;
            }
            case 4: {
                this.setRTVar("lang", "de");
                break;
            }
            case 5: {
                this.setRTVar("lang", "pt_BR");
                break;
            }
            case 7: {
                this.setRTVar("lang", "zh");
                break;
            }
            case 8: {
                this.setRTVar("lang", "kr");
                break;
            }
            case 9: {
                this.setRTVar("lang", "ja");
                break;
            }
            case 11: {
                this.setRTVar("lang", "da_DK");
                break;
            }
            case 12: {
                this.setRTVar("lang", "nl_NL");
                break;
            }
            case 13: {
                this.setRTVar("lang", "fi_FI");
                break;
            }
            case 14: {
                this.setRTVar("lang", "sv_SE");
                break;
            }
            case 6: {
                this.setRTVar("lang", "nb_NO");
                break;
            }
            case 10: {
                this.setRTVar("lang", "ru_RU");
                break;
            }
            default: {
                this.setRTVar("lang", "en_US");
            }
        }
    }

    public int getCurrentPriority() {
        return this.priority;
    }

    boolean isVisible(int n2, int n3, int n4, int n5, int n6) {
        boolean bl = false;
        if (n2 == 4 && n3 == -5) {
            System.out.println("Trace this section of annotation");
        }
        bl = n6 > this.priority;
        bl = bl && this.groupOn[n5];
        return bl;
    }

    public void build(ApStyle apStyle) {
        System.out.println("Build Not Implemented\n");
    }

    public void setAllGroupsOn() {
        for (int i2 = 0; i2 < this.groupOn.length; ++i2) {
            this.groupOn[i2] = true;
        }
    }

    public void setGroupState(String string, boolean bl) {
        for (int i2 = 0; i2 < this.groupName.length; ++i2) {
            if (!this.groupName[i2].equals(string)) continue;
            this.groupOn[i2] = bl;
        }
    }

    public boolean getGroupState(String string) {
        for (int i2 = 0; i2 < this.groupName.length; ++i2) {
            if (!this.groupName[i2].equals(string)) continue;
            return this.groupOn[i2];
        }
        return false;
    }

    public void setAllGroupsOff() {
        for (int i2 = 0; i2 < this.groupOn.length; ++i2) {
            this.groupOn[i2] = false;
        }
    }

    public final int getNumQuads() {
        return 9;
    }

    public final int getStartLine(int n2) {
        LineVector lineVector = this.quads[n2];
        return lineVector.getFirstLine();
    }

    public final int getLastLine(int n2) {
        LineVector lineVector = this.quads[n2];
        return lineVector.getLastLine();
    }

    public final int getNumSegments(int n2, int n3) {
        LineVector lineVector = this.quads[n2];
        Vector<ApSeg> vector = lineVector.get(n3);
        return vector.size();
    }

    public void paintAnnotation() {
        this.textDrawer.open();
        this.build(null);
        for (int i2 = 0; i2 < 9; ++i2) {
            int n2;
            LineVector lineVector = this.quads[i2];
            int n3 = 0;
            if (lineVector.getFirstLine() > n3) {
                n3 = lineVector.getFirstLine();
            }
            for (n2 = n3; n2 <= lineVector.getLastLine(); ++n2) {
                Vector<ApSeg> vector = lineVector.get(n2);
                for (int i3 = 0; i3 < vector.size(); ++i3) {
                    ApSeg apSeg = vector.get(i3);
                    if (!this.groupOn[apSeg.groupNumber] || apSeg.priority < this.priority) continue;
                    this.textDrawer.draw(apSeg.result, apSeg.location, apSeg.appearance, apSeg.annotationKey);
                }
            }
            n2 = -1;
            if (lineVector.getLastLine() < n2) {
                n2 = lineVector.getLastLine();
            }
            for (int i4 = n2; i4 >= lineVector.getFirstLine(); --i4) {
                Vector<ApSeg> vector = lineVector.get(i4);
                for (int i5 = 0; i5 < vector.size(); ++i5) {
                    ApSeg apSeg = vector.get(i5);
                    if (!this.groupOn[apSeg.groupNumber] || apSeg.priority < this.priority) continue;
                    this.textDrawer.draw(apSeg.result, apSeg.location, apSeg.appearance, apSeg.annotationKey);
                }
            }
        }
        this.textDrawer.close();
    }

    public ApSeg getSegAt(int n2, int n3, int n4) {
        LineVector lineVector = this.quads[n2];
        Vector<ApSeg> vector = lineVector.get(n3);
        if (vector != null) {
            if (vector.size() < n4 + 1) {
                return null;
            }
            return vector.get(n4);
        }
        return null;
    }

    public void setSegStringAt(int n2, int n3, int n4, String string) {
        ApSeg apSeg = this.getSegAt(n2, n3, n4);
        if (apSeg != null) {
            apSeg.result.setLength(0);
            apSeg.result.append(string);
        } else {
            System.out.println("Internal Error, Improper layout initialization.");
        }
    }

    public void setSeg(ApSeg apSeg) {
        int n2 = apSeg.location.quadrant;
        int n3 = apSeg.location.line;
        int n4 = apSeg.location.segment;
        LineVector lineVector = this.quads[n2];
        Vector<ApSeg> vector = lineVector.get(n3);
        if (vector == null) {
            vector = new Vector();
            lineVector.put(n3, vector);
        }
        for (int i2 = vector.size(); i2 < n4; ++i2) {
            vector.add(new ApSeg());
        }
        vector.add(n4, apSeg);
    }

    public void reset() {
    }

    public void setRTVar(String string, int n2) {
        block4: {
            try {
                Object object = this.assigners.get(string);
                if (object == null) break block4;
                if (object instanceof doubleAssigner) {
                    doubleAssigner doubleAssigner2 = (doubleAssigner)object;
                    doubleAssigner2.setValue(n2);
                    break block4;
                }
                if (object instanceof intAssigner) {
                    intAssigner intAssigner2 = (intAssigner)object;
                    intAssigner2.setValue(n2);
                    break block4;
                }
                throw new RuntimeException("attempt to set: " + string + " to the wrong type of int");
            }
            catch (Exception exception) {
                throw new RuntimeException("attempt to set: " + string + " to the wrong type of int");
            }
        }
    }

    public int getIntRTVar(String string) {
        intAssigner intAssigner2 = (intAssigner)this.assigners.get(string);
        return intAssigner2.getIntValue();
    }

    public void setRTVar(String string, String string2) {
        try {
            Object object = this.assigners.get(string);
            if (object != null) {
                StringAssigner stringAssigner = (StringAssigner)object;
                stringAssigner.setValue(string2);
            }
        }
        catch (Exception exception) {
            throw new RuntimeException("attempt to set: " + string + " to the wrong type of String");
        }
    }

    public void setRTVar(String string, boolean bl) {
        try {
            Object object = this.assigners.get(string);
            if (object != null) {
                booleanAssigner booleanAssigner2 = (booleanAssigner)object;
                booleanAssigner2.setValue(bl);
            }
        }
        catch (Exception exception) {
            throw new RuntimeException("attempt to set: " + string + " to the wrong type of String");
        }
    }

    public void setRTVar(String string, double d2) {
        try {
            Object object = this.assigners.get(string);
            if (object != null) {
                doubleAssigner doubleAssigner2 = (doubleAssigner)object;
                doubleAssigner2.setValue(d2);
            }
        }
        catch (Exception exception) {
            throw new RuntimeException("attempt to set: " + string + " to the wrong type of String");
        }
    }

    public void annotate() {
    }

    public int getNumberOfGroups() {
        return this.nbGroups;
    }

    public abstract int getNumberOfLocations();

    public abstract String getTooltip(int var1, int var2);

    protected void addGroup(ApGroup apGroup) {
        String string = apGroup.getGroupName();
        this.groupHash.put(string, apGroup);
    }

    public ApGroup getGroup(String string) {
        ApGroup apGroup = this.groupHash.get(string);
        return apGroup;
    }

    protected void addTopGroup(ApGroup apGroup) {
        int n2 = 0;
        for (int i2 = 0; i2 < this.groups.size(); ++i2) {
            if (apGroup.compareTo(this.groups.get(i2)) <= -1) continue;
            n2 = i2;
            break;
        }
        this.groups.insertElementAt(apGroup, n2);
    }

    public ApGroup getFirstGroup() {
        this.currentGroup = 0;
        if (this.groups.size() > 0) {
            ApGroup apGroup = this.groups.elementAt(this.currentGroup);
            apGroup.setCurrentChild(this.currentGroup);
            return apGroup;
        }
        return null;
    }

    public ApGroup getNextGroup() {
        ++this.currentGroup;
        if (this.groups.size() > this.currentGroup) {
            return this.groups.elementAt(this.currentGroup);
        }
        return null;
    }

    protected String[] splitString(String string, String string2) {
        Object[] objectArray;
        int n2 = 0;
        int n3 = 0;
        int n4 = string2.length();
        ArrayList<Object[]> arrayList = new ArrayList<Object[]>();
        do {
            n3 = string.indexOf(string2, n2);
            objectArray = null;
            if (n3 != -1) {
                objectArray = string.substring(n2, n3);
                n2 = n3 + n4;
            } else {
                objectArray = string.substring(n2);
            }
            if (objectArray == null || objectArray.equals("")) continue;
            arrayList.add(objectArray);
        } while (n3 != -1);
        objectArray = arrayList.toArray();
        String[] stringArray = new String[objectArray.length];
        for (int i2 = 0; i2 < objectArray.length; ++i2) {
            stringArray[i2] = (String)objectArray[i2];
        }
        return stringArray;
    }

    protected String getenv(String string) {
        try {
            return System.getProperty(string, "");
        }
        catch (Exception exception) {
            return null;
        }
    }

    protected boolean gt(String string, String string2) {
        return string2.compareTo(string) <= 0;
    }

    public boolean le(String string, String string2) {
        return string.compareTo(string2) < 0;
    }

    protected String format(String string, long l2) {
        String string2 = "";
        boolean bl = false;
        if (string.equals("%h %d %Y")) {
            this.cal.set(1, this.year(l2));
            this.cal.set(2, this.month(l2));
            this.cal.set(5, this.day(l2));
            this.date = this.cal.getTime();
            this.dateFormatter.applyPattern("MMM dd yyyy");
            string2 = this.dateFormatter.format(this.date);
            if (traceOn) {
                System.out.println("Date int:" + l2 + ":" + string2);
            }
            bl = true;
        }
        if (string.equals("%Y %m %d")) {
            this.cal.set(1, this.year(l2));
            this.cal.set(2, this.month(l2));
            this.cal.set(5, this.day(l2));
            this.date = this.cal.getTime();
            this.dateFormatter.applyPattern("yyyy MM dd");
            string2 = this.dateFormatter.format(this.date);
            if (traceOn) {
                System.out.println("Date int:" + l2 + ":" + string2);
            }
            bl = true;
        }
        if (string.equals("%r")) {
            this.cal.set(1, this.year(l2));
            this.cal.set(2, this.month(l2));
            this.cal.set(5, this.day(l2));
            this.date = this.cal.getTime();
            this.dateFormatter.applyPattern("hh:mm:ss aa");
            string2 = this.df.format(this.date);
            if (traceOn) {
                System.out.println("Date int:" + l2 + ":" + string2);
            }
            bl = true;
        }
        if (!bl) {
            return "???????";
        }
        return string2;
    }

    protected String decimalFormat(String string, double d2) {
        this.df.applyPattern(string);
        return this.df.format(d2);
    }

    protected String decimalFormat(String string, long l2) {
        this.df.applyPattern(string);
        return this.df.format(l2);
    }

    protected String decimalFormat(String string, int n2, double d2) {
        this.df.applyPattern(string);
        StringBuffer stringBuffer = new StringBuffer(this.df.format(d2));
        int n3 = stringBuffer.length();
        if (stringBuffer.length() < n2) {
            for (int i2 = 0; i2 < n2 - n3; ++i2) {
                stringBuffer.insert(0, ' ');
            }
        }
        return stringBuffer.toString();
    }

    protected String decimalFormat(String string, int n2, long l2) {
        this.df.applyPattern(string);
        StringBuffer stringBuffer = new StringBuffer(this.df.format(l2));
        if (stringBuffer.length() < n2) {
            int n3 = stringBuffer.length();
            for (int i2 = 0; i2 < n2 - n3; ++i2) {
                stringBuffer.insert(0, ' ');
            }
        }
        return stringBuffer.toString();
    }

    protected String expdecimalFormat(String string, int n2, long l2) {
        this.df.applyPattern(string);
        StringBuffer stringBuffer = new StringBuffer(this.df.format(l2));
        if (stringBuffer.length() < n2) {
            int n3 = stringBuffer.length();
            for (int i2 = 0; i2 < n2 - n3; ++i2) {
                stringBuffer.insert(0, ' ');
            }
        }
        return stringBuffer.toString();
    }

    protected String format(String string, String string2) {
        int n2 = 32;
        for (int i2 = 0; i2 < string.length(); ++i2) {
            n2 = string.charAt(i2);
            switch (n2) {
                default: 
            }
        }
        return "NIYFormatS";
    }

    protected String dateFormat(String string, String string2) {
        int n2 = Integer.parseInt(string2.substring(0, 4));
        int n3 = Integer.parseInt(string2.substring(4, 6));
        int n4 = Integer.parseInt(string2.substring(6, 8));
        int n5 = Integer.parseInt(string2.substring(8, 10));
        int n6 = Integer.parseInt(string2.substring(10, 12));
        int n7 = Integer.parseInt(string2.substring(12, 14));
        this.cal.set(n2, n3, n4, n5, n6, n7);
        this.date = this.cal.getTime();
        this.dateFormatter.applyPattern(string);
        this.dateFormatter.setCalendar(this.cal);
        this.date = this.cal.getTime();
        String string3 = this.dateFormatter.format(this.date);
        return string3;
    }

    protected String timeFormat(String string, long l2) {
        int n2 = (int)l2 % 100;
        int n3 = (int)(l2 /= 100L) % 100;
        int n4 = (int)(l2 /= 100L);
        this.cal.set(11, n4);
        this.cal.set(12, n3);
        this.cal.set(13, n2);
        this.date = this.cal.getTime();
        this.dateFormatter.applyPattern(string);
        String string2 = this.dateFormatter.format(this.date);
        return string2;
    }

    protected String timeFormat(String string, double d2) {
        int n2 = (int)d2 % 100;
        int n3 = (int)(d2 /= 100.0) % 100;
        int n4 = (int)(d2 /= 100.0);
        this.cal.set(11, n4);
        this.cal.set(12, n3);
        this.cal.set(13, n2);
        this.date = this.cal.getTime();
        this.dateFormatter.applyPattern(string);
        String string2 = this.dateFormatter.format(this.date);
        return string2;
    }

    protected String timeFormat(String string, String string2) {
        return "Not To Be Used";
    }

    protected String dateFormat(String string, long l2) {
        int n2 = (int)l2 % 100;
        int n3 = (int)(l2 /= 100L) % 100 - 1;
        int n4 = (int)(l2 /= 100L);
        this.cal.set(n4, n3, n2);
        this.date = this.cal.getTime();
        this.dateFormatter.applyPattern(string);
        String string2 = this.dateFormatter.format(this.date);
        return string2;
    }

    protected String split(String string, String string2, int n2) {
        Object[] objectArray;
        String string3 = "";
        int n3 = 0;
        int n4 = 0;
        int n5 = string2.length();
        ArrayList<Object[]> arrayList = new ArrayList<Object[]>();
        do {
            n4 = string.indexOf(string2, n3);
            objectArray = null;
            if (n4 != -1) {
                objectArray = string.substring(n3, n4);
                n3 = n4 + n5;
            } else {
                objectArray = string.substring(n3);
            }
            arrayList.add(objectArray);
        } while (n4 != -1);
        objectArray = arrayList.toArray();
        String[] stringArray = new String[objectArray.length];
        for (int i2 = 0; i2 < objectArray.length; ++i2) {
            stringArray[i2] = (String)objectArray[i2];
        }
        if (stringArray.length > n2) {
            string3 = stringArray[n2];
        }
        return string3;
    }

    protected String split(String string, int n2) {
        String[] stringArray = this.splitString(string, "\\");
        if (n2 >= stringArray.length || n2 < 0) {
            return "";
        }
        return stringArray[n2];
    }

    protected int splitCount(String string, String string2) {
        String[] stringArray = this.splitString(string, "\\");
        return stringArray.length;
    }

    protected String clean(String string) {
        return string.trim();
    }

    protected boolean isBlank(String string) {
        String string2 = string.trim();
        return string2.length() == 0;
    }

    protected int strlen(String string) {
        return string.length();
    }

    protected String replace(String string, String string2, String string3) {
        StringBuffer stringBuffer = new StringBuffer(string);
        int n2 = string.indexOf(string2);
        while (n2 != -1) {
            stringBuffer.replace(n2, n2 + string2.length(), string3);
            String string4 = stringBuffer.toString();
            n2 = string4.indexOf(string2);
        }
        return stringBuffer.toString();
    }

    protected int not(int n2) {
        if (n2 == 0) {
            return 1;
        }
        return 0;
    }

    protected String str(int n2) {
        return String.valueOf(n2);
    }

    protected String str(float f2) {
        return String.valueOf(f2);
    }

    protected String str(double d2) {
        return String.valueOf(d2);
    }

    protected String midstr(String string, int n2, int n3) {
        if (string.length() < n2 + n3) {
            if (string.length() - 1 < n2) {
                return "";
            }
            String string2 = string.substring(n2);
            return string2;
        }
        String string3 = string.substring(n2, n2 + n3);
        if (string3 == null) {
            return "";
        }
        return string3;
    }

    protected int toInt(String string) {
        double d2;
        if (string == null) {
            return 0;
        }
        if (string.compareTo("") == 0) {
            return 0;
        }
        try {
            d2 = Double.parseDouble(string);
        }
        catch (NumberFormatException numberFormatException) {
            if (traceOn) {
                System.out.println(" bad format from ApStyle::toInt number='" + string + "'");
            }
            return 0;
        }
        int n2 = (int)d2;
        return n2;
    }

    protected double toFloat(String string) {
        if (string == null) {
            return 0.0;
        }
        if (string.compareTo("") == 0) {
            return 0.0;
        }
        try {
            return Float.parseFloat(string);
        }
        catch (NumberFormatException numberFormatException) {
            if (traceOn) {
                System.out.println(" bad format from ApStyle::tofloat number='" + string + "'");
            }
            return 0.0;
        }
    }

    protected double floor(double d2) {
        return (float)Math.floor(d2);
    }

    protected int year(long l2) {
        int n2 = (int)l2 / 10000;
        return n2;
    }

    protected int month(long l2) {
        int n2 = (int)l2 / 100;
        int n3 = n2 % 100;
        return n3;
    }

    protected int day(long l2) {
        int n2 = (int)l2 % 100;
        return n2;
    }

    protected int strindex(String string, String string2) {
        int n2 = string.indexOf(string2);
        return n2;
    }

    protected boolean notZero(long l2) {
        return l2 != 0L;
    }

    protected int abs(int n2) {
        if (n2 < 0) {
            return -n2;
        }
        return n2;
    }

    protected int toInt(boolean bl) {
        if (bl) {
            return 1;
        }
        return 0;
    }

    protected double fabs(double d2) {
        return Math.abs(d2);
    }

    public ApDicomAccessor getValueAccessor() {
        return this.valueAccessor;
    }

    public void setValueAccessor(ApDicomAccessor apDicomAccessor) {
        this.valueAccessor = apDicomAccessor;
    }

    public ApTextDrawer getTextDrawer() {
        return this.textDrawer;
    }

    public void setTextDrawer(ApTextDrawer apTextDrawer) {
        this.textDrawer = apTextDrawer;
    }

    public String[] getDicomTags() {
        return this.dicomElements;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class LineVector
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private int lineNumberOffset = 0;
        private Vector<Vector<ApSeg>> lines = new Vector();

        public Vector<ApSeg> get(int n2) {
            try {
                return this.lines.get(n2 + this.lineNumberOffset);
            }
            catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                return null;
            }
        }

        public int getFirstLine() {
            return -this.lineNumberOffset;
        }

        public int getLastLine() {
            return this.lines.size() - this.lineNumberOffset - 1;
        }

        public void put(int n2, Vector<ApSeg> vector) {
            if (n2 < 0) {
                if (-n2 > this.lineNumberOffset) {
                    for (int i2 = n2 + this.lineNumberOffset + 1; i2 < 0; ++i2) {
                        this.lines.add(0, new Vector());
                    }
                    this.lineNumberOffset = -n2;
                    this.lines.add(0, vector);
                } else {
                    this.lines.add(n2 + this.lineNumberOffset, vector);
                }
            } else {
                for (int i3 = this.lines.size(); i3 < n2 + this.lineNumberOffset; ++i3) {
                    this.lines.add(i3, new Vector());
                }
                this.lines.add(n2 + this.lineNumberOffset, vector);
            }
        }
    }

    public class booleanAssigner {
        public void setValue(boolean bl) {
        }

        public boolean getBooleanvalue() {
            return false;
        }
    }

    protected class StringAssigner {
        protected StringAssigner() {
        }

        public void setValue(String string) {
        }

        public String getStringValue() {
            return "";
        }
    }

    protected class doubleAssigner {
        protected doubleAssigner() {
        }

        public void setValue(double d2) {
        }

        public double getDoubleValue() {
            return 0.0;
        }
    }

    protected class intAssigner {
        protected intAssigner() {
        }

        public void setValue(int n2) {
        }

        public int getIntValue() {
            return 0;
        }
    }
}

