/*
 * Decompiled with CFR 0.152.
 */
package com.ge.med.cse.apps.cdviewer;

import com.ge.med.cse.apps.cdviewer.MVFusionSeriesDisplayer;
import com.ge.med.idc.WindowLevelCapable;
import com.ge.med.terra.jami.XpCompositePort;
import com.ge.med.terra.jami.XpDicomElement;
import com.ge.med.terra.jami.XpDicomObject;
import com.ge.med.terra.jami.XpFrameVisualizer;
import com.ge.med.terra.jami.XpViewport;
import com.ge.med.terra.jami.XpViewportDirector;
import com.ge.med.terra.jami.render.XpImagePixelAttributes;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;

public class MvWinLinkDirector
implements XpViewportDirector {
    private ArrayList<WindowLevelCapable> portList = new ArrayList();
    private WindowlevelPropertyChangeListener listener = new WindowlevelPropertyChangeListener(this);
    private MVFusionSeriesDisplayer target = null;

    @Override
    public void connectViewport(XpViewport viewport) {
        if (!this.portList.contains(viewport) && viewport instanceof WindowLevelCapable) {
            this.portList.add((WindowLevelCapable)((Object)viewport));
            if (viewport instanceof MVFusionSeriesDisplayer) {
                this.target = (MVFusionSeriesDisplayer)viewport;
                return;
            }
            viewport.addPropertyChangeListener(this.listener);
        }
    }

    @Override
    public void disconnectAllViewports() {
        for (int i2 = 0; i2 < this.portList.size(); ++i2) {
            WindowLevelCapable port = this.portList.get(i2);
            port.removePropertyChangeListener(this.listener);
        }
        this.portList.clear();
    }

    @Override
    public void disconnectViewport(XpViewport viewport) {
        if (this.portList.contains(viewport)) {
            this.portList.remove(viewport);
            viewport.removePropertyChangeListener(this.listener);
        }
    }

    private void notifyWinowing(double width, double level, boolean isPet) {
        if (isPet) {
            this.target.setWindowing(this.target.getImageLayer(), width, level);
        } else {
            int fused = this.target.getNumImageLayers() - 1;
            XpImagePixelAttributes imgpix = this.target.getImagePixelAttributes(fused);
            if (imgpix != null) {
                imgpix.setWindowing(width, level);
            }
        }
        this.target.refreshContents();
        this.target.repaint();
    }

    static class WindowlevelPropertyChangeListener
    implements PropertyChangeListener {
        MvWinLinkDirector adaptee;

        public WindowlevelPropertyChangeListener(MvWinLinkDirector adaptee) {
            this.adaptee = adaptee;
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            String propName = evt.getPropertyName();
            boolean isPet = true;
            if ("winMax".equalsIgnoreCase(propName) || "winMin".equalsIgnoreCase(propName)) {
                XpCompositePort source = (XpCompositePort)evt.getSource();
                XpFrameVisualizer wlCap = source.getSelectedPort();
                if (source != null && source.getSelectedPort() != null && source.getSelectedPort().getFrame() instanceof XpDicomObject) {
                    XpDicomObject dicomObj = (XpDicomObject)((Object)source.getSelectedPort().getFrame());
                    XpDicomElement elem = new XpDicomElement(8, 96);
                    dicomObj.getValue(elem);
                    if (elem.value.toString().equalsIgnoreCase("CT")) {
                        isPet = false;
                    }
                    double max = wlCap.getWinMax();
                    double min = wlCap.getWinMin();
                    double width = max - min;
                    double level = (max + min) / 2.0;
                    this.adaptee.notifyWinowing(width, level, isPet);
                }
            }
        }
    }
}

