/*
 * Decompiled with CFR 0.152.
 */
package com.ge.med.cse.apps.cdviewer.treetable;

import com.ge.med.cse.apps.cdviewer.MVUtils;
import com.ge.med.cse.apps.cdviewer.treetable.PhaseTableRowObject;
import com.ge.med.cse.apps.cdviewer.treetable.TableRowObject;
import com.ge.med.cse.cvf.util.CvImageFusionUtils;
import com.ge.med.terra.tap.dm.DMObject;
import com.ge.med.terra.tap.dm.DMTag;
import java.util.Vector;

public class SeriesTableRowObject
implements TableRowObject {
    private DMObject seriesObject;
    private boolean hasChildren = false;
    private boolean expanded = false;
    private Vector<PhaseTableRowObject> children = null;

    public SeriesTableRowObject(DMObject dmObject) {
        this.seriesObject = dmObject;
        try {
            if (this.seriesObject == null || !this.seriesObject.getType().equalsIgnoreCase("series")) {
                throw new IllegalArgumentException("Invalid Series Node");
            }
            if (CvImageFusionUtils.isPETSeries(this.seriesObject) && (CvImageFusionUtils.isPETSeriesTypeDYNAMIC(this.seriesObject) || CvImageFusionUtils.isPETSeriesTypeGATED(this.seriesObject) || CvImageFusionUtils.isPETSeriesTypeWHOLEBODY(this.seriesObject))) {
                this.hasChildren = true;
            }
            if (MVUtils.isPRSeries(this.seriesObject) && dmObject.getNumberOfRelated("image") > 1) {
                this.hasChildren = true;
            }
            if (MVUtils.isSR(this.seriesObject) && dmObject.getNumberOfRelated("image") > 1) {
                this.hasChildren = true;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public boolean hasChild() {
        return this.hasChildren;
    }

    @Override
    public boolean isExpanded() {
        return this.expanded;
    }

    @Override
    public boolean isChild() {
        return false;
    }

    @Override
    public Object getValue(DMTag dmTag) {
        return this.seriesObject.getValue(dmTag);
    }

    @Override
    public void toggleExpanded() {
        this.expanded = !this.expanded;
    }

    public Vector getChildren() {
        if (this.hasChildren && this.children == null) {
            DMObject[][] imgs = null;
            if (CvImageFusionUtils.isPETSeries(this.seriesObject)) {
                imgs = CvImageFusionUtils.sortPETseries(this.seriesObject);
            } else if (MVUtils.isPRSeries(this.seriesObject)) {
                imgs = MVUtils.sortPRseries(this.seriesObject);
            } else if (MVUtils.isSR(this.seriesObject)) {
                imgs = MVUtils.sortPRseries(this.seriesObject);
            }
            this.children = new Vector();
            for (int i2 = 0; i2 < imgs.length; ++i2) {
                this.children.add(i2, new PhaseTableRowObject(imgs[i2], this.seriesObject));
            }
        }
        return this.children;
    }

    @Override
    public Object getID() {
        return this.seriesObject.toString();
    }

    @Override
    public DMObject getDMObject() {
        return this.seriesObject;
    }
}

