/*
 * Decompiled with CFR 0.152.
 */
package com.ge.med.cse.cvf.aac;

import com.ge.med.cse.cvf.action.XpWindowPresetAction;
import com.ge.med.cse.cvf.model.WWWLModel;
import com.ge.med.cse.cvf.util.CvUtils;
import com.ge.med.idc.Capable;
import com.ge.med.terra.jami.XpViewport;
import com.ge.med.terra.xpv.ui.ActiveAnnotationControl;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.SwingUtilities;

public class CVAAWWWL
implements ActiveAnnotationControl,
ActionListener {
    private static final Logger logger = Logger.getLogger(CVAAWWWL.class.getName());
    private static JPopupMenu popup = new JPopupMenu("Presets");
    private String modality = null;
    private WWWLModel wwlookup = null;
    private XpWindowPresetAction action = null;
    private Capable capable = null;

    public CVAAWWWL() {
        popup.setName("presetPopUp");
        this.action = new XpWindowPresetAction();
    }

    private void updatePresets() {
        popup.removeAll();
        String[] presets = this.wwlookup.getPresets();
        for (int i2 = 0; i2 < presets.length; ++i2) {
            JMenuItem menu = new JMenuItem();
            popup.add(menu);
            String key = this.wwlookup.getShortCutKey(presets[i2]);
            menu.setText(this.wwlookup.getTitle(presets[i2]) + " (" + key + ")");
            menu.setActionCommand(presets[i2]);
            menu.addActionListener(this);
            popup.setFocusable(false);
        }
    }

    @Override
    public void actionPerformed(ActionEvent e2) {
        String cmd = e2.getActionCommand();
        this.action.setPreset(cmd);
        this.action.actionPerformed(e2);
    }

    @Override
    public void mouseClicked(MouseEvent e2) {
        if (e2.getButton() == 3) {
            if (this.capable == null) {
                XpViewport viewport = (XpViewport)SwingUtilities.getAncestorOfClass(XpViewport.class, e2.getComponent());
                if (viewport == null || !(viewport instanceof Capable)) {
                    return;
                }
                this.capable = viewport;
            }
            if (this.capable == null) {
                logger.log(Level.WARNING, "Port is null");
                return;
            }
            if (CvUtils.isCinePlaying(this.capable)) {
                logger.log(Level.WARNING, "Cine is running");
                return;
            }
            this.modality = CvUtils.getCurrentModality(this.capable);
            if (this.modality != null) {
                this.wwlookup = WWWLModel.getModel(this.modality);
            }
            this.updatePresets();
            this.action.setCapable(this.capable);
            if (!popup.isVisible()) {
                popup.show(e2.getComponent(), e2.getX(), e2.getY());
            } else {
                popup.setLocation(e2.getX(), e2.getY());
            }
        }
    }

    @Override
    public String getShortDescription() {
        return CvUtils.getResourceBundle().getString("AA_WL_TOOLTIP");
    }

    @Override
    public void setCapable(Capable capable) {
        this.capable = capable;
    }

    @Override
    public void mouseDragged(MouseEvent e2) {
    }

    @Override
    public void mouseMoved(MouseEvent e2) {
    }

    @Override
    public void mouseEntered(MouseEvent e2) {
    }

    @Override
    public void mouseExited(MouseEvent e2) {
    }

    @Override
    public void mousePressed(MouseEvent e2) {
    }

    @Override
    public void mouseReleased(MouseEvent e2) {
    }

    @Override
    public void listenTo(Component c2) {
    }
}

