/*
 * Decompiled with CFR 0.152.
 */
package com.ge.med.cse.cvf.action;

import com.ge.med.cse.cvf.base.BaseAction;
import com.ge.med.cse.cvf.idc.XpCineCapable;
import com.ge.med.cse.cvf.util.CvUtils;
import com.ge.med.idc.Capable;
import java.awt.event.ActionEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.Icon;

public class XpCinePlayPauseAction
extends BaseAction {
    private static final Logger logger = Logger.getLogger(XpCinePlayPauseAction.class.getName());
    private static final int pause = 0;
    private static final int resume = 1;
    private static Icon pauseIcon = null;
    private static Icon resumeIcon = null;

    @Override
    public void setCapable(Capable cap) {
        super.setCapable(cap);
        this.getCapable().addPropertyChangeListener("Cine", new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                XpCineCapable cc = (XpCineCapable)XpCinePlayPauseAction.this.getCapable().getCapable(XpCineCapable.class.getName());
                if (cc != null && cc.getCine() && !cc.isPaused()) {
                    XpCinePlayPauseAction.this.updateUI(0);
                }
            }
        });
    }

    private void updateUI(int state) {
        switch (state) {
            case 1: {
                this.setActionCommand("resume");
                if (resumeIcon != null) {
                    this.putValue("SmallIcon", resumeIcon);
                }
                if (CvUtils.getResourceBundle().getString("PLAY_TOOLTIP") == null) break;
                this.setToolTip(CvUtils.getResourceBundle().getString("PLAY_TOOLTIP"));
                break;
            }
            case 0: {
                this.setActionCommand("pause");
                if (pauseIcon != null) {
                    this.putValue("SmallIcon", pauseIcon);
                }
                if (CvUtils.getResourceBundle().getString("PAUSE_TOOLTIP") == null) break;
                this.setToolTip(CvUtils.getResourceBundle().getString("PAUSE_TOOLTIP"));
            }
        }
    }

    @Override
    public void actionPerformed(ActionEvent e2) {
        logger.log(Level.INFO, "XpCinePlayPauseAction.actionPerformed()");
        XpCineCapable ccap = (XpCineCapable)this.getCapable().getCapable(XpCineCapable.class.getName());
        if (ccap != null && ccap.getCine()) {
            if (e2.getActionCommand().equals("pause")) {
                this.pauseCine(ccap);
            } else if (e2.getActionCommand().equals("resume")) {
                this.resumeCine(ccap);
            }
        }
    }

    private void resumeCine(XpCineCapable ccap) {
        logger.log(Level.INFO, "XpCinePlayPauseAction.resumeCine()");
        ccap.resumeCine();
        this.updateUI(0);
    }

    private void pauseCine(XpCineCapable ccap) {
        logger.log(Level.INFO, "XpCinePlayPauseAction.pauseCine()");
        ccap.pauseCine();
        this.updateUI(1);
    }

    @Override
    protected String getName() {
        return "XP_CINE_PLAY_PAUSE";
    }

    @Override
    protected void configure() {
        super.configure();
        pauseIcon = CvUtils.getIcon("XP_CINE_PAUSE_ICON");
        resumeIcon = CvUtils.getIcon("XP_CINE_PLY_FW_ICON");
        this.setActionCommand("pause");
        if (pauseIcon != null) {
            this.putValue("SmallIcon", pauseIcon);
        }
        if (CvUtils.getResourceBundle().getString("PAUSE_TOOLTIP") != null) {
            this.setToolTip(CvUtils.getResourceBundle().getString("PAUSE_TOOLTIP"));
        }
    }
}

