/*
 * Decompiled with CFR 0.152.
 */
package com.ge.med.cse.cvf.action;

import com.ge.med.cse.cvf.base.BaseAction;
import com.ge.med.cse.cvf.log.UserMessageLevel;
import com.ge.med.cse.cvf.util.CvUtils;
import com.ge.med.idc.CineCapable;
import java.awt.event.ActionEvent;

public class XpCineSkipAction
extends BaseAction {
    private boolean isCineOn = false;
    private int interval = 1;

    @Override
    protected String getName() {
        return "XP_CINE_SKIP";
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void actionPerformed(ActionEvent e2) {
        CineCapable ccap = this.getCineCapable();
        int start = ccap.getStartOffset();
        int end = ccap.getEndOffset();
        int totalframes = end - start;
        this.isCineOn = ccap.getCine();
        String[] params = this.getParams();
        try {
            if (params == null) {
                this.getLogger().log(UserMessageLevel.USER_MSG, CvUtils.getResourceBundle().getString("DEFAULT_CMD_FAIL_MSG"));
                return;
            }
            if (params.length != 1) {
                this.getLogger().log(UserMessageLevel.USER_MSG, CvUtils.getResourceBundle().getString("TOO_MANY_PARAM"));
                this.setParams(null);
                return;
            }
            this.interval = Integer.parseInt(params[0]);
            if (this.interval < 1 || this.interval > totalframes) {
                this.getLogger().log(UserMessageLevel.USER_MSG, CvUtils.getResourceBundle().getString("DEFAULT_CMD_FAIL_MSG"));
                this.setParams(null);
                return;
            }
            if (!this.isCineOn) {
                ccap.setCineSkip(this.interval);
            } else {
                this.getLogger().log(UserMessageLevel.USER_MSG, CvUtils.getResourceBundle().getString("DEFAULT_CMD_FAIL_MSG"));
            }
            this.setParams(null);
            return;
        }
        catch (Exception ex) {
            // empty catch block
        }
    }
}

