/*
 * Decompiled with CFR 0.152.
 */
package com.ge.med.cse.cvf.action;

import com.ge.med.cse.cvf.base.BaseAction;
import com.ge.med.cse.cvf.log.UserMessageLevel;
import com.ge.med.cse.cvf.roi.CvImageGrid;
import com.ge.med.cse.cvf.util.CvUtils;
import com.ge.med.terra.jami.RoiActor;
import com.ge.med.terra.jami.XpUserAnnotationModel;
import java.awt.event.ActionEvent;
import java.util.List;
import java.util.Vector;
import java.util.logging.Level;

public class XpEraseSelectedAction
extends BaseAction {
    @Override
    protected String getName() {
        return "XP_ERASE_SELECTED";
    }

    @Override
    public void actionPerformed(ActionEvent e2) {
        String[] params = this.getParams();
        try {
            if (params != null && params.length > 0) {
                this.getLogger().log(UserMessageLevel.USER_MSG, CvUtils.getResourceBundle().getString("INV_PARAM"));
                this.setParams(null);
            } else {
                this.eraseROI();
                this.eraseUA();
                this.getCapable().repaint();
            }
        }
        catch (Exception exp) {
            this.getLogger().log(Level.WARNING, "Exception during erase selected graphics, {0}", exp);
        }
    }

    protected void eraseROI() {
        List roiList = this.getROICapable().getRois();
        Vector<RoiActor> selectedROI = new Vector<RoiActor>();
        for (RoiActor roia : roiList) {
            if (roia instanceof CvImageGrid || !roia.isSelected()) continue;
            selectedROI.add(roia);
        }
        for (int i2 = 0; i2 < selectedROI.size(); ++i2) {
            this.getROICapable().remove((RoiActor)selectedROI.get(i2));
            this.getLogger().log(Level.FINE, "Removed the roi {0} sucessfully from the view port", selectedROI.get(i2));
        }
        selectedROI.clear();
        this.getROICapable().repaint();
    }

    protected void eraseUA() {
        List uaList = this.getUserAnnotationCapable().getUserAnnos();
        Vector<XpUserAnnotationModel> selectedUA = new Vector<XpUserAnnotationModel>();
        for (XpUserAnnotationModel uaModel : uaList) {
            if (!uaModel.isSelected()) continue;
            selectedUA.add(uaModel);
        }
        for (int i2 = 0; i2 < selectedUA.size(); ++i2) {
            this.getUserAnnotationCapable().remove((XpUserAnnotationModel)selectedUA.get(i2));
            this.getLogger().log(Level.FINE, "Removed the userannotation {0} sucessfully from the view port", selectedUA.get(i2));
        }
        selectedUA.clear();
    }
}

