/*
 * Decompiled with CFR 0.152.
 */
package com.ge.med.cse.cvf.action;

import com.ge.med.cse.cvf.base.BaseAction;
import com.ge.med.cse.cvf.cpanels.XPDisplayPrefsUtils;
import com.ge.med.cse.cvf.crossref.XpReferenceImageApp;
import com.ge.med.cse.cvf.log.CvGESyslogMessageCode;
import com.ge.med.cse.cvf.log.UserMessageLevel;
import com.ge.med.cse.cvf.print.LargePrint;
import com.ge.med.cse.cvf.print.PrinterStatus;
import com.ge.med.cse.cvf.print.XpPrintJobListener;
import com.ge.med.cse.cvf.util.CvPropertiesManager;
import com.ge.med.cse.cvf.util.CvUtils;
import com.ge.med.cse.cvf.util.DicomPrintablePort;
import com.ge.med.cse.cvf.util.DicomUtils;
import com.ge.med.idc.Capable;
import com.ge.med.idc.CineCapable;
import com.ge.med.idc.DicomPrintable;
import com.ge.med.idc.SelectionCapable;
import com.ge.med.terra.jami.XpCompositePort;
import com.ge.med.terra.jami.XpMedicalImage;
import com.ge.med.terra.jami.XpSingularPort;
import com.ge.med.terra.jami.XpSlice;
import com.ge.med.terra.jami.XpViewport;
import com.ge.med.terra.xpv.cuiPanels.TransactionLogName;
import java.awt.Dimension;
import java.awt.MouseInfo;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.print.Printable;
import java.io.IOException;
import java.util.Locale;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.print.DocFlavor;
import javax.print.DocPrintJob;
import javax.print.PrintException;
import javax.print.PrintService;
import javax.print.SimpleDoc;
import javax.print.attribute.HashPrintRequestAttributeSet;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;

public class XpF1FilmAction
extends BaseAction {
    private final Logger logger = Logger.getLogger(this.getClass().getName());
    private static final boolean byMouseFocus = CvPropertiesManager.getBoolean("XpF1FilmAction.byMouseFocus", true);
    private PrintService service_ = null;

    @Override
    protected String getName() {
        return "XP_F1_FILM";
    }

    @Override
    public void actionPerformed(ActionEvent e2) {
        JComponent selPort;
        TransactionLogName tln = new TransactionLogName("TID=CV_F1FilmAction");
        this.logger.log(Level.INFO, "{0} begin", tln);
        CineCapable cc = (CineCapable)this.getCapable().getCapable(CineCapable.class.getName());
        if (cc != null && cc.getCine()) {
            this.logger.log(Level.INFO, "F1 Film action failed as Cine is On.", tln);
        }
        this.service_ = CvUtils.getDefaultPrintService();
        if (this.service_ == null) {
            this.logger.log(Level.INFO, "{0} Sev5 No print services found !!", tln);
            this.logger.log(Level.SEVERE, CvGESyslogMessageCode.CV_PRINT_ERROR.getLocalizedMessage(), new Object[]{CvGESyslogMessageCode.CV_PRINT_ERROR, CvUtils.getResourceBundle().getString("FC_NOT_RUN")});
            return;
        }
        PrinterStatus attr = this.service_.getAttribute(PrinterStatus.class);
        boolean status = false;
        if (attr != null) {
            status = attr.getValue();
        }
        if (!status) {
            String error = CvUtils.getResourceBundle().getString("FC_NOT_RUN");
            this.logger.log(UserMessageLevel.USER_MSG, error);
            this.logger.log(Level.INFO, "{0} Sev5 Error in printing : Film Composer may not be running", tln);
            this.logger.log(Level.SEVERE, CvGESyslogMessageCode.CV_PRINT_ERROR.getLocalizedMessage(), new Object[]{CvGESyslogMessageCode.CV_PRINT_ERROR, error});
            return;
        }
        DocPrintJob job = this.service_.createPrintJob();
        if (job == null) {
            this.logger.log(Level.INFO, "{0} Sev5 Error in printing : NULL Dicom Print Job", tln);
            this.logger.log(Level.SEVERE, CvGESyslogMessageCode.CV_PRINT_ERROR.getLocalizedMessage(), new Object[]{CvGESyslogMessageCode.CV_PRINT_ERROR, CvUtils.getResourceBundle().getString("FC_NULL_JOB")});
            return;
        }
        if (CvUtils.isFilmPrintingInProgress(job)) {
            this.logger.log(Level.WARNING, "{0} Printing already in Progress", tln);
            return;
        }
        JComponent mainVp = selPort = (JComponent)((Object)this.getCapable());
        int selPortIdx = 0;
        if (byMouseFocus) {
            System.err.println("=================== Film Image By Mouse Focus");
            Point mousePt = MouseInfo.getPointerInfo().getLocation();
            Point dispPt = new Point(mousePt);
            block4: while (selPort instanceof SelectionCapable) {
                SelectionCapable selCap = (SelectionCapable)((Object)selPort);
                mainVp = selPort;
                selPort = selCap.getViewportComponent(selCap.getComponentSelection());
                for (int i2 = 0; i2 < selCap.getNumComponents(); ++i2) {
                    JComponent c2 = selCap.getViewportComponent(i2);
                    dispPt.setLocation(mousePt);
                    SwingUtilities.convertPointFromScreen(dispPt, c2);
                    if (!c2.contains(dispPt)) continue;
                    selPort = c2;
                    selPortIdx = i2;
                    continue block4;
                }
            }
        } else {
            while (selPort instanceof SelectionCapable) {
                SelectionCapable selCap = (SelectionCapable)((Object)selPort);
                mainVp = selPort;
                selPortIdx = selCap.getComponentSelection();
                selPort = selCap.getViewportComponent(selPortIdx);
            }
        }
        if (selPort == null || !(selPort instanceof Capable)) {
            this.logger.log(UserMessageLevel.USER_MSG, CvUtils.getResourceBundle().getString("FILM_NOT_SUPP"));
            this.logger.log(Level.WARNING, "{0} Filming not supported", tln);
            return;
        }
        SimpleDoc doc = null;
        HashPrintRequestAttributeSet aset = new HashPrintRequestAttributeSet();
        XpSlice slice = null;
        if (selPort instanceof XpCompositePort) {
            slice = ((XpCompositePort)selPort).getPort(0).getFrame().getSlice();
        } else if (selPort instanceof XpSingularPort) {
            slice = ((XpSingularPort)selPort).getFrame().getSlice();
        }
        if (slice != null && (slice.width >= 1024 || slice.height >= 1024)) {
            aset.add(new LargePrint("LargePrint", new Locale("en"), slice.width, slice.height));
        }
        if (selPort instanceof XpSingularPort) {
            XpSingularPort fv = (XpSingularPort)selPort;
            if (fv.getFrame() == null) {
                this.logger.log(Level.WARNING, "{0} Selected port empty");
                return;
            }
            String mod = DicomUtils.getModality((XpMedicalImage)fv.getFrame());
            int[] annotkey = XPDisplayPrefsUtils.getLargeFontAnnotationKeys(fv, mod, XPDisplayPrefsUtils.getFilmLargeFontAnnotationLevel());
            XpViewport clonePort = null;
            if (mainVp instanceof XpViewport && XpReferenceImageApp.isRefPortOn((XpViewport)mainVp, selPortIdx)) {
                clonePort = (XpViewport)XpReferenceImageApp.cloneWithRefPort((XpViewport)mainVp, selPortIdx);
                if (clonePort != null && XpReferenceImageApp.isRefPortOn((XpViewport)mainVp, selPortIdx)) {
                    clonePort.putClientProperty("reference_viewport", "true");
                }
            } else {
                clonePort = (XpViewport)fv.clone();
            }
            if (clonePort != null) {
                clonePort.setSize(new Dimension(fv.getWidth(), fv.getHeight()));
                clonePort.setAnnotationGenerator(fv.getAnnotationGenerator().getClass(), null);
                String filmAnnotLevel = XPDisplayPrefsUtils.getFilmAnnotationLevel();
                int filmCustAnnoMask = XPDisplayPrefsUtils.getFilmCustomAnnotationLevel();
                DicomPrintable printable = CvUtils.getDicomPrintable(clonePort);
                if (printable instanceof DicomPrintablePort) {
                    ((DicomPrintablePort)printable).setFilmAnnotationItems(filmAnnotLevel, filmCustAnnoMask);
                    if (annotkey != null) {
                        ((DicomPrintablePort)printable).setLargeFontAnnotation(annotkey);
                    }
                }
                doc = new SimpleDoc(printable, DocFlavor.SERVICE_FORMATTED.PRINTABLE, null);
            }
        } else if (selPort instanceof Printable) {
            doc = new SimpleDoc((Printable)((Object)selPort), DocFlavor.SERVICE_FORMATTED.PRINTABLE, null);
        } else {
            this.logger.log(UserMessageLevel.USER_MSG, CvUtils.getResourceBundle().getString("FILM_NOT_SUPP"));
            this.logger.log(Level.WARNING, "{0} Filming not supported", tln);
            return;
        }
        if (doc == null) {
            this.logger.log(Level.SEVERE, "{0} Sev5 Error in printing : NULL Dicom Print doc", tln);
            this.logger.log(Level.SEVERE, CvGESyslogMessageCode.CV_PRINT_ERROR.getLocalizedMessage(), new Object[]{CvGESyslogMessageCode.CV_PRINT_ERROR, CvUtils.getResourceBundle().getString("FC_NULL_JOB")});
            return;
        }
        XpPrintJobListener lsnr = new XpPrintJobListener(doc);
        try {
            job.addPrintJobListener(lsnr);
            job.print(doc, aset);
        }
        catch (PrintException pe) {
            this.logger.log(Level.SEVERE, "{0} Error in printing due to " + pe.getMessage(), tln);
            this.logger.log(Level.SEVERE, CvGESyslogMessageCode.CV_PRINT_ERROR.getLocalizedMessage(), new Object[]{CvGESyslogMessageCode.CV_PRINT_ERROR, pe.getMessage()});
            Object data = null;
            try {
                data = doc.getPrintData();
            }
            catch (IOException ioe) {
                // empty catch block
            }
            if (data instanceof DicomPrintablePort) {
                ((DicomPrintablePort)data).dispose();
            }
            job.removePrintJobListener(lsnr);
        }
        this.logger.log(Level.INFO, "{0} end", tln);
    }
}

