/*
 * Decompiled with CFR 0.152.
 */
package com.ge.med.cse.cvf.action;

import com.ge.med.cse.cvf.base.BaseAction;
import com.ge.med.cse.cvf.cpanels.XPDisplayPrefsUtils;
import com.ge.med.cse.cvf.crossref.XpReferenceImageApp;
import com.ge.med.cse.cvf.log.CvGESyslogMessageCode;
import com.ge.med.cse.cvf.log.UserMessageLevel;
import com.ge.med.cse.cvf.print.PrintRowColFormat;
import com.ge.med.cse.cvf.print.PrinterStatus;
import com.ge.med.cse.cvf.print.XpPrintJobListener;
import com.ge.med.cse.cvf.util.CvUtils;
import com.ge.med.cse.cvf.util.DicomPageablePort;
import com.ge.med.cse.cvf.util.DicomPrintablePort;
import com.ge.med.cse.cvf.util.DicomUtils;
import com.ge.med.idc.Capable;
import com.ge.med.idc.CineCapable;
import com.ge.med.idc.DicomPrintable;
import com.ge.med.idc.SelectionCapable;
import com.ge.med.terra.jami.XpCompositePort;
import com.ge.med.terra.jami.XpFrameVisualizer;
import com.ge.med.terra.jami.XpMedicalImage;
import com.ge.med.terra.jami.XpSingularPort;
import com.ge.med.terra.jami.XpViewport;
import com.ge.med.terra.jami.capable.FrameOwner;
import com.ge.med.terra.xpv.cuiPanels.TransactionLogName;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.print.Book;
import java.awt.print.PageFormat;
import java.awt.print.Pageable;
import java.awt.print.Printable;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.print.DocFlavor;
import javax.print.DocPrintJob;
import javax.print.PrintException;
import javax.print.PrintService;
import javax.print.SimpleDoc;
import javax.print.attribute.HashPrintRequestAttributeSet;
import javax.swing.JComponent;

public class XpF2FilmAction
extends BaseAction {
    PrintService service = null;
    Logger logger = Logger.getLogger(this.getClass().getName());
    boolean status;

    @Override
    protected String getName() {
        return "XP_F2_FILM";
    }

    @Override
    public void actionPerformed(ActionEvent e2) {
        TransactionLogName tln = new TransactionLogName("TID=CV_F2FilmAction");
        this.logger.log(Level.INFO, "{0} begin", tln);
        CineCapable cc = (CineCapable)this.getCapable().getCapable(CineCapable.class.getName());
        if (cc != null && cc.getCine()) {
            this.logger.log(Level.INFO, "F2 Film action failed as Cine is On.", tln);
        }
        this.service = CvUtils.getDefaultPrintService();
        if (this.service == null) {
            this.logger.log(Level.INFO, "{0} Sev5 No print services found !!", tln);
            this.logger.log(Level.SEVERE, CvGESyslogMessageCode.CV_PRINT_ERROR.getLocalizedMessage(), new Object[]{CvGESyslogMessageCode.CV_PRINT_ERROR, CvUtils.getResourceBundle().getString("FC_NOT_RUN")});
            return;
        }
        boolean status = false;
        PrinterStatus attr = this.service.getAttribute(PrinterStatus.class);
        if (attr != null) {
            status = attr.getValue();
        }
        if (!status) {
            String error = CvUtils.getResourceBundle().getString("FC_NOT_RUN");
            this.logger.log(UserMessageLevel.USER_MSG, error);
            this.logger.log(Level.INFO, "filmer is not running", tln);
            this.logger.log(Level.SEVERE, CvGESyslogMessageCode.CV_PRINT_ERROR.getLocalizedMessage(), new Object[]{CvGESyslogMessageCode.CV_PRINT_ERROR, error});
            return;
        }
        DocPrintJob job = this.service.createPrintJob();
        if (job == null) {
            this.logger.log(Level.INFO, "Error in printing : NULL Dicom Print Job", tln);
            this.logger.log(Level.SEVERE, CvGESyslogMessageCode.CV_PRINT_ERROR.getLocalizedMessage(), new Object[]{CvGESyslogMessageCode.CV_PRINT_ERROR, CvUtils.getResourceBundle().getString("FC_NULL_JOB")});
            return;
        }
        if (CvUtils.isFilmPrintingInProgress(job)) {
            this.logger.log(Level.WARNING, "{0} Printing already in Progress", tln);
            return;
        }
        SelectionCapable selcap = this.getSelectionCapable();
        JComponent comp = selcap.getViewportComponent(selcap.getComponentSelection());
        if (comp == null || !(comp instanceof Capable)) {
            this.logger.log(UserMessageLevel.USER_MSG, CvUtils.getResourceBundle().getString("FILM_NOT_SUPP"));
            this.logger.log(Level.INFO, "Filming not supported ", tln);
            return;
        }
        if (comp instanceof FrameOwner && ((FrameOwner)((Object)comp)).getFrame() == null) {
            this.logger.log(Level.INFO, "Selected port is empty", tln);
            return;
        }
        String filmAnnotLevel = XPDisplayPrefsUtils.getFilmAnnotationLevel();
        int filmCustAnnoMask = XPDisplayPrefsUtils.getFilmCustomAnnotationLevel();
        SimpleDoc doc = null;
        Capable cpb = (Capable)((Object)comp);
        Book book = null;
        HashPrintRequestAttributeSet aset = new HashPrintRequestAttributeSet();
        int[] annotkey = null;
        String mod = null;
        if (cpb instanceof FrameOwner) {
            mod = DicomUtils.getModality((XpMedicalImage)((FrameOwner)((Object)cpb)).getFrame());
        }
        if (cpb instanceof XpCompositePort) {
            annotkey = XPDisplayPrefsUtils.getLargeFontAnnotationKeys(((XpCompositePort)cpb).getPort(0), mod, XPDisplayPrefsUtils.getFilmLargeFontAnnotationLevel());
            XpCompositePort port = (XpCompositePort)cpb;
            int numImages = port.getRows() * port.getCols();
            book = new Book();
            boolean refVpOn = XpReferenceImageApp.isRefPortOn(port);
            for (int i2 = 0; i2 < numImages; ++i2) {
                XpFrameVisualizer fv = port.getPort(i2);
                if (fv.getFrame() == null) continue;
                XpViewport clonePort = null;
                if (refVpOn && fv.getFrame() != null) {
                    clonePort = (XpViewport)XpReferenceImageApp.cloneWithRefPort(port, i2);
                    if (clonePort != null && XpReferenceImageApp.isRefPortOn(port, i2)) {
                        clonePort.putClientProperty("reference_viewport", "true");
                    }
                } else {
                    clonePort = (XpViewport)fv.clone();
                }
                if (clonePort == null) continue;
                clonePort.setSize(new Dimension(fv.getWidth(), fv.getHeight()));
                clonePort.setAnnotationGenerator(fv.getAnnotationGenerator().getClass(), null);
                DicomPrintable printable = CvUtils.getDicomPrintable(clonePort);
                if (printable instanceof DicomPrintablePort) {
                    ((DicomPrintablePort)printable).setFilmAnnotationItems(filmAnnotLevel, filmCustAnnoMask);
                    if (annotkey != null) {
                        ((DicomPrintablePort)printable).setLargeFontAnnotation(annotkey);
                    }
                }
                book.append(printable, new PageFormat());
            }
            if (book.getNumberOfPages() >= 0) {
                doc = new SimpleDoc(book, DocFlavor.SERVICE_FORMATTED.PAGEABLE, null);
            }
            aset = new HashPrintRequestAttributeSet();
            aset.add(new PrintRowColFormat(port.getRows(), port.getCols()));
        } else if (cpb instanceof XpSingularPort) {
            annotkey = XPDisplayPrefsUtils.getLargeFontAnnotationKeys((XpSingularPort)cpb, mod, XPDisplayPrefsUtils.getFilmLargeFontAnnotationLevel());
            XpViewport vp = null;
            if (XpReferenceImageApp.isRefPortOn((XpViewport)cpb)) {
                vp = (XpViewport)XpReferenceImageApp.cloneWithRefPort((XpViewport)cpb, 0);
                if (vp != null) {
                    vp.putClientProperty("reference_viewport", "true");
                }
            } else {
                vp = (XpSingularPort)((XpSingularPort)cpb).clone();
            }
            if (vp != null) {
                vp.setSize(new Dimension(((XpSingularPort)cpb).getWidth(), ((XpSingularPort)cpb).getHeight()));
                vp.setAnnotationGenerator(((XpSingularPort)cpb).getAnnotationGenerator().getClass(), null);
                DicomPrintable printable = CvUtils.getDicomPrintable(vp);
                if (printable instanceof DicomPrintablePort) {
                    ((DicomPrintablePort)printable).setFilmAnnotationItems(filmAnnotLevel, filmCustAnnoMask);
                    if (annotkey != null) {
                        ((DicomPrintablePort)printable).setLargeFontAnnotation(annotkey);
                    }
                }
                aset = new HashPrintRequestAttributeSet();
                aset.add(new PrintRowColFormat(1, 1));
                doc = new SimpleDoc(printable, DocFlavor.SERVICE_FORMATTED.PRINTABLE, null);
            }
        } else if (cpb instanceof Printable) {
            doc = new SimpleDoc((Printable)((Object)cpb), DocFlavor.SERVICE_FORMATTED.PRINTABLE, null);
        } else {
            this.logger.log(UserMessageLevel.USER_MSG, CvUtils.getResourceBundle().getString("FILM_NOT_SUPP"));
            this.logger.log(Level.INFO, "{0} Filming not supported ", tln);
            return;
        }
        if (doc == null) {
            this.logger.log(Level.INFO, "{0} Sev5 Error in printing : NULL Dicom Print doc", tln);
            this.logger.log(Level.SEVERE, CvGESyslogMessageCode.CV_PRINT_ERROR.getLocalizedMessage(), new Object[]{CvGESyslogMessageCode.CV_PRINT_ERROR, CvUtils.getResourceBundle().getString("FC_NULL_JOB")});
            return;
        }
        XpPrintJobListener lsnr = new XpPrintJobListener(doc);
        try {
            job.addPrintJobListener(lsnr);
            job.print(doc, aset);
        }
        catch (PrintException pe) {
            this.logger.log(Level.INFO, "{0} Error in printing due to " + pe.getMessage(), tln);
            this.logger.log(Level.SEVERE, CvGESyslogMessageCode.CV_PRINT_ERROR.getLocalizedMessage(), new Object[]{CvGESyslogMessageCode.CV_PRINT_ERROR, pe.getMessage()});
            Object data = null;
            try {
                data = doc.getPrintData();
            }
            catch (IOException ioe) {
                // empty catch block
            }
            if (data instanceof DicomPrintablePort) {
                ((DicomPrintablePort)data).dispose();
            } else if (data instanceof DicomPageablePort) {
                ((DicomPageablePort)data).dispose();
            } else if (data instanceof Pageable) {
                int count = ((Pageable)data).getNumberOfPages();
                for (int i3 = 0; i3 < count; ++i3) {
                    Printable p2 = ((Pageable)data).getPrintable(i3);
                    if (!(p2 instanceof DicomPrintablePort)) continue;
                    ((DicomPrintablePort)p2).dispose();
                }
            }
            job.removePrintJobListener(lsnr);
        }
        this.logger.log(Level.INFO, "{0} end", tln);
    }
}

