/*
 * Decompiled with CFR 0.152.
 */
package com.ge.med.cse.cvf.action;

import com.ge.med.cse.cvf.base.BaseAction;
import com.ge.med.cse.cvf.base.CvImageLoader;
import com.ge.med.cse.cvf.idc.XpLinkPortCapable;
import com.ge.med.cse.cvf.log.UserMessageLevel;
import com.ge.med.cse.cvf.util.CPIUtils;
import com.ge.med.cse.cvf.util.CvPropertiesManager;
import com.ge.med.cse.cvf.util.CvUtils;
import com.ge.med.cse.cvf.util.DicomUtils;
import com.ge.med.idc.CineCapable;
import com.ge.med.terra.jami.XpDicomElement;
import com.ge.med.terra.jami.XpMedicalImage;
import com.ge.med.terra.jami.capable.FrameOwner;
import com.ge.med.terra.tap.dm.DMObject;
import com.ge.med.terra.tap.dm.DMQuery;
import com.ge.med.terra.tap.dm.DMSession;
import com.ge.med.terra.tap.dm.DMTagValueInterface;
import com.ge.med.terra.xpv.cuiPanels.TransactionLogName;
import java.awt.event.ActionEvent;
import java.lang.reflect.InvocationTargetException;
import java.util.logging.Level;
import javax.swing.SwingUtilities;

public class XpNextExamAction
extends BaseAction {
    private Thread loaderThread = null;
    private static final XpDicomElement eid = new XpDicomElement(32, 16);
    private static final XpDicomElement euid = new XpDicomElement(32, 13);
    private static final boolean isExamEnabled = CvPropertiesManager.getBoolean("cvf.examnavigation", true);
    private static final TransactionLogName tln = new TransactionLogName("TID=CV_NextExamAction");

    @Override
    protected String getName() {
        return "XP_NEXT_EXAM";
    }

    @Override
    public void actionPerformed(ActionEvent e2) {
        if (!isExamEnabled) {
            this.getLogger().log(UserMessageLevel.USER_MSG, CvUtils.getResourceBundle().getString("INV_CMD"));
            return;
        }
        if (this.loaderThread != null && this.loaderThread.isAlive()) {
            this.getLogger().log(Level.INFO, "{0} An ESI load action already processing", tln);
            return;
        }
        CineCapable cc = (CineCapable)this.getCapable().getCapable(CineCapable.class.getName());
        if (cc != null && cc.getCine()) {
            this.getLogger().log(Level.INFO, "{0} Cine on, cannot process load next exam request", tln);
            this.getLogger().log(UserMessageLevel.USER_MSG, CvUtils.getResourceBundle().getString("CINE_ON_IMGLOAD_FAILED"));
            return;
        }
        XpLinkPortCapable lpcap = (XpLinkPortCapable)this.getCapable().getCapable(XpLinkPortCapable.class.getName());
        if (lpcap != null && lpcap.getPortsLinked()) {
            this.getLogger().log(Level.SEVERE, "{0} Unlink ports to load a different exam/series", tln);
            this.getLogger().log(UserMessageLevel.USER_MSG, CvUtils.getResourceBundle().getString("UNLINK_PORT_TOLOAD_EXAM"));
            return;
        }
        this.loaderThread = new Thread(){

            @Override
            public void run() {
                DMObject[] objs;
                XpMedicalImage image = null;
                FrameOwner fpc = (FrameOwner)((Object)XpNextExamAction.this.getCapable().getCapable(FrameOwner.class.getName()));
                if (fpc != null && fpc.getFrame() instanceof XpMedicalImage) {
                    image = (XpMedicalImage)fpc.getFrame();
                }
                if (image == null) {
                    XpNextExamAction.this.getLogger().info("Selected port is empty");
                    return;
                }
                DMSession sess = CvUtils.getDMSystem().getLocalDB();
                if (sess == null) {
                    XpNextExamAction.this.getLogger().info("No DMSystem found");
                    return;
                }
                image.getValue(eid);
                image.getValue(euid);
                String query = "(0x0020, 0x000D) = " + euid.getStringValue();
                if (eid.getStringValue() != null && eid.getStringValue().trim().length() > 0) {
                    query = query + " AND (0x0020, 0x0010) = " + eid.getStringValue();
                }
                if ((objs = sess.getRelated("study", new DMQuery(query))) == null || objs.length == 0) {
                    XpNextExamAction.this.getLogger().info("Current exam query returned null, query : " + query);
                    return;
                }
                DMObject current = objs[0];
                Object sel = null;
                do {
                    DMObject next;
                    if ((next = CvUtils.getDMSystem().getNextInBrowser(current, false)) == null) continue;
                    try {
                        XpNextExamAction.this.getLogger().info("Current exam S UID:" + current.getValue(32, 13));
                        XpNextExamAction.this.getLogger().info("Next exam S UID:" + next.getValue(32, 13));
                    }
                    catch (Exception e2) {
                        XpNextExamAction.this.getLogger().info(e2.getLocalizedMessage());
                    }
                    if (next.equals(current)) break;
                    Object[] sers = next.getRelated("series");
                    if (sers != null && sers.length > 0) {
                        CvUtils.sortSeriesByBase(sers);
                        for (int i2 = 0; i2 < sers.length; ++i2) {
                            try {
                                XpNextExamAction.this.getLogger().info("\t\t series :" + i2 + " " + DicomUtils.getModality((DMTagValueInterface)sers[i2]));
                            }
                            catch (Exception e3) {
                                XpNextExamAction.this.getLogger().info(e3.getLocalizedMessage());
                            }
                            if (!CvImageLoader.getInstance().isValid(new DMObject[]{sers[i2]}) || CPIUtils.isGSPS((DMTagValueInterface)sers[i2])) continue;
                            sel = sers[i2];
                            break;
                        }
                    }
                    current = next;
                } while (sel == null && !objs[0].equals(current));
                if (sel != null) {
                    CvUtils.getDMSystem().setSelection(new DMObject[]{sel});
                    try {
                        SwingUtilities.invokeAndWait(new Runnable(){

                            @Override
                            public void run() {
                                CvImageLoader.getInstance().loadData(true);
                            }
                        });
                    }
                    catch (InterruptedException e4) {
                        XpNextExamAction.this.getLogger().info("Loading in normal way in thread");
                        CvImageLoader.getInstance().loadData(true);
                    }
                    catch (InvocationTargetException e5) {
                        XpNextExamAction.this.getLogger().info("Loading in normal way in thread");
                        CvImageLoader.getInstance().loadData(true);
                    }
                }
            }
        };
        this.loaderThread.setName("ImageLoader_NextExam");
        this.loaderThread.start();
    }
}

