/*
 * Decompiled with CFR 0.152.
 */
package com.ge.med.cse.cvf.action;

import com.ge.med.cse.cvf.base.BaseAction;
import com.ge.med.cse.cvf.base.ROIUtils;
import com.ge.med.cse.cvf.log.UserMessageLevel;
import com.ge.med.cse.cvf.roi.CvImageMatte;
import com.ge.med.cse.cvf.util.CvUtils;
import com.ge.med.terra.jami.RoiActor;
import java.awt.Shape;
import java.awt.event.ActionEvent;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RectangularShape;
import java.util.List;
import java.util.logging.Level;

public class XpRectangularMatteAction
extends BaseAction {
    @Override
    protected String getName() {
        return "XP_RECTANGULAR_MATTE";
    }

    @Override
    public void actionPerformed(ActionEvent e2) {
        Shape roiShape = null;
        String[] params = this.getParams();
        try {
            if (params != null && params.length > 0) {
                roiShape = this.parseParams(params);
                this.setParams(null);
            } else {
                roiShape = CvUtils.getROIUtils().getROIPosition(this.getROICapable(), ROIUtils.ROITYPE.RECTMATTE);
            }
            if (roiShape != null) {
                List rl = this.getROICapable().getRois();
                int size = rl.size();
                for (int i2 = 0; i2 < size; ++i2) {
                    RoiActor r2 = (RoiActor)rl.get(i2);
                    if (!(r2 instanceof CvImageMatte)) continue;
                    this.getROICapable().remove(r2);
                    break;
                }
                this.getROICapable().add(new CvImageMatte((RectangularShape)roiShape));
            } else {
                this.getLogger().log(Level.WARNING, "Rectangular Matte Shape returned NULL.");
            }
        }
        catch (Exception exp) {
            this.getLogger().log(Level.WARNING, "Exception during the rectangular matte add", exp);
            this.getLogger().log(UserMessageLevel.USER_MSG, CvUtils.getResourceBundle().getString("CMD_NOT_SUPPORTED"));
        }
    }

    private Shape parseParams(String[] st) {
        Rectangle2D.Double s2 = null;
        Point2D[] pts = null;
        if (st.length != 8) {
            this.getLogger().log(Level.WARNING, "Invalid Rectangular Matte ROI arguments");
            this.getLogger().log(UserMessageLevel.USER_MSG, CvUtils.getResourceBundle().getString("INV_PARAM"));
        } else {
            try {
                Double[] dpts = new Double[8];
                for (int i2 = 0; i2 < st.length; ++i2) {
                    dpts[i2] = Double.parseDouble(st[i2]);
                }
                pts = new Point2D[]{new Point2D.Double(dpts[0], dpts[1]), new Point2D.Double(dpts[2], dpts[3]), new Point2D.Double(dpts[4], dpts[5]), new Point2D.Double(dpts[6], dpts[7])};
                pts[0] = CvUtils.getValidImagePoint(pts[0], this.getROICapable());
                pts[1] = CvUtils.getValidImagePoint(pts[1], this.getROICapable());
                pts[2] = CvUtils.getValidImagePoint(pts[2], this.getROICapable());
                pts[3] = CvUtils.getValidImagePoint(pts[3], this.getROICapable());
                double minX = pts[0].getX();
                double maxX = pts[0].getX();
                double minY = pts[0].getY();
                double maxY = pts[0].getY();
                for (int i3 = 1; i3 < 4; ++i3) {
                    if (minX > pts[i3].getX()) {
                        minX = pts[i3].getX();
                    }
                    if (maxX < pts[i3].getX()) {
                        maxX = pts[i3].getX();
                    }
                    if (minY > pts[i3].getY()) {
                        minY = pts[i3].getY();
                    }
                    if (!(maxY < pts[i3].getY())) continue;
                    maxY = pts[i3].getY();
                }
                int width = Math.abs((int)(maxX - minX));
                int height = Math.abs((int)(maxY - minY));
                s2 = new Rectangle2D.Double(minX, minY, width, height);
            }
            catch (Exception e2) {
                this.getLogger().log(Level.WARNING, "Invalid Rectangular Matte ROI arguments", e2);
                this.getLogger().log(UserMessageLevel.USER_MSG, CvUtils.getResourceBundle().getString("INV_PARAM"));
            }
        }
        return s2;
    }
}

