/*
 * Decompiled with CFR 0.152.
 */
package com.ge.med.cse.cvf.action;

import com.ge.med.cse.cvf.base.BaseAction;
import com.ge.med.cse.cvf.crossref.XpReferenceImageApp;
import com.ge.med.terra.jami.XpViewport;
import com.ge.med.terra.xpv.base.XPscreen;
import java.awt.event.ActionEvent;
import java.util.logging.Level;
import javax.swing.JComponent;

public class XpReferenceImageAction
extends BaseAction {
    public XpReferenceImageAction() {
        this.putValue("showActionText", "show");
    }

    @Override
    protected String getName() {
        return "XP_REFERENCE_IMAGE";
    }

    @Override
    public void actionPerformed(ActionEvent e2) {
        try {
            JComponent port = this.getSelectedPort();
            if (port == null) {
                this.getLogger().log(Level.WARNING, "Selected port is null.");
                return;
            }
            if (port instanceof XpViewport) {
                switch (XpReferenceImageApp.getRefImageContext()) {
                    case 0: {
                        XpReferenceImageApp.postReferenceImage((XpViewport)port, false);
                        break;
                    }
                    case 1: {
                        XpReferenceImageApp.removeReferenceImage((XpViewport)port, false);
                        break;
                    }
                    case 2: {
                        XpReferenceImageApp.postReferenceImage((XpViewport)port, true);
                        break;
                    }
                    case 3: {
                        XpReferenceImageApp.removeReferenceImage((XpViewport)port, true);
                        break;
                    }
                    default: {
                        XpReferenceImageApp.postReferenceImage((XpViewport)port, false);
                        break;
                    }
                }
            } else {
                this.getLogger().log(Level.WARNING, "Selected port is not instance of XpViewport.");
            }
        }
        catch (Exception exp) {
            this.getLogger().log(Level.WARNING, "Exception during reference image viewport operation, stack trace {0}", new Object[]{exp});
        }
    }

    private JComponent getSelectedPort() {
        JComponent com = (JComponent)((Object)this.getCapable());
        while (com != null && com instanceof XPscreen) {
            com = ((XPscreen)com).getSelectedPort();
        }
        return com;
    }
}

