/*
 * Decompiled with CFR 0.152.
 */
package com.ge.med.cse.cvf.action;

import com.ge.med.cse.cvf.base.BaseAction;
import com.ge.med.cse.cvf.idc.XpCPICapable;
import com.ge.med.cse.cvf.util.CvUtils;
import com.ge.med.idc.Capable;
import com.ge.med.idc.SelectionCapable;
import com.ge.med.terra.jami.RoiActor;
import com.ge.med.terra.jami.XpUserAnnotationModel;
import com.ge.med.terra.jami.capable.ROICapable;
import com.ge.med.terra.jami.capable.UserAnnoCapable;
import com.ge.med.terra.jami.capable.Visible;
import java.awt.event.ActionEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.List;
import java.util.logging.Level;
import javax.swing.JComponent;

public class XpShowHideGraphics
extends BaseAction {
    boolean showGraphics = false;
    private PropertyChangeListener shlistener = new PropertyChangeListener(){
        boolean val;

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            if (evt.getPropertyName().equals("showhide_property")) {
                this.val = Boolean.parseBoolean("" + evt.getNewValue());
                XpShowHideGraphics.this.putValue("SmallIcon", CvUtils.getIcon(XpShowHideGraphics.this.getName() + (this.val ? "_ICON_HIDE" : "_ICON")));
                XpShowHideGraphics.this.putValue("ShortDescription", XpShowHideGraphics.this.getResourceBundle().getString(XpShowHideGraphics.this.getName() + (this.val ? "_TOOLTIP_HIDE" : "_TOOLTIP")));
            }
        }
    };

    @Override
    protected String getName() {
        return "XP_SHOW_HIDE_GRAPHICS";
    }

    @Override
    protected void configure() {
        this.putValue("SmallIcon", CvUtils.getIcon(this.getName() + "_ICON_HIDE"));
        this.putValue("ShortDescription", this.getResourceBundle().getString(this.getName() + "_TOOLTIP_HIDE"));
    }

    @Override
    public void actionPerformed(ActionEvent e2) {
        this.getLogger().log(Level.FINE, "User selected to " + (this.showGraphics ? "show" : "hide") + " the graphics");
        try {
            SelectionCapable sc = (SelectionCapable)this.getCapable().getCapable(SelectionCapable.class.getName());
            JComponent comp = sc.getViewportComponent(sc.getComponentSelection());
            if (comp != null) {
                if (comp instanceof XpCPICapable) {
                    ((XpCPICapable)((Object)comp)).showGraphics(this.showGraphics);
                } else {
                    int i2;
                    if (comp instanceof ROICapable) {
                        List lst = ((ROICapable)((Object)comp)).getRois();
                        for (i2 = lst.size() - 1; i2 >= 0; --i2) {
                            RoiActor ra = (RoiActor)lst.get(i2);
                            if (!(ra instanceof Visible)) continue;
                            ((Visible)((Object)ra)).setVisible(this.showGraphics);
                        }
                    }
                    if (comp instanceof UserAnnoCapable) {
                        XpUserAnnotationModel[] uams = ((UserAnnoCapable)((Object)comp)).getUserAnnos().toArray(new XpUserAnnotationModel[0]);
                        for (i2 = 0; i2 < uams.length; ++i2) {
                            uams[i2].setVisible(this.showGraphics);
                        }
                    }
                    ((JComponent)((Object)this.getCapable())).firePropertyChange("showhide_property", !this.showGraphics, this.showGraphics);
                }
                this.showGraphics = !this.showGraphics;
            }
            ((JComponent)((Object)this.getCapable())).updateUI();
        }
        catch (Exception exp) {
            this.getLogger().log(Level.WARNING, "Exception during show hide graphics, {0}", exp);
            exp.printStackTrace();
        }
    }

    @Override
    public void setCapable(Capable cap) {
        super.setCapable(cap);
        cap.addPropertyChangeListener(this.shlistener);
    }
}

