/*
 * Decompiled with CFR 0.152.
 */
package com.ge.med.cse.cvf.action;

import com.ge.med.cse.cvf.base.BaseAction;
import com.ge.med.cse.cvf.log.UserMessageLevel;
import com.ge.med.cse.cvf.util.CvUtils;
import java.awt.event.ActionEvent;
import java.util.logging.Level;

public class XpZoomAction
extends BaseAction {
    private double zoomval = 1.0;

    @Override
    protected String getName() {
        return "XP_ZOOM";
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void actionPerformed(ActionEvent arg0) {
        String[] params = this.getParams();
        try {
            if (params != null && params.length > 0) {
                block6: {
                    if (params.length == 1) {
                        this.zoomval = Double.parseDouble(params[0]);
                        if (this.zoomval > 0.0 && this.zoomval <= 8.0) {
                            int tmp = (int)(this.zoomval * 10.0);
                            this.zoomval = (double)tmp / 10.0;
                            this.getPanZoomCapable().setZoom(this.zoomval);
                            break block6;
                        } else {
                            this.getLogger().log(Level.WARNING, "Invalid zoom value entered");
                            this.getLogger().log(UserMessageLevel.USER_MSG, CvUtils.getResourceBundle().getString("INV_PARAM"));
                            return;
                        }
                    }
                    this.getLogger().log(Level.WARNING, "Invalid argument");
                    this.getLogger().log(UserMessageLevel.USER_MSG, CvUtils.getResourceBundle().getString("INV_PARAM"));
                }
                this.setParams(null);
                return;
            }
            this.getLogger().log(Level.WARNING, "Zoom factor argument missing");
            this.getLogger().log(UserMessageLevel.USER_MSG, CvUtils.getResourceBundle().getString("INSUFF_PARAM"));
            return;
        }
        catch (Exception exp) {
            this.getLogger().log(Level.WARNING, "Exception during tick mark addition , {0}", new Object[]{exp});
        }
    }
}

