/*
 * Decompiled with CFR 0.152.
 */
package com.ge.med.cse.cvf.annotation;

import com.ge.med.terra.jami.RoiActor;
import com.ge.med.terra.jami.XpAnnotationVc;
import com.ge.med.terra.jami.XpImage2DVc;
import com.ge.med.terra.jami.XpImageRoiVc;
import com.ge.med.terra.jami.XpMedicalImage2DVc;
import com.ge.med.terra.jami.annotation.XpAnnotationModel;
import com.ge.med.terra.jami.annotation.XpMRCTApdAnnotationConfig;
import com.ge.med.terra.jami.capable.InfoLabelReporter;
import com.ge.med.terra.jami.capable.Visible;
import com.ge.med.terra.jami.render.XpImageRenderAttributes;
import com.ge.med.terra.jami.render.XpImageRenderAttributesOwner;
import com.ge.med.terra.jami.roi.XpStatisticsRoi;
import java.awt.Component;
import java.awt.image.IndexColorModel;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.LinkedList;
import javax.swing.JComponent;

public class XpApdXRayAnnotConfig
extends XpMRCTApdAnnotationConfig {
    private static final int MAX_ROI_RESULTS = 5;
    private static final String[] roiPropName = new String[]{"roiResult1", "roiResult2", "roiResult3", "roiResult4", "roiResult5"};
    private static final String[] pads = new String[]{"", " ", "  ", "   ", "    ", "     ", "      ", "       ", "        ", "         "};
    private static final DecimalFormat rasf = new DecimalFormat("###0.00");
    private ArrayList roiInfoList = new ArrayList();
    private LinkedList lastSelectedRois = new LinkedList();
    private int selectedRoi = -1;
    private static final DecimalFormat df = new DecimalFormat("###0");
    private static final String DEG_SYMBOL = new String(new char[]{'\u00b0'});

    @Override
    public void configAnnotation(XpAnnotationVc avc, JComponent jc) {
        XpAnnotationModel am2 = avc.getAnnotationModel();
        XpMedicalImage2DVc mivc = (XpMedicalImage2DVc)jc;
        XpImage2DVc viewport = mivc.getImageVc();
        if (am2 == null) {
            return;
        }
        this.setROIInfo(avc, viewport);
        this.setRenderAttributes(avc, mivc);
    }

    @Override
    protected void setROIInfo(XpAnnotationVc avc, JComponent jc) {
        int i2;
        XpAnnotationModel am2 = avc.getAnnotationModel();
        if (am2 == null) {
            return;
        }
        this.roiInfoList.clear();
        this.selectedRoi = -1;
        int nroi = 0;
        int childCount = jc.getComponentCount();
        for (i2 = 0; i2 < childCount; ++i2) {
            Component c2 = jc.getComponent(i2);
            if ((!(c2 instanceof XpImageRoiVc) || !XpStatisticsRoi.isShowStatistics()) && !(c2 instanceof InfoLabelReporter)) continue;
            String label = null;
            if (c2 instanceof InfoLabelReporter) {
                label = ((InfoLabelReporter)((Object)c2)).getInfoLabel();
            } else {
                RoiActor ra;
                XpImageRoiVc rvc = (XpImageRoiVc)c2;
                if (rvc.isVisible() && (ra = rvc.getRoiActor()) instanceof Visible && ra instanceof InfoLabelReporter) {
                    InfoLabelReporter ilr = (InfoLabelReporter)((Object)ra);
                    label = ilr.getInfoLabel();
                    if (ra.isSelected()) {
                        this.selectedRoi = nroi;
                    }
                }
            }
            if (label == null) continue;
            this.roiInfoList.add(nroi, label);
            ++nroi;
        }
        if (nroi > 0) {
            if (this.selectedRoi == -1) {
                if (this.lastSelectedRois.size() > nroi) {
                    int diff = this.lastSelectedRois.size() - nroi;
                    for (int i3 = 0; i3 < diff; ++i3) {
                        int lastSelectedIdx = Integer.parseInt((String)this.lastSelectedRois.getLast());
                        LinkedList<String> temp = new LinkedList<String>();
                        int nlsr = this.lastSelectedRois.size();
                        for (int j2 = 0; j2 < nlsr - 1; ++j2) {
                            int index = Integer.parseInt((String)this.lastSelectedRois.get(j2));
                            if (index > lastSelectedIdx) {
                                --index;
                            }
                            temp.add("" + index);
                        }
                        this.lastSelectedRois = temp;
                    }
                }
            } else {
                if (this.lastSelectedRois.contains("" + this.selectedRoi)) {
                    this.lastSelectedRois.remove("" + this.selectedRoi);
                }
                this.lastSelectedRois.add("" + this.selectedRoi);
            }
            int noStat = 5;
            int rsIndex = 0;
            if (this.lastSelectedRois.size() < nroi) {
                for (int i4 = 0; i4 < nroi; ++i4) {
                    if (this.lastSelectedRois.contains("" + i4)) continue;
                    this.lastSelectedRois.add("" + i4);
                }
            }
            for (int i5 = nroi - 1; i5 >= 0 && noStat > 0; --i5) {
                int index = Integer.parseInt((String)this.lastSelectedRois.get(i5));
                if (index >= this.roiInfoList.size()) continue;
                am2.setProperty(roiPropName[rsIndex], (String)this.roiInfoList.get(index));
                ++rsIndex;
                --noStat;
            }
        } else {
            this.lastSelectedRois.clear();
        }
        for (i2 = nroi; i2 < 5; ++i2) {
            am2.setProperty(roiPropName[i2], "");
        }
    }

    @Override
    protected void setRenderAttributes(XpAnnotationVc avc, XpImageRenderAttributesOwner iraOwner) {
        XpAnnotationModel am2 = avc.getAnnotationModel();
        XpImageRenderAttributes ira = iraOwner.getImageRenderAttributes();
        if (am2 != null && ira != null) {
            long ww = (long)ira.getWindowWidth();
            long wl = (long)ira.getWindowLevel();
            double zoom = ira.getZoom();
            IndexColorModel icm = ira.getColormap();
            boolean setGSE = false;
            am2.setProperty("windowWidth", (int)ww);
            am2.setProperty("windowLevel", (int)wl);
            am2.setProperty("zoomFactor", zoom);
        }
    }
}

