/*
 * Decompiled with CFR 0.152.
 */
package com.ge.med.cse.cvf.annotation;

import com.ge.med.cse.cvf.roi.CvContinuousReporter;
import com.ge.med.cse.cvf.util.DSAImageOp;
import com.ge.med.cse.cvf.util.DicomUtils;
import com.ge.med.cse.cvf.util.ValueBasedDecimalFormatter;
import com.ge.med.terra.jami.CPoint;
import com.ge.med.terra.jami.RoiActor;
import com.ge.med.terra.jami.XpAnnotationVc;
import com.ge.med.terra.jami.XpDicomElement;
import com.ge.med.terra.jami.XpDicomObject;
import com.ge.med.terra.jami.XpImage;
import com.ge.med.terra.jami.XpImage2DVc;
import com.ge.med.terra.jami.XpImageOrientation;
import com.ge.med.terra.jami.XpImageRoiVc;
import com.ge.med.terra.jami.XpMedicalImage2DVc;
import com.ge.med.terra.jami.XpVisualComponent;
import com.ge.med.terra.jami.annotation.XpAnnotationModel;
import com.ge.med.terra.jami.annotation.XpMRCTApdAnnotationConfig;
import com.ge.med.terra.jami.capable.FrameOwner;
import com.ge.med.terra.jami.capable.InfoLabelReporter;
import com.ge.med.terra.jami.capable.Visible;
import com.ge.med.terra.jami.filter.XpImageOp;
import com.ge.med.terra.jami.platform.dm.XpMedicalDmImage;
import com.ge.med.terra.jami.render.XpImageRenderAttributes;
import com.ge.med.terra.jami.render.XpImageRenderAttributesOwner;
import com.ge.med.terra.jami.roi.XpStatisticsRoi;
import com.ge.med.terra.tap.dm.DMImage;
import com.ge.med.terra.tap.dm.DMSequence;
import com.ge.med.terra.tap.dm.DMTag;
import java.awt.Component;
import java.awt.image.IndexColorModel;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import javax.swing.JComponent;

public class XpCvApdAnnotationConfig
extends XpMRCTApdAnnotationConfig {
    private static final int MAX_ROI_RESULTS = 3;
    private static final String[] roiPropName = new String[]{"roiResult3", "roiResult2", "roiResult1"};
    private static final DecimalFormat rasf = new DecimalFormat("###0.00");
    private static final ValueBasedDecimalFormatter dfe = new ValueBasedDecimalFormatter();
    private static final String[] pads = new String[]{"", " ", "  ", "   ", "    ", "     ", "      ", "       ", "        ", "         "};
    private ArrayList roiInfoList = new ArrayList();
    private LinkedList lastSelectedRois = new LinkedList();
    private int selectedRoi = -1;

    @Override
    protected void setROIInfo(XpAnnotationVc avc, JComponent jc) {
        int i2;
        XpAnnotationModel am2 = avc.getAnnotationModel();
        if (am2 == null) {
            return;
        }
        boolean probeQ = DicomUtils.isMRProbeQImage(am2.getDicomObject());
        am2.setProperty("reportPixel_R", "");
        am2.setProperty("reportPixel_A", "");
        am2.setProperty("reportPixel_S", "");
        am2.setProperty("reportPixel_V", "");
        this.roiInfoList.clear();
        this.selectedRoi = -1;
        int nroi = 0;
        int childCount = jc.getComponentCount();
        for (i2 = 0; i2 < childCount; ++i2) {
            Component c2 = jc.getComponent(i2);
            if (c2 instanceof XpImageRoiVc && XpStatisticsRoi.isShowStatistics() || c2 instanceof InfoLabelReporter) {
                String label = null;
                if (c2 instanceof XpImageRoiVc) {
                    XpImageRoiVc rvc = (XpImageRoiVc)c2;
                    RoiActor ra = rvc.getRoiActor();
                    if (ra instanceof Visible && ((Visible)((Object)ra)).isVisible() && ra instanceof InfoLabelReporter) {
                        InfoLabelReporter ilr = (InfoLabelReporter)((Object)ra);
                        label = ilr.getInfoLabel();
                        if (ra.isSelected()) {
                            this.selectedRoi = nroi;
                        }
                    }
                } else if (c2 instanceof InfoLabelReporter) {
                    label = ((InfoLabelReporter)((Object)c2)).getInfoLabel();
                }
                if (label == null) continue;
                this.roiInfoList.add(nroi, label);
                ++nroi;
                continue;
            }
            if (!(c2 instanceof CvContinuousReporter)) continue;
            CvContinuousReporter pm = (CvContinuousReporter)c2;
            if (pm.isVisible()) {
                CPoint cp = pm.getRAS();
                double value = pm.getValue();
                String R2 = "R ";
                String A2 = "A ";
                String S2 = "S ";
                String V = "V = ";
                double r2 = cp.x;
                double a2 = cp.y;
                double s2 = cp.z;
                if (r2 < 0.0) {
                    r2 = -r2;
                    R2 = "L ";
                }
                if (a2 < 0.0) {
                    a2 = -a2;
                    A2 = "P ";
                }
                if (s2 < 0.0) {
                    s2 = -s2;
                    S2 = "I ";
                }
                R2 = R2 + rasf.format(r2) + "mm";
                A2 = A2 + rasf.format(a2) + "mm";
                S2 = S2 + rasf.format(s2) + "mm";
                V = V + dfe.customFormat(value);
                int rlen = R2.length();
                int alen = A2.length();
                int slen = S2.length();
                int vlen = V.length();
                int max = Math.max(rlen, alen);
                max = Math.max(max, slen);
                if ((max = Math.max(max, vlen)) > rlen) {
                    R2 = R2 + pads[max - rlen];
                }
                if (max > alen) {
                    A2 = A2 + pads[max - alen];
                }
                if (max > slen) {
                    S2 = S2 + pads[max - slen];
                }
                if (max > vlen) {
                    V = V + pads[max - vlen];
                }
                am2.setProperty("reportPixel_R", R2);
                am2.setProperty("reportPixel_A", A2);
                am2.setProperty("reportPixel_S", S2);
                am2.setProperty("reportPixel_V", V);
                if (!am2.queryAnnotationItem("Graphic_Results")) continue;
                am2.setAnnotationItems(new String[]{"Report_Cursor"}, true);
                continue;
            }
            if (probeQ) continue;
            am2.setAnnotationItems(new String[]{"Report_Cursor"}, false);
        }
        if (nroi > 0) {
            if (this.selectedRoi == -1) {
                if (this.lastSelectedRois.size() > nroi) {
                    int diff = this.lastSelectedRois.size() - nroi;
                    for (int i3 = 0; i3 < diff; ++i3) {
                        int lastSelectedIdx = Integer.parseInt((String)this.lastSelectedRois.getLast());
                        LinkedList<String> temp = new LinkedList<String>();
                        int nlsr = this.lastSelectedRois.size();
                        for (int j2 = 0; j2 < nlsr - 1; ++j2) {
                            int index = Integer.parseInt((String)this.lastSelectedRois.get(j2));
                            if (index > lastSelectedIdx) {
                                --index;
                            }
                            temp.add("" + index);
                        }
                        this.lastSelectedRois = temp;
                    }
                }
            } else {
                if (this.lastSelectedRois.contains("" + this.selectedRoi)) {
                    this.lastSelectedRois.remove("" + this.selectedRoi);
                }
                this.lastSelectedRois.add("" + this.selectedRoi);
            }
            int noStat = 3;
            int rsIndex = 0;
            if (this.lastSelectedRois.size() < nroi) {
                for (int i4 = 0; i4 < nroi; ++i4) {
                    if (this.lastSelectedRois.contains("" + i4)) continue;
                    this.lastSelectedRois.add("" + i4);
                }
            }
            for (int i5 = nroi - 1; i5 >= 0 && noStat > 0; --i5) {
                int index = Integer.parseInt((String)this.lastSelectedRois.get(i5));
                if (index >= this.roiInfoList.size()) continue;
                am2.setProperty(roiPropName[rsIndex], (String)this.roiInfoList.get(index));
                ++rsIndex;
                --noStat;
            }
        } else {
            this.lastSelectedRois.clear();
        }
        for (i2 = nroi; i2 < 3; ++i2) {
            am2.setProperty(roiPropName[i2], "");
        }
    }

    public static class OEC
    extends XpCvApdAnnotationConfig {
        @Override
        public void configAnnotation(XpAnnotationVc avc, JComponent jc) {
            super.configAnnotation(avc, jc);
            XpAnnotationModel am2 = avc.getAnnotationModel();
            if (am2 == null) {
                return;
            }
            FrameOwner fowner = (FrameOwner)((Object)jc);
            int frameIndex = 1;
            int frameNo = 0;
            if (fowner != null && fowner.getFrame() instanceof XpMedicalDmImage) {
                DMImage dmImg = ((XpMedicalDmImage)fowner.getFrame()).getDMImage();
                frameNo = dmImg.getFrameNumber();
                frameIndex = frameNo + 1;
            }
            am2.setProperty("frameIndex", frameIndex);
            am2.setProperty("frameType", "NAT");
            XpImageRenderAttributesOwner iraOwner = (XpImageRenderAttributesOwner)((Object)jc);
            XpImageRenderAttributes ira = iraOwner.getImageRenderAttributes();
            List imops = ira.getImageOperations();
            if (imops.size() > 0) {
                for (Object o2 : imops) {
                    if (!(o2 instanceof DSAImageOp)) continue;
                    am2.setProperty("frameType", "SUB");
                    break;
                }
            } else {
                am2.setProperty("frameType", "NAT");
            }
        }
    }

    public static class PET
    extends XpCvApdAnnotationConfig {
        @Override
        public void configAnnotation(XpAnnotationVc avc, JComponent jc) {
            XpAnnotationModel am2 = avc.getAnnotationModel();
            if (am2 == null) {
                return;
            }
            XpImageRenderAttributesOwner iraOwner = (XpImageRenderAttributesOwner)((Object)jc);
            XpVisualComponent vc = (XpVisualComponent)jc;
            FrameOwner fowner = (FrameOwner)((Object)jc);
            XpDicomElement wwwlUnits = new XpDicomElement(84, 4097);
            XpImage xi = fowner.getFrame();
            XpDicomObject dobj = (XpDicomObject)((Object)xi);
            if (dobj != null) {
                dobj.getValue(wwwlUnits);
            }
            this.setRASCorners(avc, vc);
            if (jc instanceof XpMedicalImage2DVc) {
                XpMedicalImage2DVc mivc = (XpMedicalImage2DVc)jc;
                XpImage2DVc viewport = mivc.getImageVc();
                this.setROIInfo(avc, viewport);
                XpImageRenderAttributes ira = iraOwner.getImageRenderAttributes();
                double wMax = 0.0;
                double wMin = 0.0;
                String windowingUnits = wwwlUnits.getStringValue();
                if (windowingUnits != null && windowingUnits.compareTo("BQML") == 0) {
                    wMax = ira.getWindowMax() / 1000.0;
                    wMin = ira.getWindowMin() / 1000.0;
                } else {
                    wMax = ira.getWindowMax();
                    wMin = ira.getWindowMin();
                }
                double zoom = ira.getZoom();
                if (jc instanceof XpMedicalImage2DVc) {
                    XpMedicalImage2DVc mivc1 = (XpMedicalImage2DVc)jc;
                    XpImageOrientation ior = mivc1.getDisplayOrientation();
                    String iorStr = "" + ior;
                    am2.setProperty("currentOrientation", iorStr);
                }
                am2.setProperty("windowMin", wMin);
                am2.setProperty("windowMax", wMax);
                am2.setProperty("zoomFactor", zoom);
                IndexColorModel icm = ira.getColormap();
                List ops = ira.getImageOperations();
                boolean setGSE = false;
                am2.setProperty("currentFilterDescription", "   ");
                am2.setProperty("stretchDescription", "   ");
                if (icm != null) {
                    String ctableName = "" + icm;
                    if (ctableName.indexOf("g1") != -1 || ctableName.indexOf("g2") != -1 || ctableName.indexOf("g3") != -1) {
                        setGSE = true;
                    }
                    if (setGSE) {
                        am2.setProperty("stretchDescription", ctableName);
                    }
                }
                if (ops != null) {
                    int len = ops.size();
                    String filters = null;
                    for (int i2 = 0; i2 < len; ++i2) {
                        XpImageOp iop = (XpImageOp)ops.get(i2);
                        filters = i2 == 0 ? "" + iop.getImageOpName() : " " + iop.getImageOpName();
                    }
                    if (filters != null) {
                        am2.setProperty("currentFilterDescription", filters);
                    }
                }
            }
        }
    }

    public static class NoMarkers
    extends XpCvApdAnnotationConfig {
        XpDicomElement current_fr = new XpDicomElement(0, 1);

        @Override
        public void configAnnotation(XpAnnotationVc avc, JComponent jc) {
            XpAnnotationModel am2 = avc.getAnnotationModel();
            if (am2 == null) {
                return;
            }
            FrameOwner fowner = (FrameOwner)((Object)jc);
            XpImage xi = fowner.getFrame();
            XpDicomObject dobj = (XpDicomObject)((Object)xi);
            XpMedicalImage2DVc mivc = (XpMedicalImage2DVc)jc;
            XpImage2DVc viewport = mivc.getImageVc();
            if (dobj != null) {
                dobj.getValue(this.current_fr);
                if (this.current_fr.value != null) {
                    int iCurrentFrame = (Integer)this.current_fr.value + 1;
                    am2.setProperty("current_frame_number", "" + iCurrentFrame);
                }
            }
            this.setRenderAttributes(avc, mivc);
            XpImageOrientation ior = mivc.getDisplayOrientation();
            if (ior != null) {
                String iorStr = ior.toString();
                am2.setProperty("currentOrientation", iorStr);
            }
            this.setROIInfo(avc, viewport);
        }
    }

    public static class NM
    extends XpCvApdAnnotationConfig {
        XpDicomElement current_fr = new XpDicomElement(0, 1);
        XpDicomElement total_frames = new XpDicomElement(40, 8);

        @Override
        public void configAnnotation(XpAnnotationVc avc, JComponent jc) {
            XpAnnotationModel am2 = avc.getAnnotationModel();
            if (am2 == null) {
                return;
            }
            XpImageRenderAttributesOwner iraOwner = (XpImageRenderAttributesOwner)((Object)jc);
            XpVisualComponent vc = (XpVisualComponent)jc;
            XpDicomElement wwwlUnits = new XpDicomElement(84, 4097);
            this.setRASCorners(avc, vc);
            FrameOwner fowner = (FrameOwner)((Object)jc);
            XpImage xi = fowner.getFrame();
            XpDicomObject dobj = (XpDicomObject)((Object)xi);
            if (dobj != null) {
                dobj.getValue(wwwlUnits);
                dobj.getValue(this.current_fr);
                if (this.current_fr.value != null) {
                    int iCurrentFrame = (Integer)this.current_fr.value + 1;
                    am2.setProperty("current_frame_number", "" + iCurrentFrame);
                }
            }
            if (jc instanceof XpMedicalImage2DVc) {
                XpMedicalImage2DVc mivc = (XpMedicalImage2DVc)jc;
                XpImage2DVc viewport = mivc.getImageVc();
                this.setROIInfo(avc, viewport);
                XpImageRenderAttributes ira = iraOwner.getImageRenderAttributes();
                double wMax = 0.0;
                double wMin = 0.0;
                String windowingUnits = wwwlUnits.getStringValue();
                if (windowingUnits != null && windowingUnits.compareTo("BQML") == 0) {
                    wMax = ira.getWindowMax() / 1000.0;
                    wMin = ira.getWindowMin() / 1000.0;
                } else {
                    wMax = ira.getWindowMax();
                    wMin = ira.getWindowMin();
                }
                double zoom = ira.getZoom();
                if (jc instanceof XpMedicalImage2DVc) {
                    XpMedicalImage2DVc mivc1 = (XpMedicalImage2DVc)jc;
                    XpImageOrientation ior = mivc1.getDisplayOrientation();
                    String iorStr = "" + ior;
                    am2.setProperty("currentOrientation", iorStr);
                }
                am2.setProperty("windowMin", wMin);
                am2.setProperty("windowMax", wMax);
                am2.setProperty("zoomFactor", zoom);
            }
        }
    }

    public static class Default
    extends XpCvApdAnnotationConfig {
        XpDicomElement current_fr = new XpDicomElement(0, 1);

        @Override
        public void configAnnotation(XpAnnotationVc avc, JComponent jc) {
            XpAnnotationModel am2 = avc.getAnnotationModel();
            if (am2 == null) {
                return;
            }
            XpImageRenderAttributesOwner iraOwner = (XpImageRenderAttributesOwner)((Object)jc);
            XpVisualComponent vc = (XpVisualComponent)jc;
            FrameOwner fowner = (FrameOwner)((Object)jc);
            XpImage xi = fowner.getFrame();
            XpDicomObject dobj = (XpDicomObject)((Object)xi);
            if (dobj != null) {
                dobj.getValue(this.current_fr);
                if (this.current_fr.value != null) {
                    int iCurrentFrame = (Integer)this.current_fr.value + 1;
                    am2.setProperty("current_frame_number", "" + iCurrentFrame);
                }
            }
            super.configAnnotation(avc, jc);
        }
    }

    public static class CTScout
    extends XpCvApdAnnotationConfig {
    }

    public static class CT
    extends XpCvApdAnnotationConfig {
        @Override
        public void configAnnotation(XpAnnotationVc avc, JComponent jc) {
            XpDicomElement seq_tag = new XpDicomElement(73, 4097);
            XpAnnotationModel am2 = avc.getAnnotationModel();
            if (am2 == null) {
                return;
            }
            FrameOwner fowner = (FrameOwner)((Object)jc);
            XpImage xi = fowner.getFrame();
            XpDicomObject dobj = (XpDicomObject)((Object)xi);
            if (dobj != null) {
                DMSequence refStdyDMSeq;
                Object reconObj;
                String recon_sector;
                dobj.getValue(seq_tag);
                if (seq_tag.value != null && (recon_sector = (reconObj = (refStdyDMSeq = (DMSequence)seq_tag.value).getPeer().getValue(0, new DMTag(73, 4107))).toString()) != null) {
                    am2.setProperty("recon_sectors", recon_sector);
                }
            }
            super.configAnnotation(avc, jc);
        }
    }

    public static class MR
    extends XpCvApdAnnotationConfig {
        @Override
        public void configAnnotation(XpAnnotationVc avc, JComponent jc) {
            XpAnnotationModel am2 = avc.getAnnotationModel();
            if (am2 == null) {
                return;
            }
            super.configAnnotation(avc, jc);
        }

        @Override
        protected void setRenderAttributes(XpAnnotationVc avc, XpImageRenderAttributesOwner iraOwner) {
            super.setRenderAttributes(avc, iraOwner);
            XpAnnotationModel am2 = avc.getAnnotationModel();
            XpImageRenderAttributes ira = iraOwner.getImageRenderAttributes();
            if (am2 != null && ira != null) {
                double ww = ira.getWindowWidth();
                double wl = ira.getWindowLevel();
                am2.setProperty("windowWidth", ww);
                am2.setProperty("windowLevel", wl);
            }
        }
    }
}

