/*
 * Decompiled with CFR 0.152.
 */
package com.ge.med.cse.cvf.base;

import com.ge.med.cse.cvf.util.CvPropertiesManager;
import com.ge.med.idc.SelectionCapable;
import com.ge.med.terra.jami.XpFrameVisualizer;
import com.ge.med.terra.jami.XpMouseController;
import com.ge.med.terra.jami.XpViewportManager;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.SwingUtilities;

public class CVViewPortManager
implements XpViewportManager {
    protected static final Logger logger = Logger.getLogger(CVViewPortManager.class.getName());
    protected MouseListener viewportSelector = new ViewPortSelector();
    protected XpMouseController mouseController;

    @Override
    public void createViewportCB(XpFrameVisualizer fv) {
        fv.getMedicalImageVc().getAnnotationVc().removeMouseListener(this.viewportSelector);
        fv.getMedicalImageVc().getAnnotationVc().addMouseListener(this.viewportSelector);
        fv.setMouseController(this.createMouseController());
        logger.log(Level.FINE, "Viewport selection listener and mouse controller added sucessfully");
    }

    protected XpMouseController createMouseController() {
        String strMouseController = CvPropertiesManager.getProperty("MouseController");
        try {
            if (strMouseController != null) {
                return (XpMouseController)Class.forName(strMouseController).newInstance();
            }
        }
        catch (Exception e2) {
            e2.printStackTrace();
            logger.log(Level.SEVERE, "Exception in mouse controller creation", e2);
        }
        return null;
    }

    class ViewPortSelector
    extends MouseAdapter {
        ViewPortSelector() {
        }

        @Override
        public void mouseClicked(MouseEvent e2) {
            XpFrameVisualizer fv = (XpFrameVisualizer)SwingUtilities.getAncestorOfClass(XpFrameVisualizer.class, e2.getComponent());
            SelectionCapable sel = (SelectionCapable)((Object)SwingUtilities.getAncestorOfClass(SelectionCapable.class, fv));
            int numberofSel = sel.getNumComponents();
            for (int i2 = 0; i2 < numberofSel; ++i2) {
                if (!sel.getViewportComponent(i2).equals(fv)) continue;
                sel.setComponentSelection(i2);
            }
        }
    }
}

