/*
 * Decompiled with CFR 0.152.
 */
package com.ge.med.cse.cvf.base;

import com.ge.med.cse.cvf.idc.ImageValidator;
import com.ge.med.cse.cvf.log.UserMessageLevel;
import com.ge.med.cse.cvf.util.CvPropertiesManager;
import com.ge.med.cse.cvf.util.CvUtils;
import com.ge.med.cse.cvf.util.DicomUtils;
import com.ge.med.terra.tap.dm.DMTagValueInterface;
import java.util.logging.Level;
import java.util.logging.Logger;

public class DefaultImageValidator
implements ImageValidator {
    private static final Logger logger = Logger.getLogger(ImageValidator.class.getName());
    private static final String[] modalities = CvPropertiesManager.getProperty("cvf.modalities", "ct,mr,pr").split(",");

    @Override
    public boolean isValid(DMTagValueInterface[] sel) {
        if (sel == null || sel.length <= 0) {
            logger.log(Level.WARNING, "Selection is null/ or empty");
            return false;
        }
        boolean supported = false;
        String modality = DicomUtils.getModality(sel[0]);
        if (modality != null && modality.trim().length() > 0) {
            for (int i2 = 0; i2 < modalities.length; ++i2) {
                if (!modalities[i2].equalsIgnoreCase(modality)) continue;
                supported = true;
                break;
            }
        }
        String imageType = DicomUtils.getImageType(sel[0], false);
        if (!supported && !"SSAVE".equalsIgnoreCase(imageType)) {
            logger.log(Level.WARNING, "{0} Unsupported modality " + modality);
            logger.log(UserMessageLevel.USER_MSG, CvUtils.getResourceBundle().getString("SE_NOT_SUPPORTED") + " " + modality);
            return false;
        }
        if (imageType != null && ("3DMOD".equalsIgnoreCase(imageType) || imageType.equalsIgnoreCase("SR"))) {
            logger.log(Level.WARNING, "{0} Unsupported image type " + imageType);
            logger.log(UserMessageLevel.USER_MSG, CvUtils.getResourceBundle().getString("SE_NOT_SUPPORTED") + " " + imageType);
            return false;
        }
        return true;
    }
}

