/*
 * Decompiled with CFR 0.152.
 */
package com.ge.med.cse.cvf.base;

import com.ge.med.idc.PanZoomCapable;
import com.ge.med.terra.jami.XpViewport;
import com.ge.med.terra.jami.XpViewportDirector;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;

public class XpZoomLinkDirector
implements XpViewportDirector {
    private ArrayList<PanZoomCapable> portList = new ArrayList();
    private ZoomPropertyChangeListener listener = new ZoomPropertyChangeListener(this);

    @Override
    public void connectViewport(XpViewport viewport) {
        if (!this.portList.contains(viewport) && viewport instanceof PanZoomCapable) {
            this.portList.add((PanZoomCapable)((Object)viewport));
            viewport.addPropertyChangeListener(this.listener);
        }
    }

    @Override
    public void disconnectAllViewports() {
        for (int i2 = 0; i2 < this.portList.size(); ++i2) {
            PanZoomCapable port = this.portList.get(i2);
            port.removePropertyChangeListener(this.listener);
        }
        this.portList.clear();
    }

    @Override
    public void disconnectViewport(XpViewport viewport) {
        if (this.portList.contains(viewport)) {
            this.portList.remove(viewport);
            viewport.removePropertyChangeListener(this.listener);
        }
    }

    private void notifyZoom(double zoom, Object src) {
        for (int i2 = 0; i2 < this.portList.size(); ++i2) {
            PanZoomCapable port;
            if (this.portList.get(i2).equals(src) || (port = this.portList.get(i2)).getZoom() == zoom) continue;
            port.setZoom(zoom);
        }
    }

    static class ZoomPropertyChangeListener
    implements PropertyChangeListener {
        XpZoomLinkDirector adaptee;

        public ZoomPropertyChangeListener(XpZoomLinkDirector adaptee) {
            this.adaptee = adaptee;
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            String propName = evt.getPropertyName();
            if ("zoom".equalsIgnoreCase(propName)) {
                double zoom = (Double)evt.getNewValue();
                this.adaptee.notifyZoom(zoom, evt.getSource());
            }
        }
    }
}

