/*
 * Decompiled with CFR 0.152.
 */
package com.ge.med.cse.cvf.cpanels;

import com.ge.med.cse.cvf.util.CvUtils;
import com.ge.med.idc.WindowLevelCapable;
import com.ge.med.terra.jami.XpImage;
import com.ge.med.terra.jami.XpMedicalImage;
import com.ge.med.terra.jami.XpSeriesDisplayer;
import com.ge.med.terra.jami.capable.FrameOwner;
import com.ge.med.terra.xpv.autoControls.AutoControlPanelSeek;
import com.ge.med.terra.xpv.base.CapableListener;
import com.ge.med.terra.xpv.base.XPcontrolArea;
import com.ge.med.terra.xpv.base.XPscreen;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.text.NumberFormat;
import java.util.Properties;
import javax.swing.JComponent;
import javax.swing.JFormattedTextField;

public class XPwWinWidthField
extends JFormattedTextField
implements CapableListener,
ActionListener,
PropertyChangeListener {
    transient XPscreen screen = null;
    transient AutoControlPanelSeek panelSeek = null;
    WindowLevelCapable wlc_;

    public XPwWinWidthField() {
        this.addActionListener(this);
        this.panelSeek = new AutoControlPanelSeek(this);
        this.addAncestorListener(this.panelSeek);
        this.setHorizontalAlignment(4);
    }

    public XPwWinWidthField(NumberFormat format) {
        super(format);
        format.setMaximumFractionDigits(4);
        this.addActionListener(this);
        this.panelSeek = new AutoControlPanelSeek(this);
        this.addAncestorListener(this.panelSeek);
        this.setHorizontalAlignment(4);
    }

    public void removeActionListener() {
        this.removeActionListener(this);
    }

    public void addActionListener() {
        this.addActionListener(this);
    }

    @Override
    public void setScreen(XPscreen screen) {
        this.screen = screen;
    }

    @Override
    public void setProperties(Properties properties) {
    }

    @Override
    public void selectionChanged(JComponent oldPort, JComponent newPort) {
        WindowLevelCapable wlc = (WindowLevelCapable)this.screen.getCapable(WindowLevelCapable.class.getName());
        if (this.wlc_ != null) {
            this.wlc_.removePropertyChangeListener(this);
        }
        this.wlc_ = wlc;
        if (wlc != null) {
            double newWW = wlc.getWinMax() - wlc.getWinMin();
            this.setValue(new Double(newWW));
            this.invalidate();
            wlc.removePropertyChangeListener(this);
            wlc.addPropertyChangeListener("winMax", this);
        } else {
            this.setEnabled(false);
        }
    }

    @Override
    public void setControlArea(XPcontrolArea ca) {
    }

    @Override
    public void actionPerformed(ActionEvent ce) {
        this.setWindowLevel();
    }

    private void setWindowLevel() {
        WindowLevelCapable wlc;
        if (this.screen != null) {
            XpSeriesDisplayer sd = null;
            if (this.screen.getPort(0) instanceof XpSeriesDisplayer) {
                sd = (XpSeriesDisplayer)this.screen.getPort(0);
                XpImage xi = sd.getFrame();
            } else {
                return;
            }
        }
        if ((wlc = (WindowLevelCapable)this.panelSeek.getCapable(WindowLevelCapable.class.getName())) == null) {
            return;
        }
        XpMedicalImage dmImage = null;
        if (wlc instanceof FrameOwner && ((FrameOwner)((Object)wlc)).getFrame() instanceof XpMedicalImage) {
            dmImage = (XpMedicalImage)((FrameOwner)((Object)wlc)).getFrame();
        }
        double newWW = ((Number)this.getValue()).doubleValue();
        double maxww = CvUtils.getMaxWW(dmImage);
        double minww = CvUtils.getMinWW(dmImage);
        if (newWW > maxww) {
            newWW = maxww;
            this.setValue(new Double(newWW));
        } else if (newWW < minww) {
            newWW = minww;
            this.setValue(new Double(newWW));
        }
        double max = wlc.getWinMax();
        double min = wlc.getWinMin();
        double currentWL = (max + min) / 2.0;
        wlc.setWinMinMax(currentWL - newWW * 0.5, currentWL + newWW * 0.5);
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
    }
}

