/*
 * Decompiled with CFR 0.152.
 */
package com.ge.med.cse.cvf.cpanels;

import com.ge.med.cse.cvf.action.XpFlipHorizontalAction;
import com.ge.med.cse.cvf.action.XpFlipHorizontalVerticalAction;
import com.ge.med.cse.cvf.action.XpFlipVerticalAction;
import com.ge.med.cse.cvf.action.XpResetPanAction;
import com.ge.med.cse.cvf.action.XpRotateLeftAction;
import com.ge.med.cse.cvf.action.XpRotateRightAction;
import com.ge.med.cse.cvf.util.CvPropertiesManager;
import com.ge.med.cse.cvf.util.CvUtils;
import com.ge.med.terra.xpv.autoControls.XPcaAutoControlPanel;
import com.ge.med.terra.xpv.base.PlasmaControl;
import com.ge.med.terra.xpv.base.XPscreen;
import com.ge.med.terra.xpv.cuiPanels.TransactionLogName;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.UIManager;

public class XpFlipRotatePanel
extends XPcaAutoControlPanel {
    private JButton fhBut = null;
    private JButton fvBut = null;
    private JButton flipBothBut = null;
    private JButton rlBut = null;
    private JButton rrBut = null;
    private JButton resetAllBut = null;
    List<AbstractButton> buttonList = new ArrayList<AbstractButton>();
    Logger logger = Logger.getLogger("com.ge.med.cse.cvf.cpanels");
    boolean uiIntiated = false;

    public XpFlipRotatePanel() {
        this.setIcon(CvUtils.getIcon("XP_FLIP_ROTATE_CAP_ICON"));
        TransactionLogName tln = new TransactionLogName("TID=CreateFlipRotatePanel");
        this.logger.log(Level.FINE, "{0} begin Creating FlipRotate Panel", tln);
        if (!CvPropertiesManager.getBoolean("isLazyLoading", false)) {
            this.initUI();
            this.uiIntiated = true;
        }
        this.logger.log(Level.FINE, "{0} end Creating FlipRotate Panel", tln);
    }

    @Override
    public void panelStart() {
        super.panelStart();
        if (CvPropertiesManager.getBoolean("isLazyLoading", false) && !this.uiIntiated) {
            this.initUI();
            CvUtils.updateBackground(this, UIManager.getColor("P9"));
            this.uiIntiated = true;
            this.setActionCapable();
        }
    }

    private void initUI() {
        this.setOpaque(false);
        this.rlBut = this.getHideActionTextButton(new XpRotateLeftAction());
        this.rrBut = this.getHideActionTextButton(new XpRotateRightAction());
        this.rlBut.setName("ROTATE_LEFT");
        this.rrBut.setName("ROTATE_RIGHT");
        this.buttonList.add(this.rlBut);
        this.buttonList.add(this.rrBut);
        this.fhBut = this.getHideActionTextButton(new XpFlipHorizontalAction());
        this.fvBut = this.getHideActionTextButton(new XpFlipVerticalAction());
        this.fhBut.setPreferredSize(new Dimension(55, 46));
        this.fvBut.setPreferredSize(new Dimension(55, 46));
        this.fhBut.setName("FLIP_HORZ");
        this.fvBut.setName("FLIP_VERT");
        this.buttonList.add(this.fhBut);
        this.buttonList.add(this.fvBut);
        boolean value = Boolean.parseBoolean(CvPropertiesManager.getProperty("cvf.flipRotatePanel.flipBoth", "true"));
        if (value) {
            this.flipBothBut = this.getHideActionTextButton(new XpFlipHorizontalVerticalAction());
            this.flipBothBut.setPreferredSize(new Dimension(55, 46));
            this.flipBothBut.setName("FLIP_BOTH");
            this.buttonList.add(this.flipBothBut);
        }
        this.setLayout(new BorderLayout());
        JPanel topPanel = new JPanel();
        JPanel mainPanel = new JPanel();
        JPanel buttonPanel = new JPanel();
        topPanel.setName(XpFlipRotatePanel.class.getName() + "topPanel");
        mainPanel.setName(XpFlipRotatePanel.class.getName() + "mainPanel");
        buttonPanel.setName(XpFlipRotatePanel.class.getName() + "buttonPanel");
        topPanel.setLayout(new BorderLayout());
        mainPanel.setLayout(new GridLayout(3, 1));
        buttonPanel.setLayout(new GridLayout(1, this.buttonList.size(), 5, 0));
        for (int i2 = 0; i2 < this.buttonList.size(); ++i2) {
            JPanel butPanel = new JPanel(new GridBagLayout());
            butPanel.add((Component)this.buttonList.get(i2), new GridBagConstraints(i2, 0, 1, 1, 0.0, 0.0, 11, 0, new Insets(10, 0, 0, 0), 0, 0));
            buttonPanel.add(butPanel);
        }
        mainPanel.add(buttonPanel);
        value = Boolean.parseBoolean(CvPropertiesManager.getProperty("cvf.flipRotatePanel.reset", "true"));
        if (value) {
            this.resetAllBut = this.getHideActionTextButton(new XpResetPanAction());
            this.resetAllBut.setName("RESET");
            JPanel seperatorPanel = new JPanel();
            seperatorPanel.setLayout(new BorderLayout());
            JPanel resetPanel = new JPanel(new FlowLayout());
            JSeparator separator = new JSeparator();
            resetPanel.add(this.resetAllBut);
            seperatorPanel.add(separator);
            mainPanel.add(seperatorPanel);
            mainPanel.add(resetPanel);
            this.buttonList.add(this.resetAllBut);
        }
        topPanel.add((Component)mainPanel, "North");
        this.add((Component)topPanel, "North");
    }

    protected JButton getHideActionTextButton(Action action) {
        JButton toReturn = new JButton();
        toReturn.putClientProperty("hideActionText", Boolean.TRUE);
        toReturn.setAction(action);
        toReturn.setFocusable(false);
        return toReturn;
    }

    @Override
    public void setScreen(XPscreen screen) {
        super.setScreen(screen);
        if (this.uiIntiated) {
            this.setActionCapable();
        }
    }

    @Override
    public String getName() {
        return CvUtils.getResourceBundle().getString("XP_FLIP_ROTATE_CAP_TITLE");
    }

    private void setActionCapable() {
        try {
            for (AbstractButton but : this.buttonList) {
                Action act = but.getAction();
                if (!(act instanceof PlasmaControl)) continue;
                ((PlasmaControl)((Object)act)).setCapable(this.screen_);
            }
        }
        catch (Exception e2) {
            e2.printStackTrace();
        }
    }

    @Override
    public String getTitle() {
        return CvUtils.getResourceBundle().getString("XP_FLIP_ROTATE_CAP_TITLE");
    }
}

