/*
 * Decompiled with CFR 0.152.
 */
package com.ge.med.cse.cvf.cpanels;

import com.ge.med.cse.cvf.action.XpLinkPortAction;
import com.ge.med.cse.cvf.action.XpMinMaxPortAction;
import com.ge.med.cse.cvf.controls.CvMouseControlManager;
import com.ge.med.cse.cvf.util.CvPropertiesManager;
import com.ge.med.cse.cvf.util.CvUtils;
import com.ge.med.idc.Capable;
import com.ge.med.idc.SelectionCapable;
import com.ge.med.ptk.PtkBorderFactory;
import com.ge.med.terra.jami.XpCompositePort;
import com.ge.med.terra.jami.XpSingularPort;
import com.ge.med.terra.xpv.autoControls.XPcaAutoControlPanel;
import com.ge.med.terra.xpv.base.PlasmaControl;
import com.ge.med.terra.xpv.base.XPscreen;
import com.ge.med.terra.xpv.mouseController.LeftMouseButtonController;
import com.ge.med.terra.xpv.mouseController.LeftMouseButtonModeCapable;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JToggleButton;
import javax.swing.UIManager;

public class XpImageControlPanel
extends XPcaAutoControlPanel
implements ActionListener {
    protected final int ICON_SIZE = 27;
    private Logger logger = Logger.getLogger("com.ge.med.cse.cvf.cpanels");
    private static int currentSelectedMode = -1;
    private static int prevSelectedMode = -1;
    JToggleButton linkBtn = null;
    protected JToggleButton minMaxBtn = null;
    JButton closeBtn = null;
    public static final String CLOSE_APP = "close_app";
    private HashMap<Integer, JToggleButton> mouseControllers = new HashMap();
    private HashMap<String, Integer> mouseActionCmds = new HashMap();
    private CvMouseControlManager mcManager = CvMouseControlManager.getInstance();
    private LeftMouseButtonModeCapable lmbmCapabele = new LeftMouseButtonController();
    PropertyChangeListener mouseModeChangeListener = new PropertyChangeListener(){

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            int newMode = XpImageControlPanel.this.mcManager.getMouseMode();
            if (currentSelectedMode != newMode) {
                currentSelectedMode = newMode;
                if (XpImageControlPanel.this.mouseControllers.get(newMode) != null) {
                    ((JToggleButton)XpImageControlPanel.this.mouseControllers.get(newMode)).setSelected(true);
                }
            }
        }
    };
    PropertyChangeListener portChangeListener = new PropertyChangeListener(){

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            int capablePortCount = 0;
            int nports = XpImageControlPanel.this.getScreen().getScreenLayout().getNoOfPorts();
            for (int i2 = 0; i2 < nports; ++i2) {
                if (!(XpImageControlPanel.this.getScreen().getPort(i2) instanceof Capable)) continue;
                ++capablePortCount;
            }
            XpImageControlPanel.this.linkBtn.setVisible(capablePortCount > 1);
        }
    };
    PropertyChangeListener vpListener = new PropertyChangeListener(){

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            block14: {
                block13: {
                    if (!evt.getPropertyName().equals("Cine")) break block13;
                    boolean isCineOn = (Boolean)evt.getNewValue();
                    String modesOnCine = CvPropertiesManager.getProperty("MouseModesEnabledDuringCineOn");
                    if (modesOnCine == null) {
                        return;
                    }
                    String[] modesOnDuringCine = modesOnCine.split(",");
                    ArrayList<Integer> modesOnDrngCine = new ArrayList<Integer>();
                    for (int i2 = 0; i2 < modesOnDuringCine.length; ++i2) {
                        modesOnDrngCine.add(Integer.valueOf(modesOnDuringCine[i2].trim()));
                    }
                    if (modesOnDrngCine.size() > 0) {
                        if (isCineOn) {
                            prevSelectedMode = XpImageControlPanel.this.getMouseControllerMode();
                            if (!modesOnDrngCine.contains(XpImageControlPanel.this.getMouseControllerMode())) {
                                XpImageControlPanel.this.setMouseControllerMode(Integer.parseInt(CvPropertiesManager.getProperty("DefaultMouseModeDuringCineOn", "3")));
                            }
                        } else {
                            XpImageControlPanel.this.setMouseControllerMode(prevSelectedMode);
                        }
                    }
                    for (Map.Entry pair : XpImageControlPanel.this.mouseControllers.entrySet()) {
                        if (modesOnDrngCine.contains(pair.getKey())) continue;
                        ((JToggleButton)XpImageControlPanel.this.mouseControllers.get(pair.getKey())).setEnabled(!isCineOn);
                    }
                    break block14;
                }
                if (!evt.getPropertyName().equalsIgnoreCase("reference_vp_selection")) break block14;
                boolean isRefOn = (Boolean)evt.getNewValue();
                if (isRefOn) {
                    String modesOnRefVp = CvPropertiesManager.getProperty("MouseModesEnabledWhenRefVp_Selected");
                    if (modesOnRefVp == null) {
                        return;
                    }
                    String[] modesOnRefVp_sel = modesOnRefVp.split(",");
                    ArrayList<Integer> modesOnRef = new ArrayList<Integer>();
                    for (int i3 = 0; i3 < modesOnRefVp_sel.length; ++i3) {
                        modesOnRef.add(Integer.valueOf(modesOnRefVp_sel[i3].trim()));
                    }
                    for (Map.Entry pair : XpImageControlPanel.this.mouseControllers.entrySet()) {
                        if (modesOnRef.contains(pair.getKey())) continue;
                        ((JToggleButton)XpImageControlPanel.this.mouseControllers.get(pair.getKey())).setEnabled(false);
                    }
                } else {
                    for (int i4 = 0; i4 < XpImageControlPanel.this.mouseControllers.size(); ++i4) {
                        ((JToggleButton)XpImageControlPanel.this.mouseControllers.get(i4)).setEnabled(true);
                    }
                }
            }
        }
    };

    public XpImageControlPanel() {
        try {
            this.jbInit();
            this.mcManager.removePropertyChangeListener(this.mouseModeChangeListener);
            this.mcManager.addPropertyChangeListener(this.mouseModeChangeListener);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    protected void jbInit() throws Exception {
        this.setBackground(null);
        this.setLayout(new GridBagLayout());
        this.setName("imageControlPanel");
        JPanel controlBtnPanel = new JPanel();
        controlBtnPanel.setLayout(new GridBagLayout());
        controlBtnPanel.setBackground(UIManager.getColor("P8"));
        this.addControllers(controlBtnPanel);
        XpLinkPortAction linkAction = new XpLinkPortAction();
        this.linkBtn = new JToggleButton(linkAction);
        linkAction.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                if (evt.getPropertyName().equalsIgnoreCase("SwingSelectedKey")) {
                    XpImageControlPanel.this.linkBtn.setSelected((Boolean)evt.getNewValue());
                }
            }
        });
        this.linkBtn.setName("link_button");
        this.linkBtn.setFocusable(false);
        this.linkBtn.setMargin(new Insets(0, 0, 0, 0));
        this.linkBtn.setPreferredSize(new Dimension(50, 27));
        if (Boolean.parseBoolean(CvPropertiesManager.getProperty("MinMaxButtonOn"))) {
            this.minMaxBtn = new JToggleButton(new XpMinMaxPortAction());
            this.minMaxBtn.setName("minmax_button");
            this.minMaxBtn.setFocusable(false);
            this.minMaxBtn.setMargin(new Insets(0, 0, 0, 0));
            this.minMaxBtn.setPreferredSize(new Dimension(50, 27));
        }
        JPanel emptyPnl = new JPanel();
        emptyPnl.setBackground(UIManager.getColor("P10"));
        emptyPnl.setName(XpImageControlPanel.class.getName() + "emptyPnl");
        JPanel buttonPnl = new JPanel();
        buttonPnl.setLayout(new BorderLayout());
        buttonPnl.setBackground(UIManager.getColor("P8"));
        buttonPnl.setName(XpImageControlPanel.class.getName() + "buttonPnl");
        if (this.minMaxBtn != null) {
            buttonPnl.add((Component)this.minMaxBtn, "East");
            buttonPnl.add((Component)emptyPnl, "Center");
            buttonPnl.add((Component)this.linkBtn, "West");
        } else {
            buttonPnl.add((Component)this.linkBtn, "East");
        }
        JPanel btnPanel = new JPanel();
        btnPanel.setLayout(new BorderLayout());
        btnPanel.setBorder(BorderFactory.createLineBorder(UIManager.getColor("P10")));
        btnPanel.setBackground(UIManager.getColor("P8"));
        btnPanel.add((Component)controlBtnPanel, "West");
        btnPanel.add((Component)buttonPnl, "East");
        this.closeBtn = new JButton();
        this.closeBtn.setIcon(CvUtils.getIcon("XP_CLOSE_APP_ICON"));
        this.closeBtn.setToolTipText(CvUtils.getResourceBundle().getString("XP_CLOSE_APP_TOOLTIP"));
        this.closeBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e2) {
                XpImageControlPanel.this.getScreen().firePropertyChange(XpImageControlPanel.CLOSE_APP, false, true);
            }
        });
        this.closeBtn.setFocusPainted(false);
        this.closeBtn.setFocusable(false);
        this.closeBtn.setBackground(null);
        this.closeBtn.setBorder(null);
        this.closeBtn.setForeground(UIManager.getColor("P3"));
        this.closeBtn.setPreferredSize(new Dimension(20, 20));
        this.closeBtn.setName(XpImageControlPanel.class.getName() + "closeBtn");
        JPanel closePnl = new JPanel();
        closePnl.setBackground(UIManager.getColor("P10"));
        closePnl.setLayout(new BorderLayout());
        closePnl.add((Component)this.closeBtn, "East");
        closePnl.setName(XpImageControlPanel.class.getName() + "closePnl");
        JPanel imgCtrlLblPnl = new JPanel();
        imgCtrlLblPnl.setLayout(new GridBagLayout());
        JLabel imgctrlLbl = new JLabel(CvUtils.getResourceBundle().getString("XP_IMGCONTROL_TXT"));
        imgctrlLbl.setForeground(UIManager.getColor("P7"));
        imgCtrlLblPnl.add((Component)imgctrlLbl, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 17, 2, new Insets(0, 0, 0, 0), 0, 0));
        imgCtrlLblPnl.add((Component)closePnl, new GridBagConstraints(1, 0, 1, 1, 1.0, 1.0, 13, 2, new Insets(0, 0, 0, 0), 0, 0));
        imgCtrlLblPnl.setBackground(UIManager.getColor("P10"));
        imgCtrlLblPnl.setName(XpImageControlPanel.class.getName() + "imgCtrlLblPnl");
        Insets insets = new Insets(4, 4, 4, 4);
        double[] corners = new double[]{4.0, 0.0, 0.0, 4.0};
        imgCtrlLblPnl.setBorder(PtkBorderFactory.createRoundedCornerBorder(insets, corners));
        JPanel titlePnl = new JPanel();
        titlePnl.setLayout(new BorderLayout());
        titlePnl.setBackground(UIManager.getColor("P8"));
        titlePnl.add((Component)imgCtrlLblPnl, "Center");
        titlePnl.setName(XpImageControlPanel.class.getName() + "titlePnl");
        this.add((Component)titlePnl, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 17, 2, new Insets(0, 0, 0, 0), 0, 0));
        this.add((Component)btnPanel, new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 17, 2, new Insets(0, 0, 0, 0), 0, 0));
        this.add((Component)emptyPnl, new GridBagConstraints(0, 2, 1, 1, 1.0, 1.0, 17, 2, new Insets(0, 0, 0, 0), 0, 0));
    }

    protected void addControllers(JPanel controlBtnPanel) {
        try {
            ButtonGroup controlGroup = new ButtonGroup();
            JToggleButton tbtn = null;
            int defaultSelectionMode = Integer.parseInt(CvPropertiesManager.getProperty("MouseMenu.Controller.defaultMode"));
            String mouseActionCountString = CvPropertiesManager.getProperty("MouseMenu.Controller.count");
            if (mouseActionCountString != null) {
                int count = Integer.parseInt(mouseActionCountString);
                int position = 0;
                for (int i2 = 0; i2 < count; ++i2) {
                    String modeString = CvPropertiesManager.getProperty("MouseMenu.Controller." + String.valueOf(i2) + ".mode");
                    while (modeString == null || modeString == "") {
                        ++count;
                        modeString = CvPropertiesManager.getProperty("MouseMenu.Controller." + String.valueOf(++i2) + ".mode");
                    }
                    int mode = Integer.parseInt(modeString.trim());
                    String overwriteString = CvPropertiesManager.getProperty("MouseMenu.Controller." + String.valueOf(i2) + ".overwrite");
                    boolean isOverwrite = Boolean.valueOf(overwriteString);
                    if (isOverwrite) {
                        String name = CvPropertiesManager.getProperty("MouseMenu.Controller." + String.valueOf(i2) + ".name");
                        String tooltip = CvUtils.getResourceBundle().getString("MouseMenu.Controller." + name + ".tooltip");
                        LeftMouseButtonController.putMouseModeProperty(mode, "name_property", tooltip);
                        String shortDesc = CvUtils.getResourceBundle().getString("MouseMenu.Controller." + name + ".shortdesc");
                        LeftMouseButtonController.putMouseModeProperty(mode, "short_description_property", shortDesc);
                        ImageIcon icon = (ImageIcon)CvUtils.getIcon("MouseMenu.Controller." + name + ".icon");
                        LeftMouseButtonController.putMouseModeProperty(mode, "icon_property", icon);
                        Icon selectedIcon = CvUtils.getIcon("MouseMenu.Controller." + name + ".selectedicon");
                        LeftMouseButtonController.putMouseModeProperty(mode, "selected_icon_property", selectedIcon);
                        Cursor cursor = Toolkit.getDefaultToolkit().createCustomCursor(icon.getImage(), new Point(icon.getIconWidth() / 2, icon.getIconHeight() / 2), name);
                        LeftMouseButtonController.putMouseModeProperty(mode, "cursor_property", cursor);
                    }
                    if ((tbtn = this.createController(mode)) == null) continue;
                    controlBtnPanel.add((Component)tbtn, new GridBagConstraints(position++, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(3, 5, 3, 5), 0, 0));
                    controlGroup.add(tbtn);
                    currentSelectedMode = defaultSelectionMode;
                    if (defaultSelectionMode == mode) {
                        tbtn.setSelected(true);
                    }
                    this.mouseControllers.put(mode, tbtn);
                    this.mouseActionCmds.put(tbtn.getActionCommand(), mode);
                }
            }
        }
        catch (Exception e2) {
            this.logger.log(Level.WARNING, "Unable to install Mouse Controllers. " + e2.getLocalizedMessage());
        }
    }

    private JToggleButton createController(int mode) {
        JToggleButton btn = new JToggleButton();
        btn.setIcon((Icon)LeftMouseButtonController.getMouseModeProperty(mode, "icon_property"));
        btn.setToolTipText((String)LeftMouseButtonController.getMouseModeProperty(mode, "name_property"));
        btn.addActionListener(this);
        btn.setActionCommand((String)LeftMouseButtonController.getMouseModeProperty(mode, "name_property"));
        btn.setName((String)LeftMouseButtonController.getMouseModeProperty(mode, "name_property"));
        btn.setFocusPainted(false);
        btn.setFocusable(false);
        btn.setBackground(null);
        btn.setBorder(null);
        btn.setPreferredSize(new Dimension(27, 27));
        return btn;
    }

    @Override
    public void setScreen(XPscreen screen) {
        super.setScreen(screen);
        if (this.linkBtn != null && this.linkBtn.getAction() instanceof PlasmaControl) {
            ((PlasmaControl)((Object)this.linkBtn.getAction())).setCapable(screen);
        }
        if (this.minMaxBtn != null) {
            if (this.minMaxBtn.getAction() instanceof PlasmaControl) {
                ((PlasmaControl)((Object)this.minMaxBtn.getAction())).setCapable(screen);
            }
            this.minMaxBtn.setVisible(true);
        }
        this.getScreen().removePropertyChangeListener(this.vpListener);
        this.getScreen().addPropertyChangeListener(this.vpListener);
        this.getScreen().removePropertyChangeListener("port_change_property", this.portChangeListener);
        this.getScreen().addPropertyChangeListener("port_change_property", this.portChangeListener);
        int capablePortCount = 0;
        int nports = this.getScreen().getScreenLayout().getNoOfPorts();
        for (int i2 = 0; i2 < nports; ++i2) {
            if (!(this.getScreen().getPort(i2) instanceof Capable)) continue;
            ++capablePortCount;
        }
        if (this.linkBtn != null) {
            this.linkBtn.setVisible(capablePortCount > 1);
        }
    }

    @Override
    public void actionPerformed(ActionEvent e2) {
        int mode = this.mouseActionCmds.get(e2.getActionCommand());
        this.setMouseControllerMode(mode);
    }

    private void setMouseControllerMode(int mode) {
        ArrayList<JComponent> ports = new ArrayList<JComponent>();
        SelectionCapable slccpb = (SelectionCapable)this.getScreen().getCapable(SelectionCapable.class.getName());
        for (int i2 = 0; i2 < slccpb.getNumComponents(); ++i2) {
            ports.add(slccpb.getViewportComponent(i2));
        }
        for (JComponent com : ports) {
            if (!(com instanceof XpCompositePort)) continue;
            Iterator iterator2 = ((XpCompositePort)com).getPorts();
            while (iterator2.hasNext()) {
                XpSingularPort vp = (XpSingularPort)iterator2.next();
                if (vp == null || !(vp.getMouseController() instanceof LeftMouseButtonModeCapable)) continue;
                ((LeftMouseButtonModeCapable)((Object)vp.getMouseController())).setLeftMouseButtonMode(mode);
            }
            currentSelectedMode = mode;
        }
    }

    private int getMouseControllerMode() {
        ArrayList<JComponent> ports = new ArrayList<JComponent>();
        SelectionCapable slccpb = (SelectionCapable)this.getScreen().getCapable(SelectionCapable.class.getName());
        for (int i2 = 0; i2 < slccpb.getNumComponents(); ++i2) {
            ports.add(slccpb.getViewportComponent(i2));
        }
        for (JComponent com : ports) {
            if (!(com instanceof XpCompositePort)) continue;
            Iterator iterator2 = ((XpCompositePort)com).getPorts();
            while (iterator2.hasNext()) {
                XpSingularPort vp = (XpSingularPort)iterator2.next();
                if (vp == null || !(vp.getMouseController() instanceof LeftMouseButtonModeCapable)) continue;
                return ((LeftMouseButtonModeCapable)((Object)vp.getMouseController())).getLeftMouseButtonMode();
            }
        }
        return -1;
    }
}

