/*
 * Decompiled with CFR 0.152.
 */
package com.ge.med.cse.cvf.cpanels;

import com.ge.med.cse.cvf.action.XpTextPageExamAction;
import com.ge.med.cse.cvf.action.XpTextPageROIAction;
import com.ge.med.cse.cvf.action.XpTextPageSeriesAction;
import com.ge.med.cse.cvf.util.CvUtils;
import com.ge.med.terra.xpv.autoControls.XPcaAutoControlPanel;
import com.ge.med.terra.xpv.base.PlasmaControl;
import com.ge.med.terra.xpv.base.XPscreen;
import com.ge.med.terra.xpv.cuiPanels.TransactionLogName;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.Action;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.UIManager;

public class XpTextPagePanel
extends XPcaAutoControlPanel
implements PropertyChangeListener {
    private final Logger logger = Logger.getLogger("com.ge.med.cse.cvf.cpanels");
    private JButton examButton = new JButton();
    private JButton seriesButton = new JButton();
    private JButton roiButton = new JButton();

    public XpTextPagePanel() {
        TransactionLogName tid = new TransactionLogName("TID=CreateTextPagePanel");
        this.logger.log(Level.FINE, "{0} begin, Creating textpage panel", tid);
        this.initUI();
        this.logger.log(Level.FINE, "{0} end, Creating textpage panel", tid);
    }

    private void initUI() {
        this.examButton.setPreferredSize(new Dimension(200, 40));
        this.seriesButton.setPreferredSize(new Dimension(200, 40));
        this.roiButton.setPreferredSize(new Dimension(200, 40));
        this.examButton.setActionCommand("Exam Text Page");
        this.seriesButton.setActionCommand("Series Text Page");
        this.roiButton.setActionCommand("ROI Text Page");
        this.examButton.setName("Exam_Button");
        this.seriesButton.setName("Series_Button");
        this.roiButton.setName("ROI_Button");
        this.setOpaque(false);
        this.setIcon(CvUtils.getIcon("XP_TEXTPAGE_ICON"));
        this.setTitle(CvUtils.getResourceBundle().getString("XP_TEXTPAGE_NAME"));
        try {
            if (!"CUI".equals(UIManager.getLookAndFeel().getName())) {
                UIManager.setLookAndFeel("com.ge.med.ptk.laf.CuiLookAndFeel");
            }
        }
        catch (Exception e2) {
            e2.printStackTrace();
        }
        this.setLayout(new GridBagLayout());
        this.add((Component)this.examButton, new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.add((Component)this.seriesButton, new GridBagConstraints(0, 2, 1, 1, 1.0, 1.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.add((Component)this.roiButton, new GridBagConstraints(0, 3, 1, 1, 1.0, 1.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.add((Component)new JLabel(), new GridBagConstraints(0, 4, 1, 2, 1.0, 1.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.examButton.setAction(new XpTextPageExamAction());
        this.seriesButton.setAction(new XpTextPageSeriesAction());
        this.roiButton.setAction(new XpTextPageROIAction());
    }

    @Override
    public void setScreen(XPscreen screen) {
        super.setScreen(screen);
        this.setActionCapable(this.examButton);
        this.setActionCapable(this.seriesButton);
        this.setActionCapable(this.roiButton);
    }

    private void setActionCapable(JButton but) {
        Action act = but.getAction();
        if (act instanceof PlasmaControl) {
            ((PlasmaControl)((Object)act)).setCapable(this.screen_);
        }
    }

    @Override
    public void panelStop() {
        super.panelStop();
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
    }

    @Override
    public String getToolTipText() {
        return CvUtils.getResourceBundle().getString("XP_TEXTPAGE_NAME_IMG_TOOLTIP");
    }

    @Override
    public String getName() {
        return CvUtils.getResourceBundle().getString("XP_TEXTPAGE_NAME");
    }
}

