/*
 * Decompiled with CFR 0.152.
 */
package com.ge.med.cse.cvf.crossref;

import com.ge.med.cse.cvf.comparators.DefaultImComparator;
import com.ge.med.cse.cvf.crossref.CvCrossRefUtils;
import com.ge.med.cse.cvf.crossref.XpReferenceImageDirector;
import com.ge.med.cse.cvf.log.UserMessageLevel;
import com.ge.med.cse.cvf.util.CvUtils;
import com.ge.med.idc.Capable;
import com.ge.med.idc.SelectionCapable;
import com.ge.med.terra.jami.XpMedicalImage;
import com.ge.med.terra.jami.XpSingularPort;
import com.ge.med.terra.jami.XpViewport;
import com.ge.med.terra.jami.capable.FrameOwner;
import com.ge.med.terra.jami.platform.dm.XpMedicalDmImage;
import com.ge.med.terra.jami.render.XpImageRenderAttributes;
import com.ge.med.terra.jami.render.XpImageRenderAttributesOwner;
import com.ge.med.terra.tap.dm.DMImage;
import com.ge.med.terra.tap.dm.DMObject;
import com.ge.med.terra.tap.dm.DMQuery;
import com.ge.med.terra.tap.dm.DMSession;
import com.ge.med.terra.tap.dm.DMSystem;
import com.ge.med.terra.tap.dm.DMTag;
import com.ge.med.terra.xpv.cuiPanels.TransactionLogName;
import java.awt.Component;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JComponent;

public class XpReferenceImageApp {
    public static final String REFERENCE_VP_SELECTION = "reference_vp_selection";
    protected XpReferenceImageDirector refImage = null;
    protected XpViewport mvp = null;
    protected DMSession session = null;
    protected DMObject refSeries = null;
    private static final Logger logger = Logger.getLogger(XpReferenceImageApp.class.getName());
    private static Map refImageList = Collections.synchronizedMap(new HashMap());
    private boolean force = false;
    public static final int ALL_ON = 0;
    public static final int ALL_OFF = 1;
    public static final int SELECTED_ON = 2;
    public static final int SELECTED_OFF = 3;
    private static int refImgContext = -1;
    PropertyChangeListener mvpListsner = new PropertyChangeListener(){

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            XpReferenceImageApp.this.removeRefImage(false);
            XpReferenceImageApp.this.mvp.repaint();
        }
    };
    PropertyChangeListener formatListener = new PropertyChangeListener(){

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            if (!XpReferenceImageApp.this.refImage.canPostRefImage(XpReferenceImageApp.this.mvp)) {
                XpReferenceImageApp.this.removeRefImage(false);
            }
            if (XpReferenceImageApp.this.refImage.getReferencePortCount() > 0 && !XpReferenceImageApp.this.refImage.getCurrentMode()) {
                XpReferenceImageApp.this.refImage.postReferenceImage(XpReferenceImageApp.this.force);
            }
            XpReferenceImageApp.this.mvp.repaint();
        }
    };

    public static XpReferenceImageApp getInstance(XpViewport mainvp, boolean selected) {
        return XpReferenceImageApp.getInstance(mainvp, selected, false);
    }

    public static XpReferenceImageApp getInstance(XpViewport mainvp, boolean selected, boolean force) {
        if (mainvp == null) {
            logger.log(Level.WARNING, "Main viewport is null.");
            return null;
        }
        XpReferenceImageApp riapp = null;
        if (refImageList.containsKey(Integer.toString(mainvp.hashCode()))) {
            riapp = (XpReferenceImageApp)refImageList.get(Integer.toString(mainvp.hashCode()));
            riapp.setMode(selected);
            logger.log(Level.INFO, "Returning already created instance of the RefImageApp.");
            return riapp;
        }
        try {
            riapp = new XpReferenceImageApp(mainvp, selected, force);
            refImageList.put(Integer.toString(mainvp.hashCode()), riapp);
        }
        catch (Exception ex) {
            logger.log(Level.INFO, "Error in creating new instance of ReferenceImageApp :: " + ex);
        }
        return riapp;
    }

    public static XpReferenceImageApp copyInstance(XpViewport sourcevp, XpViewport destvp, boolean force) {
        if (sourcevp == null || destvp == null) {
            logger.log(Level.WARNING, "Source/Destination viewport is null.");
            return null;
        }
        XpReferenceImageApp destriapp = null;
        if (refImageList.containsKey(Integer.toString(destvp.hashCode()))) {
            logger.log(Level.WARNING, "Reference viewport already there on dest viewport.");
            return null;
        }
        XpReferenceImageApp riapp = null;
        if (!refImageList.containsKey(Integer.toString(sourcevp.hashCode()))) {
            logger.log(Level.WARNING, "Reference viewport not found on source viewport.");
            return null;
        }
        riapp = (XpReferenceImageApp)refImageList.get(Integer.toString(sourcevp.hashCode()));
        try {
            destriapp = XpReferenceImageApp.getInstance(destvp, riapp.getMode(), force);
            destriapp.setSession(riapp.session);
            destriapp.setReferenceSeries(riapp.getReferenceSeries(), -1);
            destriapp.refImage.setFrameIndex(riapp.refImage.getReferenceFrameIndex());
            XpViewport[] ports = riapp.refImage.getRefPorts();
            if (ports != null && ports.length > 0 && ports[0] instanceof XpImageRenderAttributesOwner) {
                XpImageRenderAttributes ira = ((XpImageRenderAttributesOwner)((Object)ports[0])).getImageRenderAttributes();
                destriapp.refImage.setImageRenderAttributes(ira);
            }
        }
        catch (Exception ex) {
            logger.log(Level.INFO, "Error in creating new instance of ReferenceImageApp :: " + ex);
        }
        return destriapp;
    }

    public static void postReferenceImage(XpViewport mainvp, boolean selected) {
        XpReferenceImageApp ria;
        DMSession sess;
        TransactionLogName tln = new TransactionLogName("TID=CV_referenceImageVPOn");
        logger.log(Level.INFO, "{0} begin", tln);
        CvCrossRefUtils.CrossRefResult result = new CvCrossRefUtils.CrossRefResult();
        DMSystem dmsys = null;
        try {
            dmsys = CvUtils.getDMSystem();
        }
        catch (Exception exp) {
            logger.log(Level.WARNING, "Exception while getting DMSystem, stack trace {0} ", new Object[]{exp});
        }
        DMSession dMSession = sess = dmsys != null ? dmsys.getLocalDB() : null;
        if (sess == null) {
            logger.log(Level.WARNING, "DMSession not set.");
            result.status = 8;
        }
        if (mainvp == null) {
            logger.log(Level.WARNING, "Selected port is null.");
            result.status = 8;
        }
        if ((ria = XpReferenceImageApp.getInstance(mainvp, selected)) == null) {
            result.status = 8;
        } else {
            ria.setSession(sess);
            result = ria.fetchValidReferenceSeries();
            if (result != null && ria.getRefPortCount() == 0) {
                XpReferenceImageApp.removeReferenceImage(mainvp, false);
            }
            XpReferenceImageApp.setOprMsg(result.status);
        }
        logger.log(Level.INFO, "{0} end", tln);
    }

    public static void postReferenceImage(XpViewport mainvp, boolean selected, int se, int im) {
        XpReferenceImageApp ria;
        DMSession sess;
        TransactionLogName tln = new TransactionLogName("TID=CV_referenceImageVPOnCmd");
        logger.log(Level.INFO, "{0} begin", tln);
        CvCrossRefUtils.CrossRefResult result = new CvCrossRefUtils.CrossRefResult();
        DMSystem dmsys = null;
        try {
            dmsys = CvUtils.getDMSystem();
        }
        catch (Exception exp) {
            logger.log(Level.WARNING, "Exception while getting DMSystem, stack trace {0} ", new Object[]{exp});
        }
        DMSession dMSession = sess = dmsys != null ? dmsys.getLocalDB() : null;
        if (sess == null) {
            logger.log(Level.WARNING, "DMSession not set.");
            result.status = 8;
        }
        if (mainvp == null) {
            logger.log(Level.WARNING, "Selected port is null.");
            result.status = 8;
        }
        if ((ria = XpReferenceImageApp.getInstance(mainvp, selected)) == null) {
            result.status = 8;
        } else {
            ria.setSession(sess);
            if (se < 0) {
                result = ria.fetchValidReferenceSeries();
                if (result != null && result.status != -1 && ria.getRefPortCount() == 0) {
                    XpReferenceImageApp.removeReferenceImage(mainvp, false);
                }
                XpReferenceImageApp.setOprMsg(result.status);
            } else {
                int status = ria.setReferenceSeriesByNumber(se, im);
                if (status != -1 && ria.getRefPortCount() == 0) {
                    XpReferenceImageApp.removeReferenceImage(mainvp, false);
                }
                XpReferenceImageApp.setOprMsg(status);
            }
        }
        logger.log(Level.INFO, "{0} end", tln);
    }

    private static void setOprMsg(int status) {
        if (status != -1) {
            if (status == 0) {
                logger.log(UserMessageLevel.USER_MSG, CvUtils.getResourceBundle().getString("REFIMG_NO_VALID_SE"));
            } else if (status == 1) {
                logger.log(UserMessageLevel.USER_MSG, CvUtils.getResourceBundle().getString("REFIMG_INVALID_EXAM"));
            } else if (status == 2) {
                logger.log(UserMessageLevel.USER_MSG, CvUtils.getResourceBundle().getString("XR_INVALID_SERIES"));
            } else if (status == 3) {
                logger.log(UserMessageLevel.USER_MSG, CvUtils.getResourceBundle().getString("REFIMG_POS_ENTRY_LANDMARK"));
            } else if (status == 4) {
                logger.log(UserMessageLevel.USER_MSG, CvUtils.getResourceBundle().getString("REFIMG_POS_ENTRY_LANDMARK"));
            } else if (status == 5) {
                logger.log(UserMessageLevel.USER_MSG, CvUtils.getResourceBundle().getString("REFIMG_POS_ENTRY_LANDMARK"));
            } else if (status == 6 || status == 10) {
                logger.log(UserMessageLevel.USER_MSG, CvUtils.getResourceBundle().getString("REFIMG_SAME_SCAN_PL"));
            } else if (status == 7) {
                logger.log(UserMessageLevel.USER_MSG, CvUtils.getResourceBundle().getString("REF_SERIES_NOT_FOUND"));
            } else if (status == 9) {
                logger.log(UserMessageLevel.USER_MSG, CvUtils.getResourceBundle().getString("XP_SERIES_TOO_LAREG_FOR_CMD"));
            } else {
                logger.log(UserMessageLevel.USER_MSG, CvUtils.getResourceBundle().getString("DEFAULT_FAIL_MSG"));
            }
        }
    }

    public static void removeReferenceImage(XpViewport mainvp, boolean selected) {
        TransactionLogName tln = new TransactionLogName("TID=CV_referenceImageVPOff");
        logger.log(Level.INFO, "{0} begin", tln);
        if (refImageList.containsKey(Integer.toString(mainvp.hashCode()))) {
            XpReferenceImageApp riapp = (XpReferenceImageApp)refImageList.get(Integer.toString(mainvp.hashCode()));
            riapp.removeRefImage(selected);
        }
        logger.log(Level.INFO, "{0} end", tln);
    }

    public static Component cloneSelectedPort(XpViewport mainvp) {
        int sel = XpReferenceImageApp.getSelectedRefPortIndex(mainvp);
        if (sel == -1) {
            sel = mainvp instanceof SelectionCapable ? ((SelectionCapable)((Object)mainvp)).getComponentSelection() : 0;
        }
        if (sel != -1) {
            return XpReferenceImageApp.cloneWithRefPort(mainvp, sel);
        }
        return null;
    }

    public static int getSelectedRefPortIndex(XpViewport mainvp) {
        if (XpReferenceImageApp.isRefPortOn(mainvp)) {
            XpReferenceImageApp riapp = (XpReferenceImageApp)refImageList.get(Integer.toString(mainvp.hashCode()));
            return riapp.refImage.getSelectedRefPortIndex();
        }
        return -1;
    }

    public static boolean isRefPortOn(XpViewport mainvp) {
        if (mainvp == null) {
            logger.log(Level.WARNING, "Main viewport is null.");
            return false;
        }
        return refImageList.containsKey(Integer.toString(mainvp.hashCode()));
    }

    public static Component cloneWithRefPort(XpViewport mainvp, int portindex) {
        if (mainvp == null) {
            return null;
        }
        if (!XpReferenceImageApp.isRefPortOn(mainvp)) {
            return null;
        }
        XpReferenceImageApp riapp = (XpReferenceImageApp)refImageList.get(Integer.toString(mainvp.hashCode()));
        if (portindex >= 0) {
            JComponent c2 = null;
            c2 = mainvp instanceof SelectionCapable ? ((SelectionCapable)((Object)mainvp)).getViewportComponent(portindex) : mainvp;
            if (c2 != null) {
                XpViewport port = (XpViewport)((XpViewport)c2).clone();
                Component refvp = riapp.refImage.cloneRefPort(portindex);
                if (refvp != null) {
                    ((XpSingularPort)port).getMedicalImageVc().add(refvp, 0);
                }
                return port;
            }
        }
        return null;
    }

    public static Component copyRefPort(XpViewport mainvp, XpViewport destvp, int portindex) {
        if (XpReferenceImageApp.isRefPortOn(mainvp)) {
            XpReferenceImageApp riapp = (XpReferenceImageApp)refImageList.get(Integer.toString(mainvp.hashCode()));
            return riapp.refImage.copyRefPortTo(destvp, portindex);
        }
        return null;
    }

    public static boolean isRefPortAllOn(XpViewport mainvp) {
        if (XpReferenceImageApp.isRefPortOn(mainvp)) {
            XpReferenceImageApp riapp = (XpReferenceImageApp)refImageList.get(Integer.toString(mainvp.hashCode()));
            return riapp.refImage.isRefPortAllOn();
        }
        return false;
    }

    public static boolean isRefPortOn(XpViewport mainvp, int portindex) {
        if (XpReferenceImageApp.isRefPortOn(mainvp)) {
            XpReferenceImageApp riapp = (XpReferenceImageApp)refImageList.get(Integer.toString(mainvp.hashCode()));
            return riapp.refImage.isRefPortOn(portindex);
        }
        return false;
    }

    public static int getRefPortCount(XpViewport mainvp) {
        if (XpReferenceImageApp.isRefPortOn(mainvp)) {
            XpReferenceImageApp riapp = (XpReferenceImageApp)refImageList.get(Integer.toString(mainvp.hashCode()));
            return riapp.getRefPortCount();
        }
        return 0;
    }

    public static boolean isRefPortSelected(XpViewport mainvp) {
        if (XpReferenceImageApp.isRefPortOn(mainvp)) {
            XpReferenceImageApp riapp = (XpReferenceImageApp)refImageList.get(Integer.toString(mainvp.hashCode()));
            return riapp.refImage.isRefPortSelected();
        }
        return false;
    }

    public static JComponent getSelectedRefPort(XpViewport mainvp) {
        if (XpReferenceImageApp.isRefPortOn(mainvp)) {
            XpReferenceImageApp riapp = (XpReferenceImageApp)refImageList.get(Integer.toString(mainvp.hashCode()));
            return riapp.refImage.getSelectedRefPort();
        }
        return null;
    }

    public static void setRefPortSelection(XpViewport mainvp, int portindex) {
        if (XpReferenceImageApp.isRefPortOn(mainvp)) {
            XpReferenceImageApp riapp = (XpReferenceImageApp)refImageList.get(Integer.toString(mainvp.hashCode()));
            if (portindex < 0) {
                riapp.refImage.clearRefVpSelection();
            } else {
                riapp.refImage.setRefVpSelection(portindex);
            }
        }
    }

    public static XpViewport getRefViewportComponent(XpViewport mainvp, int index) {
        if (XpReferenceImageApp.isRefPortOn(mainvp)) {
            XpReferenceImageApp riapp = (XpReferenceImageApp)refImageList.get(Integer.toString(mainvp.hashCode()));
            return riapp.refImage.getRefPort(index);
        }
        return null;
    }

    public static void setRefImageContext(int context) {
        refImgContext = context;
    }

    public static int getRefImageContext() {
        return refImgContext;
    }

    public static Capable getCapable(XpViewport mainvp, String capIFname) {
        if (mainvp == null) {
            logger.log(Level.WARNING, "Main viewport is null.");
            return null;
        }
        if (refImageList.containsKey(Integer.toString(mainvp.hashCode()))) {
            XpReferenceImageApp riapp = (XpReferenceImageApp)refImageList.get(Integer.toString(mainvp.hashCode()));
            return riapp.refImage.getCapable(capIFname);
        }
        return null;
    }

    private XpReferenceImageApp(XpViewport mainvp, boolean selected, boolean force) {
        this.mvp = mainvp;
        this.force = force;
        this.refImage = new XpReferenceImageDirector(mainvp, selected);
        this.mvp.addPropertyChangeListener("CONTENT_CHANGED", this.mvpListsner);
        this.mvp.addPropertyChangeListener("RowColumnProperty", this.formatListener);
    }

    public void setSession(DMSession sess) {
        this.session = sess;
    }

    public void setMode(boolean selected) {
        this.refImage.updateMode(selected);
    }

    public boolean getMode() {
        return this.refImage.getCurrentMode();
    }

    public void setReferenceSeries(DMObject refseries, int imNum) {
        if (refseries != null) {
            int numImgs = refseries.getNumberOfRelated("image");
            if (numImgs == 0) {
                logger.log(Level.WARNING, "Series does not contain images.");
                return;
            }
            if (numImgs > CvUtils.getLargeSeriesSize()) {
                logger.log(Level.WARNING, "Reference Image not supported for reference Series > " + CvUtils.getLargeSeriesSize());
                return;
            }
            DMObject[] imgs = refseries.getRelated("image");
            if (imgs == null || imgs.length == 0) {
                logger.log(Level.WARNING, "Series does not contain images.");
                return;
            }
            XpMedicalImage[] imgList = CvUtils.getXpImages(imgs);
            if (imgList != null) {
                Arrays.sort(imgList, new DefaultImComparator());
                this.refImage.setReferenceImageList(imgList);
                int index = Arrays.binarySearch(imgList, new Integer(imNum), new DefaultImComparator());
                if (index < 0) {
                    index = 0;
                }
                this.refImage.setReferenceFrameIndex(index);
                this.refImage.postReferenceImage(this.force);
                this.mvp.repaint();
            } else {
                logger.log(Level.WARNING, "Series does not contain images.");
            }
        } else {
            logger.log(Level.WARNING, "Not a valid reference series");
        }
    }

    public DMObject getReferenceSeries() {
        return this.refSeries;
    }

    public void removeRefImage(boolean selected) {
        this.refImage.disconnectViewport(selected);
        if (this.refImage.getReferencePortCount() == 0) {
            refImageList.remove(Integer.toString(this.mvp.hashCode()));
            this.mvp.removePropertyChangeListener("CONTENT_CHANGED", this.mvpListsner);
            this.mvp.removePropertyChangeListener("RowColumnProperty", this.formatListener);
        }
        this.mvp.repaint();
    }

    public int getRefPortCount() {
        XpReferenceImageApp riapp = (XpReferenceImageApp)refImageList.get(Integer.toString(this.mvp.hashCode()));
        return riapp.refImage.getReferencePortCount();
    }

    public CvCrossRefUtils.CrossRefResult fetchValidReferenceSeries() {
        TransactionLogName tln = new TransactionLogName("TID=CV_fetchValidRefSeries");
        CvCrossRefUtils.CrossRefResult result = new CvCrossRefUtils.CrossRefResult();
        result.status = 7;
        if (this.session == null) {
            logger.log(Level.WARNING, "DMSession not set.");
            return result;
        }
        DMImage img = null;
        if (this.mvp instanceof FrameOwner && this.mvp.getImages() != null && this.mvp.getImages().length != 0) {
            int sel;
            JComponent port;
            if (this.mvp instanceof SelectionCapable && (port = ((SelectionCapable)((Object)this.mvp)).getViewportComponent(sel = ((SelectionCapable)((Object)this.mvp)).getComponentSelection())) instanceof FrameOwner) {
                img = ((XpMedicalDmImage)((FrameOwner)((Object)port)).getFrame()).getDMImage();
            }
            if (!this.getMode()) {
                if (img == null) {
                    img = ((XpMedicalDmImage)((FrameOwner)((Object)this.mvp)).getFrame()).getDMImage();
                }
                if (img == null) {
                    img = ((XpMedicalDmImage)this.mvp.getImages()[0]).getDMImage();
                }
            }
            if (img == null) {
                logger.log(Level.WARNING, "No images loaded in the main viewport.");
                return result;
            }
        } else {
            logger.log(Level.WARNING, "Main viewport not instance of FrameOwner.");
            return result;
        }
        logger.log(Level.INFO, "{0} begin", tln);
        result = CvCrossRefUtils.fetchValidReferenceSeries(this.session, img);
        if (result != null && result.refSeries != null) {
            this.refSeries = result.refSeries;
            int numImgs = this.refSeries.getNumberOfRelated("image");
            if (numImgs == 0) {
                logger.log(Level.WARNING, "Series does not contain images.");
                result.status = 7;
                return result;
            }
            if (numImgs > CvUtils.getLargeSeriesSize()) {
                logger.log(Level.WARNING, "Reference Image not supported for reference Series > " + CvUtils.getLargeSeriesSize());
                result.status = 9;
                return result;
            }
            int refNo = -1;
            DMObject[] imgs = this.refSeries.getRelated("image");
            if (imgs == null || imgs.length == 0) {
                logger.log(Level.WARNING, "Series does not contain images.");
                result.status = 7;
                return result;
            }
            XpMedicalImage[] imgList = CvUtils.getXpImages(imgs);
            if (imgList != null) {
                Arrays.sort(imgList, new DefaultImComparator());
                this.refImage.setReferenceImageList(imgList);
                if (result.refImage != null) {
                    Object val = result.refImage.getValue(new DMTag(32, 19));
                    if (val != null) {
                        if (val instanceof Integer) {
                            refNo = (Integer)val;
                        } else if (val instanceof String) {
                            try {
                                refNo = Integer.parseInt((String)val);
                            }
                            catch (Exception ex) {}
                        }
                    }
                } else {
                    logger.log(Level.WARNING, "Series does not contain images.");
                }
                int index = Arrays.binarySearch(imgList, new Integer(refNo), new DefaultImComparator());
                if (index < 0) {
                    index = 0;
                }
                this.refImage.setReferenceFrameIndex(index);
                this.refImage.postReferenceImage(this.force);
                this.mvp.repaint();
            }
        } else {
            Object serid = img.getValue(new DMTag(32, 17));
            String examid = (String)img.getValue(new DMTag(32, 16));
            logger.log(Level.WARNING, "No valid reference series found for E" + examid + "/S" + serid);
        }
        logger.log(Level.INFO, "{0} end", tln);
        return result;
    }

    public int setReferenceSeriesByNumber(int serNum, int imNum) {
        if (this.session == null) {
            return 7;
        }
        if (this.mvp instanceof FrameOwner && this.mvp.getImages() != null && this.mvp.getImages().length != 0) {
            int sel;
            JComponent port;
            DMImage img = null;
            if (this.mvp instanceof SelectionCapable && (port = ((SelectionCapable)((Object)this.mvp)).getViewportComponent(sel = ((SelectionCapable)((Object)this.mvp)).getComponentSelection())) instanceof FrameOwner) {
                img = ((XpMedicalDmImage)((FrameOwner)((Object)port)).getFrame()).getDMImage();
            }
            if (!this.getMode()) {
                if (img == null) {
                    img = ((XpMedicalDmImage)((FrameOwner)((Object)this.mvp)).getFrame()).getDMImage();
                }
                if (img == null) {
                    img = ((XpMedicalDmImage)this.mvp.getImages()[0]).getDMImage();
                }
            }
            if (img == null) {
                logger.log(Level.WARNING, "No images loaded in the main viewport.");
                return 7;
            }
            String serid = (String)img.getValue(new DMTag(32, 17));
            if (Integer.parseInt(serid) == serNum) {
                logger.log(Level.WARNING, "Cannot cross reference with same series.");
                logger.log(UserMessageLevel.USER_MSG, CvUtils.getResourceBundle().getString("XR_INVALID_SERIES"));
                return 2;
            }
            String examid = (String)img.getValue(new DMTag(32, 16));
            String examuid = (String)img.getValue(new DMTag(32, 13));
            String query = "(0x0020, 0x000D) = " + examuid;
            if (examid != null && examid.trim().length() > 0) {
                query = query + " AND (0x0020, 0x0010) = " + examid;
            }
            query = query + " AND (0x0020, 0x0011) = " + serNum;
            DMObject[] ser = this.session.getRelated("series", new DMQuery(query));
            CvCrossRefUtils.CrossRefResult result = null;
            int status = -1;
            DMObject refSer = null;
            DMObject refImg = null;
            if (ser != null && ser.length > 0) {
                for (int i2 = 0; i2 < ser.length; ++i2) {
                    result = CvCrossRefUtils.isSeriesValidForCrossReference(ser[i2], img);
                    status = result.status;
                    if (result == null || result.status != -1) continue;
                    refSer = ser[i2];
                    refImg = result.refImage;
                    break;
                }
            } else {
                result = new CvCrossRefUtils.CrossRefResult();
                status = result.status = 7;
            }
            if (refSer != null) {
                Object val;
                this.refSeries = refSer;
                int numImgs = this.refSeries.getNumberOfRelated("image");
                if (numImgs == 0) {
                    logger.log(Level.WARNING, "Series does not contain images.");
                    return 7;
                }
                if (numImgs > CvUtils.getLargeSeriesSize()) {
                    logger.log(Level.WARNING, "Reference Image not supported for reference Series > " + CvUtils.getLargeSeriesSize());
                    return 9;
                }
                DMObject[] imgs = this.refSeries.getRelated("image");
                if (imgs == null || imgs.length == 0) {
                    logger.log(Level.WARNING, "Series " + serid + " does not contain images");
                    return 0;
                }
                XpMedicalImage[] imgList = CvUtils.getXpImages(imgs);
                if (imgList != null) {
                    Arrays.sort(imgList, new DefaultImComparator());
                    this.refImage.setReferenceImageList(imgList);
                } else {
                    logger.log(Level.WARNING, "Series " + serid + " does not contain images");
                }
                if (imNum < 0 && refImg != null && (val = refImg.getValue(new DMTag(32, 19))) != null) {
                    int refNo = 0;
                    if (val instanceof Integer) {
                        refNo = (Integer)val;
                    } else if (val instanceof String) {
                        try {
                            refNo = Integer.parseInt((String)val);
                        }
                        catch (Exception ex) {
                            // empty catch block
                        }
                    }
                    if (refNo != 0) {
                        imNum = refNo;
                    }
                }
                if (imgList != null) {
                    int index = Arrays.binarySearch(imgList, new Integer(imNum), new DefaultImComparator());
                    if (index < 0) {
                        index = 0;
                    }
                    this.refImage.setReferenceFrameIndex(index);
                    this.refImage.postReferenceImage(this.force);
                    this.mvp.repaint();
                } else {
                    logger.log(Level.WARNING, "Series " + serid + " does not contain images");
                }
            } else {
                logger.log(Level.WARNING, "Series " + serid + " is not a valid reference series");
            }
            return status;
        }
        return 7;
    }
}

