/*
 * Decompiled with CFR 0.152.
 */
package com.ge.med.cse.cvf.dataloader;

import com.ge.med.cse.cvf.dataloader.DatasetValidator;
import com.ge.med.cse.cvf.j3d.utils.J3DGeomUtils;
import com.ge.med.cse.cvf.util.CvPropertiesManager;
import com.ge.med.cse.cvf.util.DicomUtils;
import com.ge.med.terra.tap.dm.DMTag;
import com.ge.med.terra.tap.dm.DMTagValueInterface;
import java.util.Arrays;
import java.util.List;

public class DefaultVolumeDataSetValidator
implements DatasetValidator {
    public static final String UNSUPPORTED_MODALITY = "INVALID_MODALITY";
    public static final String UNSUPPORTED_MODALITY_IMAGETYPE = "INVALID_IMAGETYPE";
    public static final String UNSUPPORTED_PHOTOMETRIC_PRESENTATION = "INVALID_PHOTOMETRIC_INTERPRETATION";
    public static final String UNSUPPORTED_SIZE = "EXCEEEDS_SIZE";

    @Override
    public String validateImages(DMTagValueInterface[] imgs) {
        try {
            int bytes;
            int numberofImages;
            int col;
            int row;
            long requestedsize;
            if (imgs == null || imgs.length <= 1) {
                return "INVALID_FOR_VOLUME";
            }
            String[] volumeModalities = CvPropertiesManager.getProperty("cvf.j3d.modalities", "ct,mr").split(",");
            for (int i2 = 0; i2 < volumeModalities.length; ++i2) {
                volumeModalities[i2] = volumeModalities[i2].toUpperCase();
            }
            String currentModality = ((String)imgs[0].getValue(new DMTag(8, 96))).toUpperCase();
            List<String> supporteList = Arrays.asList(volumeModalities);
            if (!supporteList.contains(currentModality)) {
                return UNSUPPORTED_MODALITY;
            }
            String imgType = DicomUtils.getImageType(imgs[0], false);
            String[] unsupportedImgType = CvPropertiesManager.getProperty("cvf.j3d.unsupported_imagetypes", "SCOUT,SSAVE,3DMOD,GSPS,SR,UNKNOWN").split(",");
            List<String> unsupportedList = Arrays.asList(unsupportedImgType);
            if (unsupportedList.contains(imgType)) {
                return UNSUPPORTED_MODALITY_IMAGETYPE;
            }
            String photoInterpretation = (String)imgs[0].getValue(new DMTag(40, 4));
            if (!"MONOCHROME2".equals(photoInterpretation.trim())) {
                return UNSUPPORTED_PHOTOMETRIC_PRESENTATION;
            }
            long allowedSize = Long.parseLong(CvPropertiesManager.getProperty("cvf.j3d.maxdatasize", "0"));
            if (allowedSize > 0L && (requestedsize = (long)((row = Integer.parseInt(imgs[0].getValue(new DMTag(40, 16)).toString())) * (col = Integer.parseInt(imgs[0].getValue(new DMTag(40, 17)).toString())) * (numberofImages = imgs.length) * (bytes = Integer.parseInt(imgs[0].getValue(new DMTag(40, 256)).toString()) / 8))) > allowedSize) {
                return UNSUPPORTED_SIZE;
            }
            int code = J3DGeomUtils.validateInputVolume(imgs);
            String status = J3DGeomUtils.getErrorString(code);
            return status;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return J3DGeomUtils.getErrorString(-1);
        }
    }
}

