/*
 * Decompiled with CFR 0.152.
 */
package com.ge.med.cse.cvf.dataloader.adv;

import com.ge.med.cse.cvf.dataloader.DatasetLoader;
import com.ge.med.cse.cvf.dataloader.DatasetLoaderUtils;
import com.ge.med.cse.cvf.dataloader.DatasetModel;
import com.ge.med.idc.TaskMonitor;
import com.ge.med.idc.XjImage;
import com.ge.med.terra.jami.XpCompositePort;
import com.ge.med.terra.tap.dm.DMComposite;
import com.ge.med.terra.tap.dm.DMImage;
import com.ge.med.terra.tap.dm.DMObject;
import com.ge.med.terra.tap.dm.DMTag;
import com.ge.med.terra.tap.dm.DMTagValueInterface;
import java.util.Properties;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;

public class XpBlankImageLoader
implements DatasetLoader {
    @Override
    public void load(JComponent viewport, DatasetModel model, Properties prop, TaskMonitor monitor) {
        block4: {
            try {
                if (viewport instanceof XpCompositePort && model.getDataset().getData() instanceof DMObject) {
                    XpCompositePort compPort = (XpCompositePort)viewport;
                    DMObject dmo = (DMObject)model.getDataset().getData();
                    int totalImages = dmo.getNumberOfRelated("image");
                    String str = model.getDataset().getDataSetValidator().validateImages(dmo.getRelated("image"));
                    this.loadImages(compPort, totalImages, str, monitor);
                    break block4;
                }
                if (viewport instanceof XpCompositePort && model.getDataset().getData() instanceof DMComposite) {
                    XpCompositePort compPort = (XpCompositePort)viewport;
                    DMComposite dmo = (DMComposite)model.getDataset().getData();
                    DMTag[] tags = DatasetLoaderUtils.getNeededTags(dmo);
                    DMImage[] dmImg = dmo.getImages(tags);
                    int totalImages = dmImg.length;
                    String str = model.getDataset().getDataSetValidator().validateImages(new DMTagValueInterface[]{dmo});
                    this.loadImages(compPort, totalImages, str, monitor);
                    break block4;
                }
                throw new IllegalArgumentException("Invalid dataset or viewport");
            }
            catch (Exception ex) {
                ex.printStackTrace();
                if (ex instanceof InterruptedException) break block4;
                monitor.taskFailed("DATA_LOADING_TASK_2D_SINGLE_IMAGE", "DATA_LOADING_EXCEPTION", ex);
            }
        }
    }

    private void loadImages(final XpCompositePort compPort, final int totalImages, String str, TaskMonitor monitor) {
        if ("SUPPORTED_MODALITY".equalsIgnoreCase(str.trim())) {
            if (SwingUtilities.isEventDispatchThread()) {
                compPort.setImages(new XjImage[totalImages]);
            } else {
                Runnable runnable = new Runnable(){

                    @Override
                    public void run() {
                        compPort.setImages(new XjImage[totalImages]);
                    }
                };
                try {
                    SwingUtilities.invokeAndWait(runnable);
                }
                catch (Exception e2) {
                    e2.printStackTrace();
                    SwingUtilities.invokeLater(runnable);
                }
            }
        } else {
            monitor.taskFailed("DATA_LOADING_TASK_2D_SINGLE_IMAGE", "INVALID_MODALITY", null);
        }
    }
}

