/*
 * Decompiled with CFR 0.152.
 */
package com.ge.med.cse.cvf.j3d;

import com.ge.med.idc.T3DCapable;
import com.ge.med.idc.XjChangeListener;
import com.ge.med.jnu.JnVector3d;
import com.ge.med.terra.jami.CPoint;
import com.ge.med.terra.jami.XpViewport;
import com.ge.med.terra.jami.XpViewportDirector;
import com.ge.med.terra.jami.j3d.Cursor3DModel;
import com.ge.med.terra.jami.j3d.Cursor3DVc;
import com.ge.med.terra.jami.j3d.DefaultCursor3DModel;
import com.ge.med.terra.jami.j3d.T3DViewport;
import java.awt.Color;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.EventObject;
import javax.swing.JPopupMenu;
import javax.swing.JTextArea;

public class J3DLinkedCursorDirector
implements XpViewportDirector,
PropertyChangeListener {
    private ArrayList<T3DViewport> portList = new ArrayList();
    private ArrayList<Cursor3DVc> cursorList = new ArrayList();
    private DefaultCursor3DModel model = new DefaultCursor3DModel();
    private Cursor3DListener cursorListener = new Cursor3DListener();
    boolean isVisble = false;
    boolean attached = false;

    @Override
    public void connectViewport(XpViewport viewport) {
        if (viewport == null || !(viewport instanceof T3DViewport) || this.portList.contains(viewport)) {
            return;
        }
        T3DViewport t3dvp = (T3DViewport)viewport;
        this.portList.add(t3dvp);
        this.cursorList.add(null);
        this.initPort(t3dvp);
        t3dvp.addPropertyChangeListener("VOLUME_PROPERTY", this);
        t3dvp.addPropertyChangeListener("lookPoint", this.cursorListener);
        t3dvp.addPropertyChangeListener("eyePoint", this.cursorListener);
        if (this.portList.size() > 0 && !this.attached) {
            this.attached = true;
            this.portList.get(0).addPropertyChangeListener("Cine", this);
        }
    }

    @Override
    public void disconnectAllViewports() {
        for (int index = 0; index < this.portList.size(); ++index) {
            if (index >= 0 && index < this.cursorList.size() && this.cursorList.get(index) != null) {
                this.portList.get(index).getT3DComponent().remove(this.cursorList.get(index));
                this.cursorList.get(index).removeMouseListener(this.cursorListener);
            }
            this.portList.get(index).removePropertyChangeListener("Cine", this);
            this.portList.get(index).removePropertyChangeListener("lookPoint", this.cursorListener);
            this.portList.get(index).removePropertyChangeListener("eyePoint", this.cursorListener);
            this.portList.get(index).removePropertyChangeListener("VOLUME_PROPERTY", this);
            this.attached = false;
        }
        this.model.removeChangeListener(this.cursorListener);
        this.cursorList.clear();
        this.portList.clear();
    }

    @Override
    public void disconnectViewport(XpViewport viewport) {
        if (viewport == null || !this.portList.contains(viewport)) {
            return;
        }
        int index = this.portList.indexOf(viewport);
        if (index >= 0 && index < this.cursorList.size()) {
            if (this.cursorList.get(index) != null) {
                this.portList.get(index).getT3DComponent().remove(this.cursorList.get(index));
                this.cursorList.get(index).removeMouseListener(this.cursorListener);
            }
            this.cursorList.remove(index);
        }
        this.portList.remove(index);
        viewport.removePropertyChangeListener("Cine", this);
        viewport.removePropertyChangeListener("lookPoint", this.cursorListener);
        viewport.removePropertyChangeListener("eyePoint", this.cursorListener);
        viewport.removePropertyChangeListener("VOLUME_PROPERTY", this);
        if (this.portList.size() == 0) {
            this.model.removeChangeListener(this.cursorListener);
            this.attached = false;
        }
    }

    private void initPort(T3DViewport port) {
        if (port.getVolumeModel() == null) {
            return;
        }
        this.model.setBoundsCheckEnabled(true);
        this.model.setT3D(port);
        this.model.removeChangeListener(this.cursorListener);
        double[] lookpt = this.portList.get(0).getLookPoint(null);
        this.model.setPoint(new CPoint(lookpt, 2));
        this.model.addChangeListener(this.cursorListener);
        int index = this.portList.indexOf(port);
        if (index >= 0 && index < this.cursorList.size() && this.cursorList.get(index) == null) {
            Cursor3DVc cursor = new Cursor3DVc(this.model, port);
            cursor.setCheckingWorldBounds(true);
            cursor.setContinuousUpdateEnabled(true);
            cursor.setAutoPage(false);
            cursor.setCursorShape(Cursor3DVc.X_SHAPE);
            cursor.setCursorColor(Color.RED);
            cursor.addMouseListener(this.cursorListener);
            port.getT3DComponent().add(cursor);
            this.cursorList.add(index, cursor);
            port.updateUI();
        }
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        int size;
        if (evt.getPropertyName().equals("VOLUME_PROPERTY") && evt.getSource() instanceof T3DViewport) {
            int idx = this.portList.indexOf((T3DViewport)evt.getSource());
            if (idx >= 0 && idx < this.cursorList.size() && this.cursorList.get(idx) == null) {
                this.initPort((T3DViewport)evt.getSource());
                ((T3DViewport)evt.getSource()).removePropertyChangeListener("VOLUME_PROPERTY", this);
            }
        } else if (evt.getPropertyName().equals("Cine") && (size = this.cursorList.size()) == 0) {
            return;
        }
    }

    private class Cursor3DListener
    extends MouseAdapter
    implements PropertyChangeListener,
    XjChangeListener {
        double[] eyePoint = new double[3];
        double[] lookPoint = new double[3];
        double[] upVector = new double[3];
        JnVector3d lookVector = new JnVector3d();
        JnVector3d cursorVector = new JnVector3d();
        double dot;
        JTextArea text = new JTextArea();
        JPopupMenu popup = new JPopupMenu();
        private final DecimalFormat df = new DecimalFormat("##0.0");
        private boolean isValueAdjusting = false;
        private CPoint vect = new CPoint(2);

        private synchronized void syncPorts(CPoint cursor) {
            this.isValueAdjusting = true;
            int numPorts = J3DLinkedCursorDirector.this.portList.size();
            for (int i2 = 0; i2 < numPorts; ++i2) {
                T3DViewport port = (T3DViewport)J3DLinkedCursorDirector.this.portList.get(i2);
                String rstyle = port.getRenderStyle();
                if ("VOLUME".equals(rstyle) || "FULLBODY_MIP".equals(rstyle) || "FULLBODY_MINIP".equals(rstyle) || "FULLBODY_AVERAGE".equals(rstyle) || i2 < J3DLinkedCursorDirector.this.cursorList.size() && J3DLinkedCursorDirector.this.cursorList.get(i2) != null && ((Cursor3DVc)J3DLinkedCursorDirector.this.cursorList.get(i2)).isDriving()) continue;
                port.getEyePoint(this.eyePoint);
                port.getLookPoint(this.lookPoint);
                this.lookVector.set(this.eyePoint[0] - this.lookPoint[0], this.eyePoint[1] - this.lookPoint[1], this.eyePoint[2] - this.lookPoint[2]);
                this.cursorVector.set(cursor.x - this.lookPoint[0], cursor.y - this.lookPoint[1], cursor.z - this.lookPoint[2]);
                this.lookVector.normalize();
                this.dot = this.cursorVector.dot(this.lookVector);
                this.lookVector.scale(this.dot);
                this.eyePoint[0] = this.eyePoint[0] + this.lookVector.x;
                this.eyePoint[1] = this.eyePoint[1] + this.lookVector.y;
                this.eyePoint[2] = this.eyePoint[2] + this.lookVector.z;
                this.lookPoint[0] = this.lookPoint[0] + this.lookVector.x;
                this.lookPoint[1] = this.lookPoint[1] + this.lookVector.y;
                this.lookPoint[2] = this.lookPoint[2] + this.lookVector.z;
                port.setCamera(this.eyePoint, this.lookPoint, port.getUp(this.upVector));
                port.refreshContents();
            }
            this.isValueAdjusting = false;
        }

        private synchronized boolean isValueAdjusting() {
            return this.isValueAdjusting;
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            if (this.isValueAdjusting()) {
                return;
            }
            if ("lookPoint".equals(evt.getPropertyName()) || "eyePoint".equals(evt.getPropertyName())) {
                T3DCapable port = (T3DCapable)evt.getSource();
                port.getEyePoint(this.eyePoint);
                port.getLookPoint(this.lookPoint);
                this.vect.set(J3DLinkedCursorDirector.this.model.getPoint(null));
                this.lookVector.set(this.eyePoint[0] - this.lookPoint[0], this.eyePoint[1] - this.lookPoint[1], this.eyePoint[2] - this.lookPoint[2]);
                this.cursorVector.set(this.vect.x - this.lookPoint[0], this.vect.y - this.lookPoint[1], this.vect.z - this.lookPoint[2]);
                this.lookVector.normalize();
                this.dot = this.cursorVector.dot(this.lookVector);
                if (Math.abs(this.dot) > 1.0E-4) {
                    this.lookVector.scale(this.dot);
                    this.vect.sub(this.lookVector);
                    J3DLinkedCursorDirector.this.model.setPoint(this.vect);
                }
            }
        }

        @Override
        public void mousePressed(MouseEvent e2) {
        }

        @Override
        public synchronized void stateChanged(EventObject e2) {
            Cursor3DModel model = (Cursor3DModel)e2.getSource();
            this.syncPorts(model.getPoint(null));
        }
    }
}

