/*
 * Decompiled with CFR 0.152.
 */
package com.ge.med.cse.cvf.j3d;

import com.ge.med.cse.cvf.j3d.ViewCalculator;
import com.ge.med.idc.T3DCapable;
import com.ge.med.idc.XjVolumeGeometry;
import com.ge.med.jnu.JnMatrix4d;
import com.ge.med.jnu.JnVector3d;

public class J3DRotateViewCalculator
extends ViewCalculator {
    private double angle = 15.0;
    private JnMatrix4d m = new JnMatrix4d();

    public J3DRotateViewCalculator() {
    }

    public J3DRotateViewCalculator(T3DCapable capable) {
        super(capable);
        this.setAngle(15.0);
        this.setRotateRight();
    }

    public J3DRotateViewCalculator(T3DCapable capable, XjVolumeGeometry vol) {
        super(capable, vol);
        this.setAngle(15.0);
        this.setRotateRight();
    }

    private void setAngle(double ang) {
        this.angle = ang;
        this.numViews = (int)(360.0 / this.angle);
    }

    @Override
    protected void reset() {
        super.reset();
        this.angle = 15.0;
        this.setRotateRight();
    }

    @Override
    protected void updateContent() {
        if (!this.volumeLoaded) {
            return;
        }
        this.numViews = (int)(360.0 / this.angle);
        this.pcs.firePropertyChange("FrameIndex", -1, this.curpos);
    }

    @Override
    public void getView(int i2, double[] eyept, double[] lookpt, double[] up) {
        if (this.curpos == i2) {
            this.t3dCapable.getEyePoint(eyept);
            this.t3dCapable.getLookPoint(lookpt);
            this.t3dCapable.getUp(up);
            return;
        }
        this.t3dCapable.getUp(up);
        this.t3dCapable.getEyePoint(eyept);
        this.t3dCapable.getLookPoint(lookpt);
        double[] viewvec = new double[3];
        JnVector3d.sub(lookpt, eyept, viewvec);
        this.m.transform(up);
        this.m.transform(viewvec);
        eyept[0] = lookpt[0] - viewvec[0];
        eyept[1] = lookpt[1] - viewvec[1];
        eyept[2] = lookpt[2] - viewvec[2];
    }

    @Override
    public int getViewIndex(double[] eyept, double[] lookpt, double[] up) {
        int viewIndex = 0;
        double[] tmpv = new double[3];
        JnVector3d.sub(lookpt, eyept, tmpv);
        JnVector3d.normalize(tmpv);
        double dotP = 0.0;
        if (Math.abs(dotP - 1.0) > 1.0E-5) {
            return -1;
        }
        return viewIndex;
    }

    private void setRotate(String s2, double angle) {
        double[] upvector = new double[3];
        double[] lookpt = new double[3];
        double[] eyept = new double[3];
        double[] viewvector = new double[3];
        double[] leftvector = new double[3];
        lookpt = this.t3dCapable.getLookPoint(null);
        eyept = this.t3dCapable.getEyePoint(null);
        upvector = this.t3dCapable.getUp(null);
        viewvector[0] = lookpt[0] - eyept[0];
        viewvector[1] = lookpt[1] - eyept[1];
        viewvector[2] = lookpt[2] - eyept[2];
        JnVector3d up = new JnVector3d(upvector);
        JnVector3d view = new JnVector3d(viewvector);
        leftvector = JnVector3d.cross(up, view).toArray();
        if (s2.equals("HORIZONTAL")) {
            this.m.setRotate(Math.toRadians(angle), upvector[0], upvector[1], upvector[2]);
        } else if (s2.equals("VERTICAL")) {
            this.m.setRotate(Math.toRadians(angle), leftvector[0], leftvector[1], leftvector[2]);
        }
    }

    public void setRotateLeft() {
        this.setRotate("HORIZONTAL", this.angle);
    }

    public void setRotateRight() {
        this.setRotate("HORIZONTAL", -this.angle);
    }

    public void setRotateDown() {
        this.setRotate("VERTICAL", this.angle);
    }

    public void setRotateUp() {
        this.setRotate("VERTICAL", -this.angle);
    }
}

