/*
 * Decompiled with CFR 0.152.
 */
package com.ge.med.cse.cvf.j3d;

import com.ge.med.terra.jami.CPoint;
import com.ge.med.terra.jami.CTransform;
import com.ge.med.terra.jami.XpImage;
import com.ge.med.terra.jami.XpLog;
import com.ge.med.terra.jami.XpVisualComponent;
import com.ge.med.terra.jami.capable.Replicable;
import com.ge.med.terra.jami.j3d.T3DComponent;
import java.awt.Color;
import java.awt.Container;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.text.DecimalFormat;

public class J3DTickMarkRuler
extends XpVisualComponent
implements Replicable {
    public static final int VERTICAL = 0;
    public static final int HORIZONTAL = 1;
    private int orientation;
    private XpImage prevImage;
    private Rectangle r;
    private DecimalFormat df;
    private int tickFreq = 5;
    private int tickLength = 5;
    private double tickSpacing = 10.0;
    private int margin = 30;
    private CTransform rasDispTrans = null;
    private CTransform dispRasTrans = null;
    private CPoint borderPt = new CPoint(1);
    private CPoint borderPt1 = new CPoint(1);
    private CPoint centerImagePoint = new CPoint(2);
    private CPoint oneImageTick = new CPoint(2);
    private CPoint centerPoint = new CPoint(1);
    private CPoint oneTick = new CPoint(1);

    public J3DTickMarkRuler(int orientation) {
        this.orientation = orientation;
        this.prevImage = null;
        this.r = new Rectangle();
        this.df = new DecimalFormat("###0.##");
        this.setForeground(Color.orange);
    }

    @Override
    public Object clone() {
        J3DTickMarkRuler ccr = new J3DTickMarkRuler(this.orientation);
        this.copyObject(ccr);
        return ccr;
    }

    protected void copyObject(Object o2) {
        J3DTickMarkRuler is = (J3DTickMarkRuler)o2;
        is.orientation = this.orientation;
        is.r = (Rectangle)this.r.clone();
        is.df = new DecimalFormat("###0.##");
    }

    public J3DTickMarkRuler(int orientation, int atickFreq, int atickLength, int atickSpacing, int amargin) {
        this.orientation = 1;
        this.prevImage = null;
        this.r = new Rectangle();
        this.df = new DecimalFormat("###0.##");
        this.setForeground(Color.orange);
        this.tickFreq = atickFreq;
        this.tickLength = atickLength;
        this.tickSpacing = atickSpacing;
        this.margin = amargin;
        this.orientation = orientation;
    }

    @Override
    public final boolean contains(int x2, int y2) {
        return this.r.contains(x2, y2);
    }

    protected final void line(Graphics g2, int x1, int y1, int x2, int y2) {
        g2.setColor(Color.black);
        g2.drawLine(x1 + 1, y1 + 1, x2 + 1, y2 + 1);
        Color foreground = this.getForeground();
        g2.setColor(foreground);
        g2.drawLine(x1, y1, x2, y2);
    }

    @Override
    public void paintComponent(Graphics g2) {
        Rectangle vp = this.getBounds();
        boolean updateInfo = false;
        Container c2 = this.getParent();
        if (c2 instanceof T3DComponent) {
            T3DComponent vc = (T3DComponent)c2;
            this.dispRasTrans = vc.getTransform((byte)1, (byte)2);
            this.rasDispTrans = vc.getTransform((byte)2, (byte)1);
            XpImage img = vc.getFrame();
            if (this.prevImage != img) {
                updateInfo = true;
                this.prevImage = img;
            }
        } else {
            XpLog.logger().warning("Parent container is not a T3DComponent");
        }
        if (this.orientation == 0) {
            CPoint disp_Origin = new CPoint(0, 0, 0, 1);
            CPoint disp_Y = new CPoint(0, 1, 0, 1);
            CPoint ras_Origin = new CPoint();
            CPoint ras_Y = new CPoint();
            this.dispRasTrans.transform(disp_Origin, ras_Origin);
            this.dispRasTrans.transform(disp_Y, ras_Y);
            ras_Y.sub(ras_Origin);
            ras_Y.normalize();
            ras_Y.scale(this.tickSpacing);
            this.centerImagePoint.setLocation(0.0, 0.0, 0.0);
            this.oneImageTick.setLocation(ras_Y.x, ras_Y.y, ras_Y.z);
            this.rasDispTrans.transform(this.centerImagePoint, this.centerPoint);
            this.rasDispTrans.transform(this.oneImageTick, this.oneTick);
            double cmHeight = this.centerPoint.distance(this.oneTick);
            cmHeight = Math.abs(cmHeight);
            double maxHeight = (double)vp.height / 3.0;
            int nbOfCm = cmHeight > 0.0 ? (int)(maxHeight / cmHeight) : 1;
            double x2 = vp.width - this.margin;
            double ymargin = ((double)vp.height - (double)nbOfCm * cmHeight) / 2.0;
            int i2 = 0;
            double y1 = 0.0;
            double y2 = 0.0;
            for (i2 = 0; i2 < nbOfCm; ++i2) {
                y1 = (double)i2 * cmHeight + ymargin;
                y2 = y1 + cmHeight;
                if (i2 == 0) {
                    this.borderPt.setLocation(x2, y1, 0.0);
                }
                this.line(g2, (int)x2 - this.getTickLength(i2), (int)y1, (int)x2, (int)y1);
                if (i2 == nbOfCm - 1) {
                    this.borderPt1.setLocation(x2, y2, 0.0);
                }
                this.line(g2, (int)x2, (int)y2, (int)x2 - this.getTickLength(i2 + 1), (int)y2);
            }
            this.line(g2, (int)this.borderPt.x, (int)this.borderPt.y, (int)this.borderPt1.x, (int)this.borderPt1.y);
        } else if (this.orientation == 1) {
            CPoint disp_Origin = new CPoint(0, 0, 0, 1);
            CPoint disp_X = new CPoint(1, 0, 0, 1);
            CPoint ras_Origin = new CPoint();
            CPoint ras_X = new CPoint();
            this.dispRasTrans.transform(disp_Origin, ras_Origin);
            this.dispRasTrans.transform(disp_X, ras_X);
            ras_X.sub(ras_Origin);
            ras_X.normalize();
            ras_X.scale(this.tickSpacing);
            this.centerImagePoint.setLocation(0.0, 0.0, 0.0);
            this.oneImageTick.setLocation(ras_X.x, ras_X.y, ras_X.z);
            this.rasDispTrans.transform(this.centerImagePoint, this.centerPoint);
            this.rasDispTrans.transform(this.oneImageTick, this.oneTick);
            double maxWidth = (double)vp.width / 2.0;
            double cmWidth = this.oneTick.distance(this.centerPoint);
            cmWidth = Math.abs(cmWidth);
            int nbOfCm = cmWidth > 0.0 ? (int)(maxWidth / cmWidth) : 1;
            double xmargin = ((double)vp.width - (double)nbOfCm * cmWidth) / 2.0;
            int i3 = 0;
            double y2 = vp.height - this.margin;
            for (i3 = 0; i3 < nbOfCm; ++i3) {
                double x1 = (double)i3 * cmWidth + xmargin;
                double x2 = x1 + cmWidth;
                if (i3 == 0) {
                    this.borderPt.setLocation(x1, y2, 0.0);
                }
                this.line(g2, (int)x1, (int)(y2 - (double)this.getTickLength(i3)), (int)x1, (int)y2);
                if (i3 == nbOfCm - 1) {
                    this.borderPt1.setLocation(x2, y2, 0.0);
                }
                this.line(g2, (int)x2, (int)y2, (int)x2, (int)y2 - this.getTickLength(i3 + 1));
            }
            this.line(g2, (int)this.borderPt.x, (int)this.borderPt.y, (int)this.borderPt1.x, (int)this.borderPt1.y);
        }
    }

    public int getTickLength(int i2) {
        if (i2 % this.tickFreq == 0) {
            return this.tickLength << 1;
        }
        return this.tickLength;
    }

    public int getOrientation() {
        return this.orientation;
    }

    public void setOrientation(int orientation) {
        this.orientation = orientation;
    }
}

