/*
 * Decompiled with CFR 0.152.
 */
package com.ge.med.cse.cvf.j3d.action;

import com.ge.med.cse.cvf.base.BaseAction;
import com.ge.med.cse.cvf.log.UserMessageLevel;
import com.ge.med.cse.cvf.util.CvUtils;
import com.ge.med.terra.jami.CPoint;
import com.ge.med.terra.jami.XpViewport;
import com.ge.med.terra.jami.j3d.Cursor3DVc;
import com.ge.med.terra.jami.j3d.T3DViewport;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.logging.Level;

public class J3DCenterOnCursorAction
extends BaseAction {
    @Override
    protected String getName() {
        return "J3D_CENTER_ON_CURSOR";
    }

    @Override
    public void actionPerformed(ActionEvent e2) {
        String[] params = this.getParams();
        try {
            if (params != null && params.length > 0) {
                this.getLogger().log(Level.WARNING, "Invalid parameter passed with command");
                this.getLogger().log(UserMessageLevel.USER_MSG, CvUtils.getResourceBundle().getString("INV_PARAM"));
                this.setParams(null);
            } else {
                XpViewport port = this.findSelectedViewportByClass(T3DViewport.class);
                if (port instanceof T3DViewport) {
                    Component[] comps = ((T3DViewport)port).getT3DComponent().getComponents();
                    if (comps == null || comps.length == 0) {
                        return;
                    }
                    for (int i2 = 0; i2 < comps.length; ++i2) {
                        if (!(comps[i2] instanceof Cursor3DVc)) continue;
                        CPoint pt = ((Cursor3DVc)comps[i2]).getCursorModel().getPoint(null);
                        double[] newLookPt = new double[]{pt.x, pt.y, pt.z};
                        ((T3DViewport)port).setLookPoint(newLookPt);
                    }
                }
            }
        }
        catch (Exception exp) {
            this.getLogger().log(Level.WARNING, "Exception during center on cursor operation, stack trace {0}", new Object[]{exp});
        }
    }
}

