/*
 * Decompiled with CFR 0.152.
 */
package com.ge.med.cse.cvf.j3d.action;

import com.ge.med.cse.cvf.base.BaseAction;
import com.ge.med.cse.cvf.idc.ViewTypeCapable;
import com.ge.med.cse.cvf.idc.XjVolumeCapable;
import com.ge.med.cse.cvf.j3d.utils.J3DGeomUtils;
import com.ge.med.cse.cvf.util.CvUtils;
import com.ge.med.idc.Capable;
import com.ge.med.idc.T3DCapable;
import com.ge.med.jnu.JnVector3d;
import java.awt.event.ActionEvent;
import java.util.HashMap;
import java.util.Map;

public class J3DViewResetAction
extends BaseAction {
    static boolean built_;
    private static Map viewVectorTable;
    public static final JnVector3d S_VECTOR;
    public static final JnVector3d I_VECTOR;
    public static final JnVector3d A_VECTOR;
    public static final JnVector3d P_VECTOR;
    public static final JnVector3d L_VECTOR;
    public static final JnVector3d R_VECTOR;
    private static Map upVectorTable;
    public static final JnVector3d S_UP_VECTOR;
    public static final JnVector3d I_UP_VECTOR;
    public static final JnVector3d A_UP_VECTOR;
    public static final JnVector3d P_UP_VECTOR;
    public static final JnVector3d L_UP_VECTOR;
    public static final JnVector3d R_UP_VECTOR;
    private static Map toolTipTable;
    public static final String S_TOOPTIP;
    public static final String I_TOOPTIP;
    public static final String A_TOOPTIP;
    public static final String P_TOOPTIP;
    public static final String R_TOOPTIP;
    public static final String L_TOOPTIP;
    private boolean allignedToVolume = true;
    private T3DCapable engine_ = null;
    private String orientation_ = "I";
    private JnVector3d viewVector;
    private JnVector3d upVector;
    private JnVector3d rightVector = new JnVector3d();
    private boolean centerOnVolume = false;
    private boolean centerOnFOV = false;
    private JnVector3d aVec = null;
    private JnVector3d rVec = null;
    private JnVector3d sVec = null;
    private double[] ulc = new double[3];
    private double[] xside = new double[3];
    private double[] yside = new double[3];
    private double[] zside = new double[3];
    private JnVector3d tmpV1 = new JnVector3d();
    private JnVector3d tmpV2 = new JnVector3d();

    public J3DViewResetAction() {
        this(null, "I", true);
    }

    public J3DViewResetAction(String orientation) {
        this(null, orientation, true);
    }

    public J3DViewResetAction(T3DCapable engine, String orientation, boolean allignedToVolume) {
        if (!built_) {
            J3DViewResetAction.build();
        }
        this.engine_ = engine;
        this.allignedToVolume = allignedToVolume;
        this.orientation_ = orientation;
        this.setName(orientation);
        this.setToolTip((String)toolTipTable.get(orientation.substring(0, 1).toUpperCase()));
        this.viewVector = (JnVector3d)viewVectorTable.get(orientation.substring(0, 1).toUpperCase());
        this.upVector = (JnVector3d)upVectorTable.get(orientation.substring(0, 1).toUpperCase());
        super.setCapable(this.engine_);
    }

    @Override
    protected String getName() {
        return "ViewResetAction";
    }

    public void setTarget(T3DCapable eng) {
        this.setCapable(eng);
    }

    public T3DCapable getTarget() {
        return this.engine_;
    }

    @Override
    public void setCapable(Capable cap) {
        if (cap != null) {
            super.setCapable(cap);
            this.engine_ = (T3DCapable)cap.getCapable(T3DCapable.class.getName());
        }
    }

    public void setCenterOnVolume(boolean centerVol) {
        this.centerOnVolume = centerVol;
    }

    public boolean isCenterOnVolume() {
        return this.centerOnVolume;
    }

    public void setCenterOnFOV(boolean centerFov) {
        this.centerOnFOV = centerFov;
    }

    public boolean isCenterOnFOV() {
        return this.centerOnFOV;
    }

    @Override
    public void actionPerformed(ActionEvent e2) {
        T3DCapable cap = this.engine_;
        if (cap == null && this.getCapable() != null) {
            cap = (T3DCapable)this.getCapable().getCapable(T3DCapable.class.getName());
        }
        if (cap == null) {
            return;
        }
        cap.getWorldBounds(this.ulc, this.xside, this.yside, this.zside);
        double[] center = new double[3];
        if (cap instanceof XjVolumeCapable) {
            J3DGeomUtils.getVolumeCenterRAS(((XjVolumeCapable)((Object)cap)).getVolume(), center);
        } else {
            J3DGeomUtils.getVolumeCenterRAS(this.ulc, this.xside, this.yside, this.zside, center);
        }
        if (this.allignedToVolume) {
            JnVector3d origin = new JnVector3d(this.ulc);
            this.rVec = new JnVector3d(this.xside);
            this.aVec = new JnVector3d(this.yside);
            this.sVec = new JnVector3d(this.zside);
            this.sVec.set(JnVector3d.cross(this.rVec, this.aVec));
            J3DGeomUtils.alignVolumeToRAS(origin, this.rVec, this.aVec, this.sVec);
            if ("S".equalsIgnoreCase(this.orientation_)) {
                this.viewVector.set(this.sVec);
                this.viewVector.scale(-1.0);
                this.upVector.set(this.aVec);
            } else if ("I".equalsIgnoreCase(this.orientation_)) {
                this.viewVector.set(this.sVec);
                this.upVector.set(this.aVec);
            } else if ("A".equalsIgnoreCase(this.orientation_)) {
                this.viewVector.set(this.aVec);
                this.viewVector.scale(-1.0);
                this.upVector.set(this.sVec);
            } else if ("P".equalsIgnoreCase(this.orientation_)) {
                this.viewVector.set(this.aVec);
                this.upVector.set(this.sVec);
            } else if ("R".equalsIgnoreCase(this.orientation_)) {
                this.viewVector.set(this.rVec);
                this.viewVector.scale(-1.0);
                this.upVector.set(this.sVec);
            } else if ("L".equalsIgnoreCase(this.orientation_)) {
                this.viewVector.set(this.rVec);
                this.upVector.set(this.sVec);
            }
        }
        double[] look = cap.getLookPoint(null);
        if (this.centerOnVolume) {
            look[0] = center[0];
            look[1] = center[1];
            look[2] = center[2];
        } else if (this.centerOnFOV) {
            this.tmpV1.set(this.upVector);
            this.tmpV2.set(center[0] - look[0], center[1] - look[1], center[2] - look[2]);
            this.tmpV1.normalize();
            double dot = this.tmpV2.dot(this.tmpV1);
            this.tmpV1.scale(dot);
            look[0] = look[0] + this.tmpV1.x;
            look[1] = look[1] + this.tmpV1.y;
            look[2] = look[2] + this.tmpV1.z;
            JnVector3d.cross(this.viewVector, this.upVector, this.rightVector);
            this.tmpV1.set(this.rightVector);
            this.tmpV2.set(center[0] - look[0], center[1] - look[1], center[2] - look[2]);
            this.tmpV1.normalize();
            dot = this.tmpV2.dot(this.tmpV1);
            this.tmpV1.scale(dot);
            look[0] = look[0] + this.tmpV1.x;
            look[1] = look[1] + this.tmpV1.y;
            look[2] = look[2] + this.tmpV1.z;
        }
        JnVector3d eyev = new JnVector3d(look);
        eyev.sub(this.viewVector);
        cap.setCamera(eyev.generateArray(), look, this.upVector.generateArray());
        cap.repaint();
    }

    protected static void build() {
        viewVectorTable = new HashMap(6);
        viewVectorTable.put("S", S_VECTOR);
        viewVectorTable.put("I", I_VECTOR);
        viewVectorTable.put("A", A_VECTOR);
        viewVectorTable.put("P", P_VECTOR);
        viewVectorTable.put("L", L_VECTOR);
        viewVectorTable.put("R", R_VECTOR);
        upVectorTable = new HashMap(6);
        upVectorTable.put("S", S_UP_VECTOR);
        upVectorTable.put("I", I_UP_VECTOR);
        upVectorTable.put("A", A_UP_VECTOR);
        upVectorTable.put("P", P_UP_VECTOR);
        upVectorTable.put("L", L_UP_VECTOR);
        upVectorTable.put("R", R_UP_VECTOR);
        toolTipTable = new HashMap(6);
        toolTipTable.put("S", S_TOOPTIP);
        toolTipTable.put("I", I_TOOPTIP);
        toolTipTable.put("A", A_TOOPTIP);
        toolTipTable.put("P", P_TOOPTIP);
        toolTipTable.put("L", L_TOOPTIP);
        toolTipTable.put("R", R_TOOPTIP);
    }

    static {
        S_VECTOR = new JnVector3d(0.0, 0.0, -1.0);
        I_VECTOR = new JnVector3d(0.0, 0.0, 1.0);
        A_VECTOR = new JnVector3d(0.0, -1.0, 0.0);
        P_VECTOR = new JnVector3d(0.0, 1.0, 0.0);
        L_VECTOR = new JnVector3d(1.0, 0.0, 0.0);
        R_VECTOR = new JnVector3d(-1.0, 0.0, 0.0);
        S_UP_VECTOR = new JnVector3d(0.0, -1.0, 0.0);
        I_UP_VECTOR = new JnVector3d(0.0, 1.0, 0.0);
        A_UP_VECTOR = new JnVector3d(0.0, 0.0, 1.0);
        P_UP_VECTOR = new JnVector3d(0.0, 0.0, 1.0);
        L_UP_VECTOR = new JnVector3d(0.0, 0.0, 1.0);
        R_UP_VECTOR = new JnVector3d(0.0, 0.0, 1.0);
        S_TOOPTIP = CvUtils.getResourceBundle().getString("VIEW_FROM_SUPERIOR");
        I_TOOPTIP = CvUtils.getResourceBundle().getString("VIEW_FROM_INFERIOR");
        A_TOOPTIP = CvUtils.getResourceBundle().getString("VIEW_FROM_ANTERIOR");
        P_TOOPTIP = CvUtils.getResourceBundle().getString("VIEW_FROM_POSTERIOR");
        R_TOOPTIP = CvUtils.getResourceBundle().getString("VIEW_FROM_RIGHT");
        L_TOOPTIP = CvUtils.getResourceBundle().getString("VIEW_FROM_LEFT");
    }

    public static class I
    extends J3DViewResetAction {
        public I() {
            super(null, "I", true);
        }

        public I(T3DCapable engine, boolean oblique) {
            super(engine, "I", oblique);
        }

        @Override
        public void actionPerformed(ActionEvent e2) {
            boolean applicable = true;
            ViewTypeCapable vtcap = (ViewTypeCapable)this.getCapable().getCapable(ViewTypeCapable.class.getName());
            if (vtcap != null && !"AXIAL".equals(vtcap.getViewType()) && !vtcap.getViewType(vtcap.getViewType()).isObliqueControllable()) {
                applicable = false;
            }
            if (applicable) {
                super.actionPerformed(e2);
            }
        }
    }

    public static class S
    extends J3DViewResetAction {
        public S() {
            super(null, "S", true);
        }

        public S(T3DCapable engine, boolean oblique) {
            super(engine, "S", oblique);
        }

        @Override
        public void actionPerformed(ActionEvent e2) {
            boolean applicable = true;
            ViewTypeCapable vtcap = (ViewTypeCapable)this.getCapable().getCapable(ViewTypeCapable.class.getName());
            if (vtcap != null && !"AXIAL".equals(vtcap.getViewType()) && !vtcap.getViewType(vtcap.getViewType()).isObliqueControllable()) {
                applicable = false;
            }
            if (applicable) {
                super.actionPerformed(e2);
            }
        }
    }

    public static class L
    extends J3DViewResetAction {
        public L() {
            super(null, "L", true);
        }

        public L(T3DCapable engine, boolean oblique) {
            super(engine, "L", oblique);
        }

        @Override
        public void actionPerformed(ActionEvent e2) {
            boolean applicable = true;
            ViewTypeCapable vtcap = (ViewTypeCapable)this.getCapable().getCapable(ViewTypeCapable.class.getName());
            if (vtcap != null && !"SAGITTAL".equals(vtcap.getViewType()) && !vtcap.getViewType(vtcap.getViewType()).isObliqueControllable()) {
                applicable = false;
            }
            if (applicable) {
                super.actionPerformed(e2);
            }
        }
    }

    public static class R
    extends J3DViewResetAction {
        public R() {
            super(null, "R", true);
        }

        public R(T3DCapable engine, boolean oblique) {
            super(engine, "R", oblique);
        }

        @Override
        public void actionPerformed(ActionEvent e2) {
            boolean applicable = true;
            ViewTypeCapable vtcap = (ViewTypeCapable)this.getCapable().getCapable(ViewTypeCapable.class.getName());
            if (vtcap != null && !"SAGITTAL".equals(vtcap.getViewType()) && !vtcap.getViewType(vtcap.getViewType()).isObliqueControllable()) {
                applicable = false;
            }
            if (applicable) {
                super.actionPerformed(e2);
            }
        }
    }

    public static class P
    extends J3DViewResetAction {
        public P() {
            super(null, "P", true);
        }

        public P(T3DCapable engine, boolean oblique) {
            super(engine, "P", oblique);
        }

        @Override
        public void actionPerformed(ActionEvent e2) {
            boolean applicable = true;
            ViewTypeCapable vtcap = (ViewTypeCapable)this.getCapable().getCapable(ViewTypeCapable.class.getName());
            if (vtcap != null && !"CORONAL".equals(vtcap.getViewType()) && !vtcap.getViewType(vtcap.getViewType()).isObliqueControllable()) {
                applicable = false;
            }
            if (applicable) {
                super.actionPerformed(e2);
            }
        }
    }

    public static class A
    extends J3DViewResetAction {
        public A() {
            super(null, "A", true);
        }

        public A(T3DCapable engine, boolean oblique) {
            super(engine, "A", oblique);
        }

        @Override
        public void actionPerformed(ActionEvent e2) {
            boolean applicable = true;
            ViewTypeCapable vtcap = (ViewTypeCapable)this.getCapable().getCapable(ViewTypeCapable.class.getName());
            if (vtcap != null && !"CORONAL".equals(vtcap.getViewType()) && !vtcap.getViewType(vtcap.getViewType()).isObliqueControllable()) {
                applicable = false;
            }
            if (applicable) {
                super.actionPerformed(e2);
            }
        }
    }
}

