/*
 * Decompiled with CFR 0.152.
 */
package com.ge.med.cse.cvf.j3d.action;

import com.ge.med.cse.cvf.idc.ViewTypeCapable;
import com.ge.med.cse.cvf.j3d.DynamicVolume;
import com.ge.med.cse.cvf.util.CvPropertiesManager;
import com.ge.med.idc.Capable;
import com.ge.med.idc.CineCapable;
import com.ge.med.idc.Fusion3DCapable;
import com.ge.med.terra.jami.j3d.T3DViewport;
import com.ge.med.terra.xpv.ui.ActiveAnnotationControl;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;
import javax.swing.JComponent;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;

public class J3DViewTypeActiveAnnotation
implements ActiveAnnotationControl,
ActionListener {
    private static final Logger logger = Logger.getLogger(J3DViewTypeActiveAnnotation.class.getName());
    private static final String supportedViews = "J3DViewTypeActiveAnnotation.supportedViews";
    private static List<String> displayableViews = new ArrayList<String>();
    private ViewTypeCapable vtcap_ = null;
    private JPopupMenu popup = new JPopupMenu("View Types");
    String[] viewTypes = null;
    String dataset = null;

    public J3DViewTypeActiveAnnotation() {
        this.popup.setFocusable(false);
        this.popup.setName("J3DViewTypeActiveAnnotationPopupMenu");
    }

    @Override
    public String getShortDescription() {
        return "Select View Type";
    }

    @Override
    public void listenTo(Component c2) {
        if (c2 instanceof Capable) {
            this.setCapable((Capable)((Object)c2));
        }
    }

    @Override
    public void setCapable(Capable capable) {
        this.vtcap_ = (ViewTypeCapable)capable.getCapable(ViewTypeCapable.class.getName());
    }

    @Override
    public void mousePressed(MouseEvent e2) {
        if (this.vtcap_ == null) {
            JComponent o2;
            for (o2 = (JComponent)e2.getSource(); o2 != null && !(o2 instanceof T3DViewport); o2 = (JComponent)o2.getParent()) {
            }
            if (o2 == null || !(o2 instanceof ViewTypeCapable)) {
                return;
            }
            this.vtcap_ = (ViewTypeCapable)((Object)o2);
        }
        if (this.vtcap_ == null || this.vtcap_ instanceof CineCapable && ((CineCapable)((Object)this.vtcap_)).getCine() || this.vtcap_.isViewTypeLocked()) {
            return;
        }
        this.showPopup(e2);
    }

    private void addMenuItem(String name) {
        JMenuItem menuItem = new JMenuItem(name);
        menuItem.setActionCommand(name);
        menuItem.addActionListener(this);
        this.popup.add(menuItem);
    }

    private void addSubMenuItem(String name, String[] subitems) {
        JMenu menu = new JMenu(name);
        for (int i2 = 0; i2 < subitems.length; ++i2) {
            JMenuItem menuItem = new JMenuItem(subitems[i2]);
            menuItem.setActionCommand(subitems[i2]);
            menuItem.addActionListener(this);
            menu.add(menuItem);
        }
        this.popup.add(menu);
    }

    private void buildMenu() {
        this.popup.removeAll();
        if (this.vtcap_ != null) {
            boolean volumeLoadingDone = !(((T3DViewport)((Object)this.vtcap_)).getVolume() instanceof DynamicVolume) || ((DynamicVolume)((T3DViewport)((Object)this.vtcap_)).getVolume()).isLoadingComplete();
            String[] views = this.vtcap_.getSupportedViewTypes();
            if (views != null && views.length > 0) {
                for (int i2 = 0; i2 < views.length; ++i2) {
                    if (!displayableViews.contains(views[i2])) continue;
                    ViewTypeCapable.ViewTypeActor vta = this.vtcap_.getViewType(views[i2]);
                    Fusion3DCapable fusion3DCap = (Fusion3DCapable)this.vtcap_.getCapable(Fusion3DCapable.class.getName());
                    if (fusion3DCap != null && fusion3DCap.getNumVolumeLayers() > 1 && vta.is3DViewType() || !volumeLoadingDone && vta.is3DViewType()) continue;
                    String[] subviews = vta.getSubViewTypes();
                    if (subviews != null) {
                        this.addSubMenuItem(views[i2], subviews);
                        continue;
                    }
                    this.addMenuItem(views[i2]);
                }
            }
        }
    }

    private void showPopup(MouseEvent e2) {
        this.buildMenu();
        this.popup.show(e2.getComponent(), e2.getX(), e2.getY());
    }

    @Override
    public void actionPerformed(ActionEvent e2) {
        String view = e2.getActionCommand();
        if (view != null && this.vtcap_ != null) {
            this.vtcap_.setViewType(view);
            this.vtcap_.repaint();
        }
    }

    @Override
    public void mouseReleased(MouseEvent e2) {
    }

    @Override
    public void mouseEntered(MouseEvent e2) {
    }

    @Override
    public void mouseExited(MouseEvent e2) {
    }

    @Override
    public void mouseDragged(MouseEvent e2) {
    }

    @Override
    public void mouseMoved(MouseEvent e2) {
    }

    @Override
    public void mouseClicked(MouseEvent e2) {
    }

    static {
        String val = CvPropertiesManager.getProperty(supportedViews);
        if (val == null || val.length() == 0) {
            displayableViews.add("AXIAL");
            displayableViews.add("SAGITTAL");
            displayableViews.add("CORONAL");
            displayableViews.add("OBLIQUE");
        } else {
            String[] views = val.split(",");
            for (int i2 = 0; i2 < views.length; ++i2) {
                displayableViews.add(views[i2]);
            }
        }
    }
}

