/*
 * Decompiled with CFR 0.152.
 */
package com.ge.med.cse.cvf.j3d.cpanels;

import com.ge.med.cse.cvf.j3d.action.J3DViewResetAction;
import com.ge.med.terra.xpv.autoControls.XPcaAutoControlPanel;
import com.ge.med.terra.xpv.base.XPscreen;
import com.ge.med.terra.xpv.cuiPanels.TransactionLogName;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.UIManager;

public class J3DViewResetPanel
extends XPcaAutoControlPanel {
    private static final Logger logger = Logger.getLogger("com.ge.med.cse.cvf.cpanels");
    private final int ICON_SIZE = 27;
    private static List<J3DViewResetAction> orientations = null;

    public J3DViewResetPanel() {
        TransactionLogName tid = new TransactionLogName("TID=J3DViewResetPanel");
        logger.log(Level.FINE, "{0} begin, Creating J3DViewReset panel", tid);
        this.initUI();
        logger.log(Level.FINE, "{0} end, Creating J3DViewReset panel", tid);
    }

    private void initUI() {
        this.setBackground(null);
        this.setLayout(new GridBagLayout());
        this.setName("J3DViewResetPanel");
        JPanel orienPanel = new JPanel();
        orienPanel.setLayout(new GridBagLayout());
        orienPanel.setBackground(UIManager.getColor("P8"));
        ButtonGroup bg = new ButtonGroup();
        int position = 0;
        for (J3DViewResetAction type : orientations) {
            final JButton view = new JButton(type);
            view.setPreferredSize(new Dimension(20, 27));
            view.setFocusPainted(false);
            view.setFocusable(false);
            view.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseEntered(MouseEvent arg0) {
                    super.mouseEntered(arg0);
                    view.setBackground(UIManager.getColor("P9"));
                }

                @Override
                public void mouseExited(MouseEvent arg0) {
                    super.mouseExited(arg0);
                    view.setBackground(null);
                }
            });
            view.setName(type.getClass().getName());
            view.setBorder(null);
            bg.add(view);
            orienPanel.add((Component)view, new GridBagConstraints(position++, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(3, 5, 3, 5), 0, 0));
        }
        this.add((Component)orienPanel, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 17, 2, new Insets(0, 0, 0, 0), 0, 0));
    }

    @Override
    public void setScreen(XPscreen screen) {
        super.setScreen(screen);
        for (J3DViewResetAction type : orientations) {
            type.setCapable(screen);
        }
    }

    static {
        orientations = new ArrayList<J3DViewResetAction>();
        orientations.add(new J3DViewResetAction.S());
        orientations.add(new J3DViewResetAction.I());
        orientations.add(new J3DViewResetAction.A());
        orientations.add(new J3DViewResetAction.P());
        orientations.add(new J3DViewResetAction.R());
        orientations.add(new J3DViewResetAction.L());
    }
}

