/*
 * Decompiled with CFR 0.152.
 */
package com.ge.med.cse.cvf.j3d.utils;

import com.ge.med.idc.XjVolumeGeometry;
import com.ge.med.idc.XjVolumeInfo;
import com.ge.med.jnu.JnVector3d;
import com.ge.med.terra.jami.CPoint;
import com.ge.med.terra.jami.CTransform;
import com.ge.med.terra.jami.JVolume;
import com.ge.med.terra.jami.ParallelTaskManager;
import com.ge.med.terra.jami.Worker;
import com.ge.med.terra.jami.XpPixelStatistics;
import com.ge.med.terra.jami.XpSlice;
import com.ge.med.terra.jami.capable.MultiVolumeCapable;
import com.ge.med.terra.jami.j3d.J3DVolumeModel;
import com.ge.med.terra.jami.j3d.VoxelCombiner;
import com.ge.med.terra.jami.j3d.XjVolumeUtils;
import java.awt.Graphics2D;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.awt.image.DataBufferByte;
import java.util.Arrays;

public class J3DPixelStatsCalculator {
    private static ParallelTaskManager stat_ptm = new ParallelTaskManager();
    private static StatWorker[] stat_workers = null;
    private static int[] volumeRasterFreq;
    private static XpSlice rasterSlice;
    private static BufferedImage rasterBitmap;

    private static XpPixelStatistics calcPixelStatisticsThreaded(BufferedImage bitimg, XpSlice sample, J3DVolumeModel jvm, XpPixelStatistics ps) {
        if (ps == null) {
            ps = new XpPixelStatistics();
        }
        int PAD = 0;
        short[] sdata = null;
        byte[] bdata = null;
        int dx = 0;
        int dy = 0;
        int dz = 0;
        double rescaleIntercept = 0.0;
        double rescaleSlope = 1.0;
        double[] xdir = new double[3];
        double[] ydir = new double[3];
        double[] rowstart = new double[3];
        double[] currpt = new double[3];
        double[] zero_point = new double[3];
        PAD = jvm.getJVolume().PAD;
        dx = jvm.getJVolume().dx;
        dy = jvm.getJVolume().dy;
        dz = jvm.getJVolume().dz;
        ps.resetStatistics();
        ps.min = 3.4028234663852886E38;
        ps.max = 1.4E-45f;
        sample.ul.get(rowstart);
        xdir[0] = sample.I.x * sample.pixelSizeX;
        xdir[1] = sample.I.y * sample.pixelSizeX;
        xdir[2] = sample.I.z * sample.pixelSizeX;
        ydir[0] = sample.J.x * sample.pixelSizeY;
        ydir[1] = sample.J.y * sample.pixelSizeY;
        ydir[2] = sample.J.z * sample.pixelSizeY;
        jvm.rasToVoxels(rowstart, rowstart);
        jvm.rasToVoxels(xdir, xdir);
        jvm.rasToVoxels(ydir, ydir);
        jvm.rasToVoxels(zero_point, zero_point);
        JnVector3d.sub(xdir, zero_point, xdir);
        JnVector3d.sub(ydir, zero_point, ydir);
        int rowlen_bitmap = (sample.width + 7) / 8;
        byte[] bitmap = ((DataBufferByte)bitimg.getRaster().getDataBuffer()).getData();
        int psize = dx * dy;
        int bx1 = Integer.MAX_VALUE;
        int by1 = Integer.MAX_VALUE;
        int bx2 = Integer.MIN_VALUE;
        int by2 = Integer.MIN_VALUE;
        if (jvm instanceof MultiVolumeCapable) {
            MultiVolumeCapable mvc = (MultiVolumeCapable)((Object)jvm);
            VoxelCombiner vc = mvc.getVoxelCombiner();
            vc.setData(mvc.getVoxelCombinerData());
            vc.setNumberOfThreads(1);
            rescaleIntercept = vc.getRescaleIntercept();
            rescaleSlope = vc.getRescaleSlope();
            StatWorkerArgs args = new StatWorkerArgs();
            args.bitimg = bitimg;
            args.jvm = jvm;
            args.sample = sample;
            args.vc = vc;
            args.xdir = xdir;
            args.ydir = ydir;
            args.rowstart = rowstart;
            stat_ptm.launch(args);
            ps.bounds.setBounds(J3DPixelStatsCalculator.stat_workers[0].ps.bounds);
            for (int i2 = 0; i2 < stat_workers.length; ++i2) {
                XpPixelStatistics ps_worker = J3DPixelStatsCalculator.stat_workers[i2].ps;
                ps.sum += ps_worker.sum;
                ps.sumSq += ps_worker.sumSq;
                ps.npixels += ps_worker.npixels;
                if (ps.max < ps_worker.max) {
                    ps.max = ps_worker.max;
                }
                if (!(ps.min > ps_worker.min)) continue;
                ps.min = ps_worker.min;
            }
        } else {
            JVolume.LinearVolume jls;
            JVolume.LinearVolume jvol = jvm.getJVolume();
            rescaleIntercept = jvol.rescaleIntercept;
            rescaleSlope = jvol.rescaleSlope;
            if (jvol instanceof JVolume.LinearShort) {
                jls = (JVolume.LinearShort)jvol;
                sdata = jls.volume;
            } else if (jvol instanceof JVolume.LinearByte) {
                jls = (JVolume.LinearByte)jvol;
                bdata = ((JVolume.LinearByte)jls).volume;
            }
            if (sdata != null) {
                for (int y2 = 0; y2 < sample.height; ++y2) {
                    int boffset = y2 * rowlen_bitmap;
                    currpt[0] = rowstart[0];
                    currpt[1] = rowstart[1];
                    currpt[2] = rowstart[2];
                    for (int x2 = 0; x2 < sample.width; ++x2) {
                        int bit = x2 & 7;
                        int idx = boffset + x2 / 8;
                        int on = XpPixelStatistics.bitmasks[bit] & bitmap[idx] & 0xFF;
                        if (on != 0) {
                            int sx = (int)currpt[0];
                            int sy = (int)currpt[1];
                            int sz = (int)currpt[2];
                            if (sx >= 0 && sx < dx && sy >= 0 && sy < dy && sz >= 0 && sz < dz) {
                                int volidx = PAD + sz * psize + sy * dx + sx;
                                short pval = sdata[volidx];
                                if ((double)pval < ps.min) {
                                    ps.min = pval;
                                }
                                if ((double)pval > ps.max) {
                                    ps.max = pval;
                                }
                                if (x2 < bx1) {
                                    bx1 = x2;
                                }
                                if (y2 < by1) {
                                    by1 = y2;
                                }
                                if (x2 > bx2) {
                                    bx2 = x2;
                                }
                                if (y2 > by2) {
                                    by2 = y2;
                                }
                                ps.sum += (double)pval;
                                ps.sumSq += (double)(pval * pval);
                                ++ps.npixels;
                            }
                        }
                        JnVector3d.add(currpt, xdir, currpt);
                    }
                    JnVector3d.add(rowstart, ydir, rowstart);
                }
            } else if (bdata != null) {
                for (int y3 = 0; y3 < sample.height; ++y3) {
                    int boffset = y3 * rowlen_bitmap;
                    currpt[0] = rowstart[0];
                    currpt[1] = rowstart[1];
                    currpt[2] = rowstart[2];
                    for (int x3 = 0; x3 < sample.width; ++x3) {
                        int bit = x3 & 7;
                        int idx = boffset + x3 / 8;
                        int on = XpPixelStatistics.bitmasks[bit] & bitmap[idx] & 0xFF;
                        if (on != 0) {
                            int sx = (int)currpt[0];
                            int sy = (int)currpt[1];
                            int sz = (int)currpt[2];
                            if (sx >= 0 && sx < dx && sy >= 0 && sy < dy && sz >= 0 && sz < dz) {
                                int volidx = PAD + sz * psize + sy * dx + sx;
                                byte pval = bdata[volidx];
                                if ((double)pval < ps.min) {
                                    ps.min = pval;
                                }
                                if ((double)pval > ps.max) {
                                    ps.max = pval;
                                }
                                if (x3 < bx1) {
                                    bx1 = x3;
                                }
                                if (y3 < by1) {
                                    by1 = y3;
                                }
                                if (x3 > bx2) {
                                    bx2 = x3;
                                }
                                if (y3 > by2) {
                                    by2 = y3;
                                }
                                ps.sum += (double)pval;
                                ps.sumSq += (double)(pval * pval);
                                ++ps.npixels;
                            }
                        }
                        JnVector3d.add(currpt, xdir, currpt);
                    }
                    JnVector3d.add(rowstart, ydir, rowstart);
                }
            }
        }
        ps.bounds.setBounds(bx1, by1, bx2 - bx1, by2 - by1);
        ps.min = ps.min == 3.4028234663852886E38 ? 0.0 : ps.min;
        ps.max = ps.max == (double)1.4E-45f ? 0.0 : ps.max;
        ps.mean = ps.npixels != 0 ? ps.sum / (double)ps.npixels : 0.0;
        ps.mean = rescaleSlope * ps.mean + rescaleIntercept;
        ps.max = rescaleSlope * ps.max + rescaleIntercept;
        ps.min = rescaleSlope * ps.min + rescaleIntercept;
        ps.sumSq = rescaleSlope * rescaleSlope * ps.sumSq + 2.0 * rescaleSlope * rescaleIntercept * ps.sum + (double)ps.npixels * (rescaleIntercept * rescaleIntercept);
        ps.sum = rescaleSlope * ps.sum + (double)ps.npixels * rescaleIntercept;
        ps.diffsumSq = (double)ps.npixels * ps.mean * ps.mean - 2.0 * ps.mean * ps.sum + ps.sumSq;
        ps.variance = ps.npixels > 1 ? ps.diffsumSq / (double)(ps.npixels - 1) : 0.0;
        return ps;
    }

    public static void setVolumeRasterFreq(int xRasterFreq, int yRasterFreq) {
        J3DPixelStatsCalculator.volumeRasterFreq[0] = xRasterFreq;
        J3DPixelStatsCalculator.volumeRasterFreq[1] = yRasterFreq;
    }

    private static void computeBitmap(Shape s2, double angle, XjVolumeInfo volumeInfo, XpSlice refSlice) {
        Rectangle2D bbox = s2.getBounds2D();
        if (refSlice != null) {
            AffineTransform at = new AffineTransform();
            at.setToIdentity();
            at.rotate(-angle, bbox.getCenterX(), bbox.getCenterY());
            double minX = 9999999.0;
            double maxX = -9999999.0;
            double minY = 9999999.0;
            double maxY = -9999999.0;
            Point2D.Double p0 = new Point2D.Double();
            ((Point2D)p0).setLocation(bbox.getMinX(), bbox.getMinY());
            at.transform(p0, p0);
            minX = ((Point2D)p0).getX() < minX ? ((Point2D)p0).getX() : minX;
            maxX = ((Point2D)p0).getX() > maxX ? ((Point2D)p0).getX() : maxX;
            minY = ((Point2D)p0).getY() < minY ? ((Point2D)p0).getY() : minY;
            maxY = ((Point2D)p0).getY() > maxY ? ((Point2D)p0).getY() : maxY;
            ((Point2D)p0).setLocation(bbox.getMaxX(), bbox.getMinY());
            at.transform(p0, p0);
            minX = ((Point2D)p0).getX() < minX ? ((Point2D)p0).getX() : minX;
            maxX = ((Point2D)p0).getX() > maxX ? ((Point2D)p0).getX() : maxX;
            minY = ((Point2D)p0).getY() < minY ? ((Point2D)p0).getY() : minY;
            maxY = ((Point2D)p0).getY() > maxY ? ((Point2D)p0).getY() : maxY;
            ((Point2D)p0).setLocation(bbox.getMaxX(), bbox.getMaxY());
            at.transform(p0, p0);
            minX = ((Point2D)p0).getX() < minX ? ((Point2D)p0).getX() : minX;
            maxX = ((Point2D)p0).getX() > maxX ? ((Point2D)p0).getX() : maxX;
            minY = ((Point2D)p0).getY() < minY ? ((Point2D)p0).getY() : minY;
            maxY = ((Point2D)p0).getY() > maxY ? ((Point2D)p0).getY() : maxY;
            ((Point2D)p0).setLocation(bbox.getMinX(), bbox.getMaxY());
            at.transform(p0, p0);
            minX = ((Point2D)p0).getX() < minX ? ((Point2D)p0).getX() : minX;
            maxX = ((Point2D)p0).getX() > maxX ? ((Point2D)p0).getX() : maxX;
            minY = ((Point2D)p0).getY() < minY ? ((Point2D)p0).getY() : minY;
            maxY = ((Point2D)p0).getY() > maxY ? ((Point2D)p0).getY() : maxY;
            CPoint imgpt = new CPoint(minX, minY, 0.0, 0);
            CPoint ulras = new CPoint(2);
            CPoint urras = new CPoint(2);
            CPoint brras = new CPoint(2);
            refSlice.imageToRas.transform(imgpt, ulras);
            imgpt.set(maxX, minY, 0.0);
            refSlice.imageToRas.transform(imgpt, urras);
            imgpt.set(maxX, maxY, 0.0);
            refSlice.imageToRas.transform(imgpt, brras);
            CTransform vox2ras = new CTransform();
            CTransform ras2vox = new CTransform();
            XjVolumeUtils.calculateVoxelRASTransform((XjVolumeGeometry)volumeInfo, vox2ras, ras2vox);
            CPoint ulvox = new CPoint(5);
            CPoint urvox = new CPoint(5);
            CPoint brvox = new CPoint(5);
            ras2vox.transform(ulras, ulvox);
            ras2vox.transform(urras, urvox);
            ras2vox.transform(brras, brvox);
            int voxBoxHeight = (int)Math.round(urvox.distance(brvox) * (double)volumeRasterFreq[1]);
            int voxBoxWidth = (int)Math.round(urvox.distance(ulvox) * (double)volumeRasterFreq[0]);
            rasterBitmap = new BufferedImage(voxBoxWidth, voxBoxHeight, 12);
            rasterSlice = new XpSlice(voxBoxWidth, voxBoxHeight);
            rasterSlice.setCorners(ulras, urras, brras);
            CTransform ras2img = J3DPixelStatsCalculator.rasterSlice.rasToImage;
            CTransform tx = refSlice.imageToRas.multiplyBy(ras2img);
            byte[] data = ((DataBufferByte)rasterBitmap.getRaster().getDataBuffer()).getData();
            Arrays.fill(data, (byte)0);
            tx.getTransform2D(at);
            Graphics2D g2 = (Graphics2D)rasterBitmap.getGraphics();
            g2.transform(at);
            g2.rotate(-angle, bbox.getCenterX(), bbox.getCenterY());
            g2.fill(s2);
        }
    }

    private static XpPixelStatistics calcPixelStatistics(BufferedImage bitimg, XpSlice sample, J3DVolumeModel jvm, XpPixelStatistics ps) {
        if (ps == null) {
            ps = new XpPixelStatistics();
        }
        short[] sdata = null;
        byte[] bdata = null;
        int PAD = jvm.getJVolume().PAD;
        int dx = jvm.getJVolume().dx;
        int dy = jvm.getJVolume().dy;
        int dz = jvm.getJVolume().dz;
        double rescaleIntercept = 0.0;
        double rescaleSlope = 1.0;
        double[] xdir = new double[3];
        double[] ydir = new double[3];
        double[] rowstart = new double[3];
        double[] currpt = new double[3];
        double[] zero_point = new double[3];
        sample.ul.get(rowstart);
        xdir[0] = sample.I.x * sample.pixelSizeX;
        xdir[1] = sample.I.y * sample.pixelSizeX;
        xdir[2] = sample.I.z * sample.pixelSizeX;
        ydir[0] = sample.J.x * sample.pixelSizeY;
        ydir[1] = sample.J.y * sample.pixelSizeY;
        ydir[2] = sample.J.z * sample.pixelSizeY;
        jvm.rasToVoxels(rowstart, rowstart);
        jvm.rasToVoxels(xdir, xdir);
        jvm.rasToVoxels(ydir, ydir);
        jvm.rasToVoxels(zero_point, zero_point);
        JnVector3d.sub(xdir, zero_point, xdir);
        JnVector3d.sub(ydir, zero_point, ydir);
        ps.resetStatistics();
        int rowlen_bitmap = (sample.width + 7) / 8;
        byte[] bitmap = ((DataBufferByte)bitimg.getRaster().getDataBuffer()).getData();
        int psize = dx * dy;
        int bx1 = Integer.MAX_VALUE;
        int by1 = Integer.MAX_VALUE;
        int bx2 = Integer.MIN_VALUE;
        int by2 = Integer.MIN_VALUE;
        ps.min = 3.4028234663852886E38;
        ps.max = 1.4E-45f;
        if (jvm instanceof MultiVolumeCapable) {
            MultiVolumeCapable mvc = (MultiVolumeCapable)((Object)jvm);
            VoxelCombiner vc = mvc.getVoxelCombiner();
            vc.setData(mvc.getVoxelCombinerData());
            vc.setNumberOfThreads(1);
            rescaleIntercept = vc.getRescaleIntercept();
            rescaleSlope = vc.getRescaleSlope();
            short[][] allChannelsData = (short[][])jvm.getVolumeData();
            short[][] srcBuffer = new short[allChannelsData.length][1];
            short[] resultBuffer = new short[1];
            double[] rdebug = new double[3];
            System.arraycopy(rowstart, 0, rdebug, 0, 3);
            for (int y2 = 0; y2 < sample.height; ++y2) {
                int boffset = y2 * rowlen_bitmap;
                currpt[0] = rowstart[0];
                currpt[1] = rowstart[1];
                currpt[2] = rowstart[2];
                for (int x2 = 0; x2 < sample.width; ++x2) {
                    int bit = x2 & 7;
                    int idx = boffset + x2 / 8;
                    int on = XpPixelStatistics.bitmasks[bit] & bitmap[idx] & 0xFF;
                    if (on != 0) {
                        int sx = (int)currpt[0];
                        int sy = (int)currpt[1];
                        int sz = (int)currpt[2];
                        if (sx >= 0 && sx < dx && sy >= 0 && sy < dy && sz >= 0 && sz < dz) {
                            int volidx = PAD + sz * psize + sy * dx + sx;
                            for (int channelIdx = 0; channelIdx < srcBuffer.length; ++channelIdx) {
                                srcBuffer[channelIdx][0] = allChannelsData[channelIdx][volidx];
                            }
                            vc.combine(0, resultBuffer, srcBuffer, 0, 0, 1, 1, 1);
                            short pval = resultBuffer[0];
                            if ((double)pval < ps.min) {
                                ps.min = pval;
                            }
                            if ((double)pval > ps.max) {
                                ps.max = pval;
                            }
                            if (x2 < bx1) {
                                bx1 = x2;
                            }
                            if (y2 < by1) {
                                by1 = y2;
                            }
                            if (x2 > bx2) {
                                bx2 = x2;
                            }
                            if (y2 > by2) {
                                by2 = y2;
                            }
                            ps.sum += (double)pval;
                            ps.sumSq += (double)(pval * pval);
                            ++ps.npixels;
                        }
                    }
                    JnVector3d.add(currpt, xdir, currpt);
                }
                JnVector3d.add(rowstart, ydir, rowstart);
            }
        } else {
            JVolume.LinearVolume jls;
            JVolume.LinearVolume jvol = jvm.getJVolume();
            rescaleIntercept = jvol.rescaleIntercept;
            rescaleSlope = jvol.rescaleSlope;
            if (jvol instanceof JVolume.LinearShort) {
                jls = (JVolume.LinearShort)jvol;
                sdata = jls.volume;
            } else if (jvol instanceof JVolume.LinearByte) {
                jls = (JVolume.LinearByte)jvol;
                bdata = ((JVolume.LinearByte)jls).volume;
            }
            if (sdata != null) {
                for (int y3 = 0; y3 < sample.height; ++y3) {
                    int boffset = y3 * rowlen_bitmap;
                    currpt[0] = rowstart[0];
                    currpt[1] = rowstart[1];
                    currpt[2] = rowstart[2];
                    for (int x3 = 0; x3 < sample.width; ++x3) {
                        int bit = x3 & 7;
                        int idx = boffset + x3 / 8;
                        int on = XpPixelStatistics.bitmasks[bit] & bitmap[idx] & 0xFF;
                        if (on != 0) {
                            int sx = (int)currpt[0];
                            int sy = (int)currpt[1];
                            int sz = (int)currpt[2];
                            if (sx >= 0 && sx < dx && sy >= 0 && sy < dy && sz >= 0 && sz < dz) {
                                int volidx = PAD + sz * psize + sy * dx + sx;
                                short pval = sdata[volidx];
                                if ((double)pval < ps.min) {
                                    ps.min = pval;
                                }
                                if ((double)pval > ps.max) {
                                    ps.max = pval;
                                }
                                if (x3 < bx1) {
                                    bx1 = x3;
                                }
                                if (y3 < by1) {
                                    by1 = y3;
                                }
                                if (x3 > bx2) {
                                    bx2 = x3;
                                }
                                if (y3 > by2) {
                                    by2 = y3;
                                }
                                ps.sum += (double)pval;
                                ps.sumSq += (double)(pval * pval);
                                ++ps.npixels;
                            }
                        }
                        JnVector3d.add(currpt, xdir, currpt);
                    }
                    JnVector3d.add(rowstart, ydir, rowstart);
                }
            } else if (bdata != null) {
                for (int y4 = 0; y4 < sample.height; ++y4) {
                    int boffset = y4 * rowlen_bitmap;
                    currpt[0] = rowstart[0];
                    currpt[1] = rowstart[1];
                    currpt[2] = rowstart[2];
                    for (int x4 = 0; x4 < sample.width; ++x4) {
                        int bit = x4 & 7;
                        int idx = boffset + x4 / 8;
                        int on = XpPixelStatistics.bitmasks[bit] & bitmap[idx] & 0xFF;
                        if (on != 0) {
                            int sx = (int)currpt[0];
                            int sy = (int)currpt[1];
                            int sz = (int)currpt[2];
                            if (sx >= 0 && sx < dx && sy >= 0 && sy < dy && sz >= 0 && sz < dz) {
                                int volidx = PAD + sz * psize + sy * dx + sx;
                                byte pval = bdata[volidx];
                                if ((double)pval < ps.min) {
                                    ps.min = pval;
                                }
                                if ((double)pval > ps.max) {
                                    ps.max = pval;
                                }
                                if (x4 < bx1) {
                                    bx1 = x4;
                                }
                                if (y4 < by1) {
                                    by1 = y4;
                                }
                                if (x4 > bx2) {
                                    bx2 = x4;
                                }
                                if (y4 > by2) {
                                    by2 = y4;
                                }
                                ps.sum += (double)pval;
                                ps.sumSq += (double)(pval * pval);
                                ++ps.npixels;
                            }
                        }
                        JnVector3d.add(currpt, xdir, currpt);
                    }
                    JnVector3d.add(rowstart, ydir, rowstart);
                }
            }
        }
        ps.bounds.setBounds(bx1, by1, bx2 - bx1, by2 - by1);
        ps.min = ps.min == 3.4028234663852886E38 ? 0.0 : ps.min;
        ps.max = ps.max == (double)1.4E-45f ? 0.0 : ps.max;
        ps.mean = ps.npixels != 0 ? ps.sum / (double)ps.npixels : 0.0;
        ps.mean = rescaleSlope * ps.mean + rescaleIntercept;
        ps.max = rescaleSlope * ps.max + rescaleIntercept;
        ps.min = rescaleSlope * ps.min + rescaleIntercept;
        ps.sumSq = rescaleSlope * rescaleSlope * ps.sumSq + 2.0 * rescaleSlope * rescaleIntercept * ps.sum + (double)ps.npixels * (rescaleIntercept * rescaleIntercept);
        ps.sum = rescaleSlope * ps.sum + (double)ps.npixels * rescaleIntercept;
        ps.diffsumSq = (double)ps.npixels * ps.mean * ps.mean - 2.0 * ps.mean * ps.sum + ps.sumSq;
        ps.variance = ps.npixels > 1 ? ps.diffsumSq / (double)(ps.npixels - 1) : 0.0;
        System.err.println("Sum: " + ps.sum);
        System.err.println("SumSq: " + ps.sumSq);
        System.err.println("npixels: " + ps.npixels);
        System.err.println("max: " + ps.max);
        System.err.println("min: " + ps.min);
        return ps;
    }

    private static double[] calcScaledVoxelValues(BufferedImage bitimg, XpSlice sample, J3DVolumeModel jvm) {
        double[] sresult = null;
        int voxelcount = 0;
        int PAD = 0;
        short[] sdata = null;
        byte[] bdata = null;
        int dx = 0;
        int dy = 0;
        int dz = 0;
        double rescaleIntercept = 0.0;
        double rescaleSlope = 1.0;
        double[] xdir = new double[3];
        double[] ydir = new double[3];
        double[] rowstart = new double[3];
        double[] currpt = new double[3];
        double[] zero_point = new double[3];
        sample.ul.get(rowstart);
        xdir[0] = sample.I.x * sample.pixelSizeX;
        xdir[1] = sample.I.y * sample.pixelSizeX;
        xdir[2] = sample.I.z * sample.pixelSizeX;
        ydir[0] = sample.J.x * sample.pixelSizeY;
        ydir[1] = sample.J.y * sample.pixelSizeY;
        ydir[2] = sample.J.z * sample.pixelSizeY;
        jvm.rasToVoxels(rowstart, rowstart);
        jvm.rasToVoxels(xdir, xdir);
        jvm.rasToVoxels(ydir, ydir);
        jvm.rasToVoxels(zero_point, zero_point);
        JnVector3d.sub(xdir, zero_point, xdir);
        JnVector3d.sub(ydir, zero_point, ydir);
        int rowlen_bitmap = (sample.width + 7) / 8;
        byte[] bitmap = ((DataBufferByte)bitimg.getRaster().getDataBuffer()).getData();
        sresult = new double[bitmap.length * 8];
        int psize = dx * dy;
        PAD = jvm.getJVolume().PAD;
        dx = jvm.getJVolume().dx;
        dy = jvm.getJVolume().dy;
        dz = jvm.getJVolume().dz;
        if (jvm instanceof MultiVolumeCapable) {
            MultiVolumeCapable mvc = (MultiVolumeCapable)((Object)jvm);
            VoxelCombiner vc = mvc.getVoxelCombiner();
            vc.setData(mvc.getVoxelCombinerData());
            vc.setNumberOfThreads(1);
            rescaleIntercept = vc.getRescaleIntercept();
            rescaleSlope = vc.getRescaleSlope();
            short[][] allChannelsData = (short[][])jvm.getVolumeData();
            short[][] srcBuffer = new short[allChannelsData.length][1];
            short[] resultBuffer = new short[1];
            for (int y2 = 0; y2 < sample.height; ++y2) {
                int boffset = y2 * rowlen_bitmap;
                currpt[0] = rowstart[0];
                currpt[1] = rowstart[1];
                currpt[2] = rowstart[2];
                for (int x2 = 0; x2 < sample.width; ++x2) {
                    int bit = x2 & 7;
                    int idx = boffset + x2 / 8;
                    int on = XpPixelStatistics.bitmasks[bit] & bitmap[idx] & 0xFF;
                    if (on != 0) {
                        int sx = (int)currpt[0];
                        int sy = (int)currpt[1];
                        int sz = (int)currpt[2];
                        if (sx >= 0 && sx < dx && sy >= 0 && sy < dy && sz >= 0 && sz < dz) {
                            int volidx = PAD + sz * psize + sy * dx + sx;
                            for (int channelIdx = 0; channelIdx < srcBuffer.length; ++channelIdx) {
                                srcBuffer[channelIdx][0] = allChannelsData[channelIdx][volidx];
                            }
                            vc.combine(0, resultBuffer, srcBuffer, 0, 0, 1, 1, 1);
                            sresult[voxelcount++] = (double)resultBuffer[0] * rescaleSlope + rescaleIntercept;
                        }
                    }
                    JnVector3d.add(currpt, xdir, currpt);
                }
                JnVector3d.add(rowstart, ydir, rowstart);
            }
        } else {
            JVolume.LinearVolume jls;
            JVolume.LinearVolume jvol = jvm.getJVolume();
            rescaleIntercept = jvol.rescaleIntercept;
            rescaleSlope = jvol.rescaleSlope;
            if (jvol instanceof JVolume.LinearShort) {
                jls = (JVolume.LinearShort)jvol;
                sdata = jls.volume;
            } else if (jvol instanceof JVolume.LinearByte) {
                jls = (JVolume.LinearByte)jvol;
                bdata = ((JVolume.LinearByte)jls).volume;
            }
            if (sdata != null) {
                for (int y3 = 0; y3 < sample.height; ++y3) {
                    int boffset = y3 * rowlen_bitmap;
                    currpt[0] = rowstart[0];
                    currpt[1] = rowstart[1];
                    currpt[2] = rowstart[2];
                    for (int x3 = 0; x3 < sample.width; ++x3) {
                        int bit = x3 & 7;
                        int idx = boffset + x3 / 8;
                        int on = XpPixelStatistics.bitmasks[bit] & bitmap[idx] & 0xFF;
                        if (on != 0) {
                            int sx = (int)currpt[0];
                            int sy = (int)currpt[1];
                            int sz = (int)currpt[2];
                            if (sx >= 0 && sx < dx && sy >= 0 && sy < dy && sz >= 0 && sz < dz) {
                                int volidx = PAD + sz * psize + sy * dx + sx;
                                sresult[voxelcount++] = (double)sdata[volidx] * rescaleSlope + rescaleIntercept;
                            }
                        }
                        JnVector3d.add(currpt, xdir, currpt);
                    }
                    JnVector3d.add(rowstart, ydir, rowstart);
                }
            } else if (bdata != null) {
                for (int y4 = 0; y4 < sample.height; ++y4) {
                    int boffset = y4 * rowlen_bitmap;
                    currpt[0] = rowstart[0];
                    currpt[1] = rowstart[1];
                    currpt[2] = rowstart[2];
                    for (int x4 = 0; x4 < sample.width; ++x4) {
                        int bit = x4 & 7;
                        int idx = boffset + x4 / 8;
                        int on = XpPixelStatistics.bitmasks[bit] & bitmap[idx] & 0xFF;
                        if (on != 0) {
                            int sx = (int)currpt[0];
                            int sy = (int)currpt[1];
                            int sz = (int)currpt[2];
                            if (sx >= 0 && sx < dx && sy >= 0 && sy < dy && sz >= 0 && sz < dz) {
                                int volidx = PAD + sz * psize + sy * dx + sx;
                                sresult[voxelcount++] = (double)bdata[volidx] * rescaleSlope + rescaleIntercept;
                            }
                        }
                        JnVector3d.add(currpt, xdir, currpt);
                    }
                    JnVector3d.add(rowstart, ydir, rowstart);
                }
            }
        }
        double[] result = null;
        if (voxelcount > 0) {
            result = new double[voxelcount];
            System.arraycopy(sresult, 0, result, 0, voxelcount);
        }
        return result;
    }

    public static double[] calculateScaledVoxelValues(Shape s2, double angle, J3DVolumeModel volModel, XpSlice refSlice) {
        J3DPixelStatsCalculator.computeBitmap(s2, angle, volModel.getVolume(), refSlice);
        return J3DPixelStatsCalculator.calcScaledVoxelValues(rasterBitmap, rasterSlice, volModel);
    }

    public static XpPixelStatistics calculatePixelStatistics(Shape s2, double angle, J3DVolumeModel volModel, XpSlice refSlice) {
        J3DPixelStatsCalculator.computeBitmap(s2, angle, volModel.getVolume(), refSlice);
        XpPixelStatistics ps = null;
        ps = J3DPixelStatsCalculator.calcPixelStatisticsThreaded(rasterBitmap, rasterSlice, volModel, ps);
        return ps;
    }

    public static double getArea(Shape s2, double angle, J3DVolumeModel volModel, XpSlice refSlice) {
        XpPixelStatistics ps = J3DPixelStatsCalculator.calculatePixelStatistics(s2, angle, volModel, refSlice);
        return (double)ps.npixels * J3DPixelStatsCalculator.rasterSlice.pixelSizeX * J3DPixelStatsCalculator.rasterSlice.pixelSizeY;
    }

    static {
        stat_workers = new StatWorker[ParallelTaskManager.NCPUS];
        for (int i2 = 0; i2 < stat_workers.length; ++i2) {
            J3DPixelStatsCalculator.stat_workers[i2] = new StatWorker(stat_ptm, i2);
        }
        stat_ptm.setWorkers(stat_workers);
        volumeRasterFreq = new int[]{1, 1};
        rasterSlice = null;
        rasterBitmap = null;
    }

    private static class StatWorker
    extends Worker {
        public XpPixelStatistics ps = new XpPixelStatistics();

        public StatWorker(ParallelTaskManager ptm, int workerId) {
            super(ptm, workerId);
        }

        @Override
        public void work(int workerId, int nWorkers, Object data) {
            StatWorkerArgs args = (StatWorkerArgs)data;
            BufferedImage bitimg = args.bitimg;
            J3DVolumeModel jvm = args.jvm;
            double[] rowstart = new double[3];
            System.arraycopy(args.rowstart, 0, rowstart, 0, 3);
            XpSlice sample = args.sample;
            VoxelCombiner vc = args.vc;
            double[] xdir = args.xdir;
            double[] ydir = args.ydir;
            double[] currpt = new double[3];
            int PAD = jvm.getJVolume().PAD;
            int dx = jvm.getJVolume().dx;
            int dy = jvm.getJVolume().dy;
            int dz = jvm.getJVolume().dz;
            short[][] allChannelsData = (short[][])jvm.getVolumeData();
            short[][] srcBuffer = new short[allChannelsData.length][1];
            short[] resultBuffer = new short[1];
            this.ps.resetStatistics();
            this.ps.min = 3.4028234663852886E38;
            this.ps.max = 1.4E-45f;
            int rowlen_bitmap = (sample.width + 7) / 8;
            byte[] bitmap = ((DataBufferByte)bitimg.getRaster().getDataBuffer()).getData();
            int psize = dx * dy;
            int bx1 = Integer.MAX_VALUE;
            int by1 = Integer.MAX_VALUE;
            int bx2 = Integer.MIN_VALUE;
            int by2 = Integer.MIN_VALUE;
            double[] rdebug = new double[3];
            System.arraycopy(rowstart, 0, rdebug, 0, 3);
            for (int y2 = 0; y2 < sample.height; ++y2) {
                int boffset = y2 * rowlen_bitmap;
                JnVector3d.scaleAdd(rowstart, xdir, workerId, currpt);
                for (int x2 = workerId; x2 < sample.width; x2 += nWorkers) {
                    int bit = x2 & 7;
                    int idx = boffset + x2 / 8;
                    int on = XpPixelStatistics.bitmasks[bit] & bitmap[idx] & 0xFF;
                    if (on != 0) {
                        int sx = (int)currpt[0];
                        int sy = (int)currpt[1];
                        int sz = (int)currpt[2];
                        if (sx >= 0 && sx < dx && sy >= 0 && sy < dy && sz >= 0 && sz < dz) {
                            int volidx = PAD + sz * psize + sy * dx + sx;
                            for (int channelIdx = 0; channelIdx < srcBuffer.length; ++channelIdx) {
                                srcBuffer[channelIdx][0] = allChannelsData[channelIdx][volidx];
                            }
                            vc.combine(0, resultBuffer, srcBuffer, 0, 0, 1, 1, 1);
                            short pval = resultBuffer[0];
                            if ((double)pval < this.ps.min) {
                                this.ps.min = pval;
                            }
                            if ((double)pval > this.ps.max) {
                                this.ps.max = pval;
                            }
                            if (x2 < bx1) {
                                bx1 = x2;
                            }
                            if (y2 < by1) {
                                by1 = y2;
                            }
                            if (x2 > bx2) {
                                bx2 = x2;
                            }
                            if (y2 > by2) {
                                by2 = y2;
                            }
                            this.ps.sum += (double)pval;
                            this.ps.sumSq += (double)(pval * pval);
                            ++this.ps.npixels;
                        }
                    }
                    JnVector3d.scaleAdd(currpt, xdir, nWorkers, currpt);
                }
                JnVector3d.add(rowstart, ydir, rowstart);
            }
            this.ps.bounds.setBounds(bx1, by1, bx2 - bx1, by2 - by1);
        }
    }

    private static class StatWorkerArgs {
        public VoxelCombiner vc = null;
        public J3DVolumeModel jvm = null;
        public XpSlice sample = null;
        public BufferedImage bitimg = null;
        public double[] xdir = new double[3];
        public double[] ydir = new double[3];
        public double[] rowstart = new double[3];

        private StatWorkerArgs() {
        }
    }
}

