/*
 * Decompiled with CFR 0.152.
 */
package com.ge.med.cse.cvf.j3d.vav;

import com.ge.med.cse.cvf.j3d.utils.J3DGeomUtils;
import com.ge.med.cse.cvf.j3d.vav.VVBatchProtocol;
import com.ge.med.cse.cvf.j3d.vav.VavBatchModel;
import com.ge.med.cse.cvf.j3d.vav.VavException;
import com.ge.med.cse.cvf.j3d.vav.VavImageGenerationMonitor;
import com.ge.med.cse.cvf.j3d.vav.VavRectPrismBatchModel;
import com.ge.med.cse.cvf.saveimage.XpSaveParameters;
import com.ge.med.cse.cvf.saveimage.XpSaveUtil;
import com.ge.med.cse.cvf.util.CvPropertiesManager;
import com.ge.med.cse.cvf.util.CvUtils;
import com.ge.med.idc.Capable;
import com.ge.med.idc.T3DCapable;
import com.ge.med.idc.TaskMonitor;
import com.ge.med.idc.XjVolumeInfo;
import com.ge.med.idc.XjVolumeModel;
import com.ge.med.jnu.JnVector3d;
import com.ge.med.terra.jami.image.XpBufferedImage;
import com.ge.med.terra.jami.j3d.J3DVolumeModel;
import com.ge.med.terra.jami.j3d.T3DViewport;
import com.ge.med.terra.tap.dm.DMException;
import com.ge.med.terra.tap.dm.DMSession;
import com.ge.med.terra.tap.util.dicom.DicomComposite;
import com.ge.med.terra.tap.util.dicom.UidGenerator;
import java.awt.Graphics;
import java.awt.image.BufferedImage;
import java.awt.image.DataBufferUShort;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.FileInputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.SwingUtilities;

public class VavBatchJob
implements PropertyChangeListener {
    protected final Logger logger = Logger.getLogger("com.ge.med.cse.cvf.j3d.vav");
    private PropertyChangeSupport pcs = new PropertyChangeSupport(this);
    public static final String PROCESSING_ERROR_PROPERTY = "PROCESSING_ERROR_PROPERTY";
    private DMSession outputSession = null;
    protected JnVector3d inputSliceI = null;
    protected JnVector3d inputSliceJ = null;
    protected JnVector3d inputSliceN = null;
    protected String seriesUID = null;
    protected int seriesNum = -1;
    protected String seriesDesc = null;
    protected long seriesDate = -1L;
    protected int startImageNum;
    protected int imageNum = this.startImageNum = 1;
    private VavBatchModel model = null;
    private BatchFrame[] batchFrames = null;
    protected int nextFrameIndex = -1;
    private List<TaskMonitor> taskMonitors = new ArrayList<TaskMonitor>();
    protected int numImagesProcessed = 0;
    protected int numErrors = 0;
    protected String taskName = "VAV Batch Processing";
    private double[] tempEye = new double[3];
    private double[] tempLook = new double[3];
    private double[] tempUp = new double[3];
    private double[] tempViewClip = new double[2];
    private boolean started = false;
    private boolean complete = false;
    private boolean aborted = false;
    private static boolean debugTrace = CvPropertiesManager.getProperty("vav.debug_trace") != null;
    private static final boolean referenceFrame = CvPropertiesManager.getBoolean("vav.referenceframe", false);
    private boolean generateRefFrame = referenceFrame;
    private DicomComposite refComp = null;
    private static boolean exitONsaveFrameFailure = CvPropertiesManager.getBoolean("vav.batchJob.exitOnSaveFrameFailure", false);
    private static int saveFrameRetryCount = Integer.parseInt(CvPropertiesManager.getProperty("vav.batchJob.saveFrameRetryCount", "3"));
    private boolean paused = false;
    private static final double mfactor = 1.2;
    private int reserveSpaceHandle = -1;

    public VavBatchJob() {
        this(new VavRectPrismBatchModel());
    }

    public VavBatchJob(VavBatchModel model) {
        this.model = model;
    }

    public String getName() {
        return this.taskName;
    }

    public synchronized void setSeriesUID(String seriesUID) {
        if (this.started || this.aborted || this.complete) {
            this.logger.log(Level.INFO, "Cannot set series UID, Batch Job already started");
            return;
        }
        this.seriesUID = seriesUID;
    }

    public String getSeriesUID() {
        return this.seriesUID;
    }

    public synchronized void setSeriesNumber(int seriesNum) {
        if (this.started || this.aborted || this.complete) {
            this.logger.log(Level.INFO, "Cannot set series number, Batch Job already started");
            return;
        }
        this.seriesNum = seriesNum;
    }

    public int getSeriesNumber() {
        return this.seriesNum;
    }

    public synchronized void setStartFrameNumber(int frameNumber) {
        if (this.started || this.aborted || this.complete) {
            this.logger.log(Level.INFO, "Cannot set start frame number, Batch Job already started");
            return;
        }
        if (frameNumber > 0) {
            this.startImageNum = frameNumber;
        }
    }

    public synchronized int getStartFrameNumber() {
        return this.startImageNum;
    }

    public synchronized void setModel(VavBatchModel model) {
        if (this.started || this.aborted || this.complete) {
            this.logger.log(Level.INFO, "Cannot set batch model, Batch Job already started");
            return;
        }
        if (!model.equals(this.model)) {
            if (this.model != null) {
                this.logger.log(Level.WARNING, "Overriding model in batch job.  Information associated with previous model will be lost.");
            }
            this.model = model;
            this.batchFrames = null;
            this.nextFrameIndex = -1;
        }
    }

    public synchronized VavBatchModel getModel() {
        return this.model;
    }

    public void setOutputSession(DMSession session) {
        if (this.started || this.aborted || this.complete) {
            this.logger.log(Level.INFO, "Cannot set ouput session, Batch Job already started");
            return;
        }
        this.outputSession = session;
    }

    public DMSession getOutputSession() {
        return this.outputSession;
    }

    public void setReferenceFrame(boolean refFrameOn) {
        if (this.started || this.aborted || this.complete) {
            return;
        }
        this.generateRefFrame = refFrameOn;
    }

    public boolean isReferenceFrameOn() {
        return this.generateRefFrame;
    }

    public final synchronized BatchFrame nextFrame() {
        int i2;
        if (this.aborted) {
            return null;
        }
        if (this.batchFrames == null) {
            if (this.model == null) {
                return null;
            }
            this.started = true;
            this.imageNum = this.startImageNum;
            this.batchFrames = new BatchFrame[this.model.getNumImages()];
            for (i2 = 0; i2 < this.batchFrames.length; ++i2) {
                this.batchFrames[i2] = new BatchFrame();
                this.batchFrames[i2].setCamera(this.model.getSliceEyePoint(i2, this.tempEye), this.model.getSliceLookPoint(i2, this.tempLook), this.model.getSliceUp(i2, this.tempUp));
                if (this.model instanceof VavRectPrismBatchModel) {
                    this.batchFrames[i2].setActualLookPoint(((VavRectPrismBatchModel)this.model).getActualSliceLookPoint(i2, this.tempLook));
                    this.batchFrames[i2].setSpacing(((VavRectPrismBatchModel)this.model).getSpacing());
                }
                this.batchFrames[i2].setViewHeight(this.model.getFov());
                double halfThickness = this.model.getThickness() / 2.0;
                this.tempViewClip[0] = -halfThickness;
                this.tempViewClip[1] = halfThickness;
                this.batchFrames[i2].setViewClip(this.tempViewClip);
                this.batchFrames[i2].setInverted(this.model.isInverted());
                this.batchFrames[i2].setWidth(this.model.getPixelDimension().width);
                this.batchFrames[i2].setHeight(this.model.getPixelDimension().height);
                this.batchFrames[i2].setRenderStyle(this.model.getRenderStyle());
                this.batchFrames[i2].setInverted(this.model.inverted);
                this.batchFrames[i2].addPropertyChangeListener("PROCESSING_COMPLETE_PROPERTY", this);
                this.batchFrames[i2].addPropertyChangeListener(PROCESSING_ERROR_PROPERTY, this);
            }
            this.nextFrameIndex = 0;
            this.seriesDesc = this.model.getSeriesDescription() == null ? "Reformatted" : this.model.getSeriesDescription();
            this.taskName = "VAV " + this.seriesDesc;
            this.logger.log(Level.INFO, "TID=VAV_INVOKE_LATER begin");
            SwingUtilities.invokeLater(new TaskBeginRunnable(this.taskName, this.batchFrames.length));
        }
        if (this.nextFrameIndex >= 0 && this.nextFrameIndex < this.batchFrames.length && !this.batchFrames[this.nextFrameIndex].isProcessed()) {
            return this.batchFrames[this.nextFrameIndex++];
        }
        for (i2 = 0; i2 < this.batchFrames.length; ++i2) {
            if (this.batchFrames[i2].isProcessed()) continue;
            this.nextFrameIndex = i2;
            return this.batchFrames[this.nextFrameIndex++];
        }
        return null;
    }

    public void addTaskMonitor(TaskMonitor tm) {
        this.taskMonitors.add(tm);
    }

    public void removeTaskMonitor(TaskMonitor tm) {
        this.taskMonitors.remove(tm);
    }

    protected void notifyTaskBegin(String taskName, int totalWork) {
        this.logger.log(Level.FINE, "TID=VAV_BATCH_JOB: model = " + this.model);
        int len = this.taskMonitors.size();
        for (int i2 = 0; i2 < len; ++i2) {
            TaskMonitor tm = this.taskMonitors.get(i2);
            tm.taskBegin(taskName, totalWork);
        }
    }

    protected void notifyTaskProgress(String taskName, int units, XpBufferedImage image) {
        int len = this.taskMonitors.size();
        for (int i2 = 0; i2 < len; ++i2) {
            TaskMonitor tm = this.taskMonitors.get(i2);
            if (tm instanceof VavImageGenerationMonitor) {
                ((VavImageGenerationMonitor)tm).taskProgress(taskName, units, this, image);
                continue;
            }
            tm.taskProgress(taskName, units);
        }
    }

    protected void notifyTaskDone(String taskName) {
        int len = this.taskMonitors.size();
        for (int i2 = 0; i2 < len; ++i2) {
            TaskMonitor tm = this.taskMonitors.get(i2);
            tm.taskDone(taskName);
        }
    }

    protected void notifyTaskFailed(String taskName, String reason, Exception e2) {
        int len = this.taskMonitors.size();
        for (int i2 = 0; i2 < len; ++i2) {
            TaskMonitor tm = this.taskMonitors.get(i2);
            tm.taskFailed(taskName, reason, e2);
        }
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        if (evt.getPropertyName().equals("PROCESSING_COMPLETE_PROPERTY")) {
            ++this.numImagesProcessed;
            XpBufferedImage image = (XpBufferedImage)evt.getNewValue();
            SwingUtilities.invokeLater(new TaskProgressRunnable(this.taskName, this.numImagesProcessed, image));
            if (this.numImagesProcessed + this.numErrors == this.batchFrames.length) {
                this.complete = true;
                if (!this.aborted) {
                    SwingUtilities.invokeLater(new TaskDoneRunnable(this.taskName));
                }
            }
        }
        if (evt.getPropertyName().equals(PROCESSING_ERROR_PROPERTY)) {
            ++this.numErrors;
            SwingUtilities.invokeLater(new FireErrorRunnable(evt.getOldValue(), evt.getNewValue()));
            if (exitONsaveFrameFailure && this.aborted) {
                VavException.VavErrorCodes errorcode = (VavException.VavErrorCodes)((Object)evt.getNewValue());
                SwingUtilities.invokeLater(new TaskFailedRunnable(this.taskName, errorcode.getMessage(), new VavException(errorcode)));
            }
            if (this.numImagesProcessed + this.numErrors == this.batchFrames.length) {
                this.complete = true;
                if (!this.aborted) {
                    SwingUtilities.invokeLater(new TaskDoneRunnable(this.taskName));
                }
            }
        }
    }

    public synchronized int getNumFrames() {
        if (this.batchFrames == null) {
            return 0;
        }
        return this.batchFrames.length;
    }

    public int getNumFramesProcessed() {
        return this.numImagesProcessed;
    }

    public boolean abortJob() {
        if (!this.isComplete() && !this.isAborted()) {
            this.aborted = true;
            if (this.batchFrames == null) {
                SwingUtilities.invokeLater(new TaskBeginRunnable(this.taskName, this.model != null ? this.model.getNumImages() : 1));
            }
            SwingUtilities.invokeLater(new TaskDoneRunnable(this.taskName));
            return true;
        }
        return false;
    }

    public void pauseJob() {
        if (this.isStarted() && !this.isAborted() && !this.isComplete()) {
            this.paused = true;
        }
    }

    public void resumeJob() {
        if (this.isStarted() && this.paused) {
            this.paused = false;
        }
    }

    public boolean isAborted() {
        return this.aborted;
    }

    public boolean isComplete() {
        return this.complete;
    }

    public boolean isStarted() {
        return this.started;
    }

    public boolean isPaused() {
        return this.paused;
    }

    public void reserveSpace() {
        if (this.isStarted()) {
            return;
        }
        if (this.getModel() != null && this.getModel().isTargetSet()) {
            int imgSize = this.getModel().getPixelWidth() * this.getModel().getPixelHeight() * 2;
            int spaceRequired = (int)((double)(this.getNumFrames() * imgSize) * 1.2);
            this.reserveSpaceHandle = CvUtils.getDMSystem().spaceReserve(spaceRequired);
        }
    }

    public void releaseSpace() {
        if (this.reserveSpaceHandle != -1) {
            CvUtils.getDMSystem().spaceRelease(this.reserveSpaceHandle);
        }
    }

    public void removePropertyChangeListener(PropertyChangeListener l2) {
        this.pcs.removePropertyChangeListener(l2);
    }

    public void addPropertyChangeListener(PropertyChangeListener l2) {
        this.pcs.addPropertyChangeListener(l2);
    }

    public void addPropertyChangeListener(String prop, PropertyChangeListener l2) {
        this.pcs.addPropertyChangeListener(prop, l2);
    }

    public boolean isSavingToDB() {
        return this.model.isSaving();
    }

    public static void main(String[] args) {
    }

    public class BatchFrame
    implements T3DCapable {
        private double[] actuallookPoint = null;
        private double[] lookPoint = new double[3];
        private double[] eyePoint = new double[3];
        private double[] upVector = new double[3];
        private double fov = 0.0;
        private double[] clipOffsets = new double[2];
        private int pixWidth = 512;
        private int pixHeight = 512;
        private boolean inverted = false;
        private String renderStyle = VVBatchProtocol.defaultRenderingQuality() == 2 ? "REFORMAT.TC" : "REFORMAT";
        private double spacing = 0.0;
        private Map valueMap = new HashMap();
        private String wlKey = "40,4176";
        private String wwKey = "40,4177";
        private boolean processed = false;
        private PropertyChangeSupport pcs = new PropertyChangeSupport(this);
        public static final String PROCESSING_COMPLETE_PROPERTY = "PROCESSING_COMPLETE_PROPERTY";
        public static final String PROCESSING_ERROR_PROPERTY = "PROCESSING_ERROR_PROPERTY";

        public boolean isProcessed() {
            return this.processed;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void saveFrame(XpBufferedImage image, XjVolumeModel volModel) {
            VavBatchJob.this.logger.finer("Saving frame: " + VavBatchJob.this.seriesDesc + " (" + VavBatchJob.this.model.getNumImages() + ")");
            this.processed = true;
            try {
                boolean is3drfmt;
                XjVolumeInfo volinfo = volModel.getVolume();
                XpSaveParameters params = new XpSaveParameters();
                params.image = image;
                params.imageThickness = Math.abs(this.clipOffsets[1] - this.clipOffsets[0]);
                params.sliceSpacing = this.getSpacing();
                params.renderStyle = this.getRenderStyle();
                String modality_ = null;
                if (volinfo != null) {
                    modality_ = volinfo.getValue(8, 96).toString();
                }
                if (VavBatchJob.this.getModel().getTargetPort() == null && modality_ != null && !modality_.equals("")) {
                    if (modality_.equalsIgnoreCase("CT")) {
                        if (volModel instanceof J3DVolumeModel) {
                            params.defaultWindowWidthLevel = new double[2];
                            params.defaultWindowWidthLevel[0] = ((J3DVolumeModel)volModel).j_vol.initWW;
                            params.defaultWindowWidthLevel[1] = ((J3DVolumeModel)volModel).j_vol.initWL;
                        }
                    } else if (modality_.equalsIgnoreCase("MR")) {
                        params.defaultWindowWidthLevel = null;
                    }
                } else {
                    double max = VavBatchJob.this.getModel().getTargetPort().getWinMax();
                    double min = VavBatchJob.this.getModel().getTargetPort().getWinMin();
                    params.defaultWindowWidthLevel = new double[2];
                    params.defaultWindowWidthLevel[0] = max - min;
                    params.defaultWindowWidthLevel[1] = (max + min) / 2.0;
                }
                params.grayScaleInverted = this.isInverted();
                if (VavBatchJob.this.seriesNum < 0) {
                    XjVolumeInfo dicomRef = volModel.getVolume();
                    VavBatchJob.this.seriesNum = XpSaveUtil.nextSeriesNumber(dicomRef, VavBatchJob.this.outputSession);
                }
                params.seriesNum = VavBatchJob.this.seriesNum;
                params.seriesDescription = VavBatchJob.this.seriesDesc;
                params.imageNum = VavBatchJob.this.imageNum++;
                params.seriesUID = VavBatchJob.this.seriesUID = VavBatchJob.this.seriesUID == null ? UidGenerator.newInstanceUID() : VavBatchJob.this.seriesUID;
                if (VavBatchJob.this.generateRefFrame) {
                    VavBatchJob.this.generateRefFrame = false;
                    T3DViewport port = VavBatchJob.this.getModel().getTargetPort();
                    if (port != null) {
                        double[] viewClip = new double[2];
                        port.getViewClip(viewClip);
                        double thickness = Math.abs(viewClip[0] - viewClip[1]);
                        double minThickness = Math.abs(J3DGeomUtils.getMinSliceThickness(port.getVolume(), port.getLookPoint(null), port.getEyePoint(null), false));
                        if (thickness < minThickness) {
                            thickness = minThickness;
                        }
                        params.imageThickness = thickness;
                        params.renderStyle = port.getRenderStyle();
                        BufferedImage img = (BufferedImage)((XpBufferedImage)port.getFrame()).getPixelData();
                        BufferedImage batchvc_img = new BufferedImage(img.getWidth(), img.getHeight(), 11);
                        Graphics g2 = batchvc_img.getGraphics();
                        short[] imglayer = ((DataBufferUShort)img.getRaster().getDataBuffer()).getData();
                        short[] imglayer_stored = new short[imglayer.length];
                        for (int j2 = 0; j2 < imglayer.length; ++j2) {
                            imglayer_stored[j2] = imglayer[j2];
                        }
                        short[] gxlayer = ((DataBufferUShort)batchvc_img.getRaster().getDataBuffer()).getData();
                        for (int i2 = 0; i2 < imglayer.length; ++i2) {
                            int pixval = gxlayer[i2] & 0xFFFF;
                            double w2 = (double)pixval / 65536.0;
                            if (!(w2 > 0.0)) continue;
                            imglayer[i2] = Short.MAX_VALUE;
                            imglayer[i2 + img.getWidth()] = Short.MIN_VALUE;
                        }
                        params.image = port.getFrame();
                        boolean saveStatus = XpSaveUtil.reformatSave(VavBatchJob.this.isSavingToDB(), false, VavBatchJob.this.getModel().getTargetPort(), params);
                        for (int j3 = 0; j3 < imglayer.length; ++j3) {
                            imglayer[j3] = imglayer_stored[j3];
                        }
                        params.image = image;
                        params.imageNum = VavBatchJob.this.imageNum++;
                        params.imageThickness = thickness;
                        params.renderStyle = this.getRenderStyle();
                    }
                }
                boolean bl = is3drfmt = "FULLBODY_AVERAGE".equals(params.renderStyle) || "FULLBODY_MINIP".equals(params.renderStyle) || "FULLBODY_MIP".equals(params.renderStyle);
                if (is3drfmt) {
                    params.imageThickness = J3DGeomUtils.getMaxSliceThickness(volModel.getVolume(), this.getLookPoint(null), this.getEyePoint(null));
                    VavBatchJob.this.getModel().setThickness(params.imageThickness);
                } else {
                    double minThk;
                    boolean oblique;
                    short planeType = J3DGeomUtils.getPlaneType(image.getSlice());
                    boolean bl2 = oblique = planeType == 18 || planeType == 24 || planeType == 20;
                    if (VavBatchJob.this.model instanceof VavRectPrismBatchModel && params.imageThickness < (minThk = J3DGeomUtils.getMinSliceThickness(volModel.getVolume(), this.getLookPoint(null), this.getEyePoint(null), oblique))) {
                        params.imageThickness = minThk;
                        VavBatchJob.this.model.setThickness(minThk);
                    }
                }
                if (debugTrace) {
                    System.err.println("BatchFrame.saveFrame() saving to db : " + VavBatchJob.this.isSavingToDB());
                }
                if (VavBatchJob.this.isSavingToDB()) {
                    if (VavBatchJob.this.outputSession == null) {
                        String msg = "Error during image save (output repository session is null).";
                        VavBatchJob.this.logger.log(Level.SEVERE, "{0} SEV6 " + msg, "TID=VAV_BATCH_SAVE");
                        this.pcs.firePropertyChange("PROCESSING_ERROR_PROPERTY", null, null);
                        return;
                    }
                    if (VavBatchJob.this.refComp == null) {
                        VavBatchJob.this.refComp = new DicomComposite();
                        if (volinfo != null) {
                            FileInputStream fis = new FileInputStream(volinfo.getRelatedComposite());
                            try {
                                VavBatchJob.this.refComp.read(fis);
                            }
                            catch (DMException ex) {
                                VavBatchJob.this.logger.log(Level.WARNING, "Exception while reading the reference composite", ex);
                                ex.printStackTrace();
                            }
                            finally {
                                fis.close();
                            }
                        }
                    }
                    boolean saveStatus = false;
                    for (int saveFrameRetry = 0; !saveStatus && saveFrameRetry != saveFrameRetryCount; ++saveFrameRetry) {
                        if (!exitONsaveFrameFailure) {
                            saveFrameRetryCount = 1;
                        }
                        saveStatus = VavBatchJob.this.getModel().getTargetPort() instanceof T3DViewport ? XpSaveUtil.reformatSave(VavBatchJob.this.isSavingToDB(), false, VavBatchJob.this.getModel().getTargetPort(), params) : XpSaveUtil.saveFrame(VavBatchJob.this.isSavingToDB(), false, VavBatchJob.this.refComp, params, VavBatchJob.this.outputSession);
                    }
                    if (debugTrace) {
                        System.err.println("BatchFrame.saveFrame() saving to db status : " + saveStatus);
                    }
                    if (!saveStatus && exitONsaveFrameFailure) {
                        VavBatchJob.this.abortJob();
                        String msg = "Error during dicom image save";
                        VavBatchJob.this.logger.log(Level.SEVERE, "{0} SEV6 " + msg, new Object[]{"TID=VAV_BATCH_SAVE"});
                        this.pcs.firePropertyChange("PROCESSING_ERROR_PROPERTY", null, (Object)VavException.VavErrorCodes.VAV_BATCH_IMAGE_SAVE_FAILED);
                        return;
                    }
                    if (!saveStatus) {
                        String msg = "Error during dicom image save";
                        VavBatchJob.this.logger.log(Level.SEVERE, "{0} SEV6 " + msg, new Object[]{"TID=VAV_BATCH_SAVE"});
                        this.pcs.firePropertyChange("PROCESSING_ERROR_PROPERTY", null, (Object)VavException.VavErrorCodes.VAV_BATCH_IMAGE_SAVE_FAILED);
                        return;
                    }
                }
                if (params.defaultWindowWidthLevel != null && params.defaultWindowWidthLevel.length > 0) {
                    this.valueMap.put(this.wlKey, params.defaultWindowWidthLevel[1]);
                    this.valueMap.put(this.wwKey, params.defaultWindowWidthLevel[0]);
                    image.setPropertyTable(this.valueMap);
                }
                this.pcs.firePropertyChange(PROCESSING_COMPLETE_PROPERTY, null, image);
            }
            catch (Exception ex) {
                if (debugTrace) {
                    ex.printStackTrace();
                }
                String msg = "Error during dicom image save: " + ex.getMessage();
                VavBatchJob.this.logger.log(Level.SEVERE, "{0} SEV6 " + msg, new Object[]{"TID=VAV_BATCH_SAVE", ex});
                this.pcs.firePropertyChange("PROCESSING_ERROR_PROPERTY", null, ex);
                return;
            }
        }

        public void reportProcessingError(Exception ex) {
            if (debugTrace) {
                ex.printStackTrace();
            }
            String msg = "Reporting frame processing error: " + ex.getMessage();
            VavBatchJob.this.logger.log(Level.FINE, msg);
            this.pcs.firePropertyChange("PROCESSING_ERROR_PROPERTY", null, ex);
        }

        public void setWidth(int width) {
            this.pixWidth = width;
        }

        public int getWidth() {
            return this.pixWidth;
        }

        public void setHeight(int height) {
            this.pixHeight = height;
        }

        public int getHeight() {
            return this.pixHeight;
        }

        @Override
        public void getWorldBounds(double[] ulc, double[] xside, double[] yside, double[] zside) {
            throw new UnsupportedOperationException("getWorldBounds method not supported.");
        }

        @Override
        public void setLookPoint(double[] point) {
            System.arraycopy(point, 0, this.lookPoint, 0, 3);
        }

        @Override
        public double[] getLookPoint(double[] look_pt) {
            if (look_pt == null) {
                look_pt = new double[3];
            }
            System.arraycopy(this.lookPoint, 0, look_pt, 0, 3);
            return look_pt;
        }

        public void setActualLookPoint(double[] point) {
            if (this.actuallookPoint == null) {
                this.actuallookPoint = new double[3];
            }
            System.arraycopy(point, 0, this.actuallookPoint, 0, 3);
        }

        public double[] getActualLookPoint(double[] look_pt) {
            if (look_pt == null) {
                look_pt = new double[3];
            }
            if (this.actuallookPoint == null) {
                System.arraycopy(this.lookPoint, 0, look_pt, 0, 3);
            } else {
                System.arraycopy(this.actuallookPoint, 0, look_pt, 0, 3);
            }
            return look_pt;
        }

        @Override
        public void setEyePoint(double[] point) {
            System.arraycopy(point, 0, this.eyePoint, 0, 3);
        }

        @Override
        public double[] getEyePoint(double[] eye_pt) {
            if (eye_pt == null) {
                eye_pt = new double[3];
            }
            System.arraycopy(this.eyePoint, 0, eye_pt, 0, 3);
            return eye_pt;
        }

        @Override
        public void setUp(double[] vec) {
            System.arraycopy(vec, 0, this.upVector, 0, 3);
        }

        @Override
        public double[] getUp(double[] up_vect) {
            if (up_vect == null) {
                up_vect = new double[3];
            }
            System.arraycopy(this.upVector, 0, up_vect, 0, 3);
            return up_vect;
        }

        @Override
        public void setCamera(double[] eyepoint, double[] lookpoint, double[] up) {
            this.setEyePoint(eyepoint);
            this.setLookPoint(lookpoint);
            this.setUp(up);
        }

        @Override
        public void setViewHeight(double height) {
            this.fov = height;
        }

        @Override
        public double getViewHeight() {
            return this.fov;
        }

        @Override
        public void setAspectRatio(double aspect) {
            throw new UnsupportedOperationException("setAspectRatio method not supported.  Aspect Ratio is always 1.");
        }

        @Override
        public double getAspectRatio() {
            return 1.0;
        }

        @Override
        public void setViewClip(double[] clipOffsets) {
            System.arraycopy(clipOffsets, 0, this.clipOffsets, 0, 2);
        }

        @Override
        public double[] getViewClip(double[] viewClip) {
            if (viewClip == null) {
                viewClip = new double[2];
            }
            System.arraycopy(this.clipOffsets, 0, viewClip, 0, 2);
            return viewClip;
        }

        public String getRenderStyle() {
            return this.renderStyle;
        }

        public void setRenderStyle(String renderStyle) {
            this.renderStyle = renderStyle;
        }

        @Override
        public void setPerspective(boolean b2) {
            throw new UnsupportedOperationException("setPerspective method not supported.  Perspective is always false.");
        }

        @Override
        public boolean isPerspective() {
            return false;
        }

        public void setInverted(boolean invert) {
            this.inverted = invert;
        }

        public boolean isInverted() {
            return this.inverted;
        }

        public void setSpacing(double spc) {
            this.spacing = spc;
        }

        public double getSpacing() {
            return this.spacing;
        }

        @Override
        public void removePropertyChangeListener(PropertyChangeListener l2) {
            this.pcs.removePropertyChangeListener(l2);
        }

        @Override
        public void addPropertyChangeListener(PropertyChangeListener l2) {
            this.pcs.addPropertyChangeListener(l2);
        }

        @Override
        public void removePropertyChangeListener(String prop, PropertyChangeListener l2) {
            this.pcs.removePropertyChangeListener(prop, l2);
        }

        @Override
        public void addPropertyChangeListener(String prop, PropertyChangeListener l2) {
            this.pcs.addPropertyChangeListener(prop, l2);
        }

        @Override
        public void repaint() {
            throw new UnsupportedOperationException("repaint method not supported.");
        }

        @Override
        public boolean isAutoRepaint() {
            throw new UnsupportedOperationException("isAutoRepaint method not supported.");
        }

        @Override
        public void setAutoRepaint(boolean autoRepaint) {
            throw new UnsupportedOperationException("setAutoRepaint method not supported.");
        }

        @Override
        public Capable getCapable(String capableIFName) {
            try {
                Class<Capable> cap = Capable.class;
                Class<?> cl = Class.forName(capableIFName);
                if (cap.isAssignableFrom(cl) && cl.isInstance(this)) {
                    return this;
                }
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
            return null;
        }
    }

    protected class TaskDoneRunnable
    implements Runnable {
        String taskName = "";

        public TaskDoneRunnable(String taskName) {
            this.taskName = taskName;
        }

        @Override
        public void run() {
            VavBatchJob.this.notifyTaskDone(this.taskName);
        }
    }

    protected class TaskFailedRunnable
    implements Runnable {
        String taskName = "";
        Exception exe = null;
        String reason = "";

        public TaskFailedRunnable(String taskName, String reasn, Exception e2) {
            this.taskName = taskName;
            this.exe = e2;
            this.reason = reasn;
        }

        @Override
        public void run() {
            VavBatchJob.this.notifyTaskFailed(this.taskName, this.reason, this.exe);
        }
    }

    protected class FireErrorRunnable
    implements Runnable {
        Object oldValue = null;
        Object newValue = null;

        public FireErrorRunnable(Object oldValue, Object newValue) {
            this.oldValue = oldValue;
            this.newValue = newValue;
        }

        @Override
        public void run() {
            VavBatchJob.this.pcs.firePropertyChange(VavBatchJob.PROCESSING_ERROR_PROPERTY, this.oldValue, this.newValue);
        }
    }

    protected class TaskProgressRunnable
    implements Runnable {
        String taskName = "";
        int units = 0;
        XpBufferedImage image = null;

        public TaskProgressRunnable(String taskName, int units, XpBufferedImage image) {
            this.taskName = taskName;
            this.units = units;
            this.image = image;
        }

        @Override
        public void run() {
            VavBatchJob.this.notifyTaskProgress(this.taskName, this.units, this.image);
        }
    }

    protected class TaskBeginRunnable
    implements Runnable {
        String taskName = "";
        int units = 0;

        public TaskBeginRunnable(String taskName, int units) {
            this.taskName = taskName;
            this.units = units;
        }

        @Override
        public void run() {
            VavBatchJob.this.logger.log(Level.INFO, "TID=VAV_INVOKE_LATER end");
            VavBatchJob.this.notifyTaskBegin(this.taskName, this.units);
        }
    }
}

