/*
 * Decompiled with CFR 0.152.
 */
package com.ge.med.cse.cvf.j3d.vav;

import com.ge.med.cse.cvf.j3d.vav.VVBatchProtocol;
import com.ge.med.cse.cvf.j3d.vav.VavRectPrismBatchModel;
import com.ge.med.cse.cvf.j3d.vav.VavRotateBatchModel;
import com.ge.med.cse.cvf.util.CvPropertiesManager;
import com.ge.med.idc.XjVolumeGeometry;
import com.ge.med.idc.XjVolumeModel;
import com.ge.med.terra.jami.XpSlice;
import com.ge.med.terra.jami.j3d.T3DViewport;
import java.awt.Dimension;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;

public abstract class VavBatchModel {
    public static final String REFORMAT_PLANE_AXIAL = "AXIAL";
    public static final String REFORMAT_PLANE_SAGITTAL = "SAGITTAL";
    public static final String REFORMAT_PLANE_CORONAL = "CORONAL";
    public static final String REFORMAT_PLANE_OB_AXIAL = "OB_AXIAL";
    public static final String REFORMAT_PLANE_OB_SAGITTAL = "OB_SAGITTAL";
    public static final String REFORMAT_PLANE_OB_CORONAL = "OB_CORONAL";
    public static final String BATCH_TYPE_PROPERTY = "BATCH_TYPE_PROPERTY";
    public static final String NUM_IMAGES_PROPERTY = "NUM_IMAGES_PROPERTY";
    public static final String FOV_PROPERTY = "FOV_PROPERTY";
    public static final String THICKNESS_PROPERTY = "THICKNESS_PROPERTY";
    public static final String RENDER_MODE_PROPERTY = "RENDER_MODE_PROPERTY";
    public static final String SERIES_DESCRIPTION_PROPERTY = "SERIES_DESCRIPTION_PROPERTY";
    public static final String BATCHMODEL_UPDATED_PROPERTY = "BATCHMODEL_UPDATED_PROPERTY";
    public static final double ZERO = 0.001;
    public static boolean autoEdgeEnabled = CvPropertiesManager.getBoolean("vav.isAutoEdgeEnabled", true);
    protected final PropertyChangeSupport pcs = new PropertyChangeSupport(this);
    protected double thickness = 0.0;
    protected double fov = 0.0;
    protected int pixelWidth = Integer.parseInt(CvPropertiesManager.getProperty("vav.pixelWidth", "512"));
    protected int pixelHeight = Integer.parseInt(CvPropertiesManager.getProperty("vav.pixelHeight", "512"));
    protected String renderStyle = VVBatchProtocol.defaultRenderingQuality() == 2 ? "MAJOR_AXIS_AVERAGE" : "AVERAGE";
    protected String seriesDescription = "Reformatted";
    protected boolean centerOnVolume = false;
    protected boolean fitFovToVolume = false;
    protected boolean fitToVolume = false;
    protected boolean inverted = false;
    protected boolean save = true;
    private boolean autoRun = true;
    protected XjVolumeGeometry boundingBox = null;
    protected boolean doAutoEdge = autoEdgeEnabled;
    protected final Logger logger = Logger.getLogger("com.ge.med.cse.cvf.j3d.vav");

    public static VavBatchModel createBatchModel(String protocolFile) {
        try {
            VVBatchProtocol vv = VVBatchProtocol.getBatchProtocol(protocolFile);
            return VavBatchModel.createBatchModel(vv);
        }
        catch (FileNotFoundException e2) {
            e2.printStackTrace();
        }
        catch (IOException e3) {
            e3.printStackTrace();
        }
        return null;
    }

    public static VavBatchModel createBatchModel(VVBatchProtocol protocol) {
        if (protocol == null) {
            return null;
        }
        VavBatchModel model = null;
        if (protocol.model.equals("Oblique")) {
            model = new VavRectPrismBatchModel(protocol);
        } else if (protocol.model.equals("fan")) {
            model = new VavRotateBatchModel(protocol);
            ((VavRotateBatchModel)model).set3DRotationMode(false);
        } else if (protocol.model.equals("Rotation")) {
            model = new VavRotateBatchModel(protocol);
            ((VavRotateBatchModel)model).set3DRotationMode(true);
        }
        return model;
    }

    public abstract void loadFromProtocol(VVBatchProtocol var1);

    public abstract void saveToProtocol(VVBatchProtocol var1);

    public abstract int getNumImages();

    public abstract double[] getSliceEyePoint(int var1, double[] var2);

    public abstract double[] getSliceLookPoint(int var1, double[] var2);

    public abstract double[] getSliceUp(int var1, double[] var2);

    public abstract XpSlice getSlice(int var1);

    public abstract void setTarget(XjVolumeModel var1);

    public abstract XjVolumeModel getTargetVolumeModel();

    public abstract void setTarget(XjVolumeGeometry var1);

    public abstract XjVolumeGeometry getTargetVolume();

    public abstract void setTarget(T3DViewport var1);

    public abstract T3DViewport getTargetPort();

    public abstract boolean isTargetSet();

    public abstract String getBatchType();

    public double getThickness() {
        return this.thickness;
    }

    public synchronized void setThickness(double thickness) {
        double oldthk = this.getThickness();
        if (oldthk != thickness) {
            if (thickness < 0.0) {
                String msg = "Attempting to set invalid thickness (" + thickness + " mm). Thickness must be greater than or equal to zero. Converting to positive value.";
                this.logger.log(Level.WARNING, "{0} SEV6 " + msg, "TID=VAV_BATCH_PROTOCOL");
                thickness = -thickness;
            }
            this.thickness = thickness;
            this.pcs.firePropertyChange(THICKNESS_PROPERTY, new Double(oldthk), new Double(this.thickness));
        }
    }

    public double getFov() {
        return this.fov;
    }

    public synchronized void setFov(double fov) {
        double oldfov = this.fov;
        if (oldfov != fov) {
            if (fov < 0.0) {
                String msg = "Attempting to set invalid FOV (" + fov + " mm). FOV must be greater than zero. Converting to positive value.";
                this.logger.log(Level.WARNING, "{0} SEV6 " + msg, "TID=VAV_BATCH_PROTOCOL");
                fov = -fov;
            } else if (fov == 0.0) {
                String msg = "Attempting to set invalid FOV (" + fov + " mm). FOV must be greater than zero. This will be reverted to the best fit DFOV for the view based on volume dimensions";
                this.logger.log(Level.WARNING, "{0} SEV6 " + msg, "TID=VAV_BATCH_PROTOCOL");
            }
            this.fov = fov;
            this.pcs.firePropertyChange(FOV_PROPERTY, new Double(oldfov), new Double(this.fov));
        }
    }

    public boolean isInverted() {
        return this.inverted;
    }

    public void setInverted(boolean invert) {
        this.inverted = invert;
    }

    public Dimension getPixelDimension() {
        return new Dimension(this.getPixelWidth(), this.getPixelHeight());
    }

    public int[] getDimension(int[] dim) {
        if (dim == null || dim.length != 2) {
            dim = new int[]{this.getPixelWidth(), this.getPixelHeight()};
        }
        return dim;
    }

    public int getPixelWidth() {
        return this.pixelWidth;
    }

    public int getPixelHeight() {
        return this.pixelHeight;
    }

    public void setPixelDimension(Dimension d2) {
        if (d2.width > 0 && d2.height > 0) {
            this.pixelWidth = d2.width;
            this.pixelHeight = d2.height;
        } else {
            String msg = "Attempting to set invalid pixel dimension (" + d2.width + "," + d2.height + ")";
            this.logger.log(Level.WARNING, "{0} SEV6 " + msg, "TID=VAV_BATCH_PROTOCOL");
        }
    }

    public String getRenderStyle() {
        return this.renderStyle;
    }

    public void setRenderStyle(String renderStyle) {
        String oldrs = this.getRenderStyle();
        if (renderStyle != null && !renderStyle.equals(oldrs)) {
            this.renderStyle = renderStyle;
            this.pcs.firePropertyChange(RENDER_MODE_PROPERTY, oldrs, this.renderStyle);
        }
    }

    public String getSeriesDescription() {
        return this.seriesDescription;
    }

    public void setSeriesDescription(String seriesDescription) {
        String oldsd = this.getSeriesDescription();
        if (seriesDescription != null && !seriesDescription.equals(oldsd)) {
            this.seriesDescription = seriesDescription;
            this.pcs.firePropertyChange(SERIES_DESCRIPTION_PROPERTY, oldsd, this.seriesDescription);
        }
    }

    public String toString() {
        return this.getSeriesDescription();
    }

    public void addPropertyChangeListener(PropertyChangeListener pcl) {
        this.pcs.addPropertyChangeListener(pcl);
    }

    public void addPropertyChangeListener(String prop, PropertyChangeListener pcl) {
        this.pcs.addPropertyChangeListener(prop, pcl);
    }

    public void removePropertyChangeListener(PropertyChangeListener pcl) {
        this.pcs.removePropertyChangeListener(pcl);
    }

    public void removePropertyChangeListener(String prop, PropertyChangeListener pcl) {
        this.pcs.removePropertyChangeListener(prop, pcl);
    }

    public synchronized void setCenterOnVolume(boolean center) {
        this.centerOnVolume = center;
    }

    public synchronized boolean getCenterOnVolume() {
        return this.centerOnVolume;
    }

    public synchronized void setFitFovToVolume(boolean fitFov) {
        this.fitFovToVolume = fitFov;
    }

    public synchronized boolean getFitFovToVolume() {
        return this.fitFovToVolume;
    }

    public synchronized void setFitToVolume(boolean fit2vol) {
        this.fitToVolume = fit2vol;
    }

    public synchronized boolean getFitToVolume() {
        return this.fitToVolume;
    }

    public void setSaving(boolean save) {
        this.save = save;
    }

    public boolean isSaving() {
        return this.save;
    }

    public void setAutoRun(boolean auto) {
        this.autoRun = auto;
    }

    public boolean isAutoRun() {
        return this.autoRun;
    }

    public XjVolumeGeometry getBoundingBox() {
        return this.boundingBox;
    }

    public void setBoundingBox(XjVolumeGeometry boundingBox) {
        this.boundingBox = boundingBox;
    }

    public boolean isAutoEdgeEnabled() {
        return this.doAutoEdge;
    }

    public void enableAutoEdge(boolean doAutoEdge) {
        this.doAutoEdge = doAutoEdge;
    }
}

