/*
 * Decompiled with CFR 0.152.
 */
package com.ge.med.cse.cvf.j3d.vav;

import com.ge.med.cse.cvf.idc.ViewTypeCapable;
import com.ge.med.cse.cvf.j3d.J3DViewport;
import com.ge.med.cse.cvf.j3d.utils.J3DGeomUtils;
import com.ge.med.cse.cvf.j3d.vav.VVBatchProtocol;
import com.ge.med.cse.cvf.j3d.vav.VavBatchModel;
import com.ge.med.cse.cvf.util.CvPropertiesManager;
import com.ge.med.idc.XjVolumeGeometry;
import com.ge.med.idc.XjVolumeModel;
import com.ge.med.jnu.JnQuaternion;
import com.ge.med.jnu.JnVector3d;
import com.ge.med.terra.jami.CPoint;
import com.ge.med.terra.jami.CTransform;
import com.ge.med.terra.jami.XpSlice;
import com.ge.med.terra.jami.j3d.T3DViewport;
import com.ge.med.terra.jami.j3d.XjVolumeUtils;
import java.awt.Dimension;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Locale;
import java.util.logging.Level;

public class VavRotateBatchModel
extends VavBatchModel {
    public static final String CENTER_POINT_PROPERTY = "CENTER_POINT_PROPERTY";
    public static final String INITIAL_NORMAL_PROPERTY = "INITIAL_NORMAL_VECTOR_PROPERTY";
    public static final String ROTATE_DIRECTION_PROPERTY = "ROTATE_DIRECTION_PROPERTY";
    public static final String ANGLE_BETWEEN_VIEWS_PROPERTY = "ANGLE_BETWEEN_VIEWS_PROPERTY";
    protected XjVolumeGeometry targetVolume = null;
    protected XjVolumeModel targetVolumeModel = null;
    protected T3DViewport targetViewport = null;
    protected boolean initalized_ = false;
    protected JnVector3d rasOrig = new JnVector3d();
    protected JnVector3d rside = new JnVector3d();
    protected JnVector3d aside = new JnVector3d();
    protected JnVector3d sside = new JnVector3d();
    protected CPoint volCenter = new CPoint(2);
    protected CTransform vox2ras = new CTransform();
    protected CTransform ras2vox = new CTransform();
    protected double tilt = 0.0;
    protected String initialImagePlane = null;
    protected CPoint initialUpVec = null;
    protected JnVector3d rightVec = new JnVector3d();
    protected JnVector3d rotateDirectionVec = new JnVector3d();
    protected JnVector3d rotateAxisVec = new JnVector3d();
    protected JnQuaternion rotateQuat = new JnQuaternion();
    protected int numImages = 0;
    protected CPoint center = null;
    protected CPoint initialNormal = null;
    protected double angle = 18.0;
    protected String rotateDirection = "right";
    protected boolean rotate3DMode = true;
    protected boolean alignedToVolume = true;
    protected String refViewPlane = null;
    protected boolean updateDirty = true;
    private final boolean useImageDims = CvPropertiesManager.getBoolean("vav.pixeldim.useinputimagedim", false);
    public static final double MAX_THICKNESS_FACTOR = 32.0;
    private PropertyChangeListener renderStyleListener = new PropertyChangeListener(){

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            if (VavRotateBatchModel.this.isPortMode3D()) {
                VavRotateBatchModel.this.set3DRotationMode(true);
                VavRotateBatchModel.this.setRenderStyle(VavRotateBatchModel.this.targetViewport.getRenderStyle());
            } else {
                VavRotateBatchModel.this.set3DRotationMode(false);
                VavRotateBatchModel.this.setRenderStyle(VavRotateBatchModel.this.renderStyle);
            }
        }
    };
    PropertyChangeListener cameraListener = new PropertyChangeListener(){

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            if (VavRotateBatchModel.this.targetViewport instanceof J3DViewport && ((J3DViewport)VavRotateBatchModel.this.targetViewport).getViewType().equalsIgnoreCase("3D")) {
                double[] look = VavRotateBatchModel.this.targetViewport.getLookPoint(null);
                double[] eye = VavRotateBatchModel.this.targetViewport.getEyePoint(null);
                VavRotateBatchModel.this.setCenter(new CPoint(look, 2));
                VavRotateBatchModel.this.setInitialNormal(new CPoint(eye[0] - look[0], eye[1] - look[1], eye[2] - look[2], 2));
            }
        }
    };
    private CPoint normalVec = new CPoint();
    private JnVector3d upVec = new JnVector3d();
    private CPoint ul = new CPoint(2);
    private CPoint ur = new CPoint(2);
    private CPoint br = new CPoint(2);

    public VavRotateBatchModel() {
    }

    public VavRotateBatchModel(CPoint center, CPoint initialNormal, String rotateDirection, double fov, int numImages) {
        String msg;
        if (fov < 0.0) {
            msg = "Attempting to set invalid fov (" + fov + "). FOV must be greater than zero. Converting to a positive value.";
            this.logger.log(Level.WARNING, "{0} SEV6 " + msg, "TID=VAV_BATCH_PROTOCOL");
            fov = -fov;
        }
        this.fov = fov;
        if (numImages < -1) {
            msg = "Attempting to set invalid number of images (" + numImages + "). Number of images must be greater than one. Converting to a positive value.";
            this.logger.log(Level.WARNING, "{0} SEV6 " + msg, "TID=VAV_BATCH_PROTOCOL");
            numImages = -numImages;
        }
        this.numImages = numImages;
        this.center = center;
        this.initialNormal = initialNormal;
        this.rotateDirection = rotateDirection;
    }

    public VavRotateBatchModel(VVBatchProtocol protocol) {
        this.loadFromProtocol(protocol);
    }

    @Override
    public void loadFromProtocol(VVBatchProtocol protocol) {
        if ("fan".equals(protocol.model)) {
            this.set3DRotationMode(false);
        } else if ("Rotation".equals(protocol.model)) {
            this.set3DRotationMode(true);
        } else {
            String msg = "Constructing an fan model with a protocol of type " + protocol.model + ".";
            this.logger.log(Level.INFO, "{0} SEV6 " + msg, "TID=VAV_BATCH_PROTOCOL");
            this.set3DRotationMode(false);
        }
        this.seriesDescription = protocol.name;
        this.fov = protocol.fieldOfView * 10.0;
        if (this.fov < 0.0) {
            this.fov = -this.fov;
        }
        this.angle = protocol.rotation;
        this.thickness = protocol.thickness;
        if (protocol.voxelSize > 0.0) {
            this.thickness *= protocol.voxelSize;
        }
        this.numImages = protocol.numberOfViews;
        if (this.numImages < 0) {
            this.numImages = -this.numImages;
        }
        if (protocol.autoFilming != null && protocol.autoFilming.equalsIgnoreCase("On") || protocol.autoFilming == null || protocol.autoFilming.equalsIgnoreCase("Off")) {
            // empty if block
        }
        if (this.center == null) {
            this.center = new CPoint();
        }
        this.center.setPoint(protocol.centerX, protocol.centerY, 0.0, (byte)3);
        if (this.initialUpVec == null) {
            this.initialUpVec = new CPoint();
        }
        this.initialUpVec.setPoint(protocol.vectorX, protocol.vectorY, 0.0, (byte)1);
        this.initialNormal = null;
        this.initialImagePlane = null;
        this.rotateDirection = protocol.rotateDirection;
        this.renderStyle = protocol.getT3DRenderStyle();
        if (protocol.autoFilming != null && protocol.autoFilming.equals("On") || protocol.autoFilming == null || protocol.autoFilming.equals("Off")) {
            // empty if block
        }
        if (protocol.viewName != null) {
            if (protocol.viewName.toLowerCase(Locale.ENGLISH).contains("Coronal".toLowerCase(Locale.ENGLISH))) {
                this.refViewPlane = "OB_CORONAL";
            } else if (protocol.viewName.toLowerCase(Locale.ENGLISH).contains("Sagittal".toLowerCase(Locale.ENGLISH))) {
                this.refViewPlane = "OB_SAGITTAL";
            } else if (protocol.viewName.toLowerCase(Locale.ENGLISH).contains("Axial".toLowerCase(Locale.ENGLISH))) {
                this.refViewPlane = "OB_AXIAL";
            }
        }
        this.logger.log(Level.INFO, "Protocol loaded with vaules\nDescription: " + protocol.name + "\n" + "View Name: " + protocol.viewName + "\n" + "Model: " + protocol.model + "\n" + "Rotation: " + protocol.rotation + "\n" + "NumberOfViews: " + protocol.numberOfViews + "\n" + "FieldOfView: " + protocol.fieldOfView + "\n" + "spacing: " + protocol.spacing + "\n" + "thickness: " + protocol.thickness + "\n" + "CenterX: " + protocol.centerX + "\n" + "centerY: " + protocol.centerY + "\n" + "vectorX: " + protocol.vectorX + "\n" + "vectorY: " + protocol.vectorY + "\n" + "voxelSize: " + protocol.voxelSize + "\n" + "renderMode: " + protocol.renderMode + "\n" + "End of Protocol");
        this.applyContrainingVolume();
    }

    @Override
    public void saveToProtocol(VVBatchProtocol protocol) {
        protocol.model = "fan";
        protocol.numberOfViews = this.getNumImages();
        protocol.rotation = this.getAngleBetweenViews();
        protocol.thickness = this.getThickness();
        protocol.fieldOfView = this.getFov() / 10.0;
        protocol.viewName = "";
        if (this.targetViewport != null) {
            ViewTypeCapable vtcap = (ViewTypeCapable)this.targetViewport.getCapable(ViewTypeCapable.class.getName());
            if (vtcap != null) {
                String vname = vtcap.getViewType();
                if ("AXIAL".equals(vname)) {
                    protocol.viewName = "Axial";
                } else if ("CORONAL".equals(vname)) {
                    protocol.viewName = "Coronal";
                } else if ("SAGITTAL".equals(vname)) {
                    protocol.viewName = "Sagittal";
                }
            }
            CPoint center = this.getCenter();
            this.targetViewport.getT3DComponent().getTransform((byte)2, (byte)1).transform(center);
            protocol.centerX = center.x / (double)this.targetViewport.getWidth();
            protocol.centerY = center.y / (double)this.targetViewport.getHeight();
            CPoint up = new CPoint(this.initialUpVec);
            this.targetViewport.getT3DComponent().getTransform((byte)2, (byte)1).transform(up);
            up.normalize();
            protocol.vectorX = up.x;
            protocol.vectorY = up.y;
        }
        protocol.rotateDirection = this.getRotateDirection();
        protocol.renderMode = this.getRenderStyle();
    }

    public synchronized CPoint getCenter() {
        return new CPoint(this.center);
    }

    public synchronized CPoint getInitialNormal() {
        return new CPoint(this.initialNormal);
    }

    public synchronized String getRotateDirection() {
        return this.rotateDirection;
    }

    public synchronized double getAngleBetweenViews() {
        return this.angle;
    }

    @Override
    public synchronized int getNumImages() {
        return this.numImages;
    }

    @Override
    public String getBatchType() {
        return "Rotate";
    }

    public boolean is3DRotationMode() {
        return this.rotate3DMode;
    }

    public void set3DRotationMode(boolean rotate3D) {
        if (this.rotate3DMode != rotate3D) {
            this.rotate3DMode = rotate3D;
            this.applyContrainingVolume();
        }
    }

    @Override
    public void setRenderStyle(String renderStyle) {
        String style = this.checkRenderStyle(renderStyle);
        if (!renderStyle.equals(style)) {
            this.logger.log(Level.WARNING, "Invalid render style " + renderStyle + " , Changed it to " + style);
        }
        super.setRenderStyle(style);
    }

    private String checkRenderStyle(String renderStyle) {
        boolean cubic;
        if (this.rotate3DMode) {
            if (this.isPortMode3D()) {
                return this.targetViewport.getRenderStyle();
            }
            if ("VOLUME".equals(renderStyle) || "FULLBODY_AVERAGE".equals(renderStyle) || "FULLBODY_MINIP".equals(renderStyle) || "FULLBODY_MIP".equals(renderStyle)) {
                return renderStyle;
            }
            if ("MAJOR_AXIS_MIP".equals(renderStyle) || "MIP".equals(renderStyle)) {
                return "FULLBODY_MIP";
            }
            if ("MAJOR_AXIS_MINIP".equals(renderStyle) || "MINIP".equals(renderStyle)) {
                return "FULLBODY_MINIP";
            }
            if ("MAJOR_AXIS_AVERAGE".equals(renderStyle) || "AVERAGE".equals(renderStyle)) {
                return "FULLBODY_AVERAGE";
            }
            return "FULLBODY_MIP";
        }
        boolean bl = cubic = VVBatchProtocol.defaultRenderingQuality() == 2;
        if ("FULLBODY_MIP".equals(renderStyle) || "VOLUME".equals(renderStyle)) {
            return cubic ? "MAJOR_AXIS_MIP" : "MIP";
        }
        if ("FULLBODY_MINIP".equals(renderStyle)) {
            return cubic ? "MAJOR_AXIS_MINIP" : "MINIP";
        }
        if ("FULLBODY_AVERAGE".equals(renderStyle)) {
            return cubic ? "MAJOR_AXIS_AVERAGE" : "AVERAGE";
        }
        return renderStyle;
    }

    public synchronized void setCenter(CPoint center) {
        CPoint oldcenter;
        CPoint cPoint = oldcenter = this.center == null ? null : new CPoint(this.center);
        if (this.center == null) {
            this.center = new CPoint();
        }
        if (this.initalized_ && (this.getCenterOnVolume() || this.getFitToVolume())) {
            this.center.setPoint(this.volCenter);
        } else {
            this.center.setPoint(center);
        }
        if (this.initalized_) {
            int[] dims = this.targetVolume.getVolumeDimensions(null);
            if (!J3DGeomUtils.isInVolume(this.center.generateArray(), dims, this.ras2vox)) {
                this.center.setPoint(this.volCenter);
            }
        }
        if (!this.center.equals(oldcenter)) {
            this.pcs.firePropertyChange(CENTER_POINT_PROPERTY, oldcenter, new CPoint(this.center));
        }
    }

    @Override
    public synchronized void setCenterOnVolume(boolean center) {
        super.setCenterOnVolume(center);
        if (this.getCenterOnVolume()) {
            this.setCenter(this.getCenter());
        }
    }

    public synchronized void setInitialNormal(CPoint initialNormal) {
        if (!this.initialNormal.equals(initialNormal)) {
            this.initialNormal.setPoint(initialNormal);
            this.initialUpVec = null;
            this.initialImagePlane = null;
            this.applyContrainingVolume();
            this.pcs.firePropertyChange(INITIAL_NORMAL_PROPERTY, initialNormal, this.initialNormal);
        }
    }

    @Override
    public synchronized void setFov(double fov) {
        if (this.initalized_ && (fov <= 0.0 || this.getFitFovToVolume() || this.getFitToVolume())) {
            double[] eye = new double[]{this.center.x + this.initialNormal.x, this.center.y + this.initialNormal.y, this.center.z + this.initialNormal.z};
            double[] dfov = J3DGeomUtils.getBestFitDfov(this.targetVolume, this.center.toArray(), this.initialUpVec.toArray(), eye);
            if (fov <= 0.0 || fov != Math.max(dfov[0], dfov[1])) {
                fov = Math.max(dfov[0], dfov[1]);
            }
        }
        super.setFov(fov);
    }

    @Override
    public synchronized void setFitFovToVolume(boolean fitFov) {
        super.setFitFovToVolume(fitFov);
        if (this.getFitFovToVolume()) {
            this.setFov(this.getFov());
        }
    }

    @Override
    public synchronized void setFitToVolume(boolean fit2vol) {
        super.setFitToVolume(fit2vol);
        if (this.getFitToVolume()) {
            this.setCenter(this.getCenter());
            this.setFov(this.getFov());
        }
    }

    public synchronized void setRotateDirection(String rotateDirection) {
        if (!this.getRotateDirection().equals(rotateDirection)) {
            if (!this.is3DRotationMode() && ("up".equals(rotateDirection) || "down".equals(rotateDirection))) {
                return;
            }
            this.rotateDirection = rotateDirection;
            this.applyContrainingVolume();
            this.pcs.firePropertyChange(ROTATE_DIRECTION_PROPERTY, null, this.rotateDirection);
        }
    }

    public synchronized double setAngleBetweenViews(double angle) {
        return this.setAngleBetweenViews(angle, true);
    }

    public synchronized double setAngleBetweenViews(double angle, boolean updateImages) {
        if (this.angle != angle) {
            if (angle > 180.0) {
                angle = 180.0;
            } else if (angle < 1.0) {
                angle = 1.0;
            }
            double oldAngle = this.angle;
            this.angle = angle;
            this.pcs.firePropertyChange(ANGLE_BETWEEN_VIEWS_PROPERTY, oldAngle, this.angle);
            if (updateImages) {
                double totalAngle = oldAngle * (double)(this.getNumImages() - 1);
                int numImages = (int)Math.round(totalAngle / this.angle) + 1;
                this.setNumImages(numImages, false);
            }
        }
        return this.angle;
    }

    public synchronized int setNumImages(int numImages) {
        return this.setNumImages(numImages, true);
    }

    public synchronized int setNumImages(int numImages, boolean updateAngle) {
        if (numImages != this.getNumImages() || numImages < 1 || numImages > 180) {
            if (numImages < 1) {
                numImages = 1;
            } else if (numImages > 180) {
                numImages = 180;
            }
            int oldNumImages = this.numImages;
            this.numImages = numImages;
            if (oldNumImages > 0) {
                if (updateAngle) {
                    double totalAngle = (double)(oldNumImages - 1) * this.getAngleBetweenViews();
                    double newAngle = totalAngle / (double)(numImages - 1);
                    this.setAngleBetweenViews(newAngle, false);
                }
            } else if (updateAngle) {
                this.angle = 180.0 / (double)numImages;
                this.setAngleBetweenViews(this.angle, false);
            }
            this.pcs.firePropertyChange("NUM_IMAGES_PROPERTY", oldNumImages, this.numImages);
        }
        return numImages;
    }

    public synchronized void setInitialImagePlane(String initialPlane) {
        if (initialPlane == null) {
            initialPlane = "";
        }
        if (!initialPlane.equals(this.initialImagePlane)) {
            this.initialImagePlane = initialPlane;
            this.initialNormal = null;
            this.initialUpVec = null;
            this.applyContrainingVolume();
        }
    }

    @Override
    public boolean isTargetSet() {
        return this.initalized_;
    }

    @Override
    public void setTarget(XjVolumeGeometry volume) {
        if (volume != this.targetVolume) {
            this.targetVolume = volume;
            this.targetVolumeModel = null;
            this.targetViewport = null;
            this.rasOrig.set(0.0, 0.0, 0.0);
            this.rside.set(0.0, 0.0, 0.0);
            this.aside.set(0.0, 0.0, 0.0);
            this.sside.set(0.0, 0.0, 0.0);
            this.volCenter.set(0.0, 0.0, 0.0);
            this.vox2ras.loadIdentity();
            this.ras2vox.loadIdentity();
            this.initalized_ = false;
            if (this.targetVolume != null) {
                this.init();
                this.initalized_ = true;
                this.applyContrainingVolume();
            }
        }
    }

    @Override
    public void setTarget(T3DViewport port) {
        if (this.targetViewport != null) {
            this.targetViewport.removePropertyChangeListener("renderStyle", this.renderStyleListener);
        }
        if (port.getVolume() != this.targetVolume) {
            this.targetViewport = port;
            this.targetVolume = port.getVolume();
            this.targetVolumeModel = port.getVolumeModel();
            this.rasOrig.set(0.0, 0.0, 0.0);
            this.rside.set(0.0, 0.0, 0.0);
            this.aside.set(0.0, 0.0, 0.0);
            this.sside.set(0.0, 0.0, 0.0);
            this.volCenter.set(0.0, 0.0, 0.0);
            this.vox2ras.loadIdentity();
            this.ras2vox.loadIdentity();
            this.init();
            this.initalized_ = true;
            this.applyContrainingVolume();
            this.targetViewport.addPropertyChangeListener("renderStyle", this.renderStyleListener);
        } else if (port != this.targetViewport) {
            this.targetViewport = port;
            this.targetVolumeModel = port.getVolumeModel();
            this.targetVolume = port.getVolume();
            this.initalized_ = true;
            this.applyContrainingVolume();
            this.targetViewport.addPropertyChangeListener("renderStyle", this.renderStyleListener);
        }
        if (this.isPortMode3D()) {
            this.renderStyle = this.targetViewport.getRenderStyle();
            this.set3DRotationMode(true);
        } else {
            this.set3DRotationMode(false);
        }
    }

    @Override
    public T3DViewport getTargetPort() {
        return this.targetViewport;
    }

    @Override
    public XjVolumeGeometry getTargetVolume() {
        return this.targetVolume;
    }

    @Override
    public void setTarget(XjVolumeModel volumeModel) {
        if (volumeModel != this.targetVolumeModel) {
            this.targetVolumeModel = volumeModel;
            this.targetVolume = volumeModel.getVolume();
            this.targetViewport = null;
            this.rasOrig.set(0.0, 0.0, 0.0);
            this.rside.set(0.0, 0.0, 0.0);
            this.aside.set(0.0, 0.0, 0.0);
            this.sside.set(0.0, 0.0, 0.0);
            this.volCenter.set(0.0, 0.0, 0.0);
            this.initalized_ = true;
            this.applyContrainingVolume();
        }
    }

    @Override
    public XjVolumeModel getTargetVolumeModel() {
        return this.targetVolumeModel;
    }

    private void init() {
        XjVolumeGeometry constraint;
        XjVolumeGeometry xjVolumeGeometry = this.targetVolume != null ? this.targetVolume : (this.targetViewport != null ? this.targetViewport.getVolume() : (constraint = this.targetVolumeModel != null ? this.targetVolumeModel.getVolume() : null));
        if (constraint != null) {
            J3DGeomUtils.calculateVoxelRASTransforms(constraint, this.vox2ras, this.ras2vox);
            J3DGeomUtils.alignVolumeToRAS(constraint, this.rasOrig, this.rside, this.aside, this.sside);
            this.tilt = XjVolumeUtils.calculateTilt(constraint);
            double[] center = XjVolumeUtils.getVolumeCenterRAS(constraint.getRASOfOrigin(null), constraint.getXDirectionRAS(null), constraint.getYDirectionRAS(null), constraint.getZDirectionRAS(null), constraint.getVolumeDimensions(null), null);
            this.volCenter.set(center);
        }
    }

    public synchronized void setTarget(JnVector3d parallelepipedOrigin, JnVector3d parallelepipedVector0, JnVector3d parallelepipedVector1, JnVector3d parallelepipedVector2) {
        this.targetVolume = new J3DGeomUtils.dummyVolume(parallelepipedOrigin.toArray(), parallelepipedVector0.toArray(), parallelepipedVector1.toArray(), parallelepipedVector2.toArray());
        this.targetViewport = null;
        this.targetVolumeModel = null;
        this.init();
        this.initalized_ = true;
        this.applyContrainingVolume();
    }

    private synchronized void applyContrainingVolume() {
        double[] centerPt;
        if (!this.initalized_) {
            return;
        }
        int[] dims = this.targetVolume.getVolumeDimensions(null);
        if (this.useImageDims) {
            this.setPixelDimension(new Dimension(dims[0], dims[1]));
        }
        if (this.center == null || this.getCenterOnVolume() || this.getFitToVolume()) {
            if (this.center == null) {
                this.center = new CPoint();
            }
            this.center.setPoint(this.volCenter);
        }
        if (this.center.csystem != 2) {
            this.convertPointToRAS(this.center);
        }
        if (!J3DGeomUtils.isInVolume(centerPt = new double[]{this.center.x, this.center.y, this.center.z}, dims, this.ras2vox)) {
            this.center.setPoint(this.volCenter);
        }
        if ((this.initialImagePlane == null || "".equals(this.initialImagePlane)) && this.initialNormal == null && this.initialUpVec == null) {
            this.initialImagePlane = "OB_AXIAL";
            this.alignedToVolume = true;
        }
        if (this.initialNormal == null) {
            this.initialNormal = new CPoint();
            if (this.initialUpVec != null) {
                this.calculateInitialNormalFromInitialUp();
            } else {
                double[] initialNorm = this.calculateInitialNormal();
                if (initialNorm != null) {
                    this.initialNormal.setPoint(initialNorm[0], initialNorm[1], initialNorm[2], (byte)2);
                }
            }
        }
        this.initialNormal.normalize();
        if (this.initialNormal.csystem != 2) {
            this.convertVectorToRAS(this.initialNormal);
        }
        if (this.initialUpVec == null) {
            this.calculateSliceUpVector();
        }
        if (this.numImages == 0) {
            this.numImages = (int)Math.floor(180.0 / this.angle);
        }
        if (this.thickness == 0.0) {
            this.thickness = J3DGeomUtils.getMinSliceThickness(this.targetVolume, this.initialNormal.toArray(), false);
        }
        if (this.getTargetPort() != null) {
            double minThickness = Math.abs(J3DGeomUtils.getMinSliceThickness(this.getTargetPort().getVolume(), this.getSliceLookPoint(0, null), this.getSliceEyePoint(0, null), false));
            if (this.thickness > minThickness && !this.targetViewport.getRenderStyle().startsWith("REFORMAT")) {
                if (this.thickness > 32.0 * minThickness) {
                    this.thickness = 32.0 * minThickness;
                }
            } else {
                this.thickness = minThickness;
            }
        }
        double[] eye = new double[]{this.center.x + this.initialNormal.x, this.center.y + this.initialNormal.y, this.center.z + this.initialNormal.z};
        double[] dfov = J3DGeomUtils.getBestFitDfov(this.targetVolume, this.center.toArray(), this.initialUpVec.toArray(), eye);
        if (this.fov <= 0.0 || (this.getFitFovToVolume() || this.getFitToVolume()) && this.fov != Math.max(dfov[0], dfov[1])) {
            this.fov = Math.max(dfov[0], dfov[1]);
        }
        this.calculateRotateDirection();
        this.pcs.firePropertyChange("BATCHMODEL_UPDATED_PROPERTY", false, true);
    }

    private void calculateSliceUpVector() {
        short rfmtPlane;
        if (this.initialUpVec == null) {
            this.initialUpVec = new CPoint(2);
        }
        if ((rfmtPlane = J3DGeomUtils.getPlaneType(this.initialNormal)) == 2 || rfmtPlane == 18) {
            if (this.alignedToVolume) {
                this.initialUpVec.set(this.aside);
            } else {
                this.initialUpVec.set(0.0, 1.0, 0.0);
            }
        } else if (rfmtPlane == 8 || rfmtPlane == 4 || rfmtPlane == 24 || rfmtPlane == 20) {
            if (this.alignedToVolume) {
                this.initialUpVec.set(this.sside);
            } else {
                this.initialUpVec.set(0.0, 0.0, 1.0);
            }
        }
        JnVector3d.cross(this.initialUpVec, this.initialNormal, this.rightVec);
        JnVector3d.cross(this.initialNormal, this.rightVec, this.initialUpVec);
    }

    private void calculateInitialNormalFromInitialUp() {
        this.initialUpVec.normalize();
        if (this.initialUpVec.csystem != 2) {
            this.convertVectorToRAS(this.initialUpVec);
        }
        if (this.targetViewport != null) {
            double[] eye = this.targetViewport.getEyePoint(null);
            double[] look = this.targetViewport.getLookPoint(null);
            this.rightVec.set(eye[0] - look[0], eye[1] - look[1], eye[2] - look[2]);
        } else if (this.refViewPlane != null) {
            CPoint normal = new CPoint(2);
            CPoint up = new CPoint(2);
            CPoint right = new CPoint(2);
            this.calculateSliceXYZVectors(this.refViewPlane, normal, up, right);
            this.rightVec.set(normal);
        }
        JnVector3d.cross(this.rightVec, this.initialUpVec, this.initialNormal);
        JnVector3d.cross(this.initialUpVec, this.initialNormal, this.rightVec);
    }

    private void calculateRotateDirection() {
        String rotateDir = this.getRotateDirection();
        if (!this.is3DRotationMode() && ("up".equals(rotateDir) || "down".equals(rotateDir))) {
            this.setRotateDirection("right");
        }
        if ("up".equals(rotateDir = this.getRotateDirection())) {
            this.rotateDirectionVec.set(this.initialUpVec);
        } else if ("down".equals(rotateDir)) {
            this.rotateDirectionVec.set(this.initialUpVec);
            this.rotateDirectionVec.multiplyBy(-1.0);
        } else if ("right".equals(rotateDir)) {
            this.rotateDirectionVec.set(this.rightVec);
        } else if ("left".equals(rotateDir)) {
            this.rotateDirectionVec.set(this.rightVec);
            this.rotateDirectionVec.multiplyBy(-1.0);
        } else {
            this.logger.log(Level.WARNING, "Invalid rotateDirection property.  Found: \"" + rotateDir + "\". Setting rotateDir to ROTATE_DIRECTION_RIGHT.");
            this.setRotateDirection("right");
            this.rotateDirectionVec.set(this.rightVec);
        }
        JnVector3d.cross(this.initialNormal, this.rotateDirectionVec, this.rotateAxisVec);
        this.rotateDirectionVec.normalize();
        this.rotateAxisVec.normalize();
    }

    private double[] calculateInitialNormal() {
        double[] normal = null;
        if (this.isPortMode3D()) {
            double[] look = this.targetViewport.getLookPoint(null);
            double[] eye = this.targetViewport.getEyePoint(null);
            this.setCenter(new CPoint(look, 2));
            normal = new CPoint(eye[0] - look[0], eye[1] - look[1], eye[2] - look[2], 2).toArray();
            this.targetViewport.removePropertyChangeListener("camera", this.cameraListener);
            this.targetViewport.addPropertyChangeListener("camera", this.cameraListener);
        } else {
            String initialPlane = this.initialImagePlane;
            if (initialPlane != null && !initialPlane.equals("")) {
                CPoint normal_ = new CPoint(0, 0, 0, 2);
                if (initialPlane.equals("AXIAL")) {
                    this.alignedToVolume = false;
                    normal_.set(0.0, 0.0, -1.0);
                } else if (initialPlane.equals("CORONAL")) {
                    this.alignedToVolume = false;
                    normal_.set(0.0, 1.0, 0.0);
                } else if (initialPlane.equals("SAGITTAL")) {
                    this.alignedToVolume = false;
                    normal_.set(-1.0, 0.0, 0.0);
                } else if (initialPlane.equals("OB_AXIAL")) {
                    normal_.set(this.sside);
                    normal_.scale(-1.0);
                } else if (initialPlane.equals("OB_CORONAL")) {
                    normal_.set(this.aside);
                } else if (initialPlane.equals("OB_SAGITTAL")) {
                    normal_.set(this.rside);
                    normal_.scale(-1.0);
                } else {
                    this.logger.log(Level.WARNING, "Invalid initialImagePlane property.  Found: \"" + initialPlane + "\". Setting initialImagePlane to IMAGE_PLANE_OB_CORONAL.");
                    normal_.set(this.aside);
                }
                normal = normal_.toArray();
            }
        }
        return normal;
    }

    private void convertPointToRAS(CPoint point) {
        if (!this.isTargetSet()) {
            return;
        }
        if (point.csystem != 2) {
            if (this.targetViewport != null) {
                if (point.csystem == 3) {
                    point.x *= (double)this.targetViewport.getWidth();
                    point.y *= (double)this.targetViewport.getHeight();
                    point.z = 0.0;
                    point.csystem = 1;
                }
                CPoint newPoint = this.targetViewport.getT3DComponent().transform(point, (byte)2);
                point.setPoint(newPoint);
            } else if (this.refViewPlane != null) {
                if (5 == point.csystem) {
                    CPoint pointras = new CPoint(2);
                    this.vox2ras.transform(point, pointras);
                    point.setPoint(pointras);
                } else if (1 == point.csystem || 3 == point.csystem) {
                    if (point.csystem == 3) {
                        point.x *= 512.0;
                        point.y *= 512.0;
                        point.z = 0.0;
                        point.csystem = 1;
                    }
                    CPoint c2 = new CPoint(this.volCenter);
                    double[] diff = new double[]{point.x - 256.0, point.y - 256.0, 0.0};
                    CPoint cvox = new CPoint(5);
                    this.ras2vox.transform(c2, cvox);
                    cvox.add(diff);
                    this.vox2ras.transform(cvox, c2);
                    point.setPoint(c2);
                }
            }
        }
    }

    private void convertVectorToRAS(CPoint vector) {
        if (!this.isTargetSet()) {
            return;
        }
        if (vector.csystem != 2) {
            if (this.targetViewport != null) {
                System.err.println(">>>>>>>>>>>>>>>>> " + Math.toDegrees(Math.atan2(vector.y, vector.x)));
                CPoint c2 = new CPoint((double)this.targetViewport.getWidth() * 0.5, (double)this.targetViewport.getHeight() * 0.5, 0.0, 1);
                CPoint cras = this.targetViewport.getT3DComponent().transform(c2, (byte)2);
                CPoint cvec = this.targetViewport.getT3DComponent().transform(c2, vector.csystem);
                cvec.add(vector);
                CPoint cras2 = this.targetViewport.getT3DComponent().transform(cvec, (byte)2);
                vector.setPoint(cras2);
                vector.sub(cras);
            } else if (5 == vector.csystem) {
                this.vox2ras.transform(vector);
                vector.csystem = (byte)2;
            } else if ((1 == vector.csystem || 3 == vector.csystem) && this.refViewPlane != null) {
                CPoint c3 = new CPoint(this.volCenter);
                CPoint normal = new CPoint(2);
                CPoint up = new CPoint(2);
                CPoint right = new CPoint(2);
                this.calculateSliceXYZVectors(this.refViewPlane, normal, up, right);
                c3.scaleAdd(vector.x, right);
                c3.scaleAdd(-vector.y, up);
                vector.setPoint(c3);
                vector.sub(this.volCenter);
            }
        }
    }

    private void calculateSliceXYZVectors(String refViewPlane, CPoint normal, CPoint up, CPoint right) {
        if (normal == null || up == null || right == null) {
            return;
        }
        if ("AXIAL".equals(refViewPlane)) {
            normal.set(0.0, 0.0, -1.0);
            up.set(0.0, 1.0, 0.0);
        } else if ("OB_AXIAL".equals(refViewPlane)) {
            normal.set(-this.sside.x, -this.sside.y, -this.sside.z);
            up.set(this.aside.x, this.aside.y, this.aside.z);
        } else if ("CORONAL".equals(refViewPlane)) {
            normal.set(0.0, 1.0, 0.0);
            up.set(0.0, 0.0, 1.0);
        } else if ("OB_CORONAL".equals(refViewPlane)) {
            normal.set(this.aside.x, this.aside.y, this.aside.z);
            up.set(this.sside.x, this.sside.y, this.sside.z);
        } else if ("SAGITTAL".equals(refViewPlane)) {
            normal.set(-1.0, 0.0, 0.0);
            up.set(0.0, 0.0, 1.0);
        } else if ("OB_SAGITTAL".equals(refViewPlane)) {
            normal.set(-this.rside.x, -this.rside.y, -this.rside.z);
            up.set(this.sside.x, this.sside.y, this.sside.z);
        }
        normal.normalize();
        JnVector3d.cross(up, normal, right);
        JnVector3d.cross(normal, right, up);
        up.normalize();
        right.normalize();
    }

    @Override
    public synchronized double getFov() {
        return super.getFov();
    }

    @Override
    public synchronized double[] getSliceEyePoint(int i2, double[] eye_pt) {
        if (i2 >= 0 && i2 < this.getNumImages()) {
            eye_pt = this.getSliceLookPoint(i2, eye_pt);
            this.rotateQuat.set(this.rotateAxisVec, Math.toRadians(-this.angle * (double)i2));
            this.rotateQuat.build3dRotationMatrix().transform(this.initialNormal, this.normalVec);
            eye_pt[0] = eye_pt[0] + this.normalVec.x;
            eye_pt[1] = eye_pt[1] + this.normalVec.y;
            eye_pt[2] = eye_pt[2] + this.normalVec.z;
            return eye_pt;
        }
        return null;
    }

    @Override
    public synchronized double[] getSliceLookPoint(int i2, double[] look_pt) {
        if (i2 >= 0 && i2 < this.getNumImages()) {
            if (look_pt == null) {
                look_pt = new double[]{this.center.x, this.center.y, this.center.z};
            }
            return look_pt;
        }
        return null;
    }

    @Override
    public synchronized double[] getSliceUp(int i2, double[] up_vect) {
        if (i2 >= 0 && i2 < this.getNumImages()) {
            if (up_vect == null) {
                up_vect = new double[3];
            }
            if (this.is3DRotationMode()) {
                this.rotateQuat.set(this.rotateAxisVec, Math.toRadians(-this.angle * (double)i2));
                this.rotateQuat.build3dRotationMatrix().transform(this.initialUpVec, this.upVec);
            } else {
                this.rotateQuat.set(this.rotateAxisVec, Math.toRadians(-this.angle * (double)i2));
                this.rotateQuat.build3dRotationMatrix().transform(this.initialNormal, this.normalVec);
                this.normalVec.normalize();
                short rfmtPlane = J3DGeomUtils.getPlaneType(this.normalVec);
                if (rfmtPlane == 2 || rfmtPlane == 18) {
                    if (this.alignedToVolume) {
                        this.upVec.set(this.aside);
                    } else {
                        this.upVec.set(0.0, 1.0, 0.0);
                    }
                } else if (rfmtPlane == 8 || rfmtPlane == 4 || rfmtPlane == 24 || rfmtPlane == 20) {
                    if (this.alignedToVolume) {
                        this.upVec.set(this.sside);
                    } else {
                        this.upVec.set(0.0, 0.0, 1.0);
                    }
                }
                JnVector3d.cross(this.upVec, this.normalVec, this.rightVec);
                JnVector3d.cross(this.normalVec, this.rightVec, this.upVec);
                this.upVec.normalize();
                this.rightVec.normalize();
            }
            up_vect[0] = this.upVec.x;
            up_vect[1] = this.upVec.y;
            up_vect[2] = this.upVec.z;
            return up_vect;
        }
        return null;
    }

    @Override
    public XpSlice getSlice(int i2) {
        int pw = this.getPixelWidth();
        int ph = this.getPixelHeight();
        double viewHeight = this.getFov();
        double aratio = pw / ph;
        double viewWidth = viewHeight * aratio;
        double spx = viewWidth / (double)pw;
        double spy = viewHeight / (double)ph;
        double[] look = this.getSliceLookPoint(i2, null);
        double[] eye = this.getSliceEyePoint(i2, null);
        JnVector3d n2 = new JnVector3d(eye);
        n2.sub(look);
        n2.normalize();
        JnVector3d up = new JnVector3d(this.getSliceUp(i2, null));
        up.normalize();
        JnVector3d r2 = JnVector3d.cross(up, n2);
        this.ul.x = look[0] - (double)(pw - 1) * 0.5 * r2.x * spx + (double)(ph - 1) * 0.5 * up.x * spy;
        this.ul.y = look[1] - (double)(pw - 1) * 0.5 * r2.y * spx + (double)(ph - 1) * 0.5 * up.y * spy;
        this.ul.z = look[2] - (double)(pw - 1) * 0.5 * r2.z * spx + (double)(ph - 1) * 0.5 * up.z * spy;
        this.ur.x = look[0] + (double)(pw - 1) * 0.5 * r2.x * spx + (double)(ph - 1) * 0.5 * up.x * spy;
        this.ur.y = look[1] + (double)(pw - 1) * 0.5 * r2.y * spx + (double)(ph - 1) * 0.5 * up.y * spy;
        this.ur.z = look[2] + (double)(pw - 1) * 0.5 * r2.z * spx + (double)(ph - 1) * 0.5 * up.z * spy;
        this.br.x = look[0] + (double)(pw - 1) * 0.5 * r2.x * spx - (double)(ph - 1) * 0.5 * up.x * spy;
        this.br.y = look[1] + (double)(pw - 1) * 0.5 * r2.y * spx - (double)(ph - 1) * 0.5 * up.y * spy;
        this.br.z = look[2] + (double)(pw - 1) * 0.5 * r2.z * spx - (double)(ph - 1) * 0.5 * up.z * spy;
        return new XpSlice(this.ul, this.ur, this.br, pw, ph);
    }

    private boolean isPortMode3D() {
        String rstyle;
        return this.targetViewport != null && ("FULLBODY_MIP".equals(rstyle = this.targetViewport.getRenderStyle()) || "FULLBODY_MINIP".equals(rstyle) || "FULLBODY_AVERAGE".equals(rstyle) || "VOLUME".equals(rstyle));
    }

    @Override
    public synchronized void setThickness(double thickness) {
        if (this.getTargetPort() != null) {
            boolean oblique = false;
            double minThickness = Math.abs(J3DGeomUtils.getMinSliceThickness(this.getTargetPort().getVolume(), this.getSliceLookPoint(0, null), this.getSliceEyePoint(0, null), oblique));
            if (thickness > minThickness && !this.targetViewport.getRenderStyle().startsWith("REFORMAT")) {
                if (thickness > 32.0 * minThickness) {
                    thickness = 32.0 * minThickness;
                }
            } else {
                thickness = minThickness;
            }
        }
        super.setThickness(thickness);
    }
}

