/*
 * Decompiled with CFR 0.152.
 */
package com.ge.med.cse.cvf.roi;

import com.ge.med.cse.cvf.util.CvPropertiesManager;
import com.ge.med.idc.ComponentCapable;
import com.ge.med.idc.SelectionCapable;
import com.ge.med.terra.jami.CPoint;
import com.ge.med.terra.jami.CTransform;
import com.ge.med.terra.jami.XpAppContext;
import com.ge.med.terra.jami.XpComponentCreator;
import com.ge.med.terra.jami.XpFrameVisualizer;
import com.ge.med.terra.jami.XpImage;
import com.ge.med.terra.jami.XpImage2DVc;
import com.ge.med.terra.jami.capable.GrayScaleCapable;
import com.ge.med.terra.jami.capable.Replicable;
import com.ge.med.terra.jami.marker.XpMarker;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.event.MouseEvent;
import java.awt.geom.Point2D;
import java.awt.image.BufferedImage;
import java.awt.image.DataBuffer;
import java.awt.image.DataBufferByte;
import java.awt.image.DataBufferInt;
import java.awt.image.DataBufferShort;
import java.awt.image.DataBufferUShort;
import java.awt.image.Raster;
import java.awt.image.RenderedImage;
import java.beans.PropertyChangeListener;
import javax.swing.SwingUtilities;
import javax.swing.event.AncestorEvent;
import javax.swing.event.AncestorListener;

public class CvContinuousReporter
extends XpMarker
implements Replicable,
GrayScaleCapable {
    public static final String VALUE_PROPERTY = "VALUE_PROP";
    public static final String IMAGECOORD_PROPERTY = "IMAGECOORD_PROPERTY";
    private static final int DIM = 8;
    private Raster r = null;
    private int width = 0;
    private int height = 0;
    private double value = 0.0;
    private boolean firstDraw = true;
    private double rescaleSlope = 1.0;
    private double rescaleIntercept = 0.0;
    private CPoint tempImgPt = new CPoint(0);
    private CPoint _cp0 = new CPoint();
    private CPoint img_pt = new CPoint(0);
    private CPoint disp_pt = new CPoint(1);
    private CPoint ras_pt = new CPoint(2);
    private Shape hotspot = null;
    private Rectangle bounds = new Rectangle();
    private boolean showMarker = CvPropertiesManager.getBoolean("cvf.reportcursor.showMarker", true);
    private boolean grayscaleMode = false;
    private Point2D prevCoordinate = null;
    private AncestorListener listener = new AncestorListener(){

        @Override
        public void ancestorAdded(AncestorEvent arg0) {
            if (CvContinuousReporter.this.getParent() instanceof XpImage2DVc) {
                ((XpImage2DVc)CvContinuousReporter.this.getParent()).addMouseMotionListener(CvContinuousReporter.this);
            }
            Component[] comp = ((XpImage2DVc)CvContinuousReporter.this.getParent()).getComponents();
            for (int j2 = 0; j2 < comp.length; ++j2) {
                if (comp[j2] == null) continue;
                comp[j2].addMouseMotionListener(CvContinuousReporter.this);
            }
        }

        @Override
        public void ancestorMoved(AncestorEvent arg0) {
        }

        @Override
        public void ancestorRemoved(AncestorEvent arg0) {
            if (CvContinuousReporter.this.getParent() instanceof XpImage2DVc) {
                ((XpImage2DVc)CvContinuousReporter.this.getParent()).removeMouseMotionListener(CvContinuousReporter.this);
            }
            Component[] comp = ((XpImage2DVc)CvContinuousReporter.this.getParent()).getComponents();
            for (int j2 = 0; j2 < comp.length; ++j2) {
                if (comp[j2] == null) continue;
                comp[j2].removeMouseMotionListener(CvContinuousReporter.this);
            }
        }
    };

    public CvContinuousReporter() {
        this(0.0, 0.0);
    }

    public CvContinuousReporter(double x2, double y2, Shape s2) {
        this(x2, y2);
        this.hotspot = s2;
        this.bounds.setBounds(s2.getBounds());
    }

    public CvContinuousReporter(double x2, double y2) {
        this.setForeground(Color.CYAN);
        this.img_pt.setPoint(x2, y2, 0.0, (byte)0);
        this.bounds.setBounds(-8, -8, 16, 16);
        this.addMouseListener(this);
        this.addMouseMotionListener(this);
        if (!this.showMarker) {
            this.addAncestorListener(this.listener);
        }
    }

    public boolean isMarkerShown() {
        return this.showMarker;
    }

    public void showMarker(boolean show) {
        if (show == this.showMarker) {
            return;
        }
        this.showMarker = show;
        if (this.showMarker) {
            this.removeAncestorListener(this.listener);
        } else {
            this.addAncestorListener(this.listener);
        }
    }

    @Override
    public boolean contains(int x2, int y2) {
        if (this.showMarker && this.getImage() != null) {
            double posX = (double)x2 - this.disp_pt.x;
            double posY = (double)y2 - this.disp_pt.y;
            return this.bounds.contains(posX, posY);
        }
        return false;
    }

    public void setPoint(CPoint pt) {
        CTransform tx = this.getTransform(pt.csystem, (byte)0);
        tx.transform(pt, this.tempImgPt);
        if (this.tempImgPt.x >= 0.0 && this.tempImgPt.x < (double)this.width && this.tempImgPt.y >= 0.0 && this.tempImgPt.y < (double)this.height) {
            this.img_pt.setPoint(this.tempImgPt);
            this.calcRasPoint();
            this.updateValue(this.img_pt.x, this.img_pt.y);
        }
    }

    @Override
    public final void setImage(XpImage img) {
        super.setImage(img);
        if (img != null) {
            this.rescaleSlope = img.getRescaleSlope();
            this.rescaleIntercept = img.getRescaleIntercept();
            this.width = img.getSlice().width;
            this.height = img.getSlice().height;
            this.r = null;
            this.setPoint(this.img_pt);
        }
    }

    private void updateValue(double x2, double y2) {
        Raster raster = this.r;
        if (raster == null) {
            raster = this.getRaster();
        }
        if (raster != null) {
            double old = this.value;
            try {
                int ix = (int)x2;
                int iy = (int)y2;
                DataBuffer db = raster.getDataBuffer();
                int offset = db.getOffset();
                if (db instanceof DataBufferUShort) {
                    short[] data = ((DataBufferUShort)db).getData();
                    short val = data[iy * this.width + ix + offset];
                    this.value = val;
                } else if (db instanceof DataBufferShort) {
                    short[] data = ((DataBufferShort)db).getData();
                    this.value = data[iy * this.width + ix + offset];
                } else if (db instanceof DataBufferByte) {
                    byte[] data = ((DataBufferByte)db).getData();
                    this.value = data[iy * this.width + ix + offset];
                } else if (db instanceof DataBufferInt) {
                    int[] data = ((DataBufferInt)db).getData();
                    this.value = data[iy * this.width + ix + offset] & 0xFF;
                }
            }
            catch (ArrayIndexOutOfBoundsException aie) {
                this.value = 0.0;
            }
            double modValue = this.value * this.rescaleSlope + this.rescaleIntercept;
            if (modValue != this.value) {
                this.value = modValue;
            }
            if (old != this.value) {
                this.firePropertyChange(VALUE_PROPERTY, old, this.value);
            }
        }
    }

    private Raster getRaster() {
        XpImage mi = this.getImage();
        if (mi != null) {
            RenderedImage ri = mi.getPixelData();
            this.r = ri instanceof BufferedImage ? ((BufferedImage)ri).getRaster() : ri.getData();
        }
        return this.r;
    }

    @Override
    public void mousePressed(MouseEvent me) {
        this.r = this.getRaster();
        XpFrameVisualizer fv = (XpFrameVisualizer)SwingUtilities.getAncestorOfClass(XpFrameVisualizer.class, this);
        SelectionCapable sel = (SelectionCapable)((Object)SwingUtilities.getAncestorOfClass(SelectionCapable.class, fv));
        int numberofSel = sel.getNumComponents();
        for (int i2 = 0; i2 < numberofSel; ++i2) {
            if (!sel.getViewportComponent(i2).equals(fv)) continue;
            sel.setComponentSelection(i2);
            break;
        }
    }

    @Override
    public void mouseReleased(MouseEvent me) {
        this.r = null;
    }

    @Override
    public void mouseDragged(MouseEvent me) {
        Point p2 = me.getPoint();
        this._cp0.setPoint(p2.x, p2.y, 0.0, (byte)1);
        this.setPoint(this._cp0);
        this.repaint();
    }

    @Override
    public void mouseMoved(MouseEvent me) {
        if (this.showMarker) {
            return;
        }
        Point p2 = me.getPoint();
        this._cp0.setPoint(p2.x, p2.y, 0.0, (byte)1);
        this.setPoint(this._cp0);
        this.repaint();
    }

    private void calcRasPoint() {
        CTransform ctc = this.getTransform((byte)0, (byte)2);
        ctc.transform(this.img_pt, this.ras_pt);
    }

    public final CPoint getRAS() {
        return this.ras_pt;
    }

    public final CPoint getImagePoint() {
        return this.img_pt;
    }

    public final double getValue() {
        return this.value;
    }

    @Override
    public void paintComponent(Graphics graphics) {
        if (this.showMarker) {
            boolean shadow;
            Graphics2D g2 = (Graphics2D)graphics;
            CTransform ctc = this.getTransform((byte)0, (byte)1);
            ctc.transform(this.img_pt, this.disp_pt);
            if (this.firstDraw) {
                this.calcRasPoint();
                this.updateValue(this.img_pt.x, this.img_pt.y);
                this.firstDraw = false;
            }
            g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            Color fc = this.isGrayScaleMode() ? Color.WHITE : this.getForeground();
            boolean bl = shadow = this.isGrayScaleMode() || XpAppContext.isShadowed();
            if (this.hotspot != null) {
                g2.translate(this.disp_pt.x, this.disp_pt.y);
                if (shadow) {
                    g2.setColor(Color.BLACK);
                    g2.translate(1, 1);
                    g2.draw(this.hotspot);
                    g2.translate(-1, -1);
                }
                g2.setColor(fc);
                g2.draw(this.hotspot);
                g2.translate(-this.disp_pt.x, -this.disp_pt.y);
            } else {
                int x1 = (int)(this.disp_pt.x - 8.0);
                int x2 = (int)(this.disp_pt.x + 8.0);
                int y1 = (int)(this.disp_pt.y - 8.0);
                int y2 = (int)(this.disp_pt.y + 8.0);
                g2.setStroke(new BasicStroke(2.0f));
                if (shadow) {
                    g2.setColor(Color.BLACK);
                    g2.drawLine(x1 + 2, y1 + 1, x2 + 2, y2 + 1);
                    g2.drawLine(x1 + 1, y2 + 1, x2 + 1, y1 + 1);
                }
                g2.setColor(fc);
                g2.drawLine(x1, y1, x2, y2);
                g2.drawLine(x1, y2, x2, y1);
            }
        }
    }

    public static PointMarkerCreator getComponentCreator(int ccid) {
        if (ccid == 0) {
            return new PointMarkerCreator();
        }
        return null;
    }

    @Override
    public Object clone() {
        if (this.showMarker) {
            CPoint imgPt = this.getImagePoint();
            CvContinuousReporter newCntsRprtr = new CvContinuousReporter(imgPt.x, imgPt.y);
            newCntsRprtr.showMarker = this.showMarker;
            newCntsRprtr.bounds = this.bounds;
            newCntsRprtr.hotspot = this.hotspot;
            return newCntsRprtr;
        }
        return null;
    }

    @Override
    public boolean isGrayScaleMode() {
        return this.grayscaleMode;
    }

    @Override
    public void setGrayScaleMode(boolean g2) {
        this.grayscaleMode = g2;
    }

    static {
        XpAppContext.setShadowed(true);
    }

    public static class PointMarkerCreator
    extends XpComponentCreator {
        private PropertyChangeListener pcl = null;

        @Override
        public void mousePressed(MouseEvent me) {
            XpImage2DVc ivc = (XpImage2DVc)me.getSource();
            int x2 = me.getX();
            int y2 = me.getY();
            ComponentCapable cc = this.getComponentCapable(ivc);
            if (cc != null) {
                CPoint img_pt = this.getImgPt(ivc, x2, y2);
                int xx = (int)img_pt.x;
                int yy = (int)img_pt.y;
                CvContinuousReporter ra = null;
                ra = new CvContinuousReporter(xx, yy);
                if (this.pcl != null) {
                    ra.addPropertyChangeListener(CvContinuousReporter.VALUE_PROPERTY, this.pcl);
                }
                ivc.add(ra);
                ivc.invalidate();
                ivc.validate();
                this.notifyAdditionListeners(cc);
                ivc.repaint();
            }
            if (!this.isPerpetual()) {
                this.notifyCreationListeners(cc);
                this.removeFromAll();
            }
        }

        public void setValueChangeListener(PropertyChangeListener pcl) {
            this.pcl = pcl;
        }
    }
}

