/*
 * Decompiled with CFR 0.152.
 */
package com.ge.med.cse.cvf.roi;

import com.ge.med.cse.cvf.j3d.J3DViewport;
import com.ge.med.cse.cvf.j3d.utils.J3DPixelStatsCalculator;
import com.ge.med.cse.cvf.roi.DefaultROIUtils;
import com.ge.med.cse.cvf.util.CvPropertiesManager;
import com.ge.med.cse.cvf.util.CvUtils;
import com.ge.med.cse.cvf.util.DefaultHandleFactory;
import com.ge.med.cse.cvf.util.HandleFactory;
import com.ge.med.cse.cvf.util.ValueBasedDecimalFormatter;
import com.ge.med.idc.ComponentCreator;
import com.ge.med.terra.jami.CPoint;
import com.ge.med.terra.jami.GSPSGraphic;
import com.ge.med.terra.jami.RoiActor;
import com.ge.med.terra.jami.XpAnchorable;
import com.ge.med.terra.jami.XpAppContext;
import com.ge.med.terra.jami.XpDicomElement;
import com.ge.med.terra.jami.XpDicomObject;
import com.ge.med.terra.jami.XpGeomUtils;
import com.ge.med.terra.jami.XpHandle;
import com.ge.med.terra.jami.XpImage;
import com.ge.med.terra.jami.XpPixelStatistics;
import com.ge.med.terra.jami.XpRoiComponentCreator;
import com.ge.med.terra.jami.XpSlice;
import com.ge.med.terra.jami.XpVisualComponent;
import com.ge.med.terra.jami.capable.FrameOwner;
import com.ge.med.terra.jami.capable.ROICapable;
import com.ge.med.terra.jami.j3d.J3DVolumeModel;
import com.ge.med.terra.jami.render.XpImageRenderAttributesOwner;
import com.ge.med.terra.jami.roi.RoiShapeModel;
import com.ge.med.terra.jami.roi.XpRoiHandleContainer;
import com.ge.med.terra.jami.roi.XpStatisticsRoi;
import com.ge.med.terra.jami.roi.j3d.Jami3DRoiStatistics;
import com.ge.med.terra.jami.roi.j3d.Roi3DStatImage;
import com.ge.med.terra.jami.roi.j3d.T3DStatImage;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.event.MouseEvent;
import java.awt.geom.AffineTransform;
import java.awt.geom.Ellipse2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RectangularShape;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.ResourceBundle;
import javax.swing.JComponent;

public class CvRectangularRoi
extends XpStatisticsRoi
implements Cloneable,
Serializable {
    private static ResourceBundle res = CvUtils.getResourceBundle();
    private static final long serialVersionUID = 487616567729299422L;
    protected static boolean badscreendual = false;
    private static int INNER_TOLERANCE = 10;
    private static int OUTER_TOLERANCE = 10;
    private static Color SELECTED_COLOR = null;
    private static Color UNSELECTED_COLOR = null;
    private static Color HANDLE_COLOR = null;
    private static Color ROILABEL_COLOR = null;
    private static boolean SHADOW = true;
    private static Shape MOVE_HANDLE = null;
    private static Shape CONTAINMENT_SHAPE = null;
    private static Shape ROTATE_HANDLE = null;
    private static Shape RESIZE_HANDLE = null;
    private static Cursor ROTATE_CURSOR = Cursor.getPredefinedCursor(1);
    private static Cursor MOVE_CURSOR = Cursor.getPredefinedCursor(13);
    protected transient boolean drawrectbound = false;
    private static boolean DRAW_CENTRE_MOVEHANDLE = false;
    private static CvUtils.Direction[] handlepos;
    private static int totalhandles;
    private static int ROILABEL_X;
    private static int ROILABEL_Y;
    private static int RESIZE_HANDLE_LASTINDEX;
    private static int ROTATE_HANDLE_LASTINDEX;
    private static boolean movehandlefilled;
    private static boolean resizehandlefilled;
    private static boolean rotatehandlefilled;
    private transient XpHandle[] handles = null;
    private transient JComponent[] r = null;
    private transient RectangularShape rs = null;
    private transient RectangularShape drawRs = null;
    private transient RectangularShape outerShape = null;
    private transient RectangularShape innerShape = null;
    private transient RectangularShape accumRS = null;
    private transient Point2D tmpPoint1 = new Point2D.Double();
    private transient Point2D tmpPoint2 = new Point2D.Double();
    private transient Point2D tmpPoint3 = new Point2D.Double();
    private transient Point2D tmpPoint4 = new Point2D.Double();
    private transient Point2D roiIdLoc = new Point2D.Double();
    private AffineTransform at = new AffineTransform();
    private CPoint cpDisp = new CPoint(1);
    private CPoint cpImg = new CPoint(0);
    private ContainmentCache ccache = new ContainmentCache();
    private boolean dirtyContains = true;
    private transient boolean isRotateHandleShifted = false;
    private static boolean DRAG_BY_ROILABEL;
    private transient XpGeomUtils gu = new XpGeomUtils();
    private AffineTransform invT = new AffineTransform();
    private boolean idealStatistics = true;
    private boolean squareConstraints = false;
    private static final ValueBasedDecimalFormatter dfe;
    protected boolean cornerPointAvailable = true;
    private static String AREA_SUFFIX;
    private static String AREA_PREFIX;
    private static String MAX_PREFIX;
    private static String AVG_PREFIX;
    private static String SD_PREFIX;
    static final float[] dash1;
    static final BasicStroke dashed;
    private XpDicomElement mod = new XpDicomElement(8, 96);
    private transient Point2D cnt = new Point2D.Double();

    public CvRectangularRoi(RectangularShape rs) {
        super(rs);
        this.init(rs);
        this.setClipRoi(false);
    }

    public CvRectangularRoi(RoiShapeModel ss) {
        super(ss);
        this.init((RectangularShape)ss.getShape());
        this.setClipRoi(false);
    }

    private void init(RectangularShape rs) {
        this.rs = rs;
        this.drawRs = (RectangularShape)rs.clone();
        this.outerShape = (RectangularShape)rs.clone();
        this.innerShape = (RectangularShape)rs.clone();
        this.setDragByRoiLabel(DRAG_BY_ROILABEL);
        this.createHandles();
    }

    private static void setRectRoiProperties() {
        int i2;
        int i3;
        String val = CvPropertiesManager.getProperty("jami.dualscreenbad", "false");
        if (val.toLowerCase().equals("true")) {
            badscreendual = true;
        }
        val = CvPropertiesManager.getProperty("cvf.Handle.Factory");
        HandleFactory factory = null;
        if (val != null) {
            factory = CvUtils.createHandleFactory(val);
            if (factory == null) {
                factory = new DefaultHandleFactory();
            }
        } else {
            factory = new DefaultHandleFactory();
        }
        if ((val = CvPropertiesManager.getProperty("cvf.roi.moveHandle.Style", "BOX").trim()) != null) {
            if (val.toUpperCase().equals("BOX")) {
                MOVE_HANDLE = factory.getMoveHandleShape(HandleFactory.HandleStyle.BOX);
            } else if (val.toUpperCase().equals("CROSSHAIR")) {
                MOVE_HANDLE = factory.getMoveHandleShape(HandleFactory.HandleStyle.CROSSHAIR);
            }
        }
        if ((val = CvPropertiesManager.getProperty("cvf.roi.resizeHandle.Style", "BOX").trim()) != null) {
            if (val.toUpperCase().equals("BOX")) {
                RESIZE_HANDLE = factory.getResizeHandleShape(HandleFactory.HandleStyle.BOX);
            } else if (val.toUpperCase().equals("CROSSHAIR")) {
                RESIZE_HANDLE = factory.getResizeHandleShape(HandleFactory.HandleStyle.CROSSHAIR);
            }
        }
        if ((val = CvPropertiesManager.getProperty("cvf.roi.rotateHandle.Style", "BOX").trim()) != null) {
            if (val.toUpperCase().equals("BOX")) {
                ROTATE_HANDLE = factory.getRotateHandleShape(HandleFactory.HandleStyle.BOX);
            } else if (val.toUpperCase().equals("CROSSHAIR")) {
                ROTATE_HANDLE = factory.getRotateHandleShape(HandleFactory.HandleStyle.CROSSHAIR);
            }
        }
        CONTAINMENT_SHAPE = factory.getContainmentShape();
        HANDLE_COLOR = factory.getHandleColor();
        SELECTED_COLOR = factory.getHandleSelectedColor();
        UNSELECTED_COLOR = factory.getHandleUnSelectedColor();
        Cursor c2 = factory.getRotateHandleCursor();
        if (c2 != null) {
            ROTATE_CURSOR = c2;
        }
        if ((c2 = factory.getMoveHandleCursor()) != null) {
            MOVE_CURSOR = c2;
        }
        movehandlefilled = Boolean.valueOf(CvPropertiesManager.getProperty("cvf.roi.moveHandle.filled", "false").trim());
        resizehandlefilled = Boolean.valueOf(CvPropertiesManager.getProperty("cvf.roi.resizeHandle.filled", "false").trim());
        rotatehandlefilled = Boolean.valueOf(CvPropertiesManager.getProperty("cvf.roi.rotateHandle.filled", "false").trim());
        val = CvPropertiesManager.getProperty("cvf.roi.roiLabel.Color", "yellow");
        ROILABEL_COLOR = val != null ? CvUtils.getColor(val) : HANDLE_COLOR;
        val = CvPropertiesManager.getProperty("cvf.roi.roiLabel.x", "1");
        if (val != null) {
            ROILABEL_X = Integer.parseInt(val);
        }
        if ((val = CvPropertiesManager.getProperty("cvf.roi.roiLabel.y", "-2")) != null) {
            ROILABEL_Y = Integer.parseInt(val);
        }
        if ((val = CvPropertiesManager.getProperty("cvf.roi.dragByRoiLabel", "false")) != null) {
            DRAG_BY_ROILABEL = Boolean.valueOf(val);
        }
        int handlecount = 1;
        val = CvPropertiesManager.getProperty("cvf.rectangle.totalResizeHandle", "1");
        if (val != null) {
            handlecount = Integer.parseInt(val);
        }
        if (handlecount == 0) {
            handlecount = 1;
        }
        RESIZE_HANDLE_LASTINDEX = (totalhandles += handlecount) - 1;
        CvUtils.Direction[] rsd = null;
        rsd = new CvUtils.Direction[handlecount];
        val = CvPropertiesManager.getProperty("cvf.rectangle.resizeHandle.position", "");
        String[] rs = CvUtils.parseStringList(val, ",");
        if (rs.length < handlecount) {
            for (i3 = 0; i3 < handlecount; ++i3) {
                rsd[i3] = CvUtils.getDirection(3 + i3);
            }
        } else {
            for (i3 = 0; i3 < rs.length; ++i3) {
                if (rs[i3].equalsIgnoreCase("SOUTHEAST") || rs[i3].equalsIgnoreCase("SE")) {
                    rsd[i3] = CvUtils.Direction.SOUTHEAST;
                    continue;
                }
                if (rs[i3].equalsIgnoreCase("SOUTHWEST") || rs[i3].equalsIgnoreCase("SW")) {
                    rsd[i3] = CvUtils.Direction.SOUTHWEST;
                    continue;
                }
                if (rs[i3].equalsIgnoreCase("NORTHWEST") || rs[i3].equalsIgnoreCase("NW")) {
                    rsd[i3] = CvUtils.Direction.NORTHWEST;
                    continue;
                }
                if (!rs[i3].equalsIgnoreCase("NORTHEAST") && !rs[i3].equalsIgnoreCase("NE")) continue;
                rsd[i3] = CvUtils.Direction.NORTHEAST;
            }
        }
        if ((val = CvPropertiesManager.getProperty("cvf.rectangle.totalRotateHandle", "1")) != null) {
            handlecount = Integer.parseInt(val);
        }
        if (handlecount == 0) {
            handlecount = 1;
        }
        ROTATE_HANDLE_LASTINDEX = (totalhandles += handlecount) - 1;
        CvUtils.Direction[] rotd = null;
        rotd = new CvUtils.Direction[handlecount];
        val = CvPropertiesManager.getProperty("cvf.rectangle.rotateHandle.position", "");
        String[] rot = CvUtils.parseStringList(val, ",");
        if (rot.length < handlecount) {
            for (i2 = 0; i2 < handlecount; ++i2) {
                rotd[i2] = CvUtils.getDirection(i2);
            }
        } else {
            for (i2 = 0; i2 < rot.length; ++i2) {
                if (rot[i2].equalsIgnoreCase("EAST") || rot[i2].equalsIgnoreCase("E")) {
                    rotd[i2] = CvUtils.Direction.EAST;
                    continue;
                }
                if (rot[i2].equalsIgnoreCase("NORTH") || rot[i2].equalsIgnoreCase("N")) {
                    rotd[i2] = CvUtils.Direction.NORTH;
                    continue;
                }
                if (rot[i2].equalsIgnoreCase("SOUTH") || rot[i2].equalsIgnoreCase("S")) {
                    rotd[i2] = CvUtils.Direction.SOUTH;
                    continue;
                }
                if (!rot[i2].equalsIgnoreCase("WEST") && !rot[i2].equalsIgnoreCase("W")) continue;
                rotd[i2] = CvUtils.Direction.WEST;
            }
        }
        if (DRAW_CENTRE_MOVEHANDLE = Boolean.valueOf(CvPropertiesManager.getProperty("cvf.rectangle.moveHandle.inCentre", "true").trim()).booleanValue()) {
            ++totalhandles;
        }
        handlepos = new CvUtils.Direction[totalhandles];
        for (i2 = 0; i2 <= RESIZE_HANDLE_LASTINDEX; ++i2) {
            CvRectangularRoi.handlepos[i2] = rsd[i2];
        }
        for (i2 = RESIZE_HANDLE_LASTINDEX + 1; i2 <= ROTATE_HANDLE_LASTINDEX; ++i2) {
            CvRectangularRoi.handlepos[i2] = rotd[i2 - RESIZE_HANDLE_LASTINDEX - 1];
        }
        if (DRAW_CENTRE_MOVEHANDLE) {
            CvRectangularRoi.handlepos[CvRectangularRoi.ROTATE_HANDLE_LASTINDEX + 1] = CvUtils.Direction.CENTRE;
        }
    }

    @Override
    protected void copyObject(Object o2) {
        CvRectangularRoi rr = (CvRectangularRoi)o2;
        super.copyObject(rr);
        rr.setDragByRoiLabel(this.isDragByRoiLabel());
        rr.idealStatistics = this.idealStatistics;
        rr.squareConstraints = this.squareConstraints;
    }

    protected void setDrawRectBound(boolean d2) {
        this.drawrectbound = d2;
    }

    public int getResizeHandleLastIndex() {
        return RESIZE_HANDLE_LASTINDEX;
    }

    public int getRotateHandleLastIndex() {
        return ROTATE_HANDLE_LASTINDEX;
    }

    public int getMoveHandleIndex() {
        if (DRAW_CENTRE_MOVEHANDLE) {
            return ROTATE_HANDLE_LASTINDEX + 1;
        }
        return -1;
    }

    public double getIdealLength() {
        return 0.0;
    }

    public double getIdealArea() {
        return 0.0;
    }

    @Override
    public Rectangle2D getBounds2D() {
        return this.rs.getBounds2D();
    }

    public final XpHandle getHandle(int idx) {
        if (this.handles != null && idx >= 0 && idx < this.handles.length) {
            return this.handles[idx];
        }
        return null;
    }

    protected final void setSquareConstraints(boolean squareConstraints) {
        this.squareConstraints = squareConstraints;
    }

    protected final boolean getSquareConstraints() {
        return this.squareConstraints;
    }

    public final void getFrame(Rectangle2D r2) {
        double x2 = this.rs.getX();
        double y2 = this.rs.getY();
        double w2 = this.rs.getWidth();
        double h2 = this.rs.getHeight();
        r2.setFrame(x2, y2, w2, h2);
    }

    public final Rectangle2D getFrame() {
        Rectangle2D.Double r2 = new Rectangle2D.Double();
        this.getFrame(r2);
        return r2;
    }

    public void setFrame(double x2, double y2, double w2, double h2) {
        XpSlice sl = this.getImage().getSlice();
        double X1 = 0.0;
        double Y1 = 0.0;
        double X2 = sl.width;
        double Y2 = sl.height;
        Rectangle2D domain = this.getDomain();
        if (domain != null) {
            X1 = domain.getX();
            Y1 = domain.getY();
            X2 = X1 + domain.getWidth();
            Y2 = Y1 + domain.getHeight();
        }
        double xc = x2 + w2 / 2.0;
        double yc = y2 + h2 / 2.0;
        double oldxc = xc;
        double oldyc = yc;
        xc = xc < X1 ? X1 + 1.0 : xc;
        xc = xc >= X2 ? X2 - 1.0 : xc;
        yc = yc < Y1 ? Y1 + 1.0 : yc;
        yc = yc >= Y2 ? Y2 - 1.0 : yc;
        this.rs.setFrame(x2 += xc - oldxc, y2 += yc - oldyc, w2, h2);
        this.syncModel();
    }

    @Override
    public final void getCenter(Point2D center) {
        double x2 = this.rs.getX();
        double y2 = this.rs.getY();
        double w2 = this.rs.getWidth();
        double h2 = this.rs.getHeight();
        double cx = x2 + w2 / 2.0;
        double cy = y2 + h2 / 2.0;
        center.setLocation(cx, cy);
    }

    @Override
    public Shape getDrawShape() {
        return this.drawRs;
    }

    protected void setHandleStyle() {
        int i2;
        if (!resizehandlefilled) {
            for (i2 = 0; i2 <= RESIZE_HANDLE_LASTINDEX; ++i2) {
                this.handles[i2].setShape(RESIZE_HANDLE, CONTAINMENT_SHAPE);
            }
        } else {
            for (i2 = 0; i2 <= RESIZE_HANDLE_LASTINDEX; ++i2) {
                this.handles[i2].setShape(RESIZE_HANDLE, CONTAINMENT_SHAPE);
                this.handles[i2].setFilled(true);
            }
        }
        if (!rotatehandlefilled) {
            for (i2 = RESIZE_HANDLE_LASTINDEX + 1; i2 <= ROTATE_HANDLE_LASTINDEX; ++i2) {
                this.handles[i2].setShape(ROTATE_HANDLE, CONTAINMENT_SHAPE);
            }
        } else {
            for (i2 = RESIZE_HANDLE_LASTINDEX + 1; i2 <= ROTATE_HANDLE_LASTINDEX; ++i2) {
                this.handles[i2].setShape(ROTATE_HANDLE, CONTAINMENT_SHAPE);
                this.handles[i2].setFilled(true);
            }
        }
        if (DRAW_CENTRE_MOVEHANDLE) {
            if (!movehandlefilled) {
                this.handles[ROTATE_HANDLE_LASTINDEX + 1].setShape(MOVE_HANDLE, CONTAINMENT_SHAPE);
            } else {
                this.handles[ROTATE_HANDLE_LASTINDEX + 1].setShape(MOVE_HANDLE, CONTAINMENT_SHAPE);
            }
        }
    }

    protected void setHandleCursorAndLocation() {
        block11: for (int i2 = 0; i2 < totalhandles; ++i2) {
            switch (handlepos[i2]) {
                case EAST: {
                    this.handles[i2].setLocation(this.rs.getMaxX(), this.rs.getCenterY());
                    this.handles[i2].setCursor(ROTATE_CURSOR);
                    continue block11;
                }
                case SOUTH: {
                    this.handles[i2].setLocation(this.rs.getCenterX(), this.rs.getMaxY());
                    this.handles[i2].setCursor(ROTATE_CURSOR);
                    continue block11;
                }
                case WEST: {
                    this.handles[i2].setLocation(this.rs.getMinX(), this.rs.getCenterY());
                    this.handles[i2].setCursor(ROTATE_CURSOR);
                    continue block11;
                }
                case NORTH: {
                    this.handles[i2].setLocation(this.rs.getCenterX(), this.rs.getMinY());
                    this.handles[i2].setCursor(ROTATE_CURSOR);
                    continue block11;
                }
                case SOUTHEAST: {
                    this.handles[i2].setLocation(this.rs.getMaxX(), this.rs.getMaxY());
                    this.handles[i2].setCursor(Cursor.getPredefinedCursor(5));
                    continue block11;
                }
                case SOUTHWEST: {
                    this.handles[i2].setLocation(this.rs.getMinX(), this.rs.getMaxY());
                    this.handles[i2].setCursor(Cursor.getPredefinedCursor(4));
                    continue block11;
                }
                case NORTHWEST: {
                    this.handles[i2].setLocation(this.rs.getMinX(), this.rs.getMinY());
                    this.handles[i2].setCursor(Cursor.getPredefinedCursor(6));
                    continue block11;
                }
                case NORTHEAST: {
                    this.handles[i2].setLocation(this.rs.getMaxX(), this.rs.getMinY());
                    this.handles[i2].setCursor(Cursor.getPredefinedCursor(7));
                    continue block11;
                }
                case CENTRE: {
                    this.handles[i2].setLocation(this.rs.getCenterX(), this.rs.getCenterY());
                    this.handles[i2].setCursor(MOVE_CURSOR);
                }
            }
        }
    }

    @Override
    protected void updateHandles() {
        super.updateHandles();
        block11: for (int i2 = 0; i2 < totalhandles; ++i2) {
            switch (handlepos[i2]) {
                case EAST: {
                    this.getRotatedPoint(this.rs.getMaxX(), this.rs.getCenterY(), this.handles[i2]);
                    continue block11;
                }
                case SOUTH: {
                    this.getRotatedPoint(this.rs.getCenterX(), this.rs.getMaxY(), this.handles[i2]);
                    continue block11;
                }
                case WEST: {
                    this.getRotatedPoint(this.rs.getMinX(), this.rs.getCenterY(), this.handles[i2]);
                    continue block11;
                }
                case NORTH: {
                    this.getRotatedPoint(this.rs.getCenterX(), this.rs.getMinY(), this.handles[i2]);
                    continue block11;
                }
                case SOUTHEAST: {
                    this.getRotatedPoint(this.rs.getMaxX(), this.rs.getMaxY(), this.handles[i2]);
                    continue block11;
                }
                case SOUTHWEST: {
                    this.getRotatedPoint(this.rs.getMinX(), this.rs.getMaxY(), this.handles[i2]);
                    continue block11;
                }
                case NORTHWEST: {
                    this.getRotatedPoint(this.rs.getMinX(), this.rs.getMinY(), this.handles[i2]);
                    continue block11;
                }
                case NORTHEAST: {
                    this.getRotatedPoint(this.rs.getMaxX(), this.rs.getMinY(), this.handles[i2]);
                    continue block11;
                }
                case CENTRE: {
                    this.getRotatedPoint(this.rs.getCenterX(), this.rs.getCenterY(), this.handles[i2]);
                }
            }
        }
    }

    protected void createHandles() {
        if (this.r == null) {
            this.handles = new XpHandle[totalhandles];
            int len = this.handles.length;
            for (int i2 = 0; i2 < len; ++i2) {
                this.handles[i2] = new XpHandle((XpAnchorable)this, i2, 16);
                this.add(this.handles[i2]);
                this.handles[i2].setFilled(false);
            }
            this.setHandleStyle();
            this.setHandleCursorAndLocation();
            this.updateHandles();
        }
    }

    @Override
    public String createRoiStatLabel(XpPixelStatistics ps) {
        double area;
        if (ps == null) {
            return "";
        }
        double max = ps.getMax();
        double avg = 0.0;
        double var = ps.getVariance() < 0.0 ? 0.0 : ps.getVariance();
        double stddev = Math.sqrt(var);
        double d2 = area = this.isIdealStatistics() ? this.getIdealArea() : this.getArea();
        if (ps.getNumPixels() != 0) {
            avg = ps.getSum() / (double)ps.getNumPixels();
        }
        this.setRoiStatProperties();
        String roiStat = this.getRoiLabel() + MAX_PREFIX + "=" + dfe.customFormat(max) + " " + AVG_PREFIX + "=" + dfe.customFormat(avg) + " " + SD_PREFIX + "=" + dfe.customFormat(stddev) + " " + AREA_PREFIX + " " + dfe.customFormat(area) + AREA_SUFFIX;
        return roiStat;
    }

    private void setRoiStatProperties() {
        XpImage img = this.getImage();
        String modality = null;
        if (img instanceof XpDicomObject) {
            ((XpDicomObject)((Object)img)).getValue(this.mod);
            if (this.mod.getStringValue() != null) {
                modality = this.mod.getStringValue();
            }
        }
        if (!(this.getRoiStatistics() instanceof Jami3DRoiStatistics)) {
            DefaultROIUtils.configureROIStat(img);
        }
        String modSuffix = modality != null ? "." + modality.toLowerCase() : "";
        AREA_SUFFIX = CvPropertiesManager.getProperty("cvf.roi.area.suffix" + modSuffix, "mm2");
        AREA_PREFIX = CvPropertiesManager.getProperty("cvf.roi.area.prefix" + modSuffix, "a");
        MAX_PREFIX = CvPropertiesManager.getProperty("cvf.roi.max.prefix" + modSuffix, ": max");
        AVG_PREFIX = CvPropertiesManager.getProperty("cvf.roi.average.prefix" + modSuffix, "av");
        SD_PREFIX = CvPropertiesManager.getProperty("cvf.roi.sd.prefix" + modSuffix, "sd");
    }

    @Override
    public boolean containsROI(XpVisualComponent vc, int xx, int yy) {
        Rectangle2D bounds;
        if (vc != null && this.isDragByRoiLabel() && (bounds = this.getRoiLabelBounds()) != null && bounds.contains(xx, yy)) {
            return true;
        }
        if (this.dirtyContains) {
            if (vc == null) {
                return false;
            }
            RectangularShape rs = (RectangularShape)this.getModelShape();
            double x1 = rs.getX();
            double y1 = rs.getY();
            double iw = rs.getWidth();
            double ih = rs.getHeight();
            double x2 = x1 + iw;
            double y2 = y1;
            double x3 = x1;
            double y3 = y1 + ih;
            double x4 = x1 + iw;
            double y4 = y1 + ih;
            this.cpImg.x = x1;
            this.cpImg.y = y1;
            vc.transform(this.cpImg, this.cpDisp, (byte)1);
            this.cpImg.x = x2;
            this.cpImg.y = y2;
            vc.transform(this.cpImg, this.cpDisp, (byte)1);
            this.cpImg.x = x3;
            this.cpImg.y = y3;
            vc.transform(this.cpImg, this.cpDisp, (byte)1);
            this.cpImg.x = x4;
            this.cpImg.y = y4;
            vc.transform(this.cpImg, this.cpDisp, (byte)1);
            double x5 = this.drawRs.getX();
            double y5 = this.drawRs.getY();
            double w2 = this.drawRs.getWidth();
            double h2 = this.drawRs.getHeight();
            int hIT = INNER_TOLERANCE / 2;
            int hOT = OUTER_TOLERANCE / 2;
            this.outerShape.setFrame(x5 - (double)hOT, y5 - (double)hOT, w2 + (double)OUTER_TOLERANCE, h2 + (double)OUTER_TOLERANCE);
            this.innerShape.setFrame(x5 + (double)hIT, y5 + (double)hIT, w2 - (double)INNER_TOLERANCE, h2 - (double)INNER_TOLERANCE);
            this.dirtyContains = false;
        }
        double w3 = this.ccache.w;
        double h3 = this.ccache.h;
        this.getRotatedPoint(xx, yy, -this.ccache.angle, this.ccache.cx, this.ccache.cy, this.tmpPoint1);
        boolean contained = this.outerShape.contains(this.tmpPoint1);
        if (contained && w3 > 6.0 && h3 > 6.0) {
            contained = !this.innerShape.contains(this.tmpPoint1);
        }
        return contained;
    }

    @Override
    public final void render(XpVisualComponent vc, Graphics2D g2) {
        double tcy;
        double tcx;
        this.dirtyContains = true;
        double x1 = this.rs.getX();
        double y1 = this.rs.getY();
        double x2 = x1 + this.rs.getWidth();
        double y2 = y1;
        double x3 = x1;
        double y3 = y1 + this.rs.getHeight();
        double x4 = x1 + this.rs.getWidth();
        double y4 = y1 + this.rs.getHeight();
        this.getDisplayPoint(x1, y1, this.tmpPoint1);
        this.getDisplayPoint(x2, y2, this.tmpPoint2);
        this.getDisplayPoint(x3, y3, this.tmpPoint3);
        this.getDisplayPoint(x4, y4, this.tmpPoint4);
        this.getDisplayPoint(this.rs.getX() + (double)ROILABEL_X, this.rs.getY() + (double)ROILABEL_Y, this.roiIdLoc);
        double tx1 = this.tmpPoint1.getX();
        double ty1 = this.tmpPoint1.getY();
        double tx2 = this.tmpPoint2.getX();
        double ty2 = this.tmpPoint2.getY();
        double tx3 = this.tmpPoint3.getX();
        double ty3 = this.tmpPoint3.getY();
        double tx4 = this.tmpPoint4.getX();
        double ty4 = this.tmpPoint4.getY();
        this.ccache.cx = tcx = (tx1 + tx2 + tx3 + tx4) / 4.0;
        this.ccache.cy = tcy = (ty1 + ty2 + ty3 + ty4) / 4.0;
        double dxw = tx2 - tx1;
        double dyw = ty2 - ty1;
        double w2 = Math.sqrt(dxw * dxw + dyw * dyw);
        double dxh = tx3 - tx1;
        double dyh = ty3 - ty1;
        double h2 = Math.sqrt(dxh * dxh + dyh * dyh);
        double x5 = tcx - w2 / 2.0;
        double y5 = tcy - h2 / 2.0;
        double angle = Math.atan(dyw / dxw);
        if (dyw < 0.0 && dxw < 0.0) {
            angle += Math.PI;
        } else if (dxw < 0.0 && dyw > 0.0) {
            angle += Math.PI;
        }
        this.ccache.w = w2;
        this.ccache.h = h2;
        this.ccache.angle = angle;
        this.at.setToIdentity();
        this.drawRs.setFrame(x5, y5, w2, h2);
        this.at.setToRotation(angle, tcx, tcy);
        this.gu.calcInverse(this.at, this.invT);
        g2.transform(this.at);
        super.render(vc, g2);
        if (this.drawrectbound && this.isSelected()) {
            Color saveColor = g2.getColor();
            Stroke stroke = g2.getStroke();
            Shape ds = this.getDrawShape();
            if (this.isGrayScaleMode()) {
                g2.setColor(Color.WHITE);
            } else {
                g2.setColor(XpAppContext.getSelectedColor());
            }
            Rectangle2D bounds = ds.getBounds2D();
            java.awt.Rectangle rect = bounds.getBounds();
            g2.setStroke(dashed);
            g2.drawRect(rect.x, rect.y, rect.width, rect.height);
            g2.setStroke(stroke);
            g2.setColor(saveColor);
        }
        g2.transform(this.invT);
        this.drawRoiId(vc, g2);
    }

    protected void drawRoiId(XpVisualComponent vc, Graphics2D g2) {
        if (this.isGrayScaleMode()) {
            g2.setColor(Color.WHITE);
        } else {
            g2.setColor(ROILABEL_COLOR);
        }
        this.drawRoiId(g2, this.roiIdLoc.getX(), this.roiIdLoc.getY(), this.isGrayScaleMode());
    }

    @Override
    protected void dragMouse(CPoint dragV) {
        double x2 = this.rs.getX() + dragV.x;
        double y2 = this.rs.getY() + dragV.y;
        double w2 = this.rs.getWidth();
        double h2 = this.rs.getHeight();
        this.setFrame(x2, y2, w2, h2);
    }

    protected void processAngle(int rotIdx, Point p2) {
        if (rotIdx <= ROTATE_HANDLE_LASTINDEX) {
            this.getCenter(this.cnt);
            double cx = this.cnt.getX();
            double cy = this.cnt.getY();
            this.cpDisp.setLocation(p2.getX(), p2.getY(), 0.0);
            this.displayToImage(this.cpDisp, this.cpImg);
            double x2 = this.cpImg.x;
            double y2 = this.cpImg.y;
            double pAngle = this.getAngle();
            double dx = x2 - cx;
            double dy = y2 - cy;
            double cAngle = -Math.atan(dy / dx);
            if (pAngle * cAngle < 0.0) {
                this.isRotateHandleShifted = !this.isRotateHandleShifted;
            }
            this.setAngle(cAngle);
        }
    }

    @Override
    public void anchorPressed(MouseEvent e2, Object jc) {
        super.anchorPressed(e2, jc);
        RectangularShape rs = (RectangularShape)this.getModelShape();
        if (this.accumRS == null) {
            this.accumRS = (RectangularShape)rs.clone();
        } else {
            this.accumRS.setFrame(rs.getX(), rs.getY(), rs.getWidth(), rs.getHeight());
        }
    }

    @Override
    public void anchorReleased(MouseEvent e2, Object jc) {
        super.anchorReleased(e2, jc);
    }

    @Override
    public void anchorDragged(MouseEvent e2, CPoint drag, Object jc) {
        super.anchorDragged(e2, drag, jc);
        XpHandle xph = (XpHandle)jc;
        int handleIdx = xph.getAnchorPointIndex();
        XpSlice sl = this.getImage().getSlice();
        double twidth = sl.width * 2;
        double theight = sl.height * 2;
        Point p2 = e2.getPoint();
        double x2 = this.accumRS.getX();
        double y2 = this.accumRS.getY();
        double w2 = this.accumRS.getWidth();
        double h2 = this.accumRS.getHeight();
        double prevx = x2;
        double prevy = y2;
        double prevw = w2;
        double prevh = h2;
        double dx = drag.x;
        double dy = drag.y;
        CvUtils.Direction d2 = handlepos[handleIdx];
        if (handleIdx >= 0 && handleIdx <= RESIZE_HANDLE_LASTINDEX) {
            this.getRotatedPoint(dx, dy, this.getAngle(), 0.0, 0.0, this.tmpPoint1);
            dx = this.tmpPoint1.getX();
            dy = this.tmpPoint1.getY();
            if (this.squareConstraints) {
                double dlt = dy;
                switch (d2) {
                    case NORTHWEST: {
                        x2 += dlt;
                        y2 += dlt;
                        w2 -= 2.0 * dlt;
                        h2 -= 2.0 * dlt;
                        break;
                    }
                    case NORTHEAST: {
                        y2 += dlt;
                        h2 -= 2.0 * dlt;
                        w2 -= 2.0 * dlt;
                        x2 += dlt;
                        break;
                    }
                    case SOUTHEAST: {
                        w2 += 2.0 * dlt;
                        h2 += 2.0 * dlt;
                        x2 -= dlt;
                        y2 -= dlt;
                        break;
                    }
                    case SOUTHWEST: {
                        x2 -= dlt;
                        w2 += 2.0 * dlt;
                        h2 += 2.0 * dlt;
                        y2 -= dlt;
                    }
                }
            } else {
                switch (d2) {
                    case NORTHWEST: {
                        x2 += dx;
                        y2 += dy;
                        w2 -= 2.0 * dx;
                        h2 -= 2.0 * dy;
                        break;
                    }
                    case NORTHEAST: {
                        y2 += dy;
                        h2 -= 2.0 * dy;
                        w2 += 2.0 * dx;
                        x2 -= dx;
                        break;
                    }
                    case SOUTHEAST: {
                        w2 += 2.0 * dx;
                        h2 += 2.0 * dy;
                        x2 -= dx;
                        y2 -= dy;
                        break;
                    }
                    case SOUTHWEST: {
                        x2 += dx;
                        w2 -= 2.0 * dx;
                        h2 += 2.0 * dy;
                        y2 -= dy;
                    }
                }
            }
            if (w2 > twidth) {
                w2 = twidth;
                double dw = w2 - prevw;
                x2 = prevx + dw / 2.0;
            }
            if (h2 > theight) {
                h2 = theight;
                double dh = h2 - prevh;
                y2 = prevy + dh / 2.0;
            }
        } else if (handleIdx > ROTATE_HANDLE_LASTINDEX) {
            x2 += dx;
            y2 += dy;
        } else {
            if (badscreendual) {
                int xx = p2.x;
                int yy = p2.y;
                java.awt.Rectangle bounds = this.getComponentBounds();
                if (bounds.width > 0 && bounds.height > 0) {
                    int width = bounds.width;
                    int height = bounds.height;
                    if (xx < 0) {
                        xx = 0;
                    }
                    if (xx >= width) {
                        xx = width - 1;
                    }
                    if (yy < 0) {
                        yy = 0;
                    }
                    if (yy >= height) {
                        yy = height - 1;
                    }
                    if (xx != p2.x || p2.y != yy) {
                        return;
                    }
                }
            }
            switch (d2) {
                case NORTH: {
                    this.processAngle(handleIdx, p2);
                    break;
                }
                case EAST: {
                    this.processAngle(handleIdx, p2);
                    break;
                }
                case SOUTH: {
                    this.processAngle(handleIdx, p2);
                    break;
                }
                case WEST: {
                    this.processAngle(handleIdx, p2);
                }
            }
        }
        if (w2 >= 0.5 && h2 >= 0.5) {
            this.setFrame(x2, y2, w2, h2);
        }
        this.accumRS.setFrame(this.rs.getX(), this.rs.getY(), this.rs.getWidth(), this.rs.getHeight());
    }

    @Override
    public GSPSGraphic gspsDescription() {
        return null;
    }

    private void writeObject(ObjectOutputStream s2) throws IOException {
        try {
            s2.defaultWriteObject();
            if (this.rs instanceof Rectangle2D.Double) {
                s2.writeObject(new String("Rectangle2D.Double"));
                s2.writeDouble(this.rs.getX());
                s2.writeDouble(this.rs.getY());
                s2.writeDouble(this.rs.getWidth());
                s2.writeDouble(this.rs.getHeight());
            } else if (this.rs instanceof Ellipse2D.Double) {
                s2.writeObject(new String("Ellipse2D.Double"));
                s2.writeDouble(this.rs.getX());
                s2.writeDouble(this.rs.getY());
                s2.writeDouble(this.rs.getWidth());
                s2.writeDouble(this.rs.getHeight());
            }
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
    }

    private void readObject(ObjectInputStream s2) throws IOException {
        try {
            s2.defaultReadObject();
            String shape = (String)s2.readObject();
            if (shape.compareTo("Rectangle2D.Double") == 0) {
                Rectangle2D.Double rect = null;
                rect = new Rectangle2D.Double(s2.readDouble(), s2.readDouble(), s2.readDouble(), s2.readDouble());
                this.setRoiShapeModel(new RoiShapeModel(rect));
                this.init(rect);
            } else if (shape.compareTo("Ellipse2D.Double") == 0) {
                Ellipse2D.Double ellipse = null;
                ellipse = new Ellipse2D.Double(s2.readDouble(), s2.readDouble(), s2.readDouble(), s2.readDouble());
                this.setRoiShapeModel(new RoiShapeModel(ellipse));
                this.init(ellipse);
            }
            this.tmpPoint1 = new Point2D.Double();
            this.tmpPoint2 = new Point2D.Double();
            this.tmpPoint3 = new Point2D.Double();
            this.tmpPoint4 = new Point2D.Double();
            this.gu = new XpGeomUtils();
            this.cnt = new Point2D.Double();
        }
        catch (ClassNotFoundException ex) {
            ex.printStackTrace();
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
    }

    @Override
    protected void setRoiShapeModel(RoiShapeModel shapemodel) {
        super.setRoiShapeModel(shapemodel);
    }

    public boolean isIdealStatistics() {
        return this.idealStatistics;
    }

    public void setIdealStatistics(boolean idealStatistics) {
        this.idealStatistics = idealStatistics;
    }

    static {
        totalhandles = 0;
        ROILABEL_X = 0;
        ROILABEL_Y = 0;
        movehandlefilled = false;
        resizehandlefilled = false;
        rotatehandlefilled = false;
        DRAG_BY_ROILABEL = false;
        dfe = new ValueBasedDecimalFormatter();
        AREA_SUFFIX = null;
        AREA_PREFIX = null;
        MAX_PREFIX = null;
        AVG_PREFIX = null;
        SD_PREFIX = null;
        dash1 = new float[]{3.0f};
        dashed = new BasicStroke(1.0f, 0, 0, 2.0f, dash1, 1.0f);
        CvRectangularRoi.setRectRoiProperties();
        XpHandle.setHandleColor(HANDLE_COLOR);
        XpAppContext.setSelectedColor(SELECTED_COLOR);
        XpAppContext.setUnSelectedColor(UNSELECTED_COLOR);
        XpAppContext.setShadowed(SHADOW);
    }

    private static abstract class RectComponentCreator
    extends XpRoiComponentCreator {
        private RectComponentCreator() {
        }
    }

    public static class Ellipse
    extends CvRectangularRoi
    implements Cloneable,
    Serializable {
        private transient Point2D gspsTemp = new Point2D.Double();
        private static boolean DRAW_ELLIPSE_RECTBOUND = false;

        public Ellipse(Ellipse2D e2) {
            super(e2);
            this.setDrawRectBound(DRAW_ELLIPSE_RECTBOUND);
        }

        public Ellipse(RoiShapeModel statshape) {
            super(statshape);
            this.setDrawRectBound(DRAW_ELLIPSE_RECTBOUND);
        }

        public static ComponentCreator getComponentCreator(int ccid) {
            if (ccid == 0) {
                return new EllipseCreator();
            }
            return null;
        }

        @Override
        public double getIdealArea() {
            XpImage img = this.getImage();
            double area = 0.0;
            if (img != null) {
                if (img instanceof XpDicomObject && 0 != ((XpDicomObject)((Object)img)).getValue(new XpDicomElement(32, 50))) {
                    this.cornerPointAvailable = false;
                }
                if (img instanceof Roi3DStatImage) {
                    J3DViewport j3d = (J3DViewport)((T3DStatImage)img).getViewport();
                    RectangularShape rs = (RectangularShape)this.getModelShape();
                    area = J3DPixelStatsCalculator.getArea(rs, this.getAngle(), (J3DVolumeModel)j3d.getVolumeModel(), ((T3DStatImage)img).getReferenceSlice());
                } else {
                    double pdx = img.getPixelDimensionX();
                    double pdy = img.getPixelDimensionY();
                    RectangularShape rs = (RectangularShape)this.getModelShape();
                    double pw = rs.getWidth() * pdx;
                    double ph = rs.getHeight() * pdy;
                    area = Math.PI * pw * ph / 4.0;
                }
            }
            return area;
        }

        @Override
        public double getIdealLength() {
            double len = 0.0;
            XpImage img = this.getImage();
            if (img != null) {
                double b2;
                double ph;
                if (img instanceof XpDicomObject && 0 != ((XpDicomObject)((Object)img)).getValue(new XpDicomElement(32, 50))) {
                    this.cornerPointAvailable = false;
                }
                double pdx = img.getPixelDimensionX();
                double pdy = img.getPixelDimensionY();
                RectangularShape rs = (RectangularShape)this.getModelShape();
                double pw = rs.getWidth() / 2.0 * pdx;
                double a2 = Math.max(pw, ph = rs.getHeight() / 2.0 * pdy);
                if (a2 == (b2 = Math.min(pw, ph))) {
                    return Math.PI * 2 * a2;
                }
                double ab1 = a2 - b2;
                double ab2 = a2 + b2;
                double h2 = ab1 * ab1 / (ab2 * ab2);
                double ecc = Math.sqrt(1.0 - b2 * b2 / (a2 * a2));
                if (ecc < 0.999) {
                    len = 0.7853981633974483 * (a2 + b2) * (3.0 * (1.0 + h2 / 4.0) + 1.0 / (1.0 - h2 / 4.0));
                } else {
                    double s2 = 0.825056;
                    double s1 = 4.0 * (a2 + b2);
                    double d1 = 1.7168146928204138 * a2 * b2;
                    double sq = Math.pow(a2, s2) / 2.0 + Math.pow(b2, s2) / 2.0;
                    double d2 = Math.pow(sq, 1.0 / s2);
                    len = s1 - d1 / d2;
                }
            }
            return len;
        }

        @Override
        public Object clone() {
            Ellipse2D m2 = (Ellipse2D)this.getModelShape();
            Ellipse2D r2 = (Ellipse2D)m2.clone();
            Ellipse ell = new Ellipse(r2);
            this.copyObject(ell);
            return ell;
        }

        @Override
        public final GSPSGraphic gspsDescription() {
            double h2;
            XpRoiHandleContainer.GraphicDescriptor description = null;
            RectangularShape rs = (RectangularShape)this.getModelShape();
            double x2 = rs.getX();
            double y2 = rs.getY();
            double w2 = rs.getWidth();
            if (w2 == (h2 = rs.getHeight())) {
                double cx = x2 + w2 / 2.0;
                double cy = y2 + h2 / 2.0;
                double circ_ptX = cx;
                double circ_ptY = cy + h2 / 2.0;
                Point2D[] pts = new Point2D[]{new Point2D.Double(cx, cy), new Point2D.Double(circ_ptX, circ_ptY)};
                description = new XpRoiHandleContainer.GraphicDescriptor("CIRCLE", pts);
            } else if (w2 > h2) {
                double majorP1X = x2;
                double majorP1Y = y2 + h2 / 2.0;
                double majorP2X = x2 + w2;
                double majorP2Y = majorP1Y;
                double minorP1X = x2 + w2 / 2.0;
                double minorP1Y = y2;
                double minorP2X = minorP1X;
                double minorP2Y = y2 + h2;
                this.getRotatedPoint(majorP1X, majorP1Y, this.gspsTemp);
                majorP1X = this.gspsTemp.getX();
                majorP1Y = this.gspsTemp.getY();
                this.getRotatedPoint(majorP2X, majorP2Y, this.gspsTemp);
                majorP2X = this.gspsTemp.getX();
                majorP2Y = this.gspsTemp.getY();
                this.getRotatedPoint(minorP1X, minorP1Y, this.gspsTemp);
                minorP1X = this.gspsTemp.getX();
                minorP1Y = this.gspsTemp.getY();
                this.getRotatedPoint(minorP2X, minorP2Y, this.gspsTemp);
                minorP2X = this.gspsTemp.getX();
                minorP2Y = this.gspsTemp.getY();
                Point2D[] pts = new Point2D[]{new Point2D.Double(majorP1X, majorP1Y), new Point2D.Double(majorP2X, majorP2Y), new Point2D.Double(minorP1X, minorP1Y), new Point2D.Double(minorP2X, minorP2Y)};
                description = new XpRoiHandleContainer.GraphicDescriptor("ELLIPSE", pts);
            } else {
                double majorP1X = x2 + w2 / 2.0;
                double majorP1Y = y2;
                double majorP2X = majorP1X;
                double majorP2Y = y2 + h2;
                double minorP1X = x2;
                double minorP1Y = y2 + h2 / 2.0;
                double minorP2X = x2 + w2;
                double minorP2Y = minorP1Y;
                this.getRotatedPoint(majorP1X, majorP1Y, this.gspsTemp);
                majorP1X = this.gspsTemp.getX();
                majorP1Y = this.gspsTemp.getY();
                this.getRotatedPoint(majorP2X, majorP2Y, this.gspsTemp);
                majorP2X = this.gspsTemp.getX();
                majorP2Y = this.gspsTemp.getY();
                this.getRotatedPoint(minorP1X, minorP1Y, this.gspsTemp);
                minorP1X = this.gspsTemp.getX();
                minorP1Y = this.gspsTemp.getY();
                this.getRotatedPoint(minorP2X, minorP2Y, this.gspsTemp);
                minorP2X = this.gspsTemp.getX();
                minorP2Y = this.gspsTemp.getY();
                Point2D[] pts = new Point2D[]{new Point2D.Double(majorP1X, majorP1Y), new Point2D.Double(majorP2X, majorP2Y), new Point2D.Double(minorP1X, minorP1Y), new Point2D.Double(minorP2X, minorP2Y)};
                description = new XpRoiHandleContainer.GraphicDescriptor("ELLIPSE", pts);
            }
            return description;
        }

        static {
            DRAW_ELLIPSE_RECTBOUND = Boolean.valueOf(CvPropertiesManager.getProperty("cvf.ellipse.withRectBound", "false").trim());
        }

        private static class EllipseCreator
        extends RectComponentCreator {
            double width = 20.0;
            double height = 10.0;
            double img_width = 0.0;
            double img_height = 0.0;

            private EllipseCreator() {
            }

            @Override
            public RoiActor getRoiActor(double x2, double y2) {
                double xx = x2 - this.width / 2.0;
                double yy = y2 - this.height / 2.0;
                if (xx < 0.0) {
                    xx = 0.0;
                }
                if (yy < 0.0) {
                    yy = 0.0;
                }
                if (xx + this.width > this.img_width) {
                    xx = this.img_width - this.width;
                }
                if (yy + this.height > this.img_height) {
                    yy = this.img_height - this.height;
                }
                Ellipse el = new Ellipse(new Ellipse2D.Double(xx, yy, this.width, this.height));
                el.setDragByRoiLabel(true);
                return el;
            }

            @Override
            public void mousePressed(MouseEvent me) {
                int modifiers;
                int mbutton1;
                double zo;
                XpVisualComponent jc = (XpVisualComponent)me.getSource();
                if (jc instanceof FrameOwner) {
                    XpImage img = ((FrameOwner)((Object)jc)).getFrame();
                    if (!CvUtils.measurementsValid(img)) {
                        return;
                    }
                    if (img != null) {
                        int w2 = img.getSlice().width;
                        int h2 = img.getSlice().height;
                        this.img_width = w2;
                        this.img_height = h2;
                        this.width = (double)w2 * 0.1;
                        this.height = (double)h2 * 0.1;
                    }
                }
                if (jc instanceof XpImageRenderAttributesOwner && (zo = ((XpImageRenderAttributesOwner)((Object)jc)).getImageRenderAttributes().getZoom()) > 1.0) {
                    this.width /= zo;
                    this.height /= zo;
                }
                if ((mbutton1 = (modifiers = me.getModifiers()) & 0x10) != 0) {
                    super.mousePressed(me);
                } else {
                    ROICapable rc = (ROICapable)this.getComponentCapable(jc);
                    this.shutdown(rc);
                }
            }

            @Override
            public void mouseReleased(MouseEvent me) {
                int modifiers = me.getModifiers();
                int mbutton1 = modifiers & 0x10;
                if (mbutton1 != 0) {
                    super.mouseReleased(me);
                } else {
                    XpVisualComponent jc = (XpVisualComponent)me.getSource();
                    ROICapable rc = (ROICapable)this.getComponentCapable(jc);
                    this.shutdown(rc);
                }
            }
        }
    }

    public static class Rectangle
    extends CvRectangularRoi
    implements Cloneable,
    Serializable {
        private transient Point2D gspsTemp = new Point2D.Double();

        public Rectangle(Rectangle2D r2) {
            super(r2);
        }

        public Rectangle(RoiShapeModel statshape) {
            super(statshape);
        }

        @Override
        public double getIdealArea() {
            XpImage img = this.getImage();
            double area = 0.0;
            if (img != null) {
                if (img instanceof XpDicomObject && 0 != ((XpDicomObject)((Object)img)).getValue(new XpDicomElement(32, 50))) {
                    this.cornerPointAvailable = false;
                }
                if (img instanceof Roi3DStatImage) {
                    J3DViewport j3d = (J3DViewport)((T3DStatImage)img).getViewport();
                    RectangularShape rs = (RectangularShape)this.getModelShape();
                    area = J3DPixelStatsCalculator.getArea(rs, this.getAngle(), (J3DVolumeModel)j3d.getVolumeModel(), ((T3DStatImage)img).getReferenceSlice());
                } else {
                    double pdx = img.getPixelDimensionX();
                    double pdy = img.getPixelDimensionY();
                    RectangularShape rs = (RectangularShape)this.getModelShape();
                    double pw = rs.getWidth() * pdx;
                    double ph = rs.getHeight() * pdy;
                    area = pw * ph;
                }
            }
            return area;
        }

        @Override
        public double getIdealLength() {
            XpImage img = this.getImage();
            double len = 0.0;
            if (img != null) {
                if (img instanceof XpDicomObject && 0 != ((XpDicomObject)((Object)img)).getValue(new XpDicomElement(32, 50))) {
                    this.cornerPointAvailable = false;
                }
                double pdx = img.getPixelDimensionX();
                double pdy = img.getPixelDimensionY();
                RectangularShape rs = (RectangularShape)this.getModelShape();
                double pw = rs.getWidth() * pdx;
                double ph = rs.getHeight() * pdy;
                len = 2.0 * pw + 2.0 * ph;
            }
            return len;
        }

        @Override
        public final GSPSGraphic gspsDescription() {
            Point2D[] pts = new Point2D[5];
            RectangularShape rs = (RectangularShape)this.getModelShape();
            double x2 = rs.getX();
            double y2 = rs.getY();
            double w2 = rs.getWidth();
            double h2 = rs.getHeight();
            this.getRotatedPoint(x2, y2, this.gspsTemp);
            pts[0] = new Point2D.Double(this.gspsTemp.getX(), this.gspsTemp.getY());
            this.getRotatedPoint(x2 += w2, y2, this.gspsTemp);
            pts[1] = new Point2D.Double(this.gspsTemp.getX(), this.gspsTemp.getY());
            this.getRotatedPoint(x2, y2 += h2, this.gspsTemp);
            pts[2] = new Point2D.Double(this.gspsTemp.getX(), this.gspsTemp.getY());
            this.getRotatedPoint(x2 -= w2, y2, this.gspsTemp);
            pts[3] = new Point2D.Double(this.gspsTemp.getX(), this.gspsTemp.getY());
            this.getRotatedPoint(x2, y2 -= h2, this.gspsTemp);
            pts[4] = new Point2D.Double(this.gspsTemp.getX(), this.gspsTemp.getY());
            XpRoiHandleContainer.GraphicDescriptor description = new XpRoiHandleContainer.GraphicDescriptor("POLYLINE", pts);
            return description;
        }

        public static ComponentCreator getComponentCreator(int ccid) {
            if (ccid == 0) {
                return new RectangleCreator();
            }
            return null;
        }

        @Override
        public Object clone() {
            Rectangle2D m2 = (Rectangle2D)this.getModelShape();
            Rectangle2D r2 = (Rectangle2D)m2.clone();
            Rectangle rect = new Rectangle(r2);
            this.copyObject(rect);
            return rect;
        }

        private static class RectangleCreator
        extends RectComponentCreator {
            double width = 20.0;
            double height = 10.0;
            double img_width = 0.0;
            double img_height = 0.0;

            private RectangleCreator() {
            }

            @Override
            public RoiActor getRoiActor(double x2, double y2) {
                double xx = x2 - this.width / 2.0;
                double yy = y2 - this.height / 2.0;
                if (xx < 0.0) {
                    xx = 0.0;
                }
                if (yy < 0.0) {
                    yy = 0.0;
                }
                if (xx + this.width > this.img_width) {
                    xx = this.img_width - this.width;
                }
                if (yy + this.height > this.img_height) {
                    yy = this.img_height - this.height;
                }
                Rectangle el = new Rectangle(new Rectangle2D.Double(xx, yy, this.width, this.height));
                el.setDragByRoiLabel(true);
                return el;
            }

            @Override
            public void mousePressed(MouseEvent me) {
                double zo;
                XpVisualComponent jc = (XpVisualComponent)me.getSource();
                if (jc instanceof FrameOwner) {
                    XpImage img = ((FrameOwner)((Object)jc)).getFrame();
                    if (!CvUtils.measurementsValid(img)) {
                        return;
                    }
                    if (img != null) {
                        int w2 = img.getSlice().width;
                        int h2 = img.getSlice().height;
                        this.img_width = w2;
                        this.img_height = h2;
                        this.width = (double)w2 * 0.1;
                        this.height = (double)h2 * 0.1;
                    }
                }
                if (jc instanceof XpImageRenderAttributesOwner && (zo = ((XpImageRenderAttributesOwner)((Object)jc)).getImageRenderAttributes().getZoom()) > 1.0) {
                    this.width /= zo;
                    this.height /= zo;
                }
                super.mousePressed(me);
            }
        }
    }

    private static class ContainmentCache
    implements Serializable {
        public double angle;
        public double cx;
        public double cy;
        public double w;
        public double h;

        private ContainmentCache() {
        }
    }
}

