/*
 * Decompiled with CFR 0.152.
 */
package com.ge.med.cse.cvf.roi;

import com.ge.med.cse.cvf.util.CvPropertiesManager;
import com.ge.med.cse.cvf.util.CvUtils;
import com.ge.med.cse.cvf.util.DefaultHandleFactory;
import com.ge.med.cse.cvf.util.HandleFactory;
import com.ge.med.idc.Selectable;
import com.ge.med.terra.jami.CPoint;
import com.ge.med.terra.jami.CTransform;
import com.ge.med.terra.jami.XpAppContext;
import com.ge.med.terra.jami.XpComponentCreator;
import com.ge.med.terra.jami.XpMedicalImage2DVc;
import com.ge.med.terra.jami.XpPropertiesManager;
import com.ge.med.terra.jami.XpUserAnnotationModel;
import com.ge.med.terra.jami.XpUserAnnotationVc;
import com.ge.med.terra.jami.XpVisualComponent;
import com.ge.med.terra.jami.annotation.XpAnnotationModel;
import com.ge.med.terra.jami.annotation.XpAnnotationPolicy;
import com.ge.med.terra.jami.capable.UserAnnoCapable;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Shape;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionAdapter;
import java.io.Serializable;
import java.util.Arrays;
import java.util.List;
import javax.swing.JTextArea;
import javax.swing.SwingUtilities;
import javax.swing.text.BadLocationException;
import javax.swing.text.JTextComponent;

public class CvUserAnnotationModel
extends XpUserAnnotationModel {
    public static Color unselectionTextColor = CvUtils.getColor(CvPropertiesManager.getProperty("cvf.userAnnotation.unselectionColor", "white"));
    private UaDragListener uaDragListenr = new UaDragListener();
    private UaMouseListener uaMouseListenr = new UaMouseListener();
    public static Shape MOVEHANDLE_CROSSHAIR = new DefaultHandleFactory().getHandleShape(HandleFactory.HandleStyle.CROSSHAIR);
    public static Shape MOVEHANDLE_ANGLECROSSHAIR = new DefaultHandleFactory().getHandleShape(HandleFactory.HandleStyle.ANGLECROSSHAIR);
    public static Shape MOVEHANDLE_BOX = new DefaultHandleFactory().getHandleShape(HandleFactory.HandleStyle.BOX);
    public static Shape MOVEHANDLE_CONTAINMENT = new DefaultHandleFactory().getContainmentShape();
    public static Shape userAnnotationMoveHandleShape;
    public static boolean resizeTextAreaEnable;
    public static boolean autoResizeEnable;
    public static boolean showUnSelectedBorder;
    private boolean edited = false;
    private boolean isDirty = false;
    private TextEditListener textEditListener = new TextEditListener();
    private UaFocusListener uaFocusListener = new UaFocusListener();
    private double prevvw = 0.0;

    public CvUserAnnotationModel(String text, CPoint textAnchor, CPoint target) {
        super(text, textAnchor, target);
        this.addMouseMotionListener(this.uaDragListenr);
        this.addMouseListener(this.uaMouseListenr);
        this.setUnselectedColor(unselectionTextColor);
    }

    @Override
    public Object clone() {
        CvUserAnnotationModel uam = new CvUserAnnotationModel("", null, null);
        this.copyObject(uam);
        uam.setUnselectedColor(unselectionTextColor);
        uam.setTextEdited(this.isTextEdited());
        return uam;
    }

    @Override
    protected void copyObject(Object o2) {
        super.copyObject(o2);
    }

    @Override
    public void setSelected(boolean selection) {
        super.setSelected(selection);
        if (!selection && this.getUserAnnotationVc() != null) {
            this.getUserAnnotationVc().getTextArea().select(-1, -1);
        } else if (selection && this.getUserAnnotationVc() != null) {
            this.getUserAnnotationVc().getTextArea().select(this.getText().length(), this.getText().length());
        }
    }

    @Override
    public void setUserAnnotationVc(XpUserAnnotationVc new_uavc) {
        int i2;
        List mlsnrs;
        XpUserAnnotationVc vc;
        if (this.getUserAnnotationVc() != null) {
            vc = this.getUserAnnotationVc();
            vc.getTextArea().removeKeyListener(this.textEditListener);
            vc.removeFocusListener(this.uaFocusListener);
            vc.getTextArea().removeFocusListener(this.uaFocusListener);
            mlsnrs = this.getMouseListeners();
            if (mlsnrs != null) {
                for (i2 = 0; i2 < mlsnrs.size(); ++i2) {
                    vc.removeMouseListener((MouseListener)mlsnrs.get(i2));
                }
            }
        }
        super.setUserAnnotationVc(new_uavc);
        if (this.getUserAnnotationVc() != null) {
            vc = this.getUserAnnotationVc();
            vc.getTextArea().setLineWrap(true);
            vc.getTextArea().addKeyListener(this.textEditListener);
            vc.addFocusListener(this.uaFocusListener);
            vc.getTextArea().addFocusListener(this.uaFocusListener);
            mlsnrs = this.getMouseListeners();
            if (mlsnrs != null) {
                for (i2 = 0; i2 < mlsnrs.size(); ++i2) {
                    vc.addMouseListener((MouseListener)mlsnrs.get(i2));
                }
            }
        }
    }

    @Override
    public Font getFont() {
        Component mivc;
        XpUserAnnotationVc uavc = this.getUserAnnotationVc();
        if (uavc != null && (mivc = uavc.findParentByClass(uavc, XpMedicalImage2DVc.class)) != null) {
            XpAnnotationPolicy ap = XpAnnotationModel.getAnnotationPolicy();
            Font afont = ap.getAnnotationFont(mivc.getWidth(), mivc.getHeight());
            Font tfont = this.getUserAnnotationVc().getTextArea().getFont();
            if (afont.getSize() != tfont.getSize()) {
                Font newFont = tfont.deriveFont(afont.getSize2D());
                this.setFont(newFont);
                return newFont;
            }
        }
        return super.getFont();
    }

    @Override
    public void configUserAnnotation() {
        XpUserAnnotationVc uavc = this.getUserAnnotationVc();
        if (uavc == null) {
            return;
        }
        JTextArea textArea = uavc.getTextArea();
        if (this.isSelected()) {
            textArea.setCaretColor(this.getSelectedColor());
            textArea.setForeground(this.getSelectedColor());
            textArea.setBorder(this.getSelectedBorder());
            textArea.setEditable(true);
            textArea.setFocusable(true);
        } else {
            textArea.setEditable(false);
            textArea.setForeground(this.getUnselectedColor());
            if (this.isShowUnSelectedBorder()) {
                textArea.setBorder(this.getUnselectedBorder());
            } else {
                textArea.setBorder(null);
            }
            textArea.setFocusable(false);
            this.wrapToText(textArea);
        }
    }

    private void wrapToText(JTextArea textArea) {
        int lineCount = textArea.getLineCount();
        int maxLineLen = 0;
        int boxWidth = (int)textArea.getSize().getWidth();
        double vw = textArea.getParent().getSize().getWidth();
        if (vw > this.prevvw) {
            boxWidth = (int)((double)boxWidth * (vw / this.prevvw));
            this.prevvw = vw;
        }
        int[] charWidths = textArea.getFontMetrics(textArea.getFont()).getWidths();
        for (int i2 = 0; i2 < lineCount; ++i2) {
            try {
                String text = textArea.getText(textArea.getLineStartOffset(i2), textArea.getLineEndOffset(i2) - textArea.getLineStartOffset(i2));
                int len = textArea.getFontMetrics(textArea.getFont()).stringWidth(text);
                if (len <= maxLineLen) continue;
                maxLineLen = len;
                continue;
            }
            catch (BadLocationException e2) {
                e2.printStackTrace();
            }
        }
        Arrays.sort(charWidths);
        if (boxWidth <= charWidths[charWidths.length - 1]) {
            boxWidth = charWidths[charWidths.length - 1];
        }
        if (maxLineLen >= boxWidth) {
            maxLineLen = boxWidth;
        }
        this.prevvw = vw;
        this.resizeTextArea(maxLineLen, textArea.getSize().height);
    }

    @Override
    public void keyPressed(KeyEvent e2) {
        this.getUserAnnotationVc().repaint();
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                if (CvUserAnnotationModel.this.getUserAnnotationVc() != null) {
                    CvUserAnnotationModel.this.getUserAnnotationVc().getTextArea().requestFocusInWindow();
                }
            }
        });
    }

    public void resizeTextArea(int width, int height) {
        Dimension di = new Dimension(width, height);
        if (this.getUserAnnotationVc() != null) {
            this.getUserAnnotationVc().getTextArea().setSize(di);
        }
        this.setWidth(width);
        this.setHeight(height);
    }

    public void setTextEdited(boolean textEdited) {
        this.edited = textEdited;
    }

    private boolean isTextEdited() {
        return this.edited;
    }

    public boolean isResizeTextAreaEnable() {
        return resizeTextAreaEnable;
    }

    public void setResizeTextAreaEnable(boolean resizeTextAreaEnable) {
        CvUserAnnotationModel.resizeTextAreaEnable = resizeTextAreaEnable;
    }

    public boolean isAutoResizeEnable() {
        return autoResizeEnable;
    }

    public void setAutoResizeEnable(boolean autoResizeEnable) {
        CvUserAnnotationModel.autoResizeEnable = autoResizeEnable;
    }

    public void editUserAnnotation(String defaultText, CvUserAnnotationModel uam) {
        if (!uam.getUserAnnotationVc().getText().equalsIgnoreCase(defaultText)) {
            uam.setTextEdited(true);
        }
    }

    public boolean isShowUnSelectedBorder() {
        return showUnSelectedBorder;
    }

    @Override
    public Shape getMoveHandleShape(int width, int height) {
        if (userAnnotationMoveHandleShape == MOVEHANDLE_CROSSHAIR) {
            return MOVEHANDLE_CROSSHAIR;
        }
        if (userAnnotationMoveHandleShape == MOVEHANDLE_ANGLECROSSHAIR) {
            return MOVEHANDLE_ANGLECROSSHAIR;
        }
        if (userAnnotationMoveHandleShape == MOVEHANDLE_CONTAINMENT) {
            return MOVEHANDLE_CONTAINMENT;
        }
        return MOVEHANDLE_BOX;
    }

    public static CvUserAnnotationModel getCVUserAnnotationModel(CPoint textAnchor, CPoint target) {
        String defaultText = CvPropertiesManager.getProperty("cvf.userAnnotation.defaultText", "");
        CvUserAnnotationModel.setUserAnnotationHandleShape(MOVEHANDLE_BOX);
        CvUserAnnotationModel uam = new CvUserAnnotationModel(defaultText, textAnchor, target);
        if (uam.getUserAnnotationVc() != null && uam.isResizeTextAreaEnable()) {
            int width = Integer.parseInt(CvPropertiesManager.getProperty("cvf.userAnnotation.resizeTextArea.minwidth", "60"));
            int height = Integer.parseInt(CvPropertiesManager.getProperty("cvf.userAnnotation.resizeTextArea.minheight", "20"));
            uam.resizeTextArea(width, height);
        } else if (uam.getUserAnnotationVc() != null && !uam.isResizeTextAreaEnable()) {
            if (uam.isAutoResizeEnable()) {
                uam.setAutoResize(true);
            } else {
                uam.setAutoResize(false);
            }
        }
        return uam;
    }

    public static Shape getUserAnnotationHandleShape() {
        return userAnnotationMoveHandleShape;
    }

    public static void setUserAnnotationHandleShape(Shape userAnnotationHandleShape) {
        userAnnotationMoveHandleShape = userAnnotationHandleShape;
    }

    static {
        resizeTextAreaEnable = Boolean.getBoolean(CvPropertiesManager.getProperty("cvf.userAnnotation.defaultTextShown", "true"));
        autoResizeEnable = Boolean.getBoolean(CvPropertiesManager.getProperty("cvf.userAnnotation.autoResize", "false"));
        showUnSelectedBorder = Boolean.getBoolean(CvPropertiesManager.getProperty("cvf.userAnnotation.showUnselectedBorder", "true"));
        XpAppContext.setShadowed(true);
    }

    class UaMouseListener
    extends MouseAdapter
    implements Serializable {
        UaMouseListener() {
        }

        @Override
        public void mousePressed(MouseEvent e2) {
            CvUserAnnotationModel.this.setAutoResize(false);
        }

        @Override
        public void mouseReleased(MouseEvent e2) {
            CvUserAnnotationModel.this.setAutoResize(true);
        }
    }

    private static class CvUserAnnoCreator
    extends XpComponentCreator {
        public static double xAxis = Double.parseDouble(CvPropertiesManager.getProperty("cvf.userAnnotation.xAxis", "0.2"));
        public static double yAxis = Double.parseDouble(CvPropertiesManager.getProperty("cvf.userAnnotation.yAxis", "0.3"));

        private CvUserAnnoCreator() {
        }

        @Override
        public void mousePressed(MouseEvent me) {
            XpVisualComponent jc = (XpVisualComponent)me.getSource();
            int x2 = me.getX();
            int y2 = me.getY();
            UserAnnoCapable ua = (UserAnnoCapable)this.getComponentCapable(jc);
            if (ua != null) {
                CPoint img_pt = this.getImgPt(jc, x2, y2);
                int xx = (int)img_pt.x;
                int yy = (int)img_pt.y;
                CPoint target = new CPoint(xx, yy, 0, 0);
                if (xAxis >= 0.8) {
                    xAxis = 0.3;
                    yAxis += 0.2;
                }
                if (yAxis >= 0.8) {
                    yAxis = 0.35;
                    yAxis = 0.35;
                }
                CPoint textAnchor = new CPoint(xAxis, yAxis, 0.0, 3);
                xAxis += 0.2;
                String defaultText = XpPropertiesManager.getProperty("cvf.userAnnotation.defaultText", "");
                CvUserAnnotationModel uam = new CvUserAnnotationModel(defaultText, textAnchor, target);
                uam.editUserAnnotation(defaultText, uam);
                if (uam.getUserAnnotationVc() != null && uam.isResizeTextAreaEnable()) {
                    int width = Integer.parseInt(CvPropertiesManager.getProperty("cvf.userAnnotation.resizeTextArea.minwidth", "60"));
                    int height = Integer.parseInt(CvPropertiesManager.getProperty("cvf.userAnnotation.resizeTextArea.minheight", "20"));
                    uam.resizeTextArea(width, height);
                } else if (uam.getUserAnnotationVc() != null && !uam.isResizeTextAreaEnable()) {
                    if (uam.isAutoResizeEnable()) {
                        uam.setAutoResize(true);
                    } else {
                        uam.setAutoResize(false);
                    }
                }
                uam.setShowTarget(true);
                ua.add(uam);
                if (uam.getUserAnnotationVc() != null) {
                    SwingUtilities.getWindowAncestor(uam.getUserAnnotationVc()).requestFocusInWindow();
                    uam.getUserAnnotationVc().requestFocusInWindow();
                }
                if (!this.isPerpetual()) {
                    this.notifyAdditionListeners(ua);
                    this.notifyCreationListeners(ua);
                    this.removeFromAll();
                }
            }
        }
    }

    class UaFocusListener
    implements FocusListener,
    Serializable {
        UaFocusListener() {
        }

        @Override
        public void focusGained(FocusEvent e2) {
        }

        @Override
        public void focusLost(FocusEvent e2) {
            XpUserAnnotationVc uavc;
            UserAnnoCapable uac;
            if (e2.getOppositeComponent() instanceof XpUserAnnotationVc || e2.getOppositeComponent() instanceof JTextComponent) {
                return;
            }
            if (CvUserAnnotationModel.this.isSelected() && CvUserAnnotationModel.this.isVisible()) {
                e2.getComponent().requestFocusInWindow();
            } else if ((CvUserAnnotationModel.this.getText() == null || CvUserAnnotationModel.this.getText().trim().length() == 0) && CvUserAnnotationModel.this.getUserAnnotationVc() != null && (uac = (UserAnnoCapable)((Object)(uavc = CvUserAnnotationModel.this.getUserAnnotationVc()).findParentByClass(uavc, UserAnnoCapable.class))) != null) {
                uac.remove(CvUserAnnotationModel.this);
            }
        }
    }

    class TextEditListener
    extends KeyAdapter
    implements Serializable {
        TextEditListener() {
        }

        @Override
        public void keyTyped(KeyEvent e2) {
            JTextArea textarea = (JTextArea)e2.getSource();
            if (!CvUserAnnotationModel.this.isTextEdited()) {
                textarea.setText("");
                CvUserAnnotationModel.this.setTextEdited(true);
            } else {
                textarea.setCaretPosition(textarea.getCaretPosition());
            }
        }

        private void deleteTheSelectable(Selectable s2, Object source) {
            UserAnnoCapable uac;
            XpUserAnnotationModel uam = null;
            XpUserAnnotationVc uavc = null;
            try {
                uam = (XpUserAnnotationModel)s2;
                uavc = uam.getUserAnnotationVc();
            }
            catch (ClassCastException exp) {
                return;
            }
            if (uavc != null && (uac = (UserAnnoCapable)((Object)uavc.findParentByClass(uavc, UserAnnoCapable.class))) != null) {
                uac.remove(uam);
            }
        }
    }

    class UaDragListener
    extends MouseMotionAdapter
    implements Serializable {
        UaDragListener() {
        }

        @Override
        public void mouseDragged(MouseEvent e2) {
            CPoint textAnchor = CvUserAnnotationModel.this.getTextAnchor();
            if (textAnchor.csystem == 3) {
                if (textAnchor.x < 0.01) {
                    CvUserAnnotationModel.this.setTextAnchor(new CPoint(0.01, CvUserAnnotationModel.this.getTextAnchor().y, 0.0, 3));
                } else if (textAnchor.x > 0.98) {
                    CvUserAnnotationModel.this.setTextAnchor(new CPoint(0.98, CvUserAnnotationModel.this.getTextAnchor().y, 0.0, 3));
                } else if (textAnchor.y < 0.01) {
                    CvUserAnnotationModel.this.setTextAnchor(new CPoint(CvUserAnnotationModel.this.getTextAnchor().x, 0.01, 0.0, 3));
                } else if (textAnchor.y > 0.98) {
                    CvUserAnnotationModel.this.setTextAnchor(new CPoint(CvUserAnnotationModel.this.getTextAnchor().x, 0.98, 0.0, 3));
                }
            } else if (textAnchor.csystem == 5) {
                XpUserAnnotationVc vc = CvUserAnnotationModel.this.getUserAnnotationVc();
                CTransform voxToDisp = vc.getTransform((byte)5, (byte)1);
                CTransform dispToVox = vc.getTransform((byte)1, (byte)5);
                int w2 = vc.getBounds().width;
                int h2 = vc.getBounds().height;
                CPoint display = new CPoint(textAnchor);
                CPoint vox = new CPoint();
                voxToDisp.transform(display);
                System.out.println(display.x + " __" + display.y);
                if (display.x < 2.0) {
                    display.x = 2.0;
                } else if (display.x > (double)(w2 - 2)) {
                    display.x = w2 - 2;
                } else if (display.y < 2.0) {
                    display.y = 2.0;
                } else if (display.y > (double)(h2 - 2)) {
                    display.y = h2 - 2;
                }
                vox.setPoint(display);
                dispToVox.transform(vox);
                CvUserAnnotationModel.this.setTextAnchor(vox);
            }
        }
    }
}

